/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Extension
extends Single {
    private final Pragma pragma;

    public Extension(InputInfo info, Pragma pragma, Expr expr) {
        super(info, expr, SeqType.ITEM_ZM);
        this.pragma = pragma;
    }

    @Override
    public void checkUp() throws QueryException {
        this.expr.checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        Object state = this.pragma.init(cc.qc, this.info);
        try {
            this.expr = this.expr.compile(cc);
        }
        finally {
            this.pragma.finish(cc.qc, state);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.adoptType(this.expr);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Object state = this.pragma.init(qc, this.info);
        try {
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            this.pragma.finish(qc, state);
        }
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Extension(this.info, this.pragma.copy(), this.expr.copy(cc, vm)));
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.pragma.has(flags) || super.has(flags);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Extension && this.pragma.equals(((Extension)obj).pragma) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Extension.addPlan(plan, this.planElem(new Object[0]), this.pragma, this.expr);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        Object state = this.pragma.init(ii.qc, this.info);
        try {
            boolean bl = this.expr.indexAccessible(ii);
            return bl;
        }
        finally {
            this.pragma.finish(ii.qc, state);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(String.valueOf(this.pragma)) + ' ' + "{" + ' ' + this.expr + ' ' + "}";
    }
}

