/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public enum QueryError {
    BASEX_ANNOTATION1_X_X(ErrType.BASEX, "annotation", "Annotation %% is unknown."),
    BASEX_ANNOTATION2_X_X(ErrType.BASEX, "annotation", "%: % supplied."),
    BASEX_ANNOTATION3_X_X(ErrType.BASEX, "annotation", "Annotation %% was declared twice."),
    BASEX_ANNOTATION_X_X_X(ErrType.BASEX, "annotation", "%: % expected, % found."),
    BASEX_DBPATH1_X(ErrType.BASEX, "doc", "Database path '%' yields no documents."),
    BASEX_DBPATH2_X(ErrType.BASEX, "doc", "Database path '%' yields more than one document."),
    BASEX_FUNCTION_X(ErrType.BASEX, "function", "Function items cannot be cached: %."),
    BASEX_ERROR_X(ErrType.BASEX, "error", "%"),
    BASEX_HTTP(ErrType.BASEX, "http", "HTTP connection required."),
    BASEX_OPTIONS1_X(ErrType.BASEX, "options", "Unknown database option: %."),
    BASEX_OPTIONS2_X(ErrType.BASEX, "options", "%"),
    BASEX_OPTIONS3_X(ErrType.BASEX, "options", "Database option not allowed in library module: %."),
    BASEX_OPTIONS_X_X(ErrType.BASEX, "options", "Database option '%' cannot be set to '%'."),
    BASEX_OVERFLOW(ErrType.BASEX, "overflow", "Stack Overflow: Try tail recursion?"),
    BASEX_PERMISSION_X(ErrType.BASEX, "permission", "No % permission."),
    BASEX_PERMISSION_X_X(ErrType.BASEX, "permission", "No % permission: %."),
    BASEX_RESTXQ_X(ErrType.BASEX, "restxq", "%"),
    BASEX_UPDATE(ErrType.BASEX, "update", "Update target was not created by transform expression."),
    ADMIN_DELETE_X(ErrType.ADMIN, "delete", "Log file could not be deleted: %."),
    ADMIN_TODAY(ErrType.ADMIN, "today", "Today's log file cannot be deleted."),
    ADMIN_TYPE_X(ErrType.ADMIN, "type", "Log type must consist of uppercase letters: %."),
    ARCHIVE_DESCRIPTOR1(ErrType.ARCHIVE, "descriptor", "Name of ZIP entry must not be empty."),
    ARCHIVE_DESCRIPTOR2_X(ErrType.ARCHIVE, "descriptor", "Invalid compression level: '%'."),
    ARCHIVE_DESCRIPTOR3_X(ErrType.ARCHIVE, "descriptor", "xs:dateTime value is invalid : '%'."),
    ARCHIVE_ENCODE1_X(ErrType.ARCHIVE, "encode", "Unknown encoding '%'."),
    ARCHIVE_ENCODE2_X(ErrType.ARCHIVE, "encode", "String conversion: %."),
    ARCHIVE_ERROR_X(ErrType.ARCHIVE, "error", "Operation failed: %."),
    ARCHIVE_FORMAT(ErrType.ARCHIVE, "format", "Packing format not supported."),
    ARCHIVE_FORMAT_X_X(ErrType.ARCHIVE, "format", "% not supported: '%'."),
    ARCHIVE_MODIFY_X(ErrType.ARCHIVE, "modify", "Entries of % archive cannot be modified."),
    ARCHIVE_NUMBER_X_X(ErrType.ARCHIVE, "number", "Number of entries and contents differs: % vs. %."),
    ARCHIVE_SINGLE_X(ErrType.ARCHIVE, "single", "% archives are limited to a single entry."),
    BIN_DLA_X_X(ErrType.BIN, "differing-length-arguments", "Inputs are of different length (%/%)."),
    BIN_IOOR_X_X(ErrType.BIN, "index-out-of-range", "Index '%' is out of range (0-%)."),
    BIN_NS_X(ErrType.BIN, "negative-size", "Size '%' is negative."),
    BIN_OOR_X(ErrType.BIN, "octet-out-of-range", "Octet '%' is out of range."),
    BIN_NNC(ErrType.BIN, "non-numeric-character", "Invalid character in constructor string."),
    BIN_UE_X(ErrType.BIN, "unknown-encoding", "Unknown encoding '%'."),
    BIN_CE_X(ErrType.BIN, "conversion-error", "%."),
    BIN_USO_X(ErrType.BIN, "unknown-significance-order", "Unknown octet-order value: '%'."),
    CLIENT_COMMAND_X(ErrType.CLIENT, "command", "Command could not be executed: %"),
    CLIENT_CONNECT_X(ErrType.CLIENT, "connect", "Connection failed: %"),
    CLIENT_ERROR_X(ErrType.CLIENT, "error", "An error occurred: %"),
    CLIENT_FITEM_X(ErrType.CLIENT, "function", "Result is a function item: %."),
    CLIENT_ID_X(ErrType.CLIENT, "id", "Session with ID % is not available or has been closed."),
    CLIENT_QUERY_X(ErrType.CLIENT, "query", "Query could not be executed: %"),
    CONVERT_STRING_X(ErrType.CONVERT, "string", "String conversion: %."),
    CONVERT_BINARY_X_X(ErrType.CONVERT, "binary", "Conversion of '%' to encoding '%' failed."),
    CONVERT_ENCODING_X(ErrType.CONVERT, "encoding", "Unknown encoding '%'."),
    CONVERT_BASE_X(ErrType.CONVERT, "base", "Unsupported base: %."),
    CONVERT_INTEGER_X_X(ErrType.CONVERT, "integer", "Invalid digit for base %: %."),
    CX_CANINV(ErrType.CX, 1, "Canonicalization algorithm is not supported."),
    CX_DIGINV(ErrType.CX, 2, "Digest algorithm is not supported."),
    CX_SIGINV(ErrType.CX, 3, "Signature algorithm is not supported."),
    CX_XPINV(ErrType.CX, 4, "XPath expression is invalid."),
    CX_INVNM(ErrType.CX, 5, "Invalid name for $digital-certificate root."),
    CX_KSNULL_X(ErrType.CX, 7, "Key store is null: %"),
    CX_NOKEY(ErrType.CX, 12, "Cannot find key for alias in given keystore."),
    CX_INVHASH(ErrType.CX, 13, "Hashing algorithm is not supported."),
    CX_ENC(ErrType.CX, 14, "The encoding method is not supported."),
    CX_NOSIG(ErrType.CX, 15, "Cannot find signature element."),
    CX_NOPAD(ErrType.CX, 16, "No such padding."),
    CX_BADPAD(ErrType.CX, 17, "Incorrect padding."),
    CX_ENCTYP(ErrType.CX, 18, "Encryption type is not supported."),
    CX_KEYINV(ErrType.CX, 19, "Secret key is invalid."),
    CX_ILLBLO(ErrType.CX, 20, "Illegal block size."),
    CX_INVALGO(ErrType.CX, 21, "Algorithm is not supported."),
    CX_ALINV_X(ErrType.CX, 23, "Invalid certificate alias %."),
    CX_ALGEXC(ErrType.CX, 24, "Invalid algorithm."),
    CX_IOEXC(ErrType.CX, 25, "IO Exception."),
    CX_KSEXC(ErrType.CX, 26, "Keystore exception."),
    CX_SIGEXC(ErrType.CX, 27, "Signature exception."),
    CX_SIGTYPINV(ErrType.CX, 28, "Signature type is not supported."),
    CSV_PARSE_X(ErrType.CSV, "parse", "%."),
    CSV_SERIALIZE_X(ErrType.CSV, "serialize", "%."),
    DB_ARGS_X_X(ErrType.DB, "args", "Number of specified inputs and paths differs: % vs. %."),
    DB_CONFLICT1_X_X(ErrType.DB, "conflict", "Database '%' can only be % once."),
    DB_CONFLICT2_X_X(ErrType.DB, "conflict", "Backup '%' can only be % once."),
    DB_CONFLICT3_X(ErrType.DB, "conflict", "Database '%' cannot be both altered and dropped."),
    DB_CONFLICT4_X(ErrType.DB, "conflict", "Name of source and target database is equal: %."),
    DB_LOCK1_X(ErrType.DB, "lock", "Database '%' cannot be updated, it is opened by another process."),
    DB_LOCK2_X(ErrType.DB, "lock", "%"),
    DB_MAINMEM_X(ErrType.DB, "mainmem", "Database '%' is in main memory."),
    DB_NAME_X(ErrType.DB, "name", "Invalid database name: %."),
    DB_NOBACKUP_X(ErrType.DB, "no-backup", "No backup exists for database '%'."),
    DB_NODE_X(ErrType.DB, "node", "No database node: %."),
    DB_NOINDEX_X_X(ErrType.DB, "no-index", "Database '%' has no % index."),
    DB_OPEN1_X(ErrType.DB, "open", "Database '%' not found."),
    DB_OPEN2_X(ErrType.DB, "open", "%"),
    DB_OPTION_X(ErrType.DB, "option", "Unknown option: %."),
    DB_PATH_X(ErrType.DB, "path", "Invalid path: %."),
    DB_PROPERTY_X(ErrType.DB, "property", "Unknown database property: %."),
    DB_RANGE_X_X_X(ErrType.DB, "range", "Database '%' has no node with % value %."),
    DB_TARGET_X(ErrType.DB, "target", "Invalid target path: %."),
    FETCH_OPEN_X(ErrType.FETCH, "open", "%"),
    FETCH_ENCODING_X(ErrType.FETCH, "encoding", "Unknown encoding '%'."),
    FILE_NOT_FOUND_X(ErrType.FILE, "not-found", "'%' does not exist."),
    FILE_EXISTS_X(ErrType.FILE, "exists", "'%' already exists."),
    FILE_NO_DIR_X(ErrType.FILE, "no-dir", "'%' is no directory."),
    FILE_IS_DIR_X(ErrType.FILE, "is-dir", "'%' is a directory."),
    FILE_ID_DIR2_X(ErrType.FILE, "is-dir", "'%' is a non-empty directory."),
    FILE_IS_RELATIVE_X(ErrType.FILE, "is-relative", "Base directory is relative: '%'."),
    FILE_UNKNOWN_ENCODING_X(ErrType.FILE, "unknown-encoding", "Unknown encoding '%'."),
    FILE_OUT_OF_RANGE_X_X(ErrType.FILE, "out-of-range", "Requested file chunk [%,%] exceeds file bounds."),
    FILE_INVALID_PATH_X(ErrType.FILE, "invalid-path", "Invalid file path: '%'."),
    FILE_IO_ERROR_X(ErrType.FILE, "io-error", "%"),
    FILE_IE_ERROR_ACCESS_X(ErrType.FILE, "io-error", "Access to '%' is denied."),
    FT_OPTIONS(ErrType.FT, "options", "Wildcards and fuzzy option cannot be specified both."),
    HASH_ALGORITHM_X(ErrType.HASH, "algorithm", "Algorithm not supported: '%'."),
    HTML_PARSE_X(ErrType.HTML, "parse", "%"),
    HC_ERROR_X(ErrType.HC, 1, "%"),
    HC_PARSE_X(ErrType.HC, 2, "Conversion failed: %"),
    HC_ATTR(ErrType.HC, 3, "No attribute allowed beside 'src' and 'media-type'."),
    HC_REQ_X(ErrType.HC, 4, "%."),
    HC_URL(ErrType.HC, 5, "No URL supplied."),
    HC_PARAMS(ErrType.HC, 6, "Specify request element or HTTP URI."),
    INSPECT_UNKNOWN_X(ErrType.INSPECT, "unknown", "Component '%' does not exist."),
    JOBS_ID_EXISTS_X(ErrType.JOBS, "id", "Job id already exists: %."),
    JOBS_ID_INVALID_X(ErrType.JOBS, "id", "Invalid job name: %."),
    JOBS_OPTIONS(ErrType.JOBS, "options", "Either 'cache' or 'interval' option is allowed."),
    JOBS_OVERFLOW(ErrType.JOBS, "overflow", "Too many queries queued."),
    JOBS_RANGE_X(ErrType.JOBS, "range", "Value out of range: %."),
    JOBS_RUNNING_X(ErrType.JOBS, "running", "Result is not available yet: %."),
    JOBS_SELF_X(ErrType.JOBS, "self", "Cannot wait for own job: %"),
    JOBS_UNKNOWN_X(ErrType.JOBS, "unknown", "Unknown job: %."),
    JOBS_SERVICE(ErrType.JOBS, "service", "No variables allowed."),
    JOBS_SERVICE_X_X(ErrType.JOBS, "service", "Could not write service: %."),
    JSON_PARSE_X(ErrType.JSON, "parse", "%."),
    JSON_PARSE_X_X_X(ErrType.JSON, "parse", "(%:%): %."),
    JSON_SERIALIZE_X(ErrType.JSON, "serialize", "%."),
    JSON_OPTIONS_X(ErrType.JSON, "options", "'%':'%' is not supported by the target format."),
    OUTPUT_FORMAT_X_X(ErrType.OUTPUT, "format", "%: %."),
    PROC_ENCODING_X(ErrType.PROC, "encoding", "Unknown encoding '%'."),
    PROC_ERROR_X(ErrType.PROC, "error", "%"),
    PROC_TIMEOUT(ErrType.PROC, "timeout", "The timeout was exceeded."),
    RANDOM_BOUNDS_X(ErrType.RANDOM, "bounds", "Maximum value is out of bounds: %."),
    RANGE_NEGATIVE_X(ErrType.RANDOM, "negative", "Number of values is negative: %."),
    REPO_DELETE_X(ErrType.REPO, "delete", "File '%' could not be deleted."),
    REPO_DELETE_X_X(ErrType.REPO, "delete", "Package '%' depends on package '%'."),
    REPO_DESCRIPTOR_X(ErrType.REPO, "descriptor", "%."),
    REPO_INSTALLED_X(ErrType.REPO, "installed", "Module % is already installed within another package."),
    REPO_NOTFOUND_X(ErrType.REPO, "not-found", "Package '%' not found."),
    REPO_PARSE_X_X(ErrType.REPO, "parse", "%: %."),
    REPO_VERSION(ErrType.REPO, "version", "Package version is not supported."),
    SESSION_GET_X(ErrType.SESSION, "get", "Stored attribute is no XQuery value: %."),
    SESSION_SET_X(ErrType.SESSION, "set", "Item cannot be stored: %."),
    SESSIONS_GET_X(ErrType.SESSIONS, "get", "Stored attribute is no value: %."),
    SESSIONS_SET_X(ErrType.SESSIONS, "http", "Function items cannot be stored: %."),
    SESSIONS_NOTFOUND_X(ErrType.SESSIONS, "not-found", "Session not found: %."),
    SQL_ATTRIBUTE_X(ErrType.SQL, "attribute", "Attribute not expected: %."),
    SQL_INIT_X(ErrType.SQL, "init", "Could not find driver: %"),
    SQL_ERROR_X(ErrType.SQL, "error", "An SQL exception occurred: %"),
    SQL_TIMEOUT_X(ErrType.SQL, "timeout", "A query timeout has occurred: %"),
    SQL_ID1_X(ErrType.SQL, "id", "No connection with id %."),
    SQL_ID2_X(ErrType.SQL, "id", "No prepared statement with id %."),
    SQL_PARAMETERS(ErrType.SQL, "parameters", "No parameter type supplied."),
    SQL_TYPE_X_X(ErrType.SQL, "type", "Invalid type (%): %."),
    UNIT_FAIL(ErrType.UNIT, "fail", "Assertion failed."),
    UNIT_FAIL_X(ErrType.UNIT, "fail", "%"),
    UNIT_FAIL_X_X_X(ErrType.UNIT, "fail", "Item %: % expected, % returned."),
    UNIT_NOARGS_X(ErrType.UNIT, "no-args", "Test function '%' must have no arguments."),
    UNIT_PRIVATE_X(ErrType.UNIT, "private", "Test function '%' must not be private."),
    USER_ADMIN(ErrType.USER, "admin", "User 'admin' cannot be modified."),
    USER_CONFLICT_X(ErrType.USER, "conflict", "User '%' cannot be both altered and dropped."),
    USER_EQUAL_X(ErrType.USER, "equal", "Name of old and new user is equal: %."),
    USER_INFO_X(ErrType.USER, "info", "Info can only be % once."),
    USER_LOCAL(ErrType.USER, "local", "Local permission can only be 'none', 'read' or 'write'."),
    USER_LOGGEDIN_X(ErrType.USER, "logged-in", "User '%' is currently logged in."),
    USER_NAME_X(ErrType.USER, "name", "Invalid user name: '%'."),
    USER_PASSWORD_X(ErrType.USER, "password", "Wrong password supplied for user '%'."),
    USER_PATTERN_X(ErrType.USER, "pattern", "Invalid database pattern: '%'."),
    USER_PERMISSION_X(ErrType.USER, "permission", "Invalid permission: '%'."),
    USER_UNKNOWN_X(ErrType.USER, "unknown", "User '%' does not exist."),
    USER_UPDATE1_X_X(ErrType.USER, "update", "User '%' can only be % once."),
    USER_UPDATE2_X(ErrType.USER, "update", "Pattern '%' is specified more than once."),
    USER_UPDATE3_X_X(ErrType.USER, "update", "User '%' can only be % once."),
    UTIL_NEGATIVE_X(ErrType.UTIL, "negative", "Index '%' is negative."),
    VALIDATE_ERROR_X(ErrType.VALIDATE, "error", "Validation failed: %"),
    VALIDATE_START_X(ErrType.VALIDATE, "init", "Validation could not be started: %"),
    VALIDATE_NOTFOUND_X(ErrType.VALIDATE, "not-found", "RelaxNG validation is not available."),
    VALIDATE_VERSION_X(ErrType.VALIDATE, "version", "No XML Schema implementation for version '%'."),
    WEB_INVALID1_X(ErrType.WEB, "invalid", "URL contains invalid characters: %"),
    WEB_INVALID2_X(ErrType.WEB, "invalid", "%."),
    XQUERY_UPDATE1(ErrType.XQUERY, "update", "No updating expression allowed."),
    XQUERY_UPDATE2(ErrType.XQUERY, "update", "Updating expression expected."),
    XQUERY_PERMISSION1_X(ErrType.XQUERY, "permission", "%"),
    XQUERY_PERMISSION2_X(ErrType.XQUERY, "permission", "% permission required."),
    XQUERY_TIMEOUT(ErrType.XQUERY, "timeout", "The timeout was exceeded."),
    XQUERY_MEMORY(ErrType.XQUERY, "memory", "The memory limit was exceeded."),
    XQUERY_NESTED(ErrType.XQUERY, "nested", "Nested query evaluation is not allowed."),
    XQUERY_UNEXPECTED_X(ErrType.XQUERY, "error", "Unexpected error: %"),
    XSLT_ERROR_X(ErrType.XSLT, "error", "%"),
    ZIP_NOTFOUND_X(ErrType.ZIP, 1, "Path '%' not found."),
    ZIP_INVALID_X_X(ErrType.ZIP, 2, "% element: attribute '%' expected."),
    ZIP_UNKNOWN_X(ErrType.ZIP, 2, "ZIP definition: unknown element %."),
    ZIP_FAIL_X(ErrType.ZIP, 3, "Operation failed: %."),
    APPLY_X_X(ErrType.FOAP, 1, "Arity differs from number of array members: % vs. %"),
    DIVZERO_X(ErrType.FOAR, 1, "% cannot be divided by zero."),
    DIVFLOW_X(ErrType.FOAR, 2, "Invalid division result: %."),
    RANGE_X(ErrType.FOAR, 2, "Value out of range: %."),
    ARRAYBOUNDS_X_X(ErrType.FOAY, 1, "Array index % out of bounds (1..%)."),
    ARRAYEMPTY(ErrType.FOAY, 1, "Array has no entries."),
    ARRAYNEG_X(ErrType.FOAY, 2, "Length is negative: %."),
    INVALUE_X_X(ErrType.FOCA, 2, "Cannot convert to %: %."),
    INTRANGE_X(ErrType.FOCA, 3, "Integer value out of range: %."),
    DATECALC_X_X(ErrType.FOCA, 5, "Invalid % calculation: %."),
    INVCODE_X(ErrType.FOCH, 1, "Invalid XML character '&#x%;'."),
    WHICHCOLL_X(ErrType.FOCH, 2, "%."),
    NORMUNI_X(ErrType.FOCH, 3, "Unsupported normalization form ('%')."),
    CHARCOLL(ErrType.FOCH, 4, "Collation does not operate on character-by-character basis."),
    IDDOC(ErrType.FODC, 1, "Specified node has no document node as root."),
    NODEERR_X_X(ErrType.FODC, 2, "% could not be created: %."),
    NODEFCOLL(ErrType.FODC, 2, "No default collection available."),
    IOERR_X(ErrType.FODC, 2, "%"),
    WHICHRES_X(ErrType.FODC, 2, "Resource '%' does not exist."),
    RESDIR_X(ErrType.FODC, 2, "URI '%' points to directory."),
    INVCOLL_X(ErrType.FODC, 4, "Invalid collection URI: '%'."),
    INVDOC_X(ErrType.FODC, 5, "Invalid document URI: '%'."),
    SAXERR_X(ErrType.FODC, 6, "SAX: %"),
    RESINV_X(ErrType.FODC, 7, "Resource path '%' is invalid."),
    INVDB_X(ErrType.FODC, 7, "Invalid database name: '%'."),
    FORMNUM_X(ErrType.FODF, 1280, "Unknown decimal format: '%'."),
    PICEMPTY(ErrType.FODF, 1310, "The picture string must not be empty: '%'"),
    PICNUM_X(ErrType.FODF, 1310, "Invalid picture string: '%'."),
    OPTAFTER_X(ErrType.FODF, 1310, "Optional digit sign follows mandatory digit signs: '%'."),
    INVGROUP_X(ErrType.FODF, 1310, "Invalid position of grouping separator signs: '%'."),
    DIFFMAND_X(ErrType.FODF, 1310, "Mandatory digits is not of the same group: '%'."),
    INVORDINAL_X(ErrType.FODF, 1310, "Invalid specification of ordinal numbering: '%'."),
    INVDDPATTERN_X(ErrType.FODF, 1310, "Invalid decimal-digit-pattern: '%'."),
    DATERANGE_X_X(ErrType.FODT, 1, "%: '%' out of range."),
    YEARRANGE_X(ErrType.FODT, 1, "Year '%' out of range."),
    SECRANGE_X(ErrType.FODT, 1, "Seconds '%' out of range."),
    DURRANGE_X_X(ErrType.FODT, 2, "%: '%' out of range."),
    MONTHRANGE_X(ErrType.FODT, 2, "Months '%' out of range."),
    SECDURRANGE_X(ErrType.FODT, 2, "Seconds '%' out of range."),
    DATEZERO_X_X(ErrType.FODT, 2, "Invalid % calculation: %."),
    INVALZONE_X(ErrType.FODT, 3, "Timezone out of range (-14:00 to +14:00): %."),
    ZONESEC_X(ErrType.FODT, 3, "No seconds allowed in timezone: %."),
    FUNERR1(ErrType.FOER, 0, "Halted on error()."),
    INVCOMPSPEC_X(ErrType.FOFD, 1340, "Invalid variable marker: '[%]'."),
    PICDATE_X(ErrType.FOFD, 1340, "Invalid picture string: '%'."),
    CALWHICH_X(ErrType.FOFD, 1340, "Unknown calendar: '%'."),
    INVFDPATTERN_X(ErrType.FOFD, 1340, "%"),
    PICINVCOMP_X_X(ErrType.FOFD, 1350, "Component '[%]' not applicable to % values."),
    PARSE_JSON_X(ErrType.FOJS, 1, "%"),
    DUPLICATE_JSON_X(ErrType.FOJS, 3, "%"),
    MERGE_DUPLICATE_X(ErrType.FOJS, 3, "Key % occurs more than once."),
    OPTION_JSON_X(ErrType.FOJS, 5, "%"),
    FUNC_JSON_OPT_X_X(ErrType.FOJS, 5, "% expected, % found."),
    INVALID_JSON_X(ErrType.FOJS, 6, "%"),
    ESCAPE_JSON_X(ErrType.FOJS, 7, "Invalid escape sequence: %."),
    NSDECL_X(ErrType.FONS, 4, "No namespace declared for prefix '%'."),
    INVALIDZONE_X(ErrType.FORG, 1, "Invalid timezone: %."),
    FUNCCAST_X_X(ErrType.FORG, 1, "Cannot convert to %: %."),
    FUNCCAST_X_X_X(ErrType.FORG, 1, "Cannot convert % to %: %."),
    DATEFORMAT_X_X_X(ErrType.FORG, 1, "Wrong % format: '%' (try e.g. '%')."),
    URIARG_X(ErrType.FORG, 2, "Invalid URI: %."),
    BASEURIARG_X(ErrType.FORG, 2, "Invalid base URI: %."),
    ZEROORONE(ErrType.FORG, 3, "Zero or one item expected."),
    ONEORMORE(ErrType.FORG, 4, "One or more item expected."),
    EXACTLYONE(ErrType.FORG, 5, "Exactly one item expected."),
    CMP_X(ErrType.FORG, 6, "Type % is not comparable."),
    CMP_X_X_X(ErrType.FORG, 6, "% expected, % found: %."),
    EBV_X(ErrType.FORG, 6, "Effective boolean value not defined for %."),
    EBV_X_X(ErrType.FORG, 6, "Effective boolean value not defined for %: %."),
    SUM_X_X(ErrType.FORG, 6, "Argument type % is invalid: %."),
    FUNZONE_X_X(ErrType.FORG, 8, "% and % have different timezones."),
    IETF_PARSE_X_X_X(ErrType.FORG, 10, "Invalid input (% expected, '%' found): '%'."),
    IETF_INV_X(ErrType.FORG, 10, "Invalid input: '%'."),
    REGMOD_X(ErrType.FORX, 1, "Invalid regular flag: '%'."),
    REGPAT_X(ErrType.FORX, 2, "Invalid regular expression: %."),
    REGROUP(ErrType.FORX, 3, "Pattern matches empty string."),
    FUNREPBS_X(ErrType.FORX, 4, "Invalid backslash in replacement string: %."),
    FUNREPDOL_X(ErrType.FORX, 4, "Invalid dollar sign in replacement string: %."),
    FIATOM_X(ErrType.FOTY, 13, "Items of type % cannot be atomized."),
    FISTRING_X(ErrType.FOTY, 14, "Items of type % have no string representation."),
    FICMP_X(ErrType.FOTY, 15, "Type % is not comparable."),
    UPFOTYPE_X(ErrType.FOUP, 1, "Document or element expected, % found."),
    UPDOCTYPE_X(ErrType.FOUP, 1, "Document expected, % found."),
    UPFOURI_X(ErrType.FOUP, 2, "Invalid URI: %."),
    UPPUTERR_X(ErrType.FOUP, 2, "File '%' could not be written."),
    UPDBPUT_X(ErrType.FOUP, 2, "Resource '%' could not be written."),
    UPDROPBACK_X_X(ErrType.FOUP, 2, "Backup '%' could not be %."),
    UPDBERROR_X_X(ErrType.FOUP, 2, "Database '%' could not be %."),
    UPDBOPTERR_X(ErrType.FOUP, 2, "%"),
    RESNF_X(ErrType.FOUT, 1170, "Resource '%' cannot be retrieved."),
    FRAGID_X(ErrType.FOUT, 1170, "URI contains a fragment identifier: %"),
    INVURL_X(ErrType.FOUT, 1170, "URI is invalid: %"),
    STBASEURI(ErrType.FOUT, 1170, "Static Base URI is undefined."),
    ENCODING_X(ErrType.FOUT, 1190, "Unknown encoding '%'."),
    INVCHARS_X(ErrType.FOUT, 1190, "%."),
    WHICHCHARS_X(ErrType.FOUT, 1200, "Resource contains invalid input: %."),
    FTWEIGHT_X(ErrType.FTDY, 16, "Weight value out of range: %."),
    FTMILD(ErrType.FTDY, 17, "Invalid 'mild not' selection."),
    FTWILDCARD_X(ErrType.FTDY, 20, "Invalid wildcard syntax: '%'."),
    FTIGNORE(ErrType.FTST, 7, "Ignore option not supported."),
    NOSTOPFILE_X(ErrType.FTST, 8, "Stop word file not found: '%'."),
    FTNOSTEM_X(ErrType.FTST, 9, "No stemmer available for language '%'."),
    FTNOTOK_X(ErrType.FTST, 9, "No tokenizer available for language '%'."),
    NOTHES_X(ErrType.FTST, 18, "Thesaurus not found: '%'."),
    FTDUP_X(ErrType.FTST, 19, "Match option '%' was declared twice."),
    SERATTR_X(ErrType.SENR, 1, "Attributes cannot be serialized:%."),
    SERNS_X(ErrType.SENR, 1, "Namespaces cannot be serialized:%."),
    SERFUNC_X(ErrType.SENR, 1, "Items of type % cannot be serialized."),
    SERSA(ErrType.SEPM, 4, "If 'standalone' is specified, the root must be a single element."),
    SERDT(ErrType.SEPM, 4, "If 'doctype-system' is specified, the root must be a single element."),
    SERENCODING_X(ErrType.SESU, 7, "Unknown encoding '%'."),
    SERENC_X_X(ErrType.SERE, 8, "Character '#x%;' cannot be mapped to '%'."),
    SERSTAND(ErrType.SEPM, 9, "Invalid combination of omit-xml-declaration and other parameters."),
    SERUNDECL(ErrType.SEPM, 10, "XML 1.0: undeclaring prefixes not allowed."),
    SERNORM_X(ErrType.SESU, 11, "Normalization form not supported: %."),
    SERNOTSUPP_X(ErrType.SESU, 13, "%"),
    SERILL_X(ErrType.SERE, 14, "Illegal HTML character found: #x%;."),
    SERPI(ErrType.SERE, 15, "Processing construction contains '>'."),
    SER_X(ErrType.SEPM, 16, "%"),
    SERMAP_X(ErrType.SEPM, 17, "Character map '%' is not defined."),
    SEROPT_X(ErrType.SEPM, 17, "%"),
    SEROPTION_X(ErrType.SEPM, 17, "Serialization parameter '%' is invalid."),
    SERNUMBER_X(ErrType.SERE, 20, "Numeric value cannot be represented: '%'"),
    SERJSONFUNC_X(ErrType.SERE, 21, "Items of type % cannot be serialized."),
    SERDUPL_X(ErrType.SERE, 22, "Duplicate name found: '%'"),
    SERJSON(ErrType.SERE, 23, "Only one item can be serialized with JSON."),
    SERJSONSEQ(ErrType.SERE, 23, "Value has more than one item."),
    NOCTX_X(ErrType.XPDY, 2, "%: no context value bound."),
    VAREMPTY_X(ErrType.XPDY, 2, "No value assigned to %."),
    CTXNODE(ErrType.XPDY, 50, "Root of the context value is no document node."),
    NOTREAT_X_X_X(ErrType.XPDY, 50, "Cannot treat % as %: %."),
    QUERYEMPTY(ErrType.XPST, 3, "Empty query."),
    MODLEINV_X(ErrType.XPST, 3, "Module contains illegal character: #%."),
    NOQUOTE_X(ErrType.XPST, 3, "Expecting quote%."),
    ARITY_X(ErrType.XPST, 3, "Expecting function arity, '%' found."),
    NUMBERWS_X(ErrType.XPST, 3, "Expecting separator after number: '%'."),
    NUMBER_X(ErrType.XPST, 3, "Incomplete number: '%'."),
    NUMBERITR_X_X(ErrType.XPST, 3, "Integer expected, % found: '%'."),
    QUERYEND_X(ErrType.XPST, 3, "Unexpected end of query: '%'."),
    MODEXPR(ErrType.XPST, 3, "No expression allowed in a library module."),
    MAINMOD(ErrType.XPST, 3, "Library modules cannot be evaluated."),
    CMPEXPR(ErrType.XPST, 3, "Comparison is incomplete."),
    UPDATEEXPR(ErrType.XPST, 3, "Expecting update expression."),
    NOELEMNAME(ErrType.XPST, 3, "Expecting element name."),
    ELEMNAME_X(ErrType.XPST, 3, "Expecting element name, '<%' found."),
    NOATTNAME(ErrType.XPST, 3, "Expecting attribute name."),
    NOEXPR(ErrType.XPST, 3, "Expecting expression."),
    NOCONTENT(ErrType.XPST, 3, "Expecting node content."),
    WRONGCHAR_X_X(ErrType.XPST, 3, "Expecting '%'%."),
    INVENTITY_X(ErrType.XPST, 3, "Invalid entity: '%'."),
    INCOMPLETE(ErrType.XPST, 3, "Incomplete expression."),
    EVALUNARY(ErrType.XPST, 3, "Unary operator expects a numeric value."),
    STEPMISS_X(ErrType.XPST, 3, "Expecting valid step%."),
    AXISMISS_X(ErrType.XPST, 3, "Expecting node test after % axis."),
    DECLINCOMPLETE(ErrType.XPST, 3, "Expecting 'function', 'variable', ..."),
    FUNCNAME(ErrType.XPST, 3, "Expecting function name."),
    RESERVED_X(ErrType.XPST, 3, "'%' is a reserved keyword."),
    NOVARNAME(ErrType.XPST, 3, "Variable name expected, '%' found."),
    NOVARDECL(ErrType.XPST, 3, "Expecting variable declaration."),
    NOCIDECL(ErrType.XPST, 3, "Expecting context item."),
    PIWRONG(ErrType.XPST, 3, "Expecting name of processing-instruction."),
    NOFTSELECT_X(ErrType.XPST, 3, "Expecting quote or opening curly brace%."),
    FUNCARG_X(ErrType.XPST, 3, "Expecting function argument%."),
    MAPTAAT_X(ErrType.XPST, 3, "Expecting atomic key type for map, found '%'."),
    TYPEINVALID(ErrType.XPST, 3, "Expecting type declaration."),
    NODECLFORM_X(ErrType.XPST, 3, "Decimal-format property '%' is invalid."),
    NOTYPESWITCH(ErrType.XPST, 3, "Incomplete typeswitch expression."),
    NOSWITCH(ErrType.XPST, 3, "Incomplete switch expression."),
    TYPEPAR(ErrType.XPST, 3, "Expecting '(' after 'switch' or 'typeswitch'."),
    PRAGMAINV(ErrType.XPST, 3, "Invalid pragma expression."),
    CALCEXPR(ErrType.XPST, 3, "Calculation is incomplete."),
    INVMAPKEY(ErrType.XPST, 3, "Invalid key, simple expression expected."),
    INVMAPVAL(ErrType.XPST, 3, "Invalid value, simple expression expected."),
    NORETURN(ErrType.XPST, 3, "Expecting return value."),
    NOWHERE(ErrType.XPST, 3, "Expecting valid expression after 'where'."),
    ORDERBY(ErrType.XPST, 3, "Expecting valid expression after 'order by'."),
    GRPBY(ErrType.XPST, 3, "Expecting valid expression after 'group by'."),
    FLWORRETURN(ErrType.XPST, 3, "Incomplete FLWOR expression: expecting 'return'."),
    NOSOME(ErrType.XPST, 3, "Incomplete quantifier expression."),
    IFPAR(ErrType.XPST, 3, "Expecting '(' after 'if' expression."),
    NOIF(ErrType.XPST, 3, "Incomplete 'if' expression."),
    NOFOR(ErrType.XPST, 3, "Incomplete 'for' expression."),
    NOLET(ErrType.XPST, 3, "Incomplete 'let' expression."),
    NOWINDOW(ErrType.XPST, 3, "Incomplete 'window' expression."),
    NOCOUNT(ErrType.XPST, 3, "Incomplete 'count' expression."),
    NOCLOSING_X(ErrType.XPST, 3, "Expecting closing tag </%>."),
    COMCLOSE(ErrType.XPST, 3, "Unclosed XQuery comment (: ..."),
    EXPREMPTY(ErrType.XPST, 3, "Unknown function or expression."),
    WHICHTYPE_X(ErrType.XPST, 3, "Unknown type: %."),
    BINDNAME_X(ErrType.XPST, 3, "Invalid name: '%'."),
    PIXML_X(ErrType.XPST, 3, "Processing instruction has illegal name: %."),
    QNAME_X(ErrType.XPST, 3, "Expecting QName, '%' found."),
    PROLOGORDER(ErrType.XPST, 3, "Default declarations must be declared first."),
    FTRANGE(ErrType.XPST, 3, "Expecting full-text range."),
    FTSTOP(ErrType.XPST, 3, "Stop words expected."),
    FTMATCH_X(ErrType.XPST, 3, "Unknown match option '%...'."),
    INVALPI(ErrType.XPST, 3, "Processing instruction has invalid name: '%' found."),
    INTEXP(ErrType.XPST, 3, "Integer expected."),
    VARFUNC(ErrType.XPST, 3, "Variable or function declaration expected."),
    NOANN(ErrType.XPST, 3, "No annotation allowed here."),
    NOCATCH(ErrType.XPST, 3, "Expecting catch clause."),
    ANNVALUE(ErrType.XPST, 3, "Literal expected, ')' found."),
    UPDATINGVAR(ErrType.XPST, 3, "Variable cannot be updating."),
    SIMPLETYPE_X(ErrType.XPST, 3, "Simple type expected, '%(' found."),
    KEYSPEC(ErrType.XPST, 3, "No specifier after lookup operator: '%'."),
    ARROWSPEC(ErrType.XPST, 3, "No specifier after arrow operator: '%'."),
    VARUNDEF_X(ErrType.XPST, 8, "Undefined variable %."),
    CIRCREF_X(ErrType.XPST, 8, "Static variable references itself: %"),
    VARPRIVATE_X(ErrType.XPST, 8, "Variable % is not visible from this module."),
    TYPEUNDEF_X(ErrType.XPST, 8, "Undefined type '%'."),
    SCHEMAINV_X(ErrType.XPST, 8, "Undefined schema name '%'."),
    FUNCPRIVATE_X(ErrType.XPST, 17, "Function not visible: %."),
    FUNCSIMILAR_X_X(ErrType.XPST, 17, "Unknown function: % (similar: %)."),
    FUNCARGNUM_X_X(ErrType.XPST, 17, "%: % supplied."),
    FUNCTYPES_X_X_X(ErrType.XPST, 17, "%: % supplied, % expected."),
    WHICHFUNC_X(ErrType.XPST, 17, "Unknown function: %."),
    WHICHJAVA_X_X_X(ErrType.XPST, 17, "Java function is unknown: %:%#%."),
    WHICHCLASS_X(ErrType.XPST, 17, "Java class is unknown: %."),
    JAVAAMB_X_X_X(ErrType.XPST, 17, "Java function is ambiguous: %:%#%."),
    JAVACONSAMB_X(ErrType.XPST, 17, "Java constructor is ambiguous: %."),
    FUNCNOIMPL_X(ErrType.XPST, 17, "External function not implemented: %."),
    JAVAINIT_X_X(ErrType.XPST, 17, "%: %."),
    TYPEUNKNOWN_X(ErrType.XPST, 51, "Unknown type: %."),
    CASTUNKNOWN_X(ErrType.XPST, 80, "Invalid cast type: %."),
    NOURI_X(ErrType.XPST, 81, "No namespace declared for '%'."),
    NSMISS_X(ErrType.XPST, 81, "QName '%' has no namespace."),
    WHICHCONSTR_X_X(ErrType.XPTY, 4, "Unknown Java constructor: %(%)."),
    WHICHMETHOD_X_X(ErrType.XPTY, 4, "Unknown Java method: %(%)."),
    JAVAARGS_X_X_X(ErrType.XPTY, 4, "Function %(%) cannot be called with (%)."),
    JAVAERROR_X_X_X(ErrType.XPTY, 4, "%(%): %."),
    JAVAARITY_X_X_X_X(ErrType.XPTY, 4, "Java function %:%#%: % supplied."),
    ZEROFUNCS_X_X(ErrType.XPTY, 4, "Zero-arity functions expected, % found: %."),
    NONAME_X(ErrType.XPTY, 4, "Name expected, '%' found."),
    EMPTYFOUND(ErrType.XPTY, 4, "Item expected, empty sequence found."),
    EMPTYFOUND_X(ErrType.XPTY, 4, "% expected, empty sequence found."),
    SEQFOUND_X(ErrType.XPTY, 4, "Item expected, sequence found: %."),
    NONUMBER_X_X(ErrType.XPTY, 4, "Number expected, % found: %."),
    NODUR_X_X(ErrType.XPTY, 4, "Duration expected, % found: %."),
    NOSUBDUR_X(ErrType.XPTY, 4, "Subtype of xs:duration expected: %."),
    STRQNM_X_X(ErrType.XPTY, 4, "String or QName expected, % found: %."),
    CPIWRONG_X_X(ErrType.XPTY, 4, "String or NCName expected, % found: %."),
    INVTYPE_X_X_X(ErrType.XPTY, 4, "Cannot convert % to %: %."),
    CALCTYPE_X_X_X(ErrType.XPTY, 4, "% not defined for % and %."),
    INVFUNCITEM_X_X(ErrType.XPTY, 4, "Function expected, % found: %."),
    NOPAREN_X_X(ErrType.XPTY, 4, "No parenthesis expected after %."),
    CMPTYPE_X(ErrType.XPTY, 4, "Type % is not comparable."),
    CMPTYPES_X_X(ErrType.XPTY, 4, "Types % and % are not comparable."),
    DOCATTS_X(ErrType.XPTY, 4, "Cannot add attributes to a document node: %."),
    DOCNS_X(ErrType.XPTY, 4, "Cannot add namespaces to a document node: %."),
    INVARITY_X_X_X(ErrType.XPTY, 4, "% supplied, % expected: %."),
    FUNARITY_X_X(ErrType.XPTY, 4, "Function with % supplied, % expected."),
    INVNCNAME_X(ErrType.XPTY, 4, "Invalid NCName: '%'."),
    CITYPES_X_X(ErrType.XPTY, 4, "Incompatible types in context value declarations: % vs. %."),
    LOOKUP_X(ErrType.XPTY, 4, "Input of lookup operator is not a map or array: %."),
    INVALIDOPT_X(ErrType.XPTY, 4, "%"),
    BINARY_X(ErrType.XPTY, 4, "Binary expected, % found."),
    STRNOD_X_X(ErrType.XPTY, 4, "String or node expected, % found: %."),
    MAP_X_X(ErrType.XPTY, 4, "Map expected, % found: %."),
    ELMMAP_X_X_X(ErrType.XPTY, 4, "element(%) or map expected, % found: %."),
    ELMSTR_X_X_X(ErrType.XPTY, 4, "element(%) or string expected, % found: %."),
    ELM_X_X(ErrType.XPTY, 4, "element(%) expected: %."),
    STRBIN_X_X(ErrType.XPTY, 4, "String or binary expected, % found: %."),
    INVALIDOPTION_X(ErrType.XPTY, 4, "Unknown option '%'."),
    FUNCUP_X(ErrType.XPTY, 4, "Function must not be updating: %."),
    FUNCNOTUP_X(ErrType.XPTY, 4, "Function is not updating: %."),
    MIXEDRESULTS(ErrType.XPTY, 18, "Path returns both nodes and non-nodes."),
    PATHNODE_X_X_X(ErrType.XPTY, 19, "%: node expected, % found: %."),
    STEPNODE_X_X_X(ErrType.XPTY, 20, "%: node expected, % found: %."),
    NSSENS_X_X(ErrType.XPTY, 117, "Cannot convert % to %."),
    CATTDUPL_X(ErrType.XQDY, 25, "Duplicate attribute '%'."),
    CPICONT_X(ErrType.XQDY, 26, "Processing instruction has invalid content: '%'."),
    CPIINVAL_X(ErrType.XQDY, 41, "Processing instruction has invalid name: '%'."),
    CAXML(ErrType.XQDY, 44, "XML prefix and namespace cannot be rebound."),
    CAINV_(ErrType.XQDY, 44, "Invalid attribute prefix/namespace: '%'."),
    CIRCVAR_X(ErrType.XQDY, 54, "Static variable depends on itself: %"),
    CIRCCTX(ErrType.XQDY, 54, "Context value is not defined."),
    CPIXML_X(ErrType.XQDY, 64, "Processing instruction has illegal name: '%'."),
    COMINVALID(ErrType.XQDY, 72, "Comment must not contain '--' or end with '-'."),
    INVNSNAME_X(ErrType.XQDY, 74, "Invalid namespace prefix: '%'."),
    INVNAME_X(ErrType.XQDY, 74, "Invalid QName: '%'."),
    INVPREF_X(ErrType.XQDY, 74, "No namespace declared for %."),
    CEXML(ErrType.XQDY, 96, "XML prefix or namespace cannot be rebound: '%'/'%'."),
    CEINV_X(ErrType.XQDY, 96, "Invalid element prefix/namespace '%'."),
    CNXML(ErrType.XQDY, 101, "XML prefix and namespace cannot be rebound."),
    CNINV_X(ErrType.XQDY, 101, "Invalid namespace prefix '%'."),
    CNINVNS_X(ErrType.XQDY, 101, "Invalid namespace URI '%'."),
    DUPLNSCONS_X(ErrType.XQDY, 102, "Duplicate namespace declaration: '%'."),
    MAPDUPLKEY_X_X_X(ErrType.XQDY, 137, "Key % already exists in map (values: % vs. %)."),
    IMPLSCHEMA(ErrType.XQST, 9, "Schema import not supported."),
    NSCONS(ErrType.XQST, 22, "Constant namespace value expected."),
    XQUERYVER_X(ErrType.XQST, 31, "XQuery version '%' not supported."),
    DUPLBASE(ErrType.XQST, 32, "Duplicate 'base-uri' declaration."),
    DUPLNSDECL_X(ErrType.XQST, 33, "Duplicate declaration of prefix '%'."),
    FUNCDEFINED_X(ErrType.XQST, 34, "Duplicate declaration of function '%'."),
    DUPLCOLL(ErrType.XQST, 38, "Duplicate 'collation' declaration."),
    WHICHDEFCOLL_X(ErrType.XQST, 38, "%."),
    FUNCDUPL_X(ErrType.XQST, 39, "Duplicate parameter name: %."),
    ATTDUPL_X(ErrType.XQST, 40, "Duplicate attribute '%'."),
    FNRESERVED_X(ErrType.XQST, 45, "Function '%' is in reserved namespace."),
    ANNWHICH_X_X(ErrType.XQST, 45, "Annotation %% is in reserved namespace."),
    INVURI_X(ErrType.XQST, 46, "URI '%' is invalid."),
    DUPLMODULE_X(ErrType.XQST, 47, "Module namespace is declared twice: '%'."),
    MODULENS_X(ErrType.XQST, 48, "Declaration % does not match the module namespace."),
    VARDUPL_X(ErrType.XQST, 49, "Duplicate declaration of static variable $%."),
    TYPE30_X(ErrType.XQST, 52, "Unknown cast type: %."),
    DUPLCOPYNS(ErrType.XQST, 55, "Duplicate 'copy-namespace' declaration."),
    NSEMPTY(ErrType.XQST, 57, "Namespace URI cannot be empty."),
    WHICHMOD_X(ErrType.XQST, 59, "Module not found: %."),
    WHICHMODCLASS_X(ErrType.XQST, 59, "Java class not found: %."),
    MODINIT_X_X_X(ErrType.XQST, 59, "Could not initialize %: % (%)."),
    MODINST_X_X(ErrType.XQST, 59, "Could not instantiate %: %."),
    WHICHMODFILE_X(ErrType.XQST, 59, "Could not retrieve module: %."),
    WRONGMODULE_X_X_X(ErrType.XQST, 59, "Imported module '%' has unexpected namespace: '%' vs '%'."),
    FUNNONS_X(ErrType.XQST, 60, "Namespace needed for function '%'."),
    DUPLORD(ErrType.XQST, 65, "Duplicate 'ordering' declaration."),
    DUPLNS(ErrType.XQST, 66, "Duplicate 'default namespace' declaration."),
    DUPLCONS(ErrType.XQST, 67, "Duplicate 'construction' declaration."),
    DUPLBOUND(ErrType.XQST, 68, "Duplicate 'boundary-space' declaration."),
    DUPLORDEMP(ErrType.XQST, 69, "Duplicate 'order empty' declaration."),
    BINDXML_X(ErrType.XQST, 70, "Prefix '%' cannot be rebound."),
    XMLNSDEF_X(ErrType.XQST, 70, "'%' cannot be default namespace."),
    BINDXMLURI_X_X(ErrType.XQST, 70, "'%' can only be bound to '%'."),
    ILLEGALEQNAME_X(ErrType.XQST, 70, "Illegal namespace: %."),
    DUPLNSDEF_X(ErrType.XQST, 71, "Duplicate declaration of prefix '%'."),
    IMPLVAL(ErrType.XQST, 75, "Validation not supported."),
    FLWORCOLL_X(ErrType.XQST, 76, "%."),
    NOPRAGMA(ErrType.XQST, 79, "Expecting pragma expression."),
    NSEMPTYURI(ErrType.XQST, 85, "Namespace URI cannot be empty."),
    XQUERYENC2_X(ErrType.XQST, 87, "Unknown encoding '%'."),
    NSMODURI(ErrType.XQST, 88, "Module namespace cannot be empty."),
    DUPLVAR_X(ErrType.XQST, 89, "Duplicate declaration of %."),
    INVCHARREF_X(ErrType.XQST, 90, "Invalid character reference '%'."),
    CIRCMODULE(ErrType.XQST, 93, "Circular module declaration."),
    GVARNOTDEFINED_X(ErrType.XQST, 94, "Undeclared grouping variable '%'."),
    INVDECFORM_X_X(ErrType.XQST, 97, "Invalid decimal-format property: %='%'."),
    INVDECSINGLE_X_X(ErrType.XQST, 97, "Decimal-format property is no single character: %='%'."),
    INVDECZERO_X(ErrType.XQST, 97, "Zero-digit property is no Unicode digit with value zero: %."),
    DUPLDECFORM_X(ErrType.XQST, 98, "Clash of decimal format properties: '%'."),
    DUPLITEM(ErrType.XQST, 99, "Duplicate declaration of context value."),
    DUPLWIND_X(ErrType.XQST, 103, "Duplicate declaration of %."),
    DUPLUPD(ErrType.XQST, 106, "More than one updating annotation declared."),
    DUPLFUNVIS(ErrType.XQST, 106, "More than one visibility annotation declared."),
    OPTDECL_X(ErrType.XQST, 108, "Output declaration not allowed library module: %."),
    OUTMAP_X(ErrType.XQST, 109, "Character map '%' is not defined."),
    OUTINVALID_X(ErrType.XQST, 109, "%"),
    OUTDUPL_X(ErrType.XQST, 110, "Duplicate declaration of 'output:%'."),
    DECDUPL(ErrType.XQST, 111, "Duplicate decimal-format declaration."),
    DECITEM(ErrType.XQST, 113, "Context value cannot be bound in library module."),
    DECDUPLPROP_X(ErrType.XQST, 114, "Duplicate decimal-format property '%'."),
    DUPLVARVIS(ErrType.XQST, 116, "More than one visibility annotation declared."),
    TAGWRONG_X_X(ErrType.XQST, 118, "Different start and end tag: <%>...</%>."),
    OUTDOC_X(ErrType.XQST, 119, "Serialization document '%' cannot be parsed."),
    NOVISALLOWED(ErrType.XQST, 125, "No visibility annotation allowed in inline function."),
    NSAXIS(ErrType.XQST, 134, "Namespace axis is not supported."),
    NOATTALL_X(ErrType.XQTY, 24, "Attribute does not follow root element: %."),
    NONSALL_X(ErrType.XQTY, 24, "Namespaces does not follow root element: %."),
    CONSFUNC_X(ErrType.XQTY, 105, "Invalid content: %."),
    UPNOPAR_X(ErrType.XUDY, 9, "Target has no parent: %."),
    UPNOTCOPIED_X(ErrType.XUDY, 14, "Node was not created by transform expression: %."),
    UPMULTREN_X(ErrType.XUDY, 15, "Node can only be renamed once: %."),
    UPPATHREN_X(ErrType.XUDY, 15, "Path can only be renamed once: %."),
    UPMULTREPL_X(ErrType.XUDY, 16, "Node can only be replaced once: %."),
    UPMULTDOC_X_X(ErrType.XUDY, 16, "Documents in path '%/%' can only be replaced once."),
    UPMULTREPV_X(ErrType.XUDY, 17, "Node can only be replaced once: %."),
    UPATTDUPL_X(ErrType.XUDY, 21, "Duplicate attribute: %."),
    UPNSCONFL_X_X(ErrType.XUDY, 23, "Namespace conflicts: % vs. %."),
    UPNSCONFL2_X_X(ErrType.XUDY, 24, "Namespaces conflicts: % vs. %."),
    UPSEQEMP_X(ErrType.XUDY, 27, "% target is an empty sequence."),
    UPPAREMPTY_X(ErrType.XUDY, 29, "Target has no parent: %."),
    UPATTELM_X(ErrType.XUDY, 30, "Attribute cannot be added to %."),
    UPURIDUP_X(ErrType.XUDY, 31, "URI '%' is addressed multiple times."),
    UPNOT_X(ErrType.XUST, 1, "%: no updating expression allowed."),
    UPALL(ErrType.XUST, 1, "Expressions must all be updating or return an empty sequence."),
    UPCTX(ErrType.XUST, 1, "Context value may not declare an updating expression."),
    UPMODIFY(ErrType.XUST, 2, "Transformations must all be updating or return an empty sequence."),
    UPEXPECTF(ErrType.XUST, 2, "Function body is no an updating expression."),
    DUPLREVAL(ErrType.XUST, 3, "Duplicate 'revalidation' declaration."),
    NOREVAL(ErrType.XUST, 26, "Revalidation mode not supported."),
    UUPFUNCTYPE(ErrType.XUST, 28, "No return type allowed in updating functions."),
    UPNOATTRPER_X(ErrType.XUTY, 4, "Attribute does not follow root element: %."),
    UPTRGTYP_X(ErrType.XUTY, 5, "Target is not an element or document: %."),
    UPTRGSNGL_X(ErrType.XUTY, 5, "Target is not a single node: %."),
    UPTRGTYP2_X(ErrType.XUTY, 6, "Target is not an element, text, comment or pi: %."),
    UPTRGSNGL2_X(ErrType.XUTY, 6, "Target is not a single node: %."),
    UPTRGDELEMPT_X(ErrType.XUTY, 7, "Target is not a node: %."),
    UPTRGNODE_X(ErrType.XUTY, 8, "Target is not an element, text, attribute, comment or pi: %."),
    UPTRGSINGLE_X(ErrType.XUTY, 8, "Target is not a single node: %."),
    UPWRELM_X(ErrType.XUTY, 10, "Node cannot be replaced with attribute: %."),
    UPWRATTR_X(ErrType.XUTY, 11, "Target is no attribute: %."),
    UPWRTRGTYP_X(ErrType.XUTY, 12, "Target is not an element, attribute or pi: %."),
    UPWRTRGSINGLE_X(ErrType.XUTY, 12, "Target is not a single node: %."),
    UPSINGLE_X_X(ErrType.XUTY, 13, "Value of $% is not a single node: %."),
    UPSOURCE_X(ErrType.XUTY, 13, "Source is not a node: %."),
    UPATTELM2_X(ErrType.XUTY, 22, "Attribute cannot be added to %.");

    private static final QueryError[] VALUES;
    public final String code;
    private final byte[] uri;
    private final String prefix;
    public final String desc;

    static {
        VALUES = QueryError.values();
    }

    private QueryError(ErrType type, String code, String desc) {
        this.code = code;
        this.desc = desc;
        this.uri = type.uri;
        this.prefix = type.prefix;
    }

    private QueryError(ErrType type, int number, String desc) {
        StringBuilder sb = new StringBuilder(8).append((Object)type);
        String n2 = Integer.toString(number);
        int s = 4 - n2.length();
        int i = 0;
        while (i < s) {
            sb.append('0');
            ++i;
        }
        this.code = sb.append(n2).toString();
        this.uri = type.uri;
        this.prefix = type.prefix;
        this.desc = desc;
    }

    public QueryException get(InputInfo info, Object ... ext) {
        return info != null && info.internal() ? QueryException.ERROR : new QueryException(info, this, ext);
    }

    public QueryIOException getIO(Object ... ext) {
        return new QueryIOException(this.get(null, ext));
    }

    public final boolean eq(QNm name) {
        return Token.eq(name.uri(), this.uri) && Token.eq(name.local(), Token.token(this.code));
    }

    public final QNm qname() {
        return new QNm(String.valueOf(this.prefix) + ':' + this.code, this.uri);
    }

    public final boolean is(ErrType type) {
        return this.code.startsWith(type.name());
    }

    public static QueryException get(String name, String msg, InputInfo info) {
        QueryError[] queryErrorArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryError err = queryErrorArray[n2];
            if (err.toString().equals(name)) {
                return new QueryException(info, err.qname(), msg, new Object[0]).error(err);
            }
            ++n2;
        }
        return null;
    }

    public static QueryException diffError(Item item1, Item item2, InputInfo info) {
        Type type1 = item1.type;
        Type type2 = item2.type;
        return type1 == type2 ? CMPTYPE_X.get(info, type1, item1) : CMPTYPES_X_X.get(info, type1, type2);
    }

    public static QueryException typeError(Expr expr, SeqType type, QNm name, InputInfo info) {
        TokenBuilder tb = new TokenBuilder();
        if (name != null) {
            tb.add(36).add(name.string()).add(" := ");
        }
        byte[] value = tb.add(QueryError.chop(expr, info)).finish();
        return INVTYPE_X_X_X.get(info, expr.seqType(), type, value);
    }

    public static QueryException typeError(SeqType found, SeqType type, QNm name, InputInfo info) {
        byte[] value = new TokenBuilder().add(36).add(name.string()).finish();
        return INVTYPE_X_X_X.get(info, found, type, value);
    }

    public static QueryException typeError(Value value, Type type, InputInfo info) {
        return INVTYPE_X_X_X.get(info, value.type, type, value);
    }

    public static QueryException numberError(ParseExpr expr, Item item) {
        return QueryError.numberError(item, expr.info);
    }

    public static QueryException numberError(Item item, InputInfo info) {
        return NONUMBER_X_X.get(info, item.type, item);
    }

    public static QueryException valueError(Type type, byte[] value, InputInfo info) {
        return INVALUE_X_X.get(info, type, value);
    }

    public static String arguments(long number) {
        StringBuilder sb = new StringBuilder().append(number).append(" argument");
        if (number != 1L) {
            sb.append('s');
        }
        return sb.toString();
    }

    public static byte[] chop(Object value, InputInfo info) {
        return info != null && info.internal() ? Token.EMPTY : (value instanceof byte[] ? QueryError.chop((byte[])value, info) : QueryError.chop(value.toString(), info));
    }

    public static byte[] chop(String string, InputInfo info) {
        return info != null && info.internal() ? Token.EMPTY : QueryError.chop(Token.token(string), info);
    }

    public static byte[] chop(byte[] token, InputInfo info) {
        if (info != null && info.internal()) {
            return Token.EMPTY;
        }
        TokenBuilder tb = new TokenBuilder();
        int l = 0;
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            int ts = tb.size();
            if (ts == 40) {
                tb.add("...");
                break;
            }
            if (b == 10 || b == 13) {
                b = 32;
            }
            if (b != 32 || l != 32) {
                tb.addByte((byte)b);
            }
            l = b;
            ++n2;
        }
        return tb.finish();
    }

    public String toString() {
        return this.code;
    }

    public static enum ErrType {
        ADMIN(QueryText.ADMIN_PREFIX, QueryText.ADMIN_URI),
        BASEX(QueryText.BASEX_PREFIX, QueryText.BASEX_URI),
        ARCHIVE(QueryText.ADMIN_PREFIX, QueryText.ARCHIVE_URI),
        CLIENT(QueryText.CLIENT_PREFIX, QueryText.CLIENT_URI),
        CONVERT(QueryText.CONVERT_PREFIX, QueryText.CONVERT_URI),
        CSV(QueryText.CSV_PREFIX, QueryText.CSV_URI),
        DB(QueryText.DB_PREFIX, QueryText.DB_URI),
        FETCH(QueryText.FETCH_PREFIX, QueryText.FETCH_URI),
        FT(QueryText.FT_PREFIX, QueryText.FT_URI),
        HTML(QueryText.HTML_PREFIX, QueryText.HTML_URI),
        HASH(QueryText.HASH_PREFIX, QueryText.HASH_URI),
        INSPECT(QueryText.INSPECT_PREFIX, QueryText.INSPECT_URI),
        JOBS(QueryText.JOBS_PREFIX, QueryText.JOBS_URI),
        JSON(QueryText.JSON_PREFIX, QueryText.JSON_URI),
        OUTPUT(QueryText.OUTPUT_PREFIX, QueryText.OUTPUT_URI),
        PROC(QueryText.PROC_PREFIX, QueryText.PROC_URI),
        RANDOM(QueryText.RANDOM_PREFIX, QueryText.RANDOM_URI),
        REPO(QueryText.REPO_PREFIX, QueryText.REPO_URI),
        SESSION(QueryText.SESSION_PREFIX, QueryText.SESSION_URI),
        SESSIONS(QueryText.SESSIONS_PREFIX, QueryText.SESSIONS_URI),
        SQL(QueryText.SQL_PREFIX, QueryText.SQL_URI),
        UNIT(QueryText.UNIT_PREFIX, QueryText.UNIT_URI),
        UTIL(QueryText.UTIL_PREFIX, QueryText.UTIL_URI),
        USER(QueryText.USER_PREFIX, QueryText.USER_URI),
        VALIDATE(QueryText.VALIDATE_PREFIX, QueryText.VALIDATE_URI),
        WEB(QueryText.WEB_PREFIX, QueryText.WEB_URI),
        XQUERY(QueryText.XQUERY_PREFIX, QueryText.XQUERY_URI),
        XSLT(QueryText.XSLT_PREFIX, QueryText.XSLT_URI),
        BIN(QueryText.BIN_PREFIX, QueryText.BIN_URI),
        CX(QueryText.EXPERR_PREFIX, QueryText.EXPERROR_URI),
        FILE(QueryText.FILE_PREFIX, QueryText.FILE_URI),
        HC(QueryText.EXPERR_PREFIX, QueryText.EXPERROR_URI),
        ZIP(QueryText.EXPERR_PREFIX, QueryText.EXPERROR_URI),
        FOAP,
        FOAR,
        FOAY,
        FOCA,
        FOCH,
        FODC,
        FODF,
        FODT,
        FOFD,
        FOER,
        FOJS,
        FONS,
        FORG,
        FORX,
        FOTY,
        FOUP,
        FOUT,
        FTDY,
        FTST,
        SENR,
        SEPM,
        SERE,
        SESU,
        XPDY,
        XPST,
        XPTY,
        XQDY,
        XQST,
        XQTY,
        XUDY,
        XUST,
        XUTY;

        public final String prefix;
        public final byte[] uri;

        private ErrType(byte[] pref, byte[] u) {
            this.prefix = Token.string(pref);
            this.uri = u;
        }

        private ErrType() {
            this(QueryText.ERR_PREFIX, QueryText.ERROR_URI);
        }
    }
}

