/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.options.Options;

public class AdaptiveSerializer
extends OutputSerializer {
    private static final String DOUBLES = "0.0##########################E0";
    private final OutputStream os;
    private XMLSerializer xml;

    protected AdaptiveSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        this(os, sopts, true);
    }

    protected AdaptiveSerializer(OutputStream os, SerializerOptions sopts, boolean omit) throws IOException {
        super(os, sopts);
        this.os = os;
        if (omit) {
            sopts.set(SerializerOptions.OMIT_XML_DECLARATION, Options.YesNo.YES);
        }
        this.indent = sopts.yes(SerializerOptions.INDENT);
        this.itemsep("\n");
    }

    @Override
    public Serializer sc(StaticContext sctx) {
        if (this.xml != null) {
            this.xml.sc(sctx);
        }
        return super.sc(sctx);
    }

    @Override
    public final void serialize(Item item) throws IOException {
        if (this.more) {
            this.out.print(this.itemsep);
        }
        super.serialize(item);
    }

    @Override
    protected final void node(ANode item) throws IOException {
        Type type = item.type;
        XMLSerializer ser = this.xml();
        if (type == NodeType.ATT) {
            ser.attribute(item.name(), item.string(), true);
        } else if (type == NodeType.NSP) {
            ser.namespace(item.name(), item.string(), true);
        } else {
            ser.node(item);
        }
        ser.out.flush();
        ser.reset();
    }

    @Override
    protected void atomic(Item item) throws IOException {
        TokenBuilder tb = new TokenBuilder();
        Type type = item.type;
        if (type.instanceOf(AtomType.STR) || type.instanceOf(AtomType.DEC) || type == AtomType.BLN || type == AtomType.ATM || type == AtomType.URI) {
            tb.add(item.toString());
        } else if (type == AtomType.QNM) {
            tb.add(((QNm)item).eqName());
        } else if (type == AtomType.DBL) {
            double d = ((Dbl)item).dbl();
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                tb.add(((Dbl)item).string());
            } else {
                tb.add(new DecimalFormat(DOUBLES, Token.LOC).format(d).toLowerCase());
            }
        } else {
            Item it = type.instanceOf(AtomType.DUR) ? new Dur((Dur)item) : item;
            try {
                tb.addExt(it.type, new Object[0]).add(40).add(Item.toString(it.string(null), true, false)).add(41);
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.printChars(tb.finish());
    }

    @Override
    protected final void function(FItem item) throws IOException {
        if (item instanceof Array) {
            this.array((Array)item);
        } else if (item instanceof Map) {
            this.map((Map)item);
        } else {
            TokenBuilder tb = new TokenBuilder();
            QNm fn = item.funcName();
            if (fn == null) {
                tb.add("(anonymous-function)");
            } else {
                tb.add(fn.prefixId());
            }
            this.printChars(tb.add(35).addInt(item.arity()).finish());
        }
    }

    @Override
    protected void printChar(int cp) throws IOException {
        try {
            this.out.print(cp);
        }
        catch (QueryIOException ex) {
            if (ex.getCause().error() == QueryError.SERENC_X_X) {
                this.printHex(cp);
            }
            throw ex;
        }
    }

    protected void array(Array array) throws IOException {
        TokenBuilder tb = new TokenBuilder().add(91);
        int c = 0;
        for (Value value : array.members()) {
            long vs;
            if (c++ > 0) {
                tb.add(44);
                if (this.indent) {
                    tb.add(32);
                }
            }
            if ((vs = value.size()) != 1L) {
                tb.add(40);
            }
            int i = 0;
            int cc = 0;
            while ((long)i < vs) {
                if (cc > 0) {
                    tb.add(44);
                    if (this.indent) {
                        tb.add(32);
                    }
                }
                this.printChars(tb.next());
                this.more = false;
                this.serialize(value.itemAt(i));
                ++i;
                ++cc;
            }
            if (vs == 1L) continue;
            tb.add(41);
        }
        this.printChars(tb.add(93).finish());
    }

    protected void map(Map map) throws IOException {
        TokenBuilder tb = new TokenBuilder().add("map");
        if (this.indent) {
            tb.add(32);
        }
        tb.add(123);
        int c = 0;
        ++this.level;
        for (Item key : map.keys()) {
            if (c++ > 0) {
                tb.add(44);
            }
            this.printChars(tb.next());
            this.indent();
            this.more = false;
            this.serialize(key);
            tb.add(58);
            if (this.indent) {
                tb.add(32);
            }
            try {
                boolean par;
                Value value = map.get(key, null);
                boolean bl = par = value.size() != 1L;
                if (par) {
                    tb.add(40);
                }
                int cc = 0;
                for (Item item : value) {
                    if (cc++ > 0) {
                        tb.add(44);
                        if (this.indent) {
                            tb.add(32);
                        }
                    }
                    this.printChars(tb.next());
                    this.more = false;
                    this.serialize(item);
                }
                if (!par) continue;
                tb.add(41);
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.printChars(tb.next());
        --this.level;
        this.indent();
        this.printChars(tb.add(125).finish());
    }

    private XMLSerializer xml() throws IOException {
        if (this.xml == null) {
            this.xml = new XMLSerializer(this.os, this.sopts);
            this.xml.sc(this.sc);
        }
        return this.xml;
    }
}

