/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.basex.io.in.EncodingException;
import org.basex.io.in.InputException;
import org.basex.io.in.TextInput;
import org.basex.util.Token;

abstract class TextDecoder {
    String encoding;
    boolean validate;

    TextDecoder() {
    }

    abstract int read(TextInput var1) throws IOException;

    static TextDecoder get(String enc) throws IOException {
        TextDecoder td = enc == "UTF-8" ? new UTF8() : (enc == "UTF-32" ? new UTF32() : (enc == "UTF-16LE" ? new UTF16LE() : (enc == "UTF-16" || enc == "UTF-16BE" ? new UTF16BE() : new Generic(enc))));
        td.encoding = enc;
        return td;
    }

    final int invalid() throws IOException {
        if (this.validate) {
            throw new InputException();
        }
        return 65533;
    }

    private static final class Generic
    extends TextDecoder {
        private final byte[] cache = new byte[4];
        private final ByteBuffer inc = ByteBuffer.wrap(this.cache);
        private final CharBuffer outc = CharBuffer.wrap(new char[4]);
        private final CharsetDecoder csd;

        private Generic(String enc) throws IOException {
            try {
                this.csd = Charset.forName(enc).newDecoder();
            }
            catch (Exception ex) {
                throw new EncodingException(ex);
            }
        }

        @Override
        int read(TextInput ti) throws IOException {
            int c = -1;
            while (++c < 4) {
                int ch = ti.readByte();
                if (ch < 0) break;
                this.cache[c] = (byte)ch;
                this.outc.position(0);
                this.inc.position(0);
                this.inc.limit(c + 1);
                this.csd.reset();
                CoderResult cr = this.csd.decode(this.inc, this.outc, true);
                if (cr.isMalformed()) continue;
                int i = 0;
                int os = this.outc.position();
                int o = 0;
                while (o < os) {
                    i |= this.outc.get(o) << (o << 3);
                    ++o;
                }
                return i;
            }
            return c == 0 ? -1 : this.invalid();
        }
    }

    private static class UTF16BE
    extends TextDecoder {
        private UTF16BE() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid();
            }
            return a << 8 | b;
        }
    }

    private static class UTF16LE
    extends TextDecoder {
        private UTF16LE() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid();
            }
            return a | b << 8;
        }
    }

    private static class UTF32
    extends TextDecoder {
        private UTF32() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid();
            }
            int c = ti.readByte();
            if (c < 0) {
                return this.invalid();
            }
            int d = ti.readByte();
            if (d < 0) {
                return this.invalid();
            }
            return a << 24 | b << 16 | c << 8 | d;
        }
    }

    private static class UTF8
    extends TextDecoder {
        private final byte[] cache = new byte[4];

        private UTF8() {
        }

        @Override
        int read(TextInput ti) throws IOException {
            int ch = ti.readByte();
            if (ch < 128) {
                return ch;
            }
            if (ch < 192) {
                return this.invalid();
            }
            this.cache[0] = (byte)ch;
            int cl = Token.cl((byte)ch);
            int c = 1;
            while (c < cl) {
                ch = ti.readByte();
                if (ch < 128) {
                    return this.invalid();
                }
                this.cache[c] = (byte)ch;
                ++c;
            }
            return Token.cp(this.cache, 0);
        }
    }
}

