/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.stats;

import org.basex.core.Text;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class IndexStats {
    private final int max;
    private final int[] occMin;
    private final int[] occMax;
    private final byte[][] txtMin;
    private final byte[][] txtMax;
    private int size;

    public IndexStats(int max) {
        this.max = max;
        this.occMin = new int[max];
        this.occMax = new int[max];
        this.txtMin = new byte[max][];
        this.txtMax = new byte[max][];
        int t = 0;
        while (t < max) {
            this.txtMin[t] = Token.EMPTY;
            this.txtMax[t] = Token.EMPTY;
            this.occMin[t] = Integer.MAX_VALUE;
            ++t;
        }
    }

    public boolean adding(int oc) {
        if (oc == 0) {
            return false;
        }
        ++this.size;
        return oc > this.occMax[this.max - 1] || oc < this.occMin[this.max - 1];
    }

    public void add(byte[] tx, int oc) {
        boolean dsc = oc > this.occMax[this.max - 1];
        byte[][] txt = dsc ? this.txtMax : this.txtMin;
        int[] ocs = dsc ? this.occMax : this.occMin;
        int a = this.max - 1;
        while (a >= 0) {
            if (a == 0 || dsc && oc < ocs[a - 1] || !dsc && oc > ocs[a - 1]) {
                txt[a] = tx;
                ocs[a] = oc;
                break;
            }
            txt[a] = txt[a - 1];
            ocs[a] = ocs[a - 1];
            --a;
        }
    }

    public void print(TokenBuilder tb) {
        tb.add("- Entries: ").addInt(this.size).add(Text.NL);
        int m = 0;
        int c = 0;
        int o = 0;
        while (o < this.max) {
            int tl = this.txtMin[o].length;
            if (tl == 0) {
                ++c;
            } else if (m < tl) {
                m = tl;
            }
            tl = this.txtMax[o].length;
            if (tl == 0) {
                ++c;
            } else if (m < tl) {
                m = tl;
            }
            ++o;
        }
        IndexStats.print(tb, this.txtMax, this.occMax, m + 2);
        if (c == 0) {
            tb.add("  ").add("...").add(Text.NL);
        }
        IndexStats.print(tb, this.txtMin, this.occMin, m + 2);
    }

    private static void print(TokenBuilder tb, byte[][] txt, int[] ocs, int len) {
        int ol = ocs.length;
        int o = 0;
        while (o < ol) {
            int tl = txt[o].length;
            if (tl != 0) {
                tb.add("  ").add(txt[o]);
                int jl = len - tl;
                int j = 0;
                while (j < jl) {
                    tb.add(32);
                    ++j;
                }
                tb.addInt(ocs[o]).add(120).add(Text.NL);
            }
            ++o;
        }
    }
}

