/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import org.basex.core.Context;
import org.basex.core.cmd.Find;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.view.table.TableIterator;
import org.basex.index.name.Names;
import org.basex.index.stats.StatsType;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class TableData {
    private static final int MAXROWS = 1000;
    private static final byte[] MAXTOK = new byte[]{-1};
    private static final byte[] MAXNUM = Token.token(Double.MAX_VALUE);
    final Context ctx;
    TokenList roots;
    IntList rootRows;
    IntList rows;
    TableCol[] cols;
    int rowH;
    int sortCol = -1;
    boolean asc;
    int mouseX;
    int mouseY;
    int root;
    private final GUIOptions gopts;
    private String last = "";

    TableData(Context ctx, GUIOptions gopts) {
        this.ctx = ctx;
        this.gopts = gopts;
    }

    void init(Data data) {
        this.roots = new TokenList();
        for (byte[] k : data.paths.desc(Token.EMPTY, true, true)) {
            int c = 0;
            for (byte[] kk : data.paths.desc(k, true, false)) {
                Names names;
                Names names2 = names = Token.startsWith(kk, 64) ? data.attrNames : data.elemNames;
                if (!names.stats(names.id(Token.delete(kk, 64))).isLeaf()) continue;
                ++c;
            }
            if (c <= 2) continue;
            this.roots.add(k);
        }
        this.init(data, -1);
    }

    void init(Data dt, int rt) {
        this.cols = new TableCol[0];
        this.root = rt;
        this.sortCol = -1;
        this.last = "";
        this.rowH = 1;
        if (rt == -1 && this.roots.isEmpty()) {
            return;
        }
        if (this.root == -1) {
            this.root = dt.elemNames.id((byte[])this.roots.get(0));
        }
        for (byte[] k : dt.paths.desc(dt.elemNames.key(this.root), true, true)) {
            Names names;
            boolean elem = !Token.startsWith(k, 64);
            byte[] key = Token.delete(k, 64);
            Names names2 = names = elem ? dt.elemNames : dt.attrNames;
            if (!names.stats(names.id(key)).isLeaf()) continue;
            this.addCol(key, elem);
        }
        this.context(true);
    }

    void context(boolean create) {
        if (this.cols.length == 0) {
            return;
        }
        boolean rt = this.ctx.root();
        if (!create && rt && this.rootRows != null) {
            this.rows = this.rootRows;
            this.sortCol = -1;
        } else {
            this.createRows();
            if (rt) {
                this.rootRows = this.rows;
            }
        }
        if (this.cols[0].width == 0.0 && this.cols[0].hwidth == 0.0) {
            this.calcWidths();
        }
    }

    private void addCol(byte[] name, boolean elem) {
        Data data = this.ctx.data();
        int id = (elem ? data.elemNames : data.attrNames).id(name);
        if (id == 0) {
            return;
        }
        TableCol col = new TableCol();
        col.id = id;
        col.elem = elem;
        col.name = name;
        this.cols = Array.add(this.cols, col);
    }

    private void createRows() {
        Data data = this.ctx.data();
        this.rows = new IntList();
        int[] nArray = this.ctx.current().pres();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int pre = nArray[n2];
            if (pre >= data.meta.size) break;
            int s = pre + data.size(pre, data.kind(pre));
            while ((data.kind(pre) != 1 || data.nameId(pre) != this.root) && ++pre < s) {
            }
            while (pre < s) {
                int k = data.kind(pre);
                if (k == 1 && data.nameId(pre) == this.root) {
                    this.rows.add(pre);
                }
                pre += data.attSize(pre, k);
            }
            ++n2;
        }
        this.sort();
    }

    private void calcWidths() {
        if (this.cols.length == 0) {
            return;
        }
        Data data = this.ctx.data();
        int cs = this.cols.length;
        int nRows = this.rows.size();
        TableIterator ti = new TableIterator(data, this);
        int ll = Math.min(nRows, 1000);
        int l = 0;
        while (l < ll) {
            ti.init(this.rows.get(l));
            while (ti.more()) {
                this.cols[ti.col].width += (double)data.textLen(ti.pre, ti.text);
            }
            ++l;
        }
        double[] widths = new double[cs];
        int c = 0;
        while (c < cs) {
            widths[c] = this.cols[c].width;
            ++c;
        }
        int[] il = Array.createOrder(widths, false);
        TableCol[] cl = new TableCol[cs];
        int c2 = 0;
        while (c2 < cs) {
            cl[c2] = this.cols[il[c2]];
            ++c2;
        }
        this.cols = cl;
        this.setWidths(false);
    }

    void setWidths(boolean force) {
        TableCol col;
        double sum = 0.0;
        TableCol[] tableColArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            TableCol col2 = tableColArray[n2];
            sum += col2.width;
            ++n2;
        }
        double min = force ? 0.0 : 0.5;
        int cs = this.cols.length;
        TableCol[] tableColArray2 = this.cols;
        int n3 = this.cols.length;
        int n4 = 0;
        while (n4 < n3) {
            col = tableColArray2[n4];
            col.width = Math.max(min / (double)cs, col.width / sum);
            ++n4;
        }
        sum = 0.0;
        tableColArray2 = this.cols;
        n3 = this.cols.length;
        n4 = 0;
        while (n4 < n3) {
            col = tableColArray2[n4];
            sum += col.width;
            ++n4;
        }
        tableColArray2 = this.cols;
        n3 = this.cols.length;
        n4 = 0;
        while (n4 < n3) {
            col = tableColArray2[n4];
            col.width /= sum;
            ++n4;
        }
    }

    void sort() {
        if (this.sortCol == -1) {
            return;
        }
        int c = this.cols[this.sortCol].id;
        boolean e = this.cols[this.sortCol].elem;
        Data data = this.ctx.data();
        Names index = e ? data.elemNames : data.attrNames;
        boolean num = StatsType.isNumeric(index.stats((int)c).type);
        byte[][] tokens = new byte[this.rows.size()][];
        int rs = this.rows.size();
        int r = 0;
        while (r < rs) {
            int p = this.rows.get(r);
            int s = p + data.size(p, data.kind(p));
            while (p != s) {
                int k = data.kind(p);
                if ((e ? k == 1 : k == 3) && data.nameId(p) == c) {
                    tokens[r] = data.atom(p);
                    break;
                }
                p += e ? data.attSize(p, k) : 1;
            }
            if (tokens[r] == null || tokens[r].length == 0) {
                tokens[r] = num ? MAXNUM : MAXTOK;
            }
            ++r;
        }
        this.rows.sort(tokens, num, this.asc);
    }

    int getRoot(Data data, int pre) {
        if (pre == -1) {
            return -1;
        }
        int p = pre;
        int k = data.kind(p);
        while (p != -1 && (k != 1 || data.nameId(p) != this.root)) {
            int n = k = (p = data.parent(p, k)) == -1 ? 0 : data.kind(p);
        }
        return p;
    }

    int column(int w, int mx) {
        double cs = 0.0;
        int cl = this.cols.length;
        int c = 0;
        while (c < cl) {
            double cw = (double)w * this.cols[c].width;
            double ce = cs + cw;
            if ((double)mx > cs && (double)mx < ce) {
                return c;
            }
            cs = ce;
            ++c;
        }
        return -1;
    }

    void resetFilter() {
        TableCol[] tableColArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            TableCol col = tableColArray[n2];
            col.filter = "";
            ++n2;
        }
    }

    String find() {
        Data data = this.ctx.data();
        boolean r = this.rows == this.rootRows;
        StringList filters = new StringList();
        TokenList names = new TokenList();
        BoolList elems = new BoolList();
        TableCol[] tableColArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            TableCol col = tableColArray[n2];
            filters.add(col.filter);
            names.add(col.name);
            elems.add(col.elem);
            ++n2;
        }
        String query = Find.findTable(filters, names, elems, data.elemNames.key(this.root), this.gopts.get(GUIOptions.FILTERRT) != false || r);
        if (query.equals(this.last)) {
            return null;
        }
        this.last = query;
        return query;
    }

    int rowH(double f) {
        this.rowH = Math.max(1, (int)(f * (double)GUIConstants.fontSize * 7.0 / 4.0));
        return this.rowH;
    }

    static final class TableCol {
        byte[] name;
        int id;
        boolean elem;
        double width;
        double hwidth;
        String filter = "";

        TableCol() {
        }
    }
}

