/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.Container;
import java.awt.Window;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Array;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ViewNotifier {
    private static final long LARGEDB = 200000000L;
    public static final int MAXHIST = 20;
    public int hist;
    final GUI gui;
    private final DBNodes[] marked = new DBNodes[20];
    private final DBNodes[] cont = new DBNodes[20];
    private final String[] queries = new String[20];
    private View[] view = new View[0];
    private int histsize;

    public ViewNotifier(GUI gui) {
        this.gui = gui;
    }

    void add(View vw) {
        this.view = Array.add(this.view, vw);
    }

    public void init() {
        int n;
        int n2;
        Container[] containerArray;
        Data data = this.initHistory(this.gui.context);
        if (data != null) {
            View v;
            long size = data.meta.dbsize();
            boolean open = false;
            View[] viewArray = this.view;
            int n3 = this.view.length;
            int n4 = 0;
            while (n4 < n3) {
                v = viewArray[n4];
                open |= v.visible() && v.db();
                ++n4;
            }
            if (open && size > 200000000L && BaseXDialog.confirm(this.gui, Util.info(Text.H_LARGE_DB, Performance.format(size)))) {
                viewArray = this.view;
                n3 = this.view.length;
                n4 = 0;
                while (n4 < n3) {
                    v = viewArray[n4];
                    if (v.visible() && v.db()) {
                        v.visible(false);
                    }
                    ++n4;
                }
            }
        } else {
            containerArray = this.gui.getOwnedWindows();
            n2 = containerArray.length;
            n = 0;
            while (n < n2) {
                Window w = containerArray[n];
                if (w.isVisible() && w instanceof BaseXDialog) {
                    ((BaseXDialog)w).cancel();
                }
                ++n;
            }
        }
        this.gui.context.focused = -1;
        containerArray = this.view;
        n2 = this.view.length;
        n = 0;
        while (n < n2) {
            Container v = containerArray[n];
            ((View)v).refreshInit();
            ++n;
        }
        this.gui.layoutViews();
        this.gui.setTitle();
    }

    public void focus(int pre, View vw) {
        if (this.gui.context.focused == pre) {
            return;
        }
        this.gui.context.focused = pre;
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v != vw && v.visible()) {
                v.refreshFocus();
            }
            ++n2;
        }
        if (pre != -1) {
            this.gui.status.setText(Token.string(ViewData.path(this.gui.context.data(), pre)));
        }
    }

    public void mark(DBNodes mark, View vw) {
        Context ctx = this.gui.context;
        ctx.marked = mark;
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v != vw && v.visible()) {
                v.refreshMark();
            }
            ++n2;
        }
        this.gui.filter.setEnabled(!mark.isEmpty());
        this.gui.refreshControls();
    }

    public void mark(int mode, View vw) {
        int f = this.gui.context.focused;
        if (f == -1) {
            return;
        }
        Context ctx = this.gui.context;
        DBNodes nodes = ctx.marked;
        if (mode == 0) {
            nodes = new DBNodes(ctx.data(), f);
        } else if (mode == 1) {
            nodes.union(new int[]{f});
        } else {
            nodes.toggle(f);
        }
        this.mark(nodes, vw);
    }

    public void hist(boolean forward) {
        String query;
        Context ctx = this.gui.context;
        if (forward) {
            if (this.hist == this.histsize) {
                return;
            }
            query = this.queries[++this.hist];
        } else {
            if (this.hist == 0) {
                return;
            }
            this.marked[this.hist] = ctx.marked;
            query = this.queries[--this.hist];
        }
        ctx.set(this.cont[this.hist], this.marked[this.hist]);
        this.gui.input.setText(query);
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v.visible()) {
                v.refreshContext(forward, false);
            }
            ++n2;
        }
        this.gui.refreshControls();
    }

    public void context(DBNodes nodes, boolean quick, View vw) {
        DBNodes cmp;
        Context ctx = this.gui.context;
        DBNodes newn = nodes.discardDocs();
        DBNodes empty = new DBNodes(ctx.data(), new int[0]).ftpos(ctx.marked.ftpos());
        DBNodes curr = quick ? ctx.current() : null;
        DBNodes dBNodes = cmp = quick ? curr : ctx.marked;
        if (this.cont[this.hist] == null ? cmp != null : cmp == null || !this.cont[this.hist].equals(cmp)) {
            this.checkHist();
            if (quick) {
                this.queries[this.hist] = "";
                this.marked[this.hist] = new DBNodes(ctx.data(), new int[0]);
                this.cont[++this.hist] = curr;
            } else {
                String in;
                this.queries[this.hist] = in = this.gui.input.getText();
                this.marked[this.hist] = ctx.marked;
                this.cont[++this.hist] = newn;
                this.queries[this.hist] = in;
                this.marked[this.hist] = empty;
            }
            this.histsize = this.hist;
        }
        ctx.set(newn, empty);
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v != vw && v.visible()) {
                v.refreshContext(true, quick);
            }
            ++n2;
        }
        this.gui.refreshControls();
    }

    public void update() {
        Data data = this.initHistory(this.gui.context);
        if (data == null) {
            return;
        }
        this.gui.context.marked = new DBNodes(data, new int[0]);
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v.visible()) {
                v.refreshUpdate();
            }
            ++n2;
        }
        this.gui.refreshControls();
    }

    public void layout() {
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            v.refreshLayout();
            ++n2;
        }
    }

    public String query(boolean back) {
        return back ? (this.hist > 0 ? (this.hist > 1 ? this.queries[this.hist - 2] : "") : null) : (this.hist < this.histsize ? this.queries[this.hist + 1] : null);
    }

    private void checkHist() {
        int hl = this.queries.length;
        if (this.hist + 1 == hl) {
            Array.move(this.queries, 1, 0, hl - 1);
            Array.move(this.cont, 1, 0, hl - 1);
            Array.move(this.marked, 1, 0, hl - 1);
            --this.hist;
        }
    }

    private Data initHistory(Context ctx) {
        int h = 0;
        while (h < this.histsize) {
            this.marked[h] = null;
            this.cont[h] = null;
            this.queries[h] = null;
            ++h;
        }
        this.hist = 0;
        this.histsize = 0;
        Data data = ctx.data();
        if (data != null) {
            this.marked[0] = new DBNodes(data, new int[0]);
            this.queries[0] = "";
        }
        return data;
    }
}

