/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.ViewContainer;
import org.basex.gui.view.ViewPanel;

final class ViewMover
extends BaseXPanel {
    private boolean move;
    private boolean in;

    ViewMover(GUI gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(GUIConstants.CURSORMOVE);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 8));
        new BaseXPopup(this, new GUIPopupCmd(Text.CLOSE, new BaseXKeys[0]){

            @Override
            public void execute() {
                ((ViewPanel)ViewMover.this.getParent()).delete();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(GUIConstants.PANEL);
        g.fillRect(0, 0, w, h);
        g.setColor(this.move || this.in ? GUIConstants.mgray : GUIConstants.gray);
        int y = h - 1;
        while (y >= 0) {
            g.drawLine(0, y, w, y);
            y -= 2;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ViewPanel view = (ViewPanel)this.getParent();
        Container comp = view;
        while (!((comp = comp.getParent()) instanceof ViewContainer)) {
        }
        Point a = this.getLocationOnScreen();
        Point b = comp.getLocationOnScreen();
        Point c = new Point(a.x - b.x + e.getX(), a.y - b.y + e.getY());
        ((ViewContainer)comp).dragPanel(view, c);
        this.move = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.move = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.move) {
            return;
        }
        Container comp = this;
        while (!((comp = comp.getParent()) instanceof ViewContainer)) {
        }
        ((ViewContainer)comp).dropPanel();
        this.move = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.in = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.in = false;
        this.repaint();
    }
}

