/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTextField;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextHint;
import org.basex.gui.layout.BaseXWindow;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class BaseXTextField
extends JTextField {
    public static final int DWIDTH = 350;
    private static Color back;
    private Options options;
    private Option<?> option;
    private BaseXTextHint hint;
    private String last = "";

    public BaseXTextField(GUI gui) {
        this(gui, null);
    }

    public BaseXTextField(BaseXDialog dialog) {
        this(dialog, null);
    }

    public BaseXTextField(BaseXDialog dialog, NumberOption option, Options options) {
        this(dialog, (Option<?>)option, options);
    }

    public BaseXTextField(BaseXDialog dialog, StringOption option, Options options) {
        this(dialog, (Option<?>)option, options);
    }

    private BaseXTextField(BaseXDialog dialog, Option<?> option, Options options) {
        this(dialog, options.get(option) == null ? null : options.get(option).toString());
        this.options = options;
        this.option = option;
    }

    public BaseXTextField(BaseXWindow win, String text) {
        BaseXLayout.setWidth(this, 350);
        BaseXLayout.addInteraction(this, win);
        if (back == null) {
            back = this.getBackground();
        }
        if (text != null) {
            this.setText(text);
        }
        this.addFocusListener(e -> this.selectAll());
        this.addKeyListener(e -> {
            if (BaseXKeys.UNDOSTEP.is(e) || BaseXKeys.REDOSTEP.is(e)) {
                String t = this.getText();
                this.setText(this.last);
                this.last = t;
            }
        });
        BaseXDialog dialog = win.dialog();
        if (dialog != null) {
            this.addKeyListener(dialog.keys);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.hint != null) {
            this.hint.setFont(f);
        }
    }

    public final BaseXTextField hint(String label) {
        if (this.hint == null) {
            this.hint = new BaseXTextHint(label, this);
        } else {
            this.hint.setText(label);
        }
        this.setToolTipText(label.replaceAll("\\.\\.\\.$", ""));
        return this;
    }

    @Override
    public void setText(String text) {
        this.last = text;
        super.setText(text);
        if (this.hint != null) {
            this.hint.update();
        }
    }

    public final boolean assign() {
        return this.check(true);
    }

    public final boolean check() {
        return this.check(false);
    }

    private boolean check(boolean assign) {
        if (this.option instanceof NumberOption) {
            try {
                int num = Integer.parseInt(this.getText());
                if (assign) {
                    this.options.set((NumberOption)this.option, num);
                }
                this.setBackground(back);
            }
            catch (NumberFormatException ignored) {
                this.setBackground(GUIConstants.LRED);
                return false;
            }
        } else {
            this.options.set((StringOption)this.option, this.getText());
        }
        return true;
    }
}

