/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplitSep;

public final class BaseXSplit
extends BaseXBack
implements LayoutManager {
    private final boolean horizontal;
    private double[] propSize;
    private double[] dragSize;
    private double dragPos;
    private double[] hiddenSize;
    private double[] cachedSize;

    public BaseXSplit(boolean horizontal) {
        this.layout(this);
        this.horizontal = horizontal;
    }

    @Override
    public Component add(Component comp) {
        if (this.getComponentCount() != 0) {
            super.add(new BaseXSplitSep(this.horizontal));
        }
        super.add(comp);
        this.propSize = null;
        return comp;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.propSize = null;
    }

    public void init(double[] vis, double[] hidden) {
        this.propSize = vis;
        this.hiddenSize = hidden;
    }

    public void visible(boolean show) {
        boolean s = true;
        if (this.propSize != null) {
            double[] dArray = this.propSize;
            int n = this.propSize.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                s &= d != 0.0;
                ++n2;
            }
        }
        if (this.propSize == null || s ^ show) {
            if (show) {
                this.propSize = this.cachedSize;
            } else {
                this.cachedSize = this.propSize;
                this.propSize = this.hiddenSize;
            }
            this.revalidate();
        }
    }

    void startDrag(double p) {
        this.dragPos = p;
        this.dragSize = (double[])this.propSize.clone();
    }

    void drag(BaseXSplitSep sep, double p) {
        if (this.dragSize == null) {
            this.startDrag(p);
        }
        Component[] m = this.getComponents();
        int r = this.propSize.length;
        int q = 0;
        int n = 0;
        while (n < r - 1) {
            if (m[(n << 1) + 1] == sep) {
                q = n + 1;
            }
            ++n;
        }
        double v = (this.dragPos - p) / (double)(this.horizontal ? this.getWidth() : this.getHeight());
        int i = 0;
        while (i < q) {
            if (this.dragSize[i] - v / (double)q < 1.0E-4) {
                return;
            }
            ++i;
        }
        i = q;
        while (i < r) {
            if (this.dragSize[i] + v / (double)(r - q) < 1.0E-4) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < q) {
            this.propSize[i] = this.dragSize[i] - v / (double)q;
            ++i;
        }
        i = q;
        while (i < r) {
            this.propSize[i] = this.dragSize[i] + v / (double)(r - q);
            ++i;
        }
        this.revalidate();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int c;
        Component[] comps = this.getComponents();
        int cl = comps.length;
        int w = this.getWidth();
        int h = this.getHeight();
        int panels = comps.length + 1 >> 1;
        if (this.propSize == null) {
            this.propSize = new double[panels];
            c = 0;
            while (c < cl) {
                if ((c & 1) == 0) {
                    this.propSize[c >> 1] = 1.0 / (double)panels;
                }
                ++c;
            }
        }
        c = panels - 1;
        double[] dArray = this.propSize;
        int n = this.propSize.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d == 0.0) {
                --c;
            }
            ++n2;
        }
        int sz = (this.horizontal ? w : h) - c * 8;
        double posD = 0.0;
        boolean invisible = false;
        c = 0;
        while (c < cl) {
            int size;
            if ((c & 1) == 0) {
                size = (int)(this.propSize[c >> 1] * (double)sz);
                invisible = size == 0;
            } else {
                size = invisible ? 0 : 8;
            }
            int pos = (int)posD;
            if (this.horizontal) {
                comps[c].setBounds(pos, 0, size, h);
            } else {
                comps[c].setBounds(0, pos, w, size);
            }
            posD += (double)size;
            ++c;
        }
    }
}

