/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.basex.gui.GUIConstants;
import org.basex.util.Prop;

public enum BaseXKeys {
    PREVCHAR(0, 37, 1),
    NEXTCHAR(0, 39, 1),
    PREVWORD(Prop.MAC ? 8 : GUIConstants.META, 37, 1),
    NEXTWORD(Prop.MAC ? 8 : GUIConstants.META, 39, 1),
    LINESTART(Prop.MAC ? GUIConstants.META : 0, Prop.MAC ? 37 : 36, 1),
    LINEEND(Prop.MAC ? GUIConstants.META : 0, Prop.MAC ? 39 : 35, 1),
    PREVLINE(0, 38, 1),
    NEXTLINE(0, 40, 1),
    PREVPAGE(0, 33, 1),
    NEXTPAGE(0, 34, 1),
    TEXTSTART(GUIConstants.META, Prop.MAC ? 38 : 36, 1),
    TEXTEND(GUIConstants.META, Prop.MAC ? 40 : 35, 1),
    SCROLLUP(Prop.MAC ? 8 : GUIConstants.META, 38),
    SCROLLDOWN(Prop.MAC ? 8 : GUIConstants.META, 40),
    TAB(0, 9, 1),
    PREVPAGE_RO(1, 32),
    NEXTPAGE_RO(0, 32),
    DELPREV(0, 8, 1),
    DELNEXT(0, 127),
    UNDOSTEP(GUIConstants.META, 90),
    REDOSTEP(Prop.MAC ? GUIConstants.META | 1 : GUIConstants.META, Prop.MAC ? 90 : 89),
    CUT1(GUIConstants.META, 88),
    CUT2(1, 127),
    COPY1(GUIConstants.META, 67),
    COPY2(GUIConstants.META, 155),
    PASTE1(GUIConstants.META, 86),
    PASTE2(1, 155),
    SELECTALL(GUIConstants.META, 65),
    MOVEDOWN(Prop.MAC ? 9 : 8, 40),
    MOVEUP(Prop.MAC ? 9 : 8, 38),
    COMPLETE(2, 32),
    DELPREVWORD(Prop.MAC ? 8 : GUIConstants.META, 8),
    DELNEXTWORD(Prop.MAC ? 8 : GUIConstants.META, 127),
    DELLINESTART(GUIConstants.META | (Prop.MAC ? 0 : 1), 8),
    DELLINEEND(GUIConstants.META | (Prop.MAC ? 0 : 1), 127),
    DELLINE(GUIConstants.META | 1, 68),
    FOCUSINPUT(Prop.MAC ? GUIConstants.META : 0, 117),
    FOCUSEDITOR(Prop.MAC ? GUIConstants.META : 0, 123),
    NEXTTAB(2, 9),
    PREVTAB(3, 9),
    CLOSETAB(GUIConstants.META, 115),
    GOBACK(Prop.MAC ? GUIConstants.META : 8, 37),
    GOFORWARD(Prop.MAC ? GUIConstants.META : 8, 39),
    GOUP(Prop.MAC ? GUIConstants.META : 8, 38),
    GOHOME(Prop.MAC ? GUIConstants.META : 8, 36),
    GOTOLINE(GUIConstants.META, 76),
    FIND(GUIConstants.META, 70),
    FINDNEXT1(Prop.MAC ? GUIConstants.META : 0, 114),
    FINDNEXT2(GUIConstants.META, 71),
    FINDPREV1(Prop.MAC ? GUIConstants.META | 1 : 1, 114),
    FINDPREV2(GUIConstants.META | 1, 71),
    INCFONT1(GUIConstants.META, 521),
    INCFONT2(GUIConstants.META, 61),
    DECFONT(GUIConstants.META, 45),
    NORMFONT(GUIConstants.META, 48),
    EXEC1(GUIConstants.META, 10),
    UNIT(GUIConstants.META | 1, 10),
    ESCAPE(0, 27),
    CONTEXT(0, 525),
    COPYPATH(GUIConstants.META | 1, 67),
    REFRESH(0, 116),
    RENAME(0, 113),
    NEWDIR(GUIConstants.META | 1, 78),
    SPACE(0, 32, 1 | GUIConstants.META),
    ENTER(0, 10),
    SHIFT_ENTER(1, 10);

    private final int modifiers;
    private final int key;
    private final int allowed;

    private BaseXKeys(int modifiers, int key, int allowed) {
        this.modifiers = modifiers;
        this.key = key;
        this.allowed = allowed;
    }

    private BaseXKeys(int m, int k) {
        this(m, k, 0);
    }

    public boolean is(KeyEvent e) {
        int c = e.getKeyCode();
        int m = e.getModifiers() | this.allowed;
        return m == (this.modifiers | this.allowed) && (c == 0 ? KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar()) : c) == this.key;
    }

    public static boolean sc(InputEvent e) {
        return (GUIConstants.META & e.getModifiers()) == GUIConstants.META;
    }

    public static boolean control(KeyEvent e) {
        return e.isControlDown() || e.isMetaDown() || !Prop.MAC && e.isAltDown();
    }

    public static boolean modifier(KeyEvent e) {
        int c = e.getKeyCode();
        return c == 18 || c == 16 || c == 157 || c == 17 || c == 19 || c == 20 || c == 27 || c == 9 && (e.isAltDown() || e.isMetaDown() || e.isControlDown());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(KeyEvent.getKeyModifiersText(this.modifiers));
        if (sb.length() != 0) {
            sb.append('+');
        }
        return sb.append(KeyEvent.getKeyText(this.key)).toString();
    }

    String shortCut() {
        StringBuilder sb = new StringBuilder();
        if ((this.modifiers & 4) != 0) {
            sb.append("meta").append(' ');
        }
        if ((this.modifiers & 2) != 0) {
            sb.append("ctrl").append(' ');
        }
        if ((this.modifiers & 8) != 0) {
            sb.append("alt").append(' ');
        }
        if ((this.modifiers & 1) != 0) {
            sb.append("shift").append(' ');
        }
        if (this.key == 10) {
            sb.append("ENTER");
        } else if (this.key == 127) {
            sb.append("DELETE");
        } else if (this.key == 46) {
            sb.append("PERIOD");
        } else {
            sb.append(KeyEvent.getKeyText(this.key));
        }
        return sb.toString();
    }
}

