/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.http.MediaType;

public final class BaseXImages {
    private static final HashMap<String, ImageIcon> ICONS = new HashMap();
    private static final HashMap<String, Icon> FILES = new HashMap();
    private static final FileSystemView FS = FileSystemView.getFileSystemView();
    private static final Icon XMLTEXT = BaseXImages.icon("text_xml");
    private static final Icon RAWTEXT = BaseXImages.icon("text_raw");
    private static final Icon DIR1 = BaseXImages.icon("file_dir1");
    private static final Icon DIR2 = BaseXImages.icon("file_dir2");
    private static final Icon TEXT = BaseXImages.icon("file_text");
    private static final Icon XML = BaseXImages.icon("file_xml");
    private static final Icon XQUERY = BaseXImages.icon("file_xquery");
    private static final Icon BASEX = BaseXImages.icon("file_basex");
    private static final Icon UNKNOWN = BaseXImages.icon("file_unknown");

    private BaseXImages() {
    }

    public static Image get(String name) {
        return BaseXImages.get(BaseXImages.url(name));
    }

    public static Image get(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    public static ImageIcon icon(String name) {
        return ICONS.computeIfAbsent(name, n -> new ImageIcon(BaseXImages.get(n)));
    }

    private static URL url(String name) {
        String path = "/img/" + name + ".png";
        URL url = BaseXImages.class.getResource(path);
        if (url == null) {
            Util.stack("Image not found: " + path);
            url = BaseXImages.class.getResource("/img/warn.png");
        }
        return url;
    }

    public static Icon dir(boolean expanded) {
        return expanded ? DIR2 : DIR1;
    }

    public static Icon text(boolean raw) {
        return raw ? RAWTEXT : XMLTEXT;
    }

    public static Icon file(IOFile file) {
        if (file == null) {
            return UNKNOWN;
        }
        String path = file.path();
        MediaType type = MediaType.get(path);
        if (type.isXML()) {
            return XML;
        }
        if (type.isXQuery()) {
            return XQUERY;
        }
        if (path.contains(".basex")) {
            return BASEX;
        }
        if (Prop.WIN) {
            int p = path.lastIndexOf(path, 46);
            String suffix = p == -1 ? null : path.substring(p + 1);
            Icon icon = null;
            if (suffix != null) {
                icon = FILES.get(suffix);
            }
            if (icon == null) {
                icon = FS.getSystemIcon(file.file());
                if (suffix != null) {
                    FILES.put(suffix, icon);
                }
            }
            return icon;
        }
        return type.isText() ? TEXT : UNKNOWN;
    }
}

