/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import javax.swing.UIManager;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSerial;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Reflect;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;

final class DialogVisualPrefs
extends BaseXBack {
    private final GUI gui;
    private final BaseXCheckBox showNames;
    private final BaseXCheckBox treeSlims;
    private final BaseXCheckBox treeAtts;
    private final BaseXCombo mapAlgo;
    private final BaseXSlider mapWeight;
    private final BaseXCheckBox mapAtts;
    private final BaseXCombo mapOffsets;
    private final BaseXCombo lookfeel;
    private final BaseXSerial serial;
    private final StringList classes = new StringList();
    private static final String[] LOOKANDFEELS = new String[]{"com.jtattoo.plaf.acryl.AcrylLookAndFeel", "com.jtattoo.plaf.aero.AeroLookAndFeel", "com.jtattoo.plaf.aluminium.AluminiumLookAndFeel", "com.jtattoo.plaf.bernstein.BernsteinLookAndFeel", "com.jtattoo.plaf.fast.FastLookAndFeel", "com.jtattoo.plaf.graphite.GraphiteLookAndFeel", "com.jtattoo.plaf.hifi.HiFiLookAndFeel", "com.jtattoo.plaf.luna.LunaLookAndFeel", "com.jtattoo.plaf.mcwin.McWinLookAndFeel", "com.jtattoo.plaf.mint.MintLookAndFeel", "com.jtattoo.plaf.noire.NoireLookAndFeel", "com.jtattoo.plaf.smart.SmartLookAndFeel", "com.jtattoo.plaf.texture.TextureLookAndFeel"};

    DialogVisualPrefs(BaseXDialog dialog) {
        this.border(8).setLayout(new TableLayout(2, 1, 0, 8));
        this.gui = dialog.gui;
        GUIOptions gopts = dialog.gui.gopts;
        this.showNames = new BaseXCheckBox(dialog, Text.SHOW_NAME_ATTS, GUIOptions.SHOWNAME, gopts);
        this.treeSlims = new BaseXCheckBox(dialog, Text.ADJUST_NODES, GUIOptions.TREESLIMS, gopts);
        this.treeAtts = new BaseXCheckBox(dialog, Text.SHOW_ATTS, GUIOptions.TREEATTS, gopts);
        this.mapAlgo = new BaseXCombo((BaseXWindow)dialog, GUIOptions.MAPALGO, (Options)gopts, Text.MAP_LAYOUTS);
        this.mapOffsets = new BaseXCombo((BaseXWindow)dialog, GUIOptions.MAPOFFSETS, (Options)gopts, Text.MAP_CHOICES);
        this.mapWeight = new BaseXSlider(dialog, 0, 100, GUIOptions.MAPWEIGHT, gopts);
        this.mapAtts = new BaseXCheckBox(dialog, Text.SHOW_ATTS, GUIOptions.MAPATTS, gopts);
        this.mapAlgo.setSize(200, 100);
        BaseXLayout.setWidth(this.mapWeight, 150);
        StringList lafs = new StringList("(default)");
        this.classes.add("");
        int i = 0;
        int c = 0;
        String laf = gopts.get(GUIOptions.LOOKANDFEEL);
        for (String clzz : DialogVisualPrefs.lf()) {
            lafs.add(clzz.replaceAll("^.*\\.|LookAndFeel$", ""));
            this.classes.add(clzz);
            ++c;
            if (!clzz.equals(laf)) continue;
            i = c;
        }
        this.lookfeel = new BaseXCombo((BaseXWindow)dialog, (String[])lafs.finish());
        this.lookfeel.setSelectedIndex(i);
        this.serial = new BaseXSerial(dialog, this.gui.context.options.get(MainOptions.SERIALIZER));
        BaseXBack pp = new BaseXBack().layout(new TableLayout(3, 1, 0, 8));
        BaseXBack ppp = new BaseXBack(new TableLayout(2, 1));
        ppp.add(new BaseXLabel(String.valueOf(Text.JAVA_LF) + ":", true, true));
        ppp.add(this.lookfeel);
        pp.add(ppp);
        ppp = new BaseXBack(new TableLayout(2, 1));
        ppp.add(new BaseXLabel(String.valueOf(Text.GENERAL) + ":", true, true));
        ppp.add(this.showNames);
        pp.add(ppp);
        ppp = new BaseXBack(new TableLayout(3, 1));
        ppp.add(new BaseXLabel(String.valueOf(Text.TREE) + ":", true, true));
        ppp.add(this.treeSlims);
        ppp.add(this.treeAtts);
        pp.add(ppp);
        BaseXBack p = new BaseXBack(new TableLayout(1, 2, 40, 0));
        p.add(pp);
        pp = new BaseXBack(new TableLayout(3, 1));
        pp.add(new BaseXLabel(String.valueOf(Text.MAP) + ":", true, true));
        ppp = new BaseXBack(new TableLayout(2, 2, 8, 8));
        ppp.add(new BaseXLabel(String.valueOf(Text.ALGORITHM) + ":"));
        ppp.add(this.mapAlgo);
        ppp.add(new BaseXLabel(String.valueOf(Text.OFFSETS) + ":"));
        ppp.add(this.mapOffsets);
        pp.add(ppp);
        ppp = new BaseXBack(new TableLayout(3, 1, 0, 8));
        ppp.add(new BaseXLabel(String.valueOf(Text.RATIO) + ": "));
        ppp.add(this.mapWeight);
        ppp.add(this.mapAtts);
        pp.add(ppp);
        p.add(pp);
        this.add(p);
        this.add(this.serial);
    }

    boolean action() {
        this.treeSlims.assign();
        this.treeAtts.assign();
        this.mapAtts.assign();
        this.showNames.assign();
        this.mapWeight.assign();
        this.mapAlgo.assign();
        this.mapOffsets.assign();
        this.gui.gopts.set(GUIOptions.LOOKANDFEEL, (String)this.classes.get(this.lookfeel.getSelectedIndex()));
        return true;
    }

    private static StringList lf() {
        Object laf;
        StringList sl = new StringList();
        Object[] objectArray = UIManager.getInstalledLookAndFeels();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            laf = objectArray[n2];
            sl.add(((UIManager.LookAndFeelInfo)laf).getClassName());
            ++n2;
        }
        objectArray = LOOKANDFEELS;
        n = LOOKANDFEELS.length;
        n2 = 0;
        while (n2 < n) {
            laf = objectArray[n2];
            if (Reflect.find((String)laf) != null) {
                sl.add(laf);
            }
            ++n2;
        }
        return sl;
    }

    void update() {
        this.serial.init(this.gui.context.options.get(MainOptions.SERIALIZER));
    }

    void cancel() {
        this.gui.set(MainOptions.SERIALIZER, this.serial.options());
    }
}

