/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class DialogInput
extends BaseXDialog {
    private final BaseXTextField input;
    private final String old;
    private final BaseXBack buttons;
    private final BaseXLabel info;
    private final StringList db;
    private final int type;

    DialogInput(String old, String title, BaseXDialog dialog, int type) {
        super(dialog, title);
        this.old = old;
        this.type = type;
        this.db = dialog.gui.context.listDBs();
        String t = "";
        if (type == 0) {
            t = String.valueOf(Text.TARGET_PATH) + ": ";
        } else if (type == 1) {
            t = String.valueOf(Text.NAME_OF_DB) + ": ";
        } else if (type == 2) {
            t = String.valueOf(Text.NAME_OF_DB_COPY) + ": ";
        }
        this.set(new BaseXLabel(t, false, true).border(0, 0, 6, 0), "North");
        this.input = new BaseXTextField(this, old);
        this.info = new BaseXLabel(" ");
        BaseXBack p = new BaseXBack(new BorderLayout(0, 8));
        p.add((Component)this.input, "North");
        p.add((Component)this.info, "Center");
        this.set(p, "Center");
        this.buttons = this.newButtons(Text.B_OK, Text.B_CANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.finish();
    }

    String input() {
        return this.input.getText().trim();
    }

    @Override
    public void action(Object cmp) {
        String in = this.input();
        this.ok = this.type != 0 && (this.db.contains(in) || in.equals(this.old));
        String msg = null;
        if (this.ok) {
            msg = Util.info(Text.DB_EXISTS_X, in);
        }
        if (!this.ok) {
            boolean bl = this.type == 0 ? MetaData.normPath(in) != null : (this.ok = Databases.validName(in));
            if (!this.ok) {
                msg = in.isEmpty() ? Text.ENTER_DB_NAME : Util.info(Text.INVALID_X, Text.NAME);
            }
        }
        this.info.setText(msg, this.type == 1 || this.type == 2 ? GUIConstants.Msg.ERROR : GUIConstants.Msg.WARN);
        DialogInput.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }
}

