/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.nio.charset.Charset;
import java.util.SortedMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.basex.core.Text;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIMacOSX;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXImages;
import org.basex.util.Prop;

public final class GUIConstants {
    public static final String MAPVIEW = "map";
    public static final String FOLDERVIEW = "folder";
    public static final String TEXTVIEW = "text";
    public static final String TABLEVIEW = "table";
    public static final String INFOVIEW = "info";
    public static final String EXPLOREVIEW = "explore";
    public static final String PLOTVIEW = "plot";
    public static final String TREEVIEW = "tree";
    public static final String EDITORVIEW = "editor";
    public static final String VIEWS = "V H editor folder map plot  - H text info table tree explore - -";
    static final GUIMenuCmd[] TOOLBAR;
    static final String[] MENUBAR;
    static final GUICommand[][] MENUITEMS;
    public static final GUIMenuCmd[] POPUP;
    public static final Cursor CURSORARROW;
    public static final Cursor CURSORHAND;
    public static final Cursor CURSORWAIT;
    public static final Cursor CURSORMOVEH;
    public static final Cursor CURSORMOVEV;
    public static final Cursor CURSORTEXT;
    public static final Cursor CURSORMOVE;
    private static final UIDefaults DEFAULTS;
    public static final Color BACK;
    public static final Color TEXT;
    public static final Color PANEL;
    public static final Color RED;
    public static final Color LRED;
    public static final Color GREEN;
    public static final Color BLUE;
    public static final Color KEYWORD;
    public static final Color COMMENT;
    public static final Color DIGIT;
    public static final Color VARIABLE;
    public static final Color VALUE;
    public static Color lgray;
    public static Color gray;
    public static Color mgray;
    public static Color dgray;
    private static final Color[] COLORS;
    private static final boolean INVERT;
    public static Color color1;
    public static Color color2;
    public static Color color3;
    public static Color color4;
    public static Color colormark1;
    public static Color colormark2;
    public static Color colormark3;
    public static Color colormark4;
    public static Color color1A;
    public static Color color2A;
    public static Color color3A;
    public static Color colormark1A;
    public static Color colormark2A;
    public static final String[] ENCODINGS;
    public static final JLabel LABEL;
    public static Font lfont;
    public static Font font;
    public static Font bfont;
    public static Font mfont;
    public static Font dmfont;
    public static int fontSize;
    private static int[] fwidth;
    private static int[] mfwidth;
    private static int[] bwidth;
    private static int[] dmwidth;
    public static final int NO_MOD = 0;
    public static final int SHIFT = 1;
    public static final int ALT = 8;
    public static final int CTRL = 2;
    public static final int META;

    static {
        GUIMenuCmd[] gUIMenuCmdArray = new GUIMenuCmd[20];
        gUIMenuCmdArray[0] = GUIMenuCmd.C_CREATE;
        gUIMenuCmdArray[1] = GUIMenuCmd.C_OPEN_MANAGE;
        gUIMenuCmdArray[2] = GUIMenuCmd.C_INFO;
        gUIMenuCmdArray[3] = GUIMenuCmd.C_CLOSE;
        gUIMenuCmdArray[5] = GUIMenuCmd.C_GOHOME;
        gUIMenuCmdArray[6] = GUIMenuCmd.C_GOBACK;
        gUIMenuCmdArray[7] = GUIMenuCmd.C_GOUP;
        gUIMenuCmdArray[8] = GUIMenuCmd.C_GOFORWARD;
        gUIMenuCmdArray[10] = GUIMenuCmd.C_SHOWEDITOR;
        gUIMenuCmdArray[11] = GUIMenuCmd.C_SHOWRESULT;
        gUIMenuCmdArray[12] = GUIMenuCmd.C_SHOWINFO;
        gUIMenuCmdArray[14] = GUIMenuCmd.C_SHOWMAP;
        gUIMenuCmdArray[15] = GUIMenuCmd.C_SHOWTREE;
        gUIMenuCmdArray[16] = GUIMenuCmd.C_SHOWFOLDER;
        gUIMenuCmdArray[17] = GUIMenuCmd.C_SHOWPLOT;
        gUIMenuCmdArray[18] = GUIMenuCmd.C_SHOWTABLE;
        gUIMenuCmdArray[19] = GUIMenuCmd.C_SHOWEXPLORE;
        TOOLBAR = gUIMenuCmdArray;
        MENUBAR = new String[]{Text.DATABASE, Text.EDITOR, Text.VIEW, Text.VISUALIZATION, Text.OPTIONS, Text.HELP};
        MENUITEMS = new GUICommand[][]{{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUICommand.SEPARATOR, GUIMenuCmd.C_INFO, GUIMenuCmd.C_EXPORT, GUIMenuCmd.C_CLOSE, GUICommand.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_EXIT}, {GUIMenuCmd.C_EDITNEW, GUIMenuCmd.C_EDITOPEN, GUIMenuCmd.C_EDITREOPEN, GUIMenuCmd.C_EDITSAVE, GUIMenuCmd.C_EDITSAVEAS, GUIMenuCmd.C_EDITCLOSE, GUIMenuCmd.C_EDITCLOSEALL, GUICommand.SEPARATOR, GUIMenuCmd.C_FORMAT, GUIMenuCmd.C_COMMENT, GUIMenuCmd.C_SORT, GUICommand.SEPARATOR, GUIMenuCmd.C_LOWERCASE, GUIMenuCmd.C_UPPERCASE, GUIMenuCmd.C_TITLECASE, GUICommand.SEPARATOR, GUIMenuCmd.C_VARS, GUIMenuCmd.C_NEXTERROR, GUIMenuCmd.C_JUMPFILE}, {GUIMenuCmd.C_SHOWEDITOR, GUIMenuCmd.C_SHOWPROJECT, GUIMenuCmd.C_FILESEARCH, GUICommand.SEPARATOR, GUIMenuCmd.C_SHOWRESULT, GUIMenuCmd.C_SHOWINFO, GUICommand.SEPARATOR, GUIMenuCmd.C_SHOWBUTTONS, GUIMenuCmd.C_SHOWINPUT, GUIMenuCmd.C_SHOWSTATUS, GUIMacOSX.nativeFullscreen() ? null : GUIMenuCmd.C_FULL}, {GUIMenuCmd.C_SHOWMAP, GUIMenuCmd.C_SHOWTREE, GUIMenuCmd.C_SHOWFOLDER, GUIMenuCmd.C_SHOWPLOT, GUIMenuCmd.C_SHOWTABLE, GUIMenuCmd.C_SHOWEXPLORE}, {GUIMenuCmd.C_RTEXEC, GUIMenuCmd.C_RTFILTER, GUICommand.SEPARATOR, GUIMenuCmd.C_COLOR, GUIMenuCmd.C_FONTS, Prop.MAC ? null : GUICommand.SEPARATOR, GUIMenuCmd.C_PACKAGES, Prop.MAC ? null : GUIMenuCmd.C_PREFS}, {GUIMenuCmd.C_HELP, Prop.MAC ? null : GUICommand.SEPARATOR, GUIMenuCmd.C_COMMUNITY, GUIMenuCmd.C_UPDATES, Prop.MAC ? null : GUICommand.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_ABOUT}};
        GUIMenuCmd[] gUIMenuCmdArray2 = new GUIMenuCmd[10];
        gUIMenuCmdArray2[0] = GUIMenuCmd.C_GOBACK;
        gUIMenuCmdArray2[1] = GUIMenuCmd.C_FILTER;
        gUIMenuCmdArray2[3] = GUIMenuCmd.C_COPY;
        gUIMenuCmdArray2[4] = GUIMenuCmd.C_PASTE;
        gUIMenuCmdArray2[5] = GUIMenuCmd.C_DELETE;
        gUIMenuCmdArray2[6] = GUIMenuCmd.C_INSERT;
        gUIMenuCmdArray2[7] = GUIMenuCmd.C_EDIT;
        gUIMenuCmdArray2[9] = GUIMenuCmd.C_COPYPATH;
        POPUP = gUIMenuCmdArray2;
        CURSORARROW = new Cursor(0);
        CURSORHAND = new Cursor(12);
        CURSORWAIT = new Cursor(3);
        CURSORMOVEH = new Cursor(11);
        CURSORMOVEV = new Cursor(8);
        CURSORTEXT = new Cursor(2);
        CURSORMOVE = new Cursor(13);
        DEFAULTS = UIManager.getDefaults();
        BACK = DEFAULTS.getColor("TextPane.background");
        TEXT = DEFAULTS.getColor("TextPane.foreground");
        PANEL = DEFAULTS.getColor("Label.background");
        RED = GUIConstants.color(224, 0, 0);
        LRED = GUIConstants.color(255, 216, 216);
        GREEN = GUIConstants.color(0, 160, 0);
        BLUE = GUIConstants.color(0, 64, 192);
        KEYWORD = GUIConstants.color(32, 96, 176);
        COMMENT = GUIConstants.color(0, 160, 160);
        DIGIT = GUIConstants.color(192, 112, 32);
        VARIABLE = GUIConstants.color(32, 160, 32);
        VALUE = GUIConstants.color(112, 112, 112);
        COLORS = new Color[100];
        INVERT = BACK.getRed() + BACK.getGreen() + BACK.getBlue() < 384;
        SortedMap<String, Charset> cs = Charset.availableCharsets();
        ENCODINGS = cs.keySet().toArray(new String[cs.size()]);
        LABEL = new JLabel();
        META = Prop.MAC ? 4 : 2;
    }

    private GUIConstants() {
    }

    public static synchronized void init(GUIOptions opts) {
        lgray = GUIConstants.color(224, 224, 224);
        gray = GUIConstants.color(160, 160, 160);
        mgray = GUIConstants.color(128, 128, 128);
        dgray = GUIConstants.color(64, 64, 64);
        int r = opts.get(GUIOptions.COLORRED);
        int g = opts.get(GUIOptions.COLORGREEN);
        int b = opts.get(GUIOptions.COLORBLUE);
        int cl = COLORS.length;
        int c = 1;
        while (c < cl + 1) {
            GUIConstants.COLORS[c - 1] = GUIConstants.color(Math.max(255 - c * r, 0), Math.max(255 - c * g, 0), Math.max(255 - c * b, 0));
            ++c;
        }
        color1 = GUIConstants.color(GUIConstants.darker(r, 24), GUIConstants.darker(g, 25), GUIConstants.darker(b, 40));
        color2 = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 32), GUIConstants.darker(b, 44));
        color3 = GUIConstants.color(GUIConstants.darker(r, 48), GUIConstants.darker(g, 50), GUIConstants.darker(b, 40));
        color4 = GUIConstants.color(GUIConstants.darker(r, 140), GUIConstants.darker(g, 100), GUIConstants.darker(b, 70));
        colormark1 = GUIConstants.color(GUIConstants.darker(r, 16), GUIConstants.darker(g, 120), GUIConstants.darker(b, 240));
        colormark2 = GUIConstants.color(GUIConstants.darker(r, 16), GUIConstants.darker(g, 80), GUIConstants.darker(b, 160));
        colormark3 = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 160), GUIConstants.darker(b, 320));
        colormark4 = GUIConstants.color(GUIConstants.darker(r, 1), GUIConstants.darker(g, 40), GUIConstants.darker(b, 80));
        Color col = COLORS[16];
        color1A = GUIConstants.color(GUIConstants.darker(r, 110), GUIConstants.darker(g, 150), GUIConstants.darker(b, 160), 100);
        color2A = GUIConstants.color(col.getRed(), col.getGreen(), col.getBlue(), 50);
        color3A = GUIConstants.color(col.getRed(), col.getGreen(), col.getBlue(), 30);
        colormark1A = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 160), GUIConstants.darker(b, 320), 100);
        colormark2A = GUIConstants.color(GUIConstants.darker(r, 12), GUIConstants.darker(g, 60), GUIConstants.darker(b, 120), 100);
        String name = opts.get(GUIOptions.FONT);
        int type = opts.get(GUIOptions.FONTTYPE);
        int sz = LABEL.getFont().getSize();
        dmfont = new Font(opts.get(GUIOptions.MONOFONT), 0, sz);
        lfont = new Font(name, type, sz * 2);
        fontSize = opts.get(GUIOptions.FONTSIZE);
        font = new Font(name, type, fontSize);
        mfont = new Font(opts.get(GUIOptions.MONOFONT), type, fontSize);
        bfont = new Font(name, 1, fontSize);
        dmwidth = LABEL.getFontMetrics(dmfont).getWidths();
        fwidth = LABEL.getFontMetrics(font).getWidths();
        mfwidth = LABEL.getFontMetrics(mfont).getWidths();
        bwidth = LABEL.getFontMetrics(bfont).getWidths();
    }

    public static Color color(int i) {
        return COLORS[Math.min(COLORS.length - 1, i)];
    }

    public static int[] fontWidths(Font f) {
        if (f == font) {
            return fwidth;
        }
        if (f == mfont) {
            return mfwidth;
        }
        if (f == bfont) {
            return bwidth;
        }
        if (f == dmfont) {
            return dmwidth;
        }
        return LABEL.getFontMetrics(f).getWidths();
    }

    private static int darker(int c, int f) {
        return Math.max(0, 255 - c * f / 10);
    }

    private static Color color(int r, int g, int b) {
        return INVERT ? new Color(255 - r, 255 - g, 255 - b) : new Color(r, g, b);
    }

    private static Color color(int r, int g, int b, int a) {
        return INVERT ? new Color(255 - r, 255 - g, 255 - b, 255 - a) : new Color(r, g, b, a);
    }

    public static enum Msg {
        WARN("warn", "warning"),
        ERROR("error", "error"),
        SUCCESS("ok", "information"),
        QUESTION("warn", "question"),
        YESNOCANCEL("warn", "question");

        public final Icon small;
        public final Icon large;

        private Msg(String s, String l) {
            this.small = BaseXImages.icon(s);
            this.large = UIManager.getIcon("OptionPane." + l + "Icon");
        }
    }
}

