/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.core.users.Perm;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.util.Util;

public final class Check
extends Command {
    public Check(String input) {
        super(Perm.NONE, input);
    }

    @Override
    protected boolean run() {
        Close.close(this.context);
        String input = this.args[0];
        IO io = IO.get(input);
        String dbName = io.dbName();
        Command cmd = this.open(io, dbName) ? new Open(dbName) : new CreateDB(dbName, io.exists() ? input : null);
        try {
            boolean ok = ((Command)this.pushJob(cmd)).run(this.context);
            String msg = cmd.info().trim();
            boolean bl = ok ? this.info(msg, new Object[0]) : this.error(msg, new Object[0]);
            return bl;
        }
        finally {
            this.popJob();
        }
    }

    private boolean open(IO input, String dbName) {
        if (!this.context.user().has(Perm.CREATE)) {
            return true;
        }
        if (!this.soptions.dbPath(dbName).exists()) {
            return false;
        }
        if (!input.exists()) {
            return true;
        }
        MetaData meta = new MetaData(dbName, this.options, this.soptions);
        try {
            meta.read();
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
        return meta.time == input.timeStamp();
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("%CONTEXT").add(IO.get(this.args[0]).dbName());
    }

    @Override
    public boolean newData(Context ctx) {
        return Close.close(ctx);
    }
}

