/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.csv;

import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.query.QueryException;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class CsvOptions
extends Options {
    public static final StringOption SEPARATOR = new StringOption("separator", CsvSep.COMMA.toString());
    public static final EnumOption<CsvFormat> FORMAT = new EnumOption<CsvFormat>("format", CsvFormat.DIRECT);
    public static final BooleanOption HEADER = new BooleanOption("header", false);
    public static final BooleanOption BACKSLASHES = new BooleanOption("backslashes", false);
    public static final BooleanOption LAX = new BooleanOption("lax", true);
    public static final BooleanOption QUOTES = new BooleanOption("quotes", true);

    @Override
    public synchronized void assign(String name, String value) throws BaseXException {
        super.assign(name, value);
        this.check();
    }

    @Override
    public synchronized void assign(Item name, Item value, boolean error, InputInfo info) throws BaseXException, QueryException {
        super.assign(name, value, error, info);
        this.check();
    }

    private void check() throws BaseXException {
        if (this.separator() == -1) {
            throw new BaseXException("Invalid separator: '%'", this.get(SEPARATOR));
        }
    }

    public int separator() {
        char ch;
        String sep = this.get(SEPARATOR);
        CsvSep[] csvSepArray = CsvSep.values();
        int n = csvSepArray.length;
        int n2 = 0;
        while (n2 < n) {
            CsvSep s = csvSepArray[n2];
            if (sep.equals(s.toString())) {
                return s.sep;
            }
            ++n2;
        }
        if (sep.length() == 1 && XMLToken.valid(ch = sep.charAt(0))) {
            return ch;
        }
        return -1;
    }

    public CsvOptions() {
    }

    CsvOptions(CsvOptions opts) {
        super(opts);
    }

    public static enum CsvFormat {
        DIRECT,
        ATTRIBUTES,
        XQUERY;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum CsvSep {
        COMMA(','),
        SEMICOLON(';'),
        COLON(':'),
        TAB('\t'),
        SPACE(' ');

        public final char sep;

        private CsvSep(char sep) {
            this.sep = sep;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

