# Linux
# gnu compile script for adaventure
# suitable for gnat from AdaCore 2018
#
# dynamic:  SFMLv2.5.0, OpenAL-v1.17.3, SDL2v2.0.7, 
# with libopenal.so [v1.17.3] built from src from 
# https://github.com/kcat/openal-soft
#
# This script probably produces the most
# portable linux executable...albeit much
# larger than lcmp.sh
#
# shared library presence in linux distros:
# 56/77	FLAC   => 73%
# 75/77	ogg
# 22/77	openal => most rare @ 28%
# 76/77	vorbis
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libogg.so.

#########################################################
#
# use this to ensure a complete recompilation:
#if [ -d ./obj/ ]; then
#	rm ./obj/*
#else
#	mkdir obj
#fi



# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2019/bin:$PATH



#########################################################

# This step is not necessary if libsnd4ada.so is already present...
#
# prepares libsnd4ada.so file prior to gnatmake...
# using g++ from GNAT:

#g++ adabindings/sfmlAudio/snd4ada.cpp -c -Werror -fPIC -IincSFML250

#g++ -shared -o ./libs/gnu/libsnd4ada.so snd4ada.o \
#-L$PWD/libs/gnu -lsfml-audio -lsfml-system

#rm snd4ada.o


#########################################################

gnatmake adaventure -o adaventure_gnu \
-O3 -gnat12 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs \
-lGL -lpthread -lstdc++ \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lz -lm -lsnd4ada -lfreetype -lpng12 \
-lglfw -lsfml-audio -lsfml-system \
-lopenal -lcrypto -logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC

#NOTE:  final line above has libs that need not be explicitly
#       mentioned, yet are used and may be non-standard






# -- Copyright (C) 2020  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

