# Linux
# gnu compile script for adaventure
# suitable for gnat from AdaCore 2019
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libogg.so.

#########################################################
#
# use this to ensure a complete recompilation:
#if [ -d ./obj/ ]; then
#	rm ./obj/*
#else
#	mkdir obj
#fi



# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2019/bin:$PATH




gnatmake adaventure -o adaventure_gnu \
-O3 -gnat12 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlFake \
-I$PWD/adabindings/Tables \
-I$PWD/adabindings/FreeTypeAda \
-largs \
-lGL -lX11 -lpthread -lstdc++ -lm -lz \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lfreetype -lpng12 \
-lglfw 





# -- Copyright (C) 2020  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

