
--
-- Copyright (C) 2023  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with text_io;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;




package body dumpgl is

	use gl;
	use text_io;


-- note:  for production code 
-- disable the raising of exceptions 
-- when GL errors occur by setting dump_debug to false:

function dumpGLerrorQueue(id: string) return integer is
	use gl.binding;
	errno: interfaces.c.unsigned;
	isAnError: boolean;
	ercount: integer := 0;
begin
	isAnError:=false;
	loop
		errno:=glGetError;
		exit when errno=gl_no_error;
		ercount:=ercount+1;
		isAnError:=true;

		if dump_debug then
			put("GLerror=");
			put(interfaces.c.unsigned'image(errno));
			if errno=1280 then
				put("=invalid_enum");
			elsif errno=1281 then
				put("=invalid_value");
			elsif errno=1282 then
				put("=invalid_operation");
			elsif errno=1283 then
				put("=stack_overflow");
			elsif errno=1284 then
				put("=stack_underflow");
			elsif errno=1285 then
				put("=out_of_memory");
			end if;
			new_line;
		end if; --dump_debug
	end loop;
	if isAnError and dump_debug then
		put_line("...@ id="&id);
	end if;
	return ercount;
end dumpGLerrorQueue;
--
-- 16#0#   =    0 = no_error
-- 16#500# = 1280 = invalid_enum
-- 16#501# = 1281 = invalid_value
-- 16#502# = 1282 = invalid_operation
-- 16#503# = 1283 = stack_overflow
-- 16#504# = 1284 = stack_underflow
-- 16#505# = 1285 = out_of_memory
--





end dumpgl;

