

# AdaGate 
## using GLFW & OpenAL


## Recent Changes


**ver 7.4.2 -- 19jun2023**

* Discontiued OSX support, greatly simplifying game package.
* Added music to flyover intro screen.
* Restored best kawoosh sound.
* Avatar now rises & falls with ocean waves when swimming.


## More change-history at end of file.


## AdaGate Game Description
AdaGate is a strategy game with escape rooms in a Stargate fantasy setting. It is an elaborate example of modern OpenGL programming using the Ada language; and a tribute to Narbacular Drop.

Runs on Windows, and GNU/Linux.  The linux binary now runs on many linux distros! Includes all source code, build scripts & resources.
 

-----------------------------------------------------------
Featuring

	* no installation
	* no dependencies
	* simply unzip in your Downloads directory, and run;
	* or unzip onto a USB flash drive [w/same file format] and run.
-----------------------------------------------------------

## AdaGate Introduction
While searching a remote south-seas atoll for remnants of a lost American heroine, you find a nearly operational stargate.  If you can get it working, you will be transported into an off-world temple with multiple chambers.  You'll need to power up the portal system by rolling alien power cells onto their sockets.  Simple, right?  Then use your portal gun to bypass obstacles through another dimension.

Escape all chambers to ascend to the lake sanctuary, where the level of difficulty is increased for your next game.



## AdaGate Game Features

* Works on PCs or laptops running Windows, or GNU/Linux.  And if Ada is installed you can rebuild it yourself!  But first try the binaries that are delivered for all platforms.

* Windows & Linux binaries provided, as well as full source. 

* Note that a 32+64 bit builds for Windows are delivered.

* Laptop friendly controls;  supports HiDpi displays.

* A 3D Sokoban puzzle game that uses the intersection of two cylinders as a puzzle piece that rolls in two perpendicular directions.

* Stargate dial-home-device [DHD] allows non-linear play; see the island setting evolve from sun to fog to evening to night.

* Roll the ZPM power cells to empower the portals and escape thru a wormhole

* Four rooms and five degrees of difficulty for a total of 20 challenging puzzles. And solutions are available in the file ./data/solns.sok.

* Serves as a blueprint for modern OpenGL programming in Ada or C++ using GLSL 330, shaders, uniforms and textures.

* Note that Sangwine's PNG-IO library, and the Ada bindings to OpenAL, OpenGL & GLFW3 in this app constitute a complete, yet easily extendable Ada library that could be used for most any modern OpenGL project including games, animations, simulations, modeling, or engineering.

* The sound system enables a build with surprising portability across various linux distros, as well as across various platforms.



## mouse/touchpad/keyboard controls

[You might need to disconnect unused gamecontrollers to prevent spinning!]

Look direction is controlled by touch pad or mouse;
The mouse wheel controls camera zoom.  On laptops, a 2-finger swipe simulates the mouse wheel;
Zoom can also be controlled with keys n, f, z [Nearer,Further,default];

Movement is controlled by the WASD keys or the arrow keys:

			(Up)
	(Lt)	(Dn)	(Rt)

Shoot the two portal guns using:  (L)-key (R)-key, or (if you have two) the two mouse buttons.

(space)-key => jump up/over short walls

(esc)-key => exit;

* (m)-key or (F1)-key	=> toggle between mouse-view (1st-person) or avatar(3rd-person)

In case of control problems with the game, or if you want to easily inspect something, use 1st-person mode.


### joystick
* joystick : attitude
* center thumb btn: forward
* trigger btn: backward
* Ltop/Rtop btns: select/shoot
* 1st base btn: jump

------------------------------------------------------------
### gamecontroller
* Lpaddle/Lhat : attitude
* Rpaddle : movement
* L/R Shoulder btns: select/shoot
* 1st Dpad-down btn: jump

------------------------------------------------------------
### controller settings
If the need arises, copy the file "default_settings.txt" to "settings.txt".  Then you can manually edit the floats that define the sensitivity for mouse, keyboard, gamepad & joystick, as well as forward speed of the avatar.

------------------------------------------------------------

If you ever get stuck, try to jump up + forward or back.

------------------------------------------------------------
------------------------------------------------------------


## required for running:

* graphics card with ample memory & updated driver that supports OpenGL version 3.3 or later.  
* Windows, GNU/Linux;
* optional game controller or joystick.


### Note on Intel embedded graphics
* Such hardware uses system RAM;  8Gb is enough to run but the drivers I've experienced exhibit annoying flaws, although the game is still playable.


## Setup & Running Adagate:

The application's main directory [./agate/] contains files for deployment on 2 platforms:  1)windows, 2)linux, in addition to source code.  If you are NOT running windows, you do not need .dll files.  

Windows users see also:  "windows-setup.txt"

Unzip the archive.  On Windows, 7z [www.7-zip.org] works well for this.

The game may be run from a command line terminal window on all 3 platforms. Navigate to the installation directory and type:

* adagate32.bat (Windows 32-bit) or type binw32\adagate32.exe
* adagate64.bat (Windows 64-bit) or type binw64\adagate64.exe

* adagate (Linux)

**If an older Linux system complains that /dev/dsp/ cannot be opened, prepend the command with "padsp",EG:  "padsp (ExeName)".**



----------------------------------------------------------------------

I believe this single linux executable will run on most recent distributions of linux. It has been tested on OpenSuse, Trisquel, ScientificLinux(rhel) and Mint.

Another alternative is to install WINE. The Windows executable will run on linux using wine thusly:

	* wine binw32/adagate32.exe


Windows users note: I suggest that you DO NOT try running the linux executables under WSL [Windows Subsystem for Linux]; that mode is not supported. Simply use one of the windows builds.

----------------------------------------------------------------------

The install directory should contain a subdirectory named "data".  It contains shaders, skyboxes, sound and texture data, as well as the puzzle definitions.

Tips:  0) type "h" for the help screen.  1) the ZPM is heavy!  If you kick it out of reach under water then you will be stranded on the island.  2) when in trouble in a dungeon, jumping may help.

By the way, you are ideally supposed to solve the sokoban puzzles without jumping up onto the walls.  On the other hand, if you jump into the puzzle at the wrong place, it might be impossible to solve.

--------------------------------------------------------------------------
Notes:

First, note that your screen brightness might need to be reduced to fully appreciate the lighting effects in level 3.

Second, note that AdaGate is geared toward a fairly capable graphics card.

Third, note that this game runs fine on an Intel NUC with embedded Intel graphics, so the graphics demands are modest.

Fourth, note that adjustable OpenGL settings should favor performance.

--------------------------------------------------------------------------
Open source Ada developers are welcome to help improve or extend this game.

Please send improvements, comments, suggestions or questions to:

<fastrgv@gmail.com>

-------------------------------------------------------------------

## Open Source libraries included that allow rebuilding:
* GLFW3, glext
* the included "bindings" directory contains Ada interfaces:
	* Stephen Sanguine's AdaPngLib
	* Dmitriy Anisimkov's Zlib for Ada
	* gl
	* glfwada
	* OpenAL

## Rebuild Requirements:
* systems:  Windows, or GNU/Linux
* a recent Ada compiler;  eg. GNU-Ada...try this source:

https://github.com/alire-project/GNAT-FSF-builds/releases






## Build instructions for AdaGate:

Two [pre-compiled] binary executables are delivered, one for Windows & one for gnu/linux.  I think the Windows executable is fairly portable.  It was built on Windows 10.  The linux binary, adagate, is intended to run in the presence of the directory "./libs/gnu", which contains GLFW3 libraries that can be, but need not be present on a target system.

The distributed linux executable requires glibc v2.14 or newer.  That means if your distribution is older than june 2011, it may not run, and you will need to recompile.

Build scripts for GNU Ada [with its own g++] are provided. But should also work for GNAT from the GNU Compiler Collection, with minor changes. See ./alternateBuildScripts/.

-------------------------------------------------------

**msWin32** => setpath32.bat + wcmp32.bat
**msWin64** => setpath64.bat + wcmp64.bat (read ~docs\gnuAdaOnWindows.txt)

Note that the above windows build script might need to be adjusted to reference your actual installation directory for the GNU Ada compiler.


------------------------------------------------------
**GNU/Linux** => lcmp.sh

utilizes the shared GLFW libraries that are delivered in this bundle under ./libs/gnu/.  This is used to build the [gnu/linux] executable, which should run in the presence of ./libs/gnu/, whether or not your system has those shared libraries installed.

If the delivered linux binary does not run, try...

* Manually install GNU Ada.
* Rerun the compile script lcmp.sh.

### Fixable Linux Link Problems:

On a linux build machine, you might get fixable link errors, depending on its configuration.  If you are missing "libxxx.so", you might need to create a proper softlink so it can be found.


----------------------------------------------------------------------
## For Developers Only:  Portable Avatar Using Shaders

* This approach encapsulates the details of avatar shape, color, and movement within GLSL shaders and a related code object that defines vertices and texture maps.  The object may be an Ada package or C++ class.

* Programmatic inputs include uniforms for time, position, attitude, & type of motion.  The shaders then offload the realtime computational burdens onto the graphics processor.

* Data that defines shape and color, as well as the uniforms and functions that define behavior, reside completely within the object and shaders.  This data can ultimately be as detailed and refined as your imagination permits.  And any refinements made are not obfuscated in some esoteric or proprietary format with a limited audience, but remain fully portable and easily enhanced by most any developer using Free Open Source languages, tools and compilers.

* One approach would be to completely define the avatar within the shaders alone, possibly without using any texture files.  Just look at the creatures in (glslsandbox.com).  This would require advanced GLSL skills.

* But a huge selection of available MineCraft skins lead to the present avatar object design.

* In this application, the texture object is a cube with radius one that is defined as 6 disjoint cubelets (the precise name is rectangular cuboid or parallelpiped).  The 2 upper quarters map to the head and torso.  The lower half is divided into 4 cubelets that are mapped to arms and legs. See "cuboid.txt". The Minecraft images used for the texture also have 6 parts that map to the limbs, head and torso.

* The result is an utterly portable avatar defined by an image and 4 text files:
	* texture object body, avatarobj.adb
	* texture object specification, avatarobj.ads
	* vertex shader, avatarobj.vs
	* fragment shader, avatarobj.fs
	* any MineCraft Skin png file

* Interfacing game code with such an avatar is simple.  Essentially you need only pass the current uniform values prior to drawing, including time, position, attitude, motion-type.

* Of course one still needs a decent camera positioning and pointing policy within the game code in order to fully appreciate and exhibit the avatar. The details are beyond the scope of this brief introduction, but generally the current policy is a damped and delayed move toward some fixed ideal camera position above and behind the avatar.



----------------------------------------------------------------------
## For Developers Only:  Fancy Shaders

This app demonstrates how to use fancy fragment shaders from glslsandbox.com to make wormhole effects, starry skies, and moving-scene wall hangings. See below (Media Files).  It also demonstrates metallic texture overlays, and the use of coherent noise to create the stargate event horizon, and rolling fireball in the brick dungeon.


----------------------------------------------------------------------
## For Developers Only:  OpenAL portable sound package

This app uses a cross-platform sound-playing package for Ada apps that can asynchronously start and stop music loops, as well as initiate transient sounds, allowing unlimited concurrency.

It plays WAV files, via OpenAL, on Windows, and linux platforms.

It is suitable for any Ada application that needs music, sound loops or transient sound effects; eg. games.


----------------------------------------------------------------
----------------------------------------------------------------


## what is special about this project?

The linux-build of this app is among very few modern OpenGL games with sound where a single pre-built executable can run on multiple Linux distros without 3rd party add-ons! It has been tested on OpenSuse, ScientificLinux, Mint, & Trisquel.

For developers, this project can serve as a testbed for learning modern OpenGL and GLSL.

It uses the Ada programming language and modern OpenGL methods, with textures, shaders and uniforms.  Compiles and runs on Windows & GNU/Linux systems.

Focusing on portability, transparency, and open source freedom, this project relies exclusively on F.O.S.S. tools:  a thin GLFW3 binding, a thin OpenGL binding, a PNG reader by Stephen Sanguine & Dimitry Anisimkov, OpenAL-Audio with a homebrew binding, and a GNAT compiler.

This is one of the most functionally advanced demonstrations of "modern" OpenGL using Ada to be published as a complete F.O.S.S. application.  The term "functionally advanced" means that the code is focused on comprehensibility and completeness rather than elegance.  Further development of structure and style is left as an exercise for the coding student.

The Ada bindings are thin, so the relationship to C++ methodology is transparent.  Developers should note that these Ada bindings can be used for any OpenGL Ada project.

For the C++ programmer the code should be easy to comprehend; and for the experienced Ada programmer there are many improvements to be made to better utilize the advanced protections and features of the Ada language.  

This is a work in progress, so please excuse any scaffolding and debugging code has not been removed.

Open source Ada developers are welcome to help improve or extend this app.
Developer or not, send comments, suggestions or questions to:
fastrgv@gmail.com





--------------------------
## License:


This app is covered by the GNU GPL v3 as indicated in the sources:


 Copyright (C) 2023  <fastrgv@gmail.com>

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You may read the full text of the GNU General Public License
 at <http://www.gnu.org/licenses/>.


## Media Files for AdaGate:

### General Note
The particular choices of sound, image, and fragment shader files [x.fs] delivered are not essential to the function of the game and are easily replaced.  This software is primarily intended as a tutorial example of modern OpenGL methods using GLSL.  The only requirements are that sounds be in WAV or OGG format, images be in PNG format, and shaders be updated to GLSL 330 specifications.  Skybox images must have a 90x90 degree field of view [for a correct perspective], and all 6 must have the same pixel dimensions.

It is my intention to use media with copyrights or licenses that are compatible with GPLv3. Please notify me if you believe there is an incompatibility, and it will be removed ASAP, eg a CC-by-NC license is NOT GPL compatible.



### Defining Your Own Puzzles:
  Read puzzle_replacement.txt

### SoundFiles
Using "sox", most sounds have been converted to the WAV format.  Most sounds are from freesound.org and are covered by the Creative Commons CC0 license documented in the accompanying file ./licenses/creativeCommonsCC0.txt. A few others with CC-by-3.0 license have accompanying text files with attributions.

"Among the Falls" [music for level 1], and others, are from (http://www.freesfx.co.uk).  See the file licenses/freeSFX_license.txt.

OpiumLoop is from "PartnersInRhyme": see signed authorization in ~/licenses/


### ImageFiles 
Most images for textures were freely [no copyright indications] available on google images.  Some wall textures used are from the GPL2.0/GPL3.0-only section of OpenGameArt.Org.  One other thatched roof texture was used from http://www.mayang.com/textures.  See ./licenses/mayang_license.txt.  Others from pixabay.com have a CC0 license; see ./licenses/creativeCommonsCC0.txt.  More recently, some are from http://all-free-download.com/free-photos/.

### ShaderFiles 
Several fragment shader files used were downloaded from http://glslsandbox.com/ and put under ./data/.  All frag. shaders from glslsandbox are under the MIT license (see ./licenses/mit_license.txt).  Existing comments or any identifying information was retained.  What follows are acknowledgments for some that were identifyable.

Volcano & "Red Planet" from Mahmud Yuldashev <mahmud9935@gmail.com>, and "waterWorldCCNSA3.fs" with a CreativeCommons license, and which seems to be credited to Alexander Alekseev with mods by Mahmud Yuldashev.

In order to make any of these usable, I had to modernize them to glsl version 330 specifications, and adapt some to utilize additional uniforms for input.

### Avatars
Several are available under the directory ~/data/avatars/.  Simply copy your preferred one into ~/data/ and rename to skin.png.  Also, many other MineCraft avatars can be used.

### SkyBoxes 
For some of these, I lowered the horizon slightly for technical reasons;  and for others I converted to png files.

One source is (www.custommapmakers.org/skyboxes.php), which gathers together many free-to-use skyboxes.

Another skybox  [from  (http://www.redsorceress.com/skybox.html)]  is credited to "The Mighty Pete" at http://www.petesoasis.com (which seems defunct).

At least 3 beautiful hi-res skyboxes used [from OpenGameArt.org] are the work of Heiko Irrgang <hi@93-interactive.com> and is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.  To view a copy of this license, visit (http://creativecommons.org/licenses/by-sa/3.0/) or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.  See also the accompanying file ./licenses/ccsa3_license.txt.




## Download Sites for AdaGate and my other games:

https://github.com/fastrgv?tab=repositories
https://www.indiedb.com/members/fastrgv/games
https://fastrgv.itch.io
https://sourceforge.net/u/fastrgv/profile/
https://gamejolt.com/@fastrgv/games


## video links [all showing older versions of AdaGate]:

level beta puzzle:
<http://youtu.be/WQU5kdO_93k>

level beta lava pit:
<http://youtu.be/0LH9H0hNF1Q>

prolog flyover (dec15):
<http://youtu.be/IOybN0lgBh8>

agnew, atoll sea life (dec15):
<http://youtu.be/SZsdmISNia4>


A 3rd party 11 minute video of AdaGate is here:
<https://www.youtube.com/watch?v=qNPc6yXfIV4&feature=youtu.be>

Ominous Fireball (12mar17):
<https://youtu.be/iJnz_u3tsnY>

Duke goes for a swim (31oct17):
<https://youtu.be/D3yBovxkhGI>

----------------------------------------------------------------
----------------------------------------------------------------

## Older Change History:

**ver 7.4.1 -- 30sep2022**
* Now using simpler-to-setup GNU Ada for Win64.

**ver 7.4.0 -- 20sep2022**
* Restored Win64 build, now using MSYS2 & mingw64 on Windows.

**ver 7.3.6 -- 16sep22**
* Now uses a generic utex, called gtex, for messages.
* Removed Win64 build.
* Now using GNU Ada rather than defunct AdaCore compiler.

**ver 7.3.5 -- 16apr22**
* Reverted linux libraries to exclusively shared format for portability.
* Alternate script for GNU-Ada also works, now.

**ver 7.3.4 -- 11feb22**
* Updated libglfw.
* Elliminated unused Frameworks directory
* ZoomWheel code improvements.

**ver 7.3.3 -- 29dec21**
* Replaced all cc-by-nc-licensed sound files due to incompatibility with GPLv3.
* Made final, minor adjustments to new sounds.
* Minor visual tweaks to kawhoosh.
* Moved auxillary source code directories (from ./) into ./src/.

