<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Library functions used by question/preview.php.
 *
 * @package    core_question
 * @subpackage questionengine
 * @copyright  2010 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/formslib.php');


/**
 * Settings form for the preview options.
 *
 * @copyright  2009 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @deprecated since Moodle 4.0
 * @see qbank_previewquestion\form\preview_options_form
 * @todo MDL-71679 class renaming
 */
class preview_options_form extends moodleform {

    public function definition() {
        debugging('Class preview_options_form has been deprecated and moved to qbank_previewquestion plugin,
         please use qbank_previewquestion\form\preview_options_form instead.', DEBUG_DEVELOPER);
        $mform = $this->_form;

        $hiddenofvisible = array(
            question_display_options::HIDDEN => get_string('notshown', 'question'),
            question_display_options::VISIBLE => get_string('shown', 'question'),
        );

        $mform->addElement('header', 'attemptoptionsheader', get_string('attemptoptions', 'question'));

        $behaviours = question_engine::get_behaviour_options(
                $this->_customdata['quba']->get_preferred_behaviour());
        $mform->addElement('select', 'behaviour',
                get_string('howquestionsbehave', 'question'), $behaviours);
        $mform->addHelpButton('behaviour', 'howquestionsbehave', 'question');

        $mform->addElement('float', 'maxmark', get_string('markedoutof', 'question'),
                array('size' => '5'));

        if ($this->_customdata['maxvariant'] > 1) {
            $variants = range(1, $this->_customdata['maxvariant']);
            $mform->addElement('select', 'variant', get_string('questionvariant', 'question'),
                    array_combine($variants, $variants));
        }
        $mform->setType('variant', PARAM_INT);

        $mform->addElement('submit', 'saverestart',
                get_string('restartwiththeseoptions', 'question'));

        $mform->addElement('header', 'displayoptionsheader', get_string('displayoptions', 'question'));

        $mform->addElement('select', 'correctness', get_string('whethercorrect', 'question'),
                $hiddenofvisible);

        $marksoptions = array(
            question_display_options::HIDDEN => get_string('notshown', 'question'),
            question_display_options::MAX_ONLY => get_string('showmaxmarkonly', 'question'),
            question_display_options::MARK_AND_MAX => get_string('showmarkandmax', 'question'),
        );
        $mform->addElement('select', 'marks', get_string('marks', 'question'), $marksoptions);

        $mform->addElement('select', 'markdp', get_string('decimalplacesingrades', 'question'),
                question_engine::get_dp_options());

        $mform->addElement('select', 'feedback',
                get_string('specificfeedback', 'question'), $hiddenofvisible);

        $mform->addElement('select', 'generalfeedback',
                get_string('generalfeedback', 'question'), $hiddenofvisible);

        $mform->addElement('select', 'rightanswer',
                get_string('rightanswer', 'question'), $hiddenofvisible);

        $mform->addElement('select', 'history',
                get_string('responsehistory', 'question'), $hiddenofvisible);

        $mform->addElement('submit', 'saveupdate',
                get_string('updatedisplayoptions', 'question'));
    }
}


/**
 * Displays question preview options as default and set the options.
 *
 * Setting default, getting and setting user preferences in question preview options.
 *
 * @copyright  2010 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @deprecated since Moodle 4.0
 * @see qbank_previewquestion\output\question_preview_options
 * @todo MDL-71679 class renaming
 */
class question_preview_options extends question_display_options {
    /** @var string the behaviour to use for this preview. */
    public $behaviour;

    /** @var number the maximum mark to use for this preview. */
    public $maxmark;

    /** @var int the variant of the question to preview. */
    public $variant;

    /** @var string prefix to append to field names to get user_preference names. */
    const OPTIONPREFIX = 'question_preview_options_';

    /**
     * Constructor.
     * @param stdClass $question
     */
    public function __construct($question) {
        debugging('Class question_preview_options has been deprecated and moved to qbank_previewquestion plugin,
         please use qbank_previewquestion\question_preview_options instead.', DEBUG_DEVELOPER);
        $this->behaviour = 'deferredfeedback';
        $this->maxmark = $question->defaultmark;
        $this->variant = null;
        $this->correctness = self::VISIBLE;
        $this->marks = self::MARK_AND_MAX;
        $this->markdp = get_config('quiz', 'decimalpoints');
        $this->feedback = self::VISIBLE;
        $this->numpartscorrect = $this->feedback;
        $this->generalfeedback = self::VISIBLE;
        $this->rightanswer = self::VISIBLE;
        $this->history = self::HIDDEN;
        $this->flags = self::HIDDEN;
        $this->manualcomment = self::HIDDEN;
    }

    /**
     * @return array names of the options we store in the user preferences table.
     */
    protected function get_user_pref_fields() {
        return array('behaviour', 'correctness', 'marks', 'markdp', 'feedback',
                'generalfeedback', 'rightanswer', 'history');
    }

    /**
     * @return array names and param types of the options we read from the request.
     */
    protected function get_field_types() {
        return array(
            'behaviour' => PARAM_ALPHA,
            'maxmark' => PARAM_LOCALISEDFLOAT,
            'variant' => PARAM_INT,
            'correctness' => PARAM_BOOL,
            'marks' => PARAM_INT,
            'markdp' => PARAM_INT,
            'feedback' => PARAM_BOOL,
            'generalfeedback' => PARAM_BOOL,
            'rightanswer' => PARAM_BOOL,
            'history' => PARAM_BOOL,
        );
    }

    /**
     * Load the value of the options from the user_preferences table.
     */
    public function load_user_defaults() {
        $defaults = get_config('question_preview');
        foreach ($this->get_user_pref_fields() as $field) {
            $this->$field = get_user_preferences(
                    self::OPTIONPREFIX . $field, $defaults->$field);
        }
        $this->numpartscorrect = $this->feedback;
    }

    /**
     * Save a change to the user's preview options to the database.
     * @param object $newoptions
     */
    public function save_user_preview_options($newoptions) {
        foreach ($this->get_user_pref_fields() as $field) {
            if (isset($newoptions->$field)) {
                set_user_preference(self::OPTIONPREFIX . $field, $newoptions->$field);
            }
        }
    }

    /**
     * Set the value of any fields included in the request.
     */
    public function set_from_request() {
        foreach ($this->get_field_types() as $field => $type) {
            $this->$field = optional_param($field, $this->$field, $type);
        }
        $this->numpartscorrect = $this->feedback;
    }

    /**
     * @return string URL fragment. Parameters needed in the URL when continuing
     * this preview.
     */
    public function get_url_params() {
        $params = array();
        foreach ($this->get_field_types() as $field => $notused) {
            if ($field == 'behaviour' || $field == 'maxmark' || is_null($this->$field)) {
                continue;
            }
            $params[$field] = $this->$field;
        }
        return $params;
    }
}


/**
 * Called via pluginfile.php -> question_pluginfile to serve files belonging to
 * a question in a question_attempt when that attempt is a preview.
 *
 * @package  core_question
 * @category files
 * @param stdClass $course course settings object
 * @param stdClass $context context object
 * @param string $component the name of the component we are serving files for.
 * @param string $filearea the name of the file area.
 * @param int $qubaid the question_usage this image belongs to.
 * @param int $slot the relevant slot within the usage.
 * @param array $args the remaining bits of the file path.
 * @param bool $forcedownload whether the user must be forced to download the file.
 * @param array $fileoptions
 * @return void false if file not found, does not return if found - justsend the file
 * @deprecated since Moodle 4.0
 * @see qbank_previewquestion\helper::question_preview_question_pluginfile()
 * @todo Final deprecation on Moodle 4.4 MDL-72438
 */
function question_preview_question_pluginfile($course, $context, $component,
        $filearea, $qubaid, $slot, $args, $forcedownload, $fileoptions) {
    debugging('Function question_preview_question_pluginfile() has been deprecated and moved to qbank_previewquestion plugin,
     please use qbank_previewquestion\helper::question_preview_question_pluginfile() instead.', DEBUG_DEVELOPER);
    qbank_previewquestion\helper::question_preview_question_pluginfile($course, $context,
            $component, $filearea, $qubaid, $slot, $args, $forcedownload, $fileoptions);
}

/**
 * The the URL to use for actions relating to this preview.
 * @param int $questionid the question being previewed.
 * @param int $qubaid the id of the question usage for this preview.
 * @param question_preview_options $options the options in use.
 * @param context $context
 * @deprecated since Moodle 4.0
 * @see qbank_previewquestion\helper::question_preview_action_url()
 * @todo Final deprecation on Moodle 4.4 MDL-72438
 */
function question_preview_action_url($questionid, $qubaid,
        question_preview_options $options, $context) {
    debugging('Function question_preview_action_url() has been deprecated and moved to qbank_previewquestion plugin,
     please use qbank_previewquestion\helper::question_preview_action_url() instead.', DEBUG_DEVELOPER);
    qbank_previewquestion\helper::question_preview_action_url($questionid, $qubaid, $options, $context);
}

/**
 * The the URL to use for actions relating to this preview.
 * @param int $questionid the question being previewed.
 * @param context $context the current moodle context.
 * @param int $previewid optional previewid to sign post saved previewed answers.
 * @deprecated since Moodle 4.0
 * @see qbank_previewquestion\helper::question_preview_form_url()
 * @todo Final deprecation on Moodle 4.4 MDL-72438
 */
function question_preview_form_url($questionid, $context, $previewid = null) {
    debugging('Function question_preview_form_url() has been deprecated and moved to qbank_previewquestion plugin,
     please use qbank_previewquestion\helper::question_preview_form_url() instead.', DEBUG_DEVELOPER);
    qbank_previewquestion\helper::question_preview_form_url($questionid, $context, $previewid);
}

/**
 * Delete the current preview, if any, and redirect to start a new preview.
 * @param int $previewid
 * @param int $questionid
 * @param object $displayoptions
 * @param object $context
 * @deprecated since Moodle 4.0
 * @see qbank_previewquestion\helper::restart_preview()
 * @todo Final deprecation on Moodle 4.4 MDL-72438
 */
function restart_preview($previewid, $questionid, $displayoptions, $context) {
    debugging('Function restart_preview() has been deprecated and moved to qbank_previewquestion plugin,
     please use qbank_previewquestion\helper::restart_preview() instead.', DEBUG_DEVELOPER);
    qbank_previewquestion\helper::restart_preview($previewid, $questionid, $displayoptions, $context);
}
