define ("tool_usertours/tour",["exports","jquery","core/aria","core/popper","core/event_dispatcher","./events"],function(a,b,c,d,e,f){"use strict";Object.defineProperty(a,"__esModule",{value:!0});a.default=void 0;b=i(b);c=h(c);d=i(d);var q;function g(){if("function"!=typeof WeakMap)return null;var a=new WeakMap;g=function(){return a};return a}function h(a){if(a&&a.__esModule){return a}if(null===a||"object"!==l(a)&&"function"!=typeof a){return{default:a}}var b=g();if(b&&b.has(a)){return b.get(a)}var c={},d=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var e in a){if(Object.prototype.hasOwnProperty.call(a,e)){var f=d?Object.getOwnPropertyDescriptor(a,e):null;if(f&&(f.get||f.set)){Object.defineProperty(c,e,f)}else{c[e]=a[e]}}}c.default=a;if(b){b.set(a,c)}return c}function i(a){return a&&a.__esModule?a:{default:a}}function j(a,b){var c=Object.keys(a);if(Object.getOwnPropertySymbols){var d=Object.getOwnPropertySymbols(a);if(b)d=d.filter(function(b){return Object.getOwnPropertyDescriptor(a,b).enumerable});c.push.apply(c,d)}return c}function k(a){for(var b=1,c;b<arguments.length;b++){c=null!=arguments[b]?arguments[b]:{};if(b%2){j(Object(c),!0).forEach(function(b){p(a,b,c[b])})}else if(Object.getOwnPropertyDescriptors){Object.defineProperties(a,Object.getOwnPropertyDescriptors(c))}else{j(Object(c)).forEach(function(b){Object.defineProperty(a,b,Object.getOwnPropertyDescriptor(c,b))})}}return a}function l(a){"@babel/helpers - typeof";if("function"==typeof Symbol&&"symbol"==typeof Symbol.iterator){l=function(a){return typeof a}}else{l=function(a){return a&&"function"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a}}return l(a)}function m(a,b){if(!(a instanceof b)){throw new TypeError("Cannot call a class as a function")}}function n(a,b){for(var c=0,d;c<b.length;c++){d=b[c];d.enumerable=d.enumerable||!1;d.configurable=!0;if("value"in d)d.writable=!0;Object.defineProperty(a,d.key,d)}}function o(a,b,c){if(b)n(a.prototype,b);if(c)n(a,c);return a}function p(a,b,c){if(b in a){Object.defineProperty(a,b,{value:c,enumerable:!0,configurable:!0,writable:!0})}else{a[b]=c}return a}var r=(q=function(){function a(b){m(this,a);p(this,"tourRunning",!1);this.init(b)}o(a,[{key:"init",value:function init(a){this.eventHandlers={};this.reset();this.originalConfiguration=a||{};this.configure.apply(this,arguments);try{this.storage=window.sessionStorage;this.storageKey="tourstate_"+this.tourName}catch(a){this.storage=!1;this.storageKey=""}return this}},{key:"reset",value:function reset(){this.hide();this.eventHandlers=[];this.resetStepListeners();this.originalConfiguration={};this.steps=[];this.currentStepNumber=0;return this}},{key:"configure",value:function configure(a){var b=this;if("object"===l(a)){if("undefined"!=typeof a.tourName){this.tourName=a.tourName}if(a.eventHandlers){var c=function(c){a.eventHandlers[c].forEach(function(a){this.addEventHandler(c,a)},b)};for(var d in a.eventHandlers){c(d)}}this.resetStepDefaults(!0);if("object"===l(a.steps)){this.steps=a.steps}if("undefined"!=typeof a.template){this.templateContent=a.template}}this.checkMinimumRequirements();return this}},{key:"checkMinimumRequirements",value:function checkMinimumRequirements(){if(!this.tourName){throw new Error("Tour Name required")}if(!this.steps||!this.steps.length){throw new Error("Steps must be specified")}}},{key:"resetStepDefaults",value:function resetStepDefaults(a){if("undefined"==typeof a){a=!0}this.stepDefaults={};if(!a||"undefined"==typeof this.originalConfiguration.stepDefaults){this.setStepDefaults({})}else{this.setStepDefaults(this.originalConfiguration.stepDefaults)}return this}},{key:"setStepDefaults",value:function setStepDefaults(a){if(!this.stepDefaults){this.stepDefaults={}}b.default.extend(this.stepDefaults,{element:"",placement:"top",delay:0,moveOnClick:!1,moveAfterTime:0,orphan:!1,direction:1},a);return this}},{key:"getCurrentStepNumber",value:function getCurrentStepNumber(){return parseInt(this.currentStepNumber,10)}},{key:"setCurrentStepNumber",value:function setCurrentStepNumber(a){this.currentStepNumber=a;if(this.storage){try{this.storage.setItem(this.storageKey,a)}catch(a){if(a.code===DOMException.QUOTA_EXCEEDED_ERR){this.storage.removeItem(this.storageKey)}}}}},{key:"getNextStepNumber",value:function getNextStepNumber(a){if("undefined"==typeof a){a=this.getCurrentStepNumber()}var b=a+1;while(b<=this.steps.length){if(this.isStepPotentiallyVisible(this.getStepConfig(b))){return b}b++}return null}},{key:"getPreviousStepNumber",value:function getPreviousStepNumber(a){if("undefined"==typeof a){a=this.getCurrentStepNumber()}var b=a-1;while(0<=b){if(this.isStepPotentiallyVisible(this.getStepConfig(b))){return b}b--}return null}},{key:"isLastStep",value:function isLastStep(a){var b=this.getNextStepNumber(a);return null===b}},{key:"isFirstStep",value:function isFirstStep(a){var b=this.getPreviousStepNumber(a);return null===b}},{key:"isStepPotentiallyVisible",value:function isStepPotentiallyVisible(a){if(!a){return!1}if(this.isStepActuallyVisible(a)){return!0}if("undefined"!=typeof a.orphan&&a.orphan){return!0}if("undefined"!=typeof a.delay&&a.delay){return!0}return!1}},{key:"isStepActuallyVisible",value:function isStepActuallyVisible(a){if(!a){return!1}var b=this.getStepTarget(a);if(b&&b.length&&b.is(":visible")){return!!b.length}return!1}},{key:"next",value:function next(){return this.gotoStep(this.getNextStepNumber())}},{key:"previous",value:function previous(){return this.gotoStep(this.getPreviousStepNumber(),-1)}},{key:"gotoStep",value:function gotoStep(a,b){if(0>a){return this.endTour()}var c=this.getStepConfig(a);if(null===c){return this.endTour()}return this._gotoStep(c,b)}},{key:"_gotoStep",value:function _gotoStep(a,b){if(!a){return this.endTour()}if("undefined"!=typeof a.delay&&a.delay&&!a.delayed){a.delayed=!0;window.setTimeout(this._gotoStep.bind(this),a.delay,a,b);return this}else if(!a.orphan&&!this.isStepActuallyVisible(a)){var d=-1==b?"getPreviousStepNumber":"getNextStepNumber";return this.gotoStep(this[d](a.stepNumber),b)}this.hide();var c=this.dispatchEvent(f.eventTypes.stepRender,{stepConfig:a},!0);if(!c.defaultPrevented){this.renderStep(a);this.dispatchEvent(f.eventTypes.stepRendered,{stepConfig:a})}return this}},{key:"getStepConfig",value:function getStepConfig(a){if(null===a||0>a||a>=this.steps.length){return null}var c=this.normalizeStepConfig(this.steps[a]);c=b.default.extend(c,{stepNumber:a});return c}},{key:"normalizeStepConfig",value:function normalizeStepConfig(a){if("undefined"!=typeof a.reflex&&"undefined"==typeof a.moveAfterClick){a.moveAfterClick=a.reflex}if("undefined"!=typeof a.element&&"undefined"==typeof a.target){a.target=a.element}if("undefined"!=typeof a.content&&"undefined"==typeof a.body){a.body=a.content}a=b.default.extend({},this.stepDefaults,a);a=b.default.extend({},{attachTo:a.target,attachPoint:"after"},a);if(a.attachTo){a.attachTo=(0,b.default)(a.attachTo).first()}return a}},{key:"getStepTarget",value:function getStepTarget(a){if(a.target){return(0,b.default)(a.target)}return null}},{key:"dispatchEvent",value:function dispatchEvent(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},c=2<arguments.length&&arguments[2]!==void 0?arguments[2]:!1;return(0,e.dispatchEvent)(a,k({tour:this},b),document,{cancelable:c})}},{key:"addEventHandler",value:function addEventHandler(a,b){if("undefined"==typeof this.eventHandlers[a]){this.eventHandlers[a]=[]}this.eventHandlers[a].push(b);return this}},{key:"processStepListeners",value:function processStepListeners(a){this.listeners.push({node:this.currentStepNode,args:["click","[data-role=\"next\"]",b.default.proxy(this.next,this)]},{node:this.currentStepNode,args:["click","[data-role=\"previous\"]",b.default.proxy(this.previous,this)]},{node:this.currentStepNode,args:["click","[data-role=\"end\"]",b.default.proxy(this.endTour,this)]},{node:(0,b.default)("[data-flexitour=\"backdrop\"]"),args:["click",b.default.proxy(this.hide,this)]},{node:(0,b.default)("body"),args:["keydown",b.default.proxy(this.handleKeyDown,this)]});if(a.moveOnClick){var c=this.getStepTarget(a);this.listeners.push({node:c,args:["click",b.default.proxy(function(a){if(0===(0,b.default)(a.target).parents("[data-flexitour=\"container\"]").length){window.setTimeout(b.default.proxy(this.next,this),500)}},this)]})}this.listeners.forEach(function(a){a.node.on.apply(a.node,a.args)});return this}},{key:"resetStepListeners",value:function resetStepListeners(){if(this.listeners){this.listeners.forEach(function(a){a.node.off.apply(a.node,a.args)})}this.listeners=[];return this}},{key:"renderStep",value:function renderStep(a){this.currentStepConfig=a;this.setCurrentStepNumber(a.stepNumber);var c=(0,b.default)(this.getTemplateContent());c.find("[data-placeholder=\"title\"]").html(a.title);c.find("[data-placeholder=\"body\"]").html(a.body);if(this.isFirstStep(a.stepNumber)){c.find("[data-role=\"previous\"]").hide()}else{c.find("[data-role=\"previous\"]").prop("disabled",!1)}if(this.isLastStep(a.stepNumber)){c.find("[data-role=\"next\"]").hide();c.find("[data-role=\"end\"]").removeClass("btn-secondary").addClass("btn-primary")}else{c.find("[data-role=\"next\"]").prop("disabled",!1)}c.find("[data-role=\"previous\"]").attr("role","button");c.find("[data-role=\"next\"]").attr("role","button");c.find("[data-role=\"end\"]").attr("role","button");a.template=c;this.addStepToPage(a);this.processStepListeners(a);return this}},{key:"getTemplateContent",value:function getTemplateContent(){return(0,b.default)(this.templateContent).clone()}},{key:"addStepToPage",value:function addStepToPage(a){var c=(0,b.default)("<span data-flexitour=\"container\"></span>").html(a.template).hide(),e=(0,b.default)("body, html").stop(!0,!0);if(this.isStepActuallyVisible(a)){var f=this.getStepTarget(a);if(f.parents("[data-usertour=\"scroller\"]").length){e=f.parents("[data-usertour=\"scroller\"]")}f.data("flexitour","target");var g=this.calculateZIndex(f);if(g){a.zIndex=g+1}if(a.zIndex){c.css("zIndex",a.zIndex+1)}this.positionBackdrop(a);(0,b.default)(document.body).append(c);this.currentStepNode=c;this.currentStepNode.css({top:0,left:0});e.animate({scrollTop:this.calculateScrollTop(a)}).promise().then(function(){this.positionStep(a);this.revealStep(a)}.bind(this)).catch(function(){})}else if(a.orphan){a.isOrphan=!0;a.attachTo=(0,b.default)("body").first();a.attachPoint="append";this.positionBackdrop(a);c.addClass("orphan");(0,b.default)(document.body).append(c);this.currentStepNode=c;this.currentStepNode.offset(this.calculateStepPositionInPage());this.currentStepNode.css("position","fixed");this.currentStepPopper=new d.default((0,b.default)("body"),this.currentStepNode[0],{removeOnDestroy:!0,placement:a.placement+"-start",arrowElement:"[data-role=\"arrow\"]",modifiers:{hide:{enabled:!1},applyStyle:{onLoad:null,enabled:!1}}});this.revealStep(a)}return this}},{key:"revealStep",value:function revealStep(a){this.currentStepNode.fadeIn("",b.default.proxy(function(){this.announceStep(a);this.currentStepNode.focus();window.setTimeout(b.default.proxy(function(){if(this.currentStepNode){this.currentStepNode.focus()}},this),100)},this));return this}},{key:"announceStep",value:function announceStep(a){var b="tour-step-"+this.tourName+"-"+a.stepNumber;this.currentStepNode.attr("id",b);var c=this.currentStepNode.find("[data-placeholder=\"body\"]").first();c.attr("id",b+"-body");c.attr("role","document");var d=this.currentStepNode.find("[data-placeholder=\"title\"]").first();d.attr("id",b+"-title");d.attr("aria-labelledby",b+"-body");this.currentStepNode.attr("role","dialog");this.currentStepNode.attr("tabindex",0);this.currentStepNode.attr("aria-labelledby",b+"-title");this.currentStepNode.attr("aria-describedby",b+"-body");var e=this.getStepTarget(a);if(e){if(!e.attr("tabindex")){e.attr("tabindex",0)}e.data("original-describedby",e.attr("aria-describedby")).attr("aria-describedby",b+"-body")}this.accessibilityShow(a);return this}},{key:"handleKeyDown",value:function handleKeyDown(a){var c="a[href], link[href], [draggable=true], [contenteditable=true], ";c+=":input:enabled, [tabindex], button:enabled";switch(a.keyCode){case 27:this.endTour();break;case 9:(function(){if(!this.currentStepConfig.hasBackdrop){return}var d=(0,b.default)(document.activeElement),e=this.getStepTarget(this.currentStepConfig),f=(0,b.default)(c),g=(0,b.default)("span[data-flexitour=\"container\"]"),h;if(e){f=f.filter(function(a,b){return null!==e&&(e.has(b).length||g.has(b).length||e.is(b)||g.is(b))})}f.each(function(a,b){if(d.is(b)){h=a;return!1}return!0});var i,j,k;if(void 0!=h){var l=1;if(a.shiftKey){l=-1}i=h;do{i+=l;j=(0,b.default)(f[i])}while(j.length&&j.is(":disabled")||j.is(":hidden"));if(j.length){k=j.closest(e).length;k=k||j.closest(this.currentStepNode).length}else{k=!1}}if(k){j.focus()}else{if(a.shiftKey){this.currentStepNode.find(c).last().focus()}else{if(this.currentStepConfig.isOrphan){this.currentStepNode.focus()}else{e.focus()}}}a.preventDefault()}).call(this);break;}}},{key:"startTour",value:function startTour(a){if(this.storage&&"undefined"==typeof a){var c=this.storage.getItem(this.storageKey);if(c){var d=parseInt(c,10);if(d<=this.steps.length){a=d}}}if("undefined"==typeof a){a=this.getCurrentStepNumber()}var b=this.dispatchEvent(f.eventTypes.tourStart,{startAt:a},!0);if(!b.defaultPrevented){this.gotoStep(a);this.tourRunning=!0;this.dispatchEvent(f.eventTypes.tourStarted,{startAt:a})}return this}},{key:"restartTour",value:function restartTour(){return this.startTour(0)}},{key:"endTour",value:function endTour(){var a=this.dispatchEvent(f.eventTypes.tourEnd,{},!0);if(a.defaultPrevented){return this}if(this.currentStepConfig){var b=this.getStepTarget(this.currentStepConfig);if(b){if(!b.attr("tabindex")){b.attr("tabindex","-1")}b.focus()}}this.hide(!0);this.tourRunning=!1;this.dispatchEvent(f.eventTypes.tourEnded);return this}},{key:"hide",value:function hide(a){var c=this.dispatchEvent(f.eventTypes.stepHide,{},!0);if(c.defaultPrevented){return this}if(this.currentStepNode&&this.currentStepNode.length){this.currentStepNode.hide();if(this.currentStepPopper){this.currentStepPopper.destroy()}}if(this.currentStepConfig){var e=this.getStepTarget(this.currentStepConfig);if(e){if(e.data("original-labelledby")){e.attr("aria-labelledby",e.data("original-labelledby"))}if(e.data("original-describedby")){e.attr("aria-describedby",e.data("original-describedby"))}if(e.data("original-tabindex")){e.attr("tabindex",e.data("tabindex"))}}this.currentStepConfig=null}var d=0;if(a){d=400}(0,b.default)("[data-flexitour=\"step-background\"]").remove();(0,b.default)("[data-flexitour=\"step-backdrop\"]").removeAttr("data-flexitour");(0,b.default)("[data-flexitour=\"backdrop\"]").fadeOut(d,function(){(0,b.default)(this).remove()});if(this.currentStepNode&&this.currentStepNode.length){var g=this.currentStepNode.attr("id");if(g){var h="[aria-describedby=\""+g+"-body\"]";(0,b.default)(h).removeAttr("tabindex");(0,b.default)(h).removeAttr("aria-describedby")}}this.resetStepListeners();this.accessibilityHide();this.dispatchEvent(f.eventTypes.stepHidden);this.currentStepNode=null;this.currentStepPopper=null;return this}},{key:"show",value:function show(){var a=this.getCurrentStepNumber();return this.gotoStep(a)}},{key:"getStepContainer",value:function getStepContainer(){return(0,b.default)(this.currentStepNode)}},{key:"calculateScrollTop",value:function calculateScrollTop(a){var c=(0,b.default)(window).height(),d=this.getStepTarget(a);parent=(0,b.default)(window);if(d.parents("[data-usertour=\"scroller\"]").length){parent=d.parents("[data-usertour=\"scroller\"]")}var e=parent.scrollTop();if("top"===a.placement){e=d.offset().top-c/2}else if("bottom"===a.placement){e=d.offset().top+d.height()+e-c/2}else if(d.height()<=.8*c){e=d.offset().top-(c-d.height())/2}else{e=d.offset().top-.2*c}e=Math.max(0,e);e=Math.min((0,b.default)(document).height()-c,e);return Math.ceil(e)}},{key:"calculateStepPositionInPage",value:function calculateStepPositionInPage(){var a=(0,b.default)(window).height(),c=this.currentStepNode.height(),d=(0,b.default)(window).width(),e=this.currentStepNode.width();return{top:Math.ceil((a-c)/2),left:Math.ceil((d-e)/2)}}},{key:"positionStep",value:function positionStep(a){var c=this.currentStepNode;if(!c||!c.length){return this}a.placement=this.recalculatePlacement(a);var e;switch(a.placement){case"left":e=["left","right","top","bottom"];break;case"right":e=["right","left","top","bottom"];break;case"top":e=["top","bottom","right","left"];break;case"bottom":e=["bottom","top","right","left"];break;default:e="flip";break;}var f=this.getStepTarget(a),g={placement:a.placement+"-start",removeOnDestroy:!0,modifiers:{flip:{behaviour:e},arrow:{element:"[data-role=\"arrow\"]"}},onCreate:function onCreate(a){h(a)},onUpdate:function onUpdate(a){h(a)}},h=function(a){var c=a.placement.split("-")[0],d=-1!==["left","right"].indexOf(c),e=a.instance.popper.querySelector("[data-role=\"arrow\"]"),f=(0,b.default)(a.instance.popper.querySelector("[data-role=\"flexitour-step\"]"));if(d){var g=parseFloat(window.getComputedStyle(e).height),h=parseFloat(window.getComputedStyle(e).top),i=parseFloat(window.getComputedStyle(a.instance.popper).height),j=parseFloat(window.getComputedStyle(a.instance.popper).top),k=parseFloat(f.css("borderTopWidth")),l=2*parseFloat(f.css("borderTopLeftRadius")),m=h+g/2,n=i+j-k-l,o=j+k+l;if(m>=n||m<=o){var y=0;if(m>i/2){y=n-g}else{y=o+g}(0,b.default)(e).css("top",y)}}else{var p=parseFloat(window.getComputedStyle(e).width),q=parseFloat(window.getComputedStyle(e).left),r=parseFloat(window.getComputedStyle(a.instance.popper).width),s=parseFloat(window.getComputedStyle(a.instance.popper).left),t=parseFloat(f.css("borderTopWidth")),u=2*parseFloat(f.css("borderTopLeftRadius")),v=q+p/2,w=r+s-t-u,x=s+t+u;if(v>=w||v<=x){var z=0;if(v>r/2){z=w-p}else{z=x+p}(0,b.default)(e).css("left",z)}}},i=(0,b.default)("[data-flexitour=\"step-background\"]");if(i.length){f=i}this.currentStepPopper=new d.default(f,c[0],g);return this}},{key:"recalculatePlacement",value:function recalculatePlacement(a){var b=this.getStepTarget(a),c=this.currentStepNode.width()+16,d=b.offset().left-10,e=b.offset().left+b.width()+10,f=a.placement;if(-1!==["left","right"].indexOf(f)){if(d<c+10&&e+c+10>document.documentElement.clientWidth){f="top"}}return f}},{key:"positionBackdrop",value:function positionBackdrop(a){if(a.backdrop){this.currentStepConfig.hasBackdrop=!0;var f=(0,b.default)("<div data-flexitour=\"backdrop\"></div>");if(a.zIndex){if("append"===a.attachPoint){a.attachTo.append(f)}else{f.insertAfter(a.attachTo)}}else{(0,b.default)("body").append(f)}if(this.isStepActuallyVisible(a)){var g=(0,b.default)("[data-flexitour=\"step-background\"]");if(!g.length){g=(0,b.default)("<div data-flexitour=\"step-background\"></div>")}var c=this.getStepTarget(a),d=10,e=c;if(d){e=(0,b.default)("body")}var h=0;if(c.parents("[data-usertour=\"scroller\"]").length){h=c.parents("[data-usertour=\"scroller\"]").scrollTop();g.css({position:"fixed"})}g.css({width:c.outerWidth()+d+d,height:c.outerHeight()+d+d,left:c.offset().left-d,top:c.offset().top+h-d,backgroundColor:this.calculateInherittedBackgroundColor(e)});if(c.offset().left<d){g.css({width:c.outerWidth()+c.offset().left+d,left:c.offset().left})}if(c.offset().top+h<d){g.css({height:c.outerHeight()+c.offset().top+d,top:c.offset().top})}var i=c.css("borderRadius");if(i&&i!==(0,b.default)("body").css("borderRadius")){g.css("borderRadius",i)}var j=this.calculatePosition(c);if("fixed"===j){g.css("top",0)}else if("absolute"===j){g.css("position","fixed")}var k=g.clone();k.css({backgroundColor:f.css("backgroundColor"),opacity:f.css("opacity")});k.attr("data-flexitour","step-background-fader");if(c.parents("[data-region=\"fixed-drawer\"]").length){var l=c.clone();g.append(l)}if(a.zIndex){if("append"===a.attachPoint){a.attachTo.append(g)}else{k.insertAfter(a.attachTo);g.insertAfter(a.attachTo)}}else{(0,b.default)("body").append(k);(0,b.default)("body").append(g)}c.attr("data-flexitour","step-backdrop");if(a.zIndex){f.css("zIndex",a.zIndex);g.css("zIndex",a.zIndex+1);c.css("zIndex",a.zIndex+2)}k.fadeOut("2000",function(){(0,b.default)(this).remove()})}}return this}},{key:"calculateZIndex",value:function calculateZIndex(a){a=(0,b.default)(a);while(a.length&&a[0]!==document){var c=a.css("position");if("absolute"===c||"relative"===c||"fixed"===c){var d=parseInt(a.css("zIndex"),10);if(!isNaN(d)&&0!==d){return d}}a=a.parent()}return 0}},{key:"calculateInherittedBackgroundColor",value:function calculateInherittedBackgroundColor(a){var c=(0,b.default)("<div>").hide();(0,b.default)("body").append(c);var d=c.css("backgroundColor");c.remove();a=(0,b.default)(a);while(a.length&&a[0]!==document){var e=a.css("backgroundColor");if(e!==d){return e}a=a.parent()}return null}},{key:"calculatePosition",value:function calculatePosition(a){a=(0,b.default)(a);while(a.length&&a[0]!==document){var c=a.css("position");if("static"!==c){return c}a=a.parent()}return null}},{key:"accessibilityShow",value:function accessibilityShow(){var a=function(a){var b=a.data("flexitour");if(b){switch(b){case"container":case"target":return;}}var d=a.attr("aria-hidden");if(!d){a.attr("data-has-hidden",!0);c.hide(a)}};this.currentStepNode.siblings().each(function(c,d){a((0,b.default)(d))});this.currentStepNode.parentsUntil("body").siblings().each(function(c,d){a((0,b.default)(d))})}},{key:"accessibilityHide",value:function accessibilityHide(){var a=function(a){var b=a.attr("data-has-hidden");if("undefined"!=typeof b){a.removeAttr("data-has-hidden");c.unhide(a)}};(0,b.default)("[data-has-hidden]").each(function(c,d){a((0,b.default)(d))})}}]);return a}(),q);a.default=r;return a.default});
//# sourceMappingURL=tour.min.js.map
