/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.Token;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SrvTabNameToken
extends Token
implements Dumpable {
    public static final int TDS_OFF_SELECT = 365;
    public static final int TDS_OFF_FROM = 335;
    public static final int TDS_OFF_ORDER = 357;
    public static final int TDS_OFF_COMPUTE = 313;
    public static final int TDS_OFF_TABLE = 371;
    public static final int TDS_OFF_PROC = 362;
    public static final int TDS_OFF_STMT = 459;
    public static final int TDS_OFF_PARAM = 452;
    private int _length;
    private Vector _names;

    public SrvTabNameToken(TdsInputStream tdsInputStream) throws IOException {
        int n;
        this._length = tdsInputStream.readShort();
        this._names = new Vector();
        for (int i = this._length; i > 0; i -= n) {
            n = tdsInputStream.readUnsignedByte();
            --i;
            if (n == 0) break;
            String string = tdsInputStream.readString(n);
            this._names.addElement(string);
        }
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(164)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "TABNAME Token (0x" + HexConverts.hexConvert((int)164, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "TABNAME Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._length);
            }
            if (dumpFilter.includesDetail(3)) {
                Enumeration enumeration = this._names.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (dumpFilter.includesDetail(1)) {
                        dumpInfo.addInt("Name Length", 1, string.length());
                    }
                    dumpInfo.addText("Table Name", string.length(), string);
                }
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 164;
    }
}

