/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.SrvCapabilityToken;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvRowDataFormat2;
import com.sybase.jdbc3.tds.SrvSQLTypeFormatter;
import com.sybase.jdbc3.tds.SrvTypeException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SrvSQLTypeFormatter2
extends SrvSQLTypeFormatter {
    public SrvSQLTypeFormatter2(SrvFormatToken srvFormatToken, SrvCapabilityToken srvCapabilityToken) {
        super(srvFormatToken, srvCapabilityToken);
    }

    public DataFormat[] buildDataFormat(ResultSet resultSet) throws IOException {
        SrvRowDataFormat2[] srvRowDataFormat2Array = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n == 0) {
                throw new SrvTypeException("Cannot format result set with  0 columns");
            }
            srvRowDataFormat2Array = new SrvRowDataFormat2[n];
            for (int i = 1; i <= n; ++i) {
                int n2;
                String string;
                String string2;
                String string3;
                String string4;
                int n3;
                Object v = _formatmap.get(new Integer(resultSetMetaData.getColumnType(i)));
                if (v == null) {
                    throw new SrvTypeException("Cannot map JDBC type " + resultSetMetaData.getColumnTypeName(i) + " to TDS type");
                }
                int[] nArray = (int[])v;
                if (this._cap.handlesDataType(nArray[1])) {
                    n3 = 0;
                    if (resultSetMetaData.isNullable(i) == 1) {
                        n3 |= 0x20;
                    }
                    if (resultSetMetaData.isWritable(i)) {
                        n3 |= 0x10;
                    }
                    string4 = resultSetMetaData.getColumnLabel(i);
                    string3 = resultSetMetaData.getCatalogName(i);
                    string2 = resultSetMetaData.getSchemaName(i);
                    string = resultSetMetaData.getTableName(i);
                    switch (nArray[1]) {
                        case 39: 
                        case 47: 
                        case 175: {
                            n2 = resultSetMetaData.getColumnDisplaySize(i);
                            break;
                        }
                        case 37: 
                        case 45: 
                        case 225: {
                            n2 = resultSetMetaData.getColumnDisplaySize(i) / 2;
                            break;
                        }
                        default: {
                            n2 = nArray[2];
                        }
                    }
                } else {
                    throw new SrvTypeException("Not handling client literal  conversion for JDBC types " + resultSetMetaData.getColumnTypeName(i));
                }
                srvRowDataFormat2Array[i - 1] = new SrvRowDataFormat2(string4, string3, string2, string, resultSetMetaData.getColumnName(i), nArray[1], n3, n2, resultSetMetaData.getPrecision(i), resultSetMetaData.getScale(i), null);
            }
        }
        catch (SQLException sQLException) {
            throw new SrvTypeException("SQL to TDS conversion error: " + sQLException);
        }
        return srvRowDataFormat2Array;
    }
}

