/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.RowToken;
import com.sybase.jdbc3.tds.SrvDataToken;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.SrvJavaTypeFormatter;
import com.sybase.jdbc3.tds.SrvTypeFormatter;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.Token;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;

public class SrvRowToken
extends RowToken
implements SrvDataToken,
Dumpable {
    SrvTypeFormatter _formatter = null;
    TdsInputStream _in = null;

    public SrvRowToken(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
        this._in = tdsInputStream;
    }

    public SrvRowToken() {
    }

    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeByte(209);
        this._formatter.sendDataStream(tdsOutputStream);
    }

    public void setFormatter(SrvTypeFormatter srvTypeFormatter) {
        this._formatter = srvTypeFormatter;
    }

    public TdsInputStream getStream() {
        return this._in;
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        if (this._formatter == null) {
            throw new Error("Ya godda have a formatter to dump rows.");
        }
        DumpInfo dumpInfo = null;
        SrvJavaTypeFormatter srvJavaTypeFormatter = (SrvJavaTypeFormatter)this._formatter;
        Object[] objectArray = srvJavaTypeFormatter.convertData((Token)this);
        if (dumpFilter.includesToken(209)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ROW Token (0x" + HexConverts.hexConvert((int)209, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ROW Token");
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(6)) {
                int[] nArray = srvJavaTypeFormatter.getColumnStatusBytes();
                int[] nArray2 = srvJavaTypeFormatter.getSerializationTypes();
                int[] nArray3 = srvJavaTypeFormatter.getDataLengths();
                int[] nArray4 = srvJavaTypeFormatter.getLengthSizes();
                SrvFormatToken srvFormatToken = srvJavaTypeFormatter.getDataFormats();
                String[] stringArray = new String[]{"DATA_NORMAL", "DATA_NULL", "DATA_ZERO_LENGTH_TEXT_IMAGE", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>", "<unrecognized>"};
                for (int i = 0; i < objectArray.length; ++i) {
                    dumpInfo.addInfo("TDSFmt", 0, "Column " + (i + 1));
                    DataFormat dataFormat = srvFormatToken.formatAt(i);
                    String string = null;
                    if (dataFormat.isUnitype()) {
                        string = this.getStream().getBigEndian() ? "UnicodeBigUnmarked" : "UnicodeLittleUnmarked";
                    }
                    if (dumpFilter.includesDetail(1)) {
                        if (nArray[i] != 9999) {
                            byte by = (byte)nArray[i];
                            dumpInfo.addBitfield("Column Status", 1, by, stringArray);
                            if ((by & 1) != 0) {
                                dumpInfo.addValue("Row data", nArray3[i], objectArray[i], string);
                                continue;
                            }
                        }
                        dumpInfo.addInt("Length", nArray4[i], nArray3[i]);
                    }
                    if (nArray2[i] != 9999) {
                        dumpInfo.addInt("Blob Serialization Type", 1, nArray2[i]);
                    }
                    dumpInfo.addValue("Row data", nArray3[i], objectArray[i], string);
                }
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 209;
    }
}

