/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.Token;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SrvControlToken
extends Token
implements Dumpable {
    protected int _totalLen;
    protected Vector _formats;

    public SrvControlToken(TdsInputStream tdsInputStream) throws IOException {
        int n;
        ControlInfo controlInfo;
        this._totalLen = tdsInputStream.readUnsignedShort();
        this._formats = new Vector();
        for (n = this._totalLen; n > 0; n -= controlInfo.getLength()) {
            controlInfo = new ControlInfo(tdsInputStream);
            this._formats.addElement(controlInfo);
        }
        if (n < 0) {
            throw new IOException("Malformed Control token lengths");
        }
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(174)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "CONTROL Token (0x" + HexConverts.hexConvert((int)174, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "CONTROL Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3)) {
                Enumeration enumeration = this._formats.elements();
                while (enumeration.hasMoreElements()) {
                    ControlInfo controlInfo = (ControlInfo)enumeration.nextElement();
                    dumpInfo.addInfo(controlInfo.dump(dumpFilter));
                }
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 174;
    }

    private class ControlInfo
    implements Dumpable {
        private int _length;
        private byte[] _format;

        protected ControlInfo(TdsInputStream tdsInputStream) throws IOException {
            this._length = tdsInputStream.readUnsignedByte();
            if (this._length != 0) {
                this._format = new byte[this._length];
                tdsInputStream.read(this._format);
            }
        }

        protected int getLength() {
            return this._length + 1;
        }

        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Control Info Length", 1, this._length);
            }
            if (this._length != 0) {
                dumpInfo.addHex("Control Info", this._length, this._format);
            }
            return dumpInfo;
        }

        public int getTokenType() {
            return -1;
        }
    }
}

