/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.error.Errors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.ProfileData;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.BatchContextImpl;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;
import sqlj.runtime.profile.ref.RTStatementJDBCCallable;
import sqlj.runtime.profile.ref.RTStatementJDBCPrepared;

public class JDBCProfile
implements DynamicProfile {
    private ProfileData profileData;
    private Connection conn;

    public JDBCProfile(Connection connection, ProfileData profileData) {
        this.profileData = profileData;
        this.conn = connection;
    }

    @Override
    public ProfileData getProfileData() {
        return this.profileData;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    private RTStatement getStatement(int n2) throws SQLException {
        EntryInfo entryInfo = this.profileData.getEntryInfo(n2);
        int n3 = entryInfo.getRole();
        int n4 = 1003;
        int n5 = 1007;
        String string = this.getSQLString(n2);
        if ((n3 == 2 || n3 == 7) && entryInfo.getResultSetType() != 128) {
            Field field;
            Class clazz;
            String string2;
            boolean bl2 = false;
            if (entryInfo.isScrollable()) {
                string2 = entryInfo.getResultSetName();
                clazz = null;
                try {
                    clazz = this.profileData.getProfile().getLoader().loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Errors.raiseErrorWithGivenMsg("JDBCProfile.getStatement(): Iterator class <" + string2 + "> not found - failure to acquire cursor information");
                }
                int n6 = 1;
                field = null;
                try {
                    field = clazz.getDeclaredField("sensitivity");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                try {
                    if (field != null) {
                        n6 = field.getInt(null);
                        n4 = n6 == 3 ? 1005 : 1004;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    Errors.raiseErrorWithGivenMsg("JDBCProfile.getStatement(): IllegalAccessException on 'sensitivity' for iterator class <" + string2 + ">. Iterator class must be public");
                }
            }
            if (n3 == 7) {
                n5 = 1008;
                string2 = entryInfo.getResultSetName();
                clazz = null;
                try {
                    clazz = this.profileData.getProfile().getLoader().loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Errors.raiseErrorWithGivenMsg("JDBCProfile.getStatement(): Iterator class <" + string2 + "> not found - failure to acquire cursor information");
                }
                String string3 = " FOR UPDATE ";
                field = null;
                try {
                    field = clazz.getDeclaredField("updateColumns");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (field != null) {
                    try {
                        String string4 = (String)field.get(null);
                        if (string4 != null) {
                            string3 = string3 + " OF " + string4 + " ";
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Errors.raiseErrorWithGivenMsg("JDBCProfile.getStatement(): IllegalAccessException on 'updateColumns' for iterator class <" + string2 + ">. Iterator class must be public");
                    }
                }
                string = this.addUpdateClause(string, string3);
            }
        }
        if (entryInfo.getStatementType() == 2) {
            return this.prepareStatement(string, n4, n5);
        }
        return this.prepareCall(string, n4, n5);
    }

    @Override
    public RTStatement getStatement(int n2, Map map) throws SQLException {
        return this.getStatement(n2, null, map);
    }

    @Override
    public RTStatement getStatement(int n2, BatchContext batchContext, Map map) throws SQLException {
        if (map != null) {
            this.conn.setTypeMap(map);
        }
        RTStatementJDBCBase rTStatementJDBCBase = (RTStatementJDBCBase)((Object)this.getStatement(n2));
        EntryInfo entryInfo = this.profileData.getEntryInfo(n2);
        if (rTStatementJDBCBase != null) {
            rTStatementJDBCBase.setEntryInfo(entryInfo);
            rTStatementJDBCBase.setBatchContext((BatchContextImpl)batchContext);
        }
        return (RTStatement)((Object)rTStatementJDBCBase);
    }

    protected String getSQLString(int n2) throws SQLException {
        return this.profileData.getEntryInfo(n2).getSQLString();
    }

    @Override
    public RTCallableStatement prepareCall(String string) throws SQLException {
        return new RTStatementJDBCCallable(this.conn.prepareCall(string));
    }

    @Override
    public RTStatement prepareStatement(String string) throws SQLException {
        return new RTStatementJDBCPrepared(this.conn.prepareStatement(string));
    }

    public RTStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        return new RTStatementJDBCPrepared(this.conn.prepareStatement(string, n2, n3));
    }

    public RTCallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        return new RTStatementJDBCCallable(this.conn.prepareCall(string, n2, n3));
    }

    @Override
    public void close() throws SQLException {
    }

    private String addUpdateClause(String string, String string2) {
        boolean bl2 = false;
        String string3 = string.trim().toUpperCase();
        if (string3.endsWith("RR") || string3.endsWith("RS") || string3.endsWith("CS") || string3.endsWith("UR")) {
            if ((string3 = string3.substring(0, string3.length() - 2).trim()).endsWith("WITH")) {
                bl2 = true;
            }
        } else if (string3.endsWith("LOCKS")) {
            if ((string3 = string3.substring(0, string3.length() - 5).trim()).endsWith("UPDATE")) {
                string3 = string3.substring(0, string3.length() - 6).trim();
            } else if (string3.endsWith("SHARE")) {
                string3 = string3.substring(0, string3.length() - 5).trim();
            } else if (string3.endsWith("EXCLUSIVE")) {
                string3 = string3.substring(0, string3.length() - 9).trim();
            }
            if (string3.endsWith("KEEP")) {
                bl2 = true;
            }
        }
        if (bl2) {
            int n2;
            int n3 = string.lastIndexOf(119);
            int n4 = n3 > (n2 = string.lastIndexOf(87)) ? n3 : n2;
            String string4 = null;
            if (n4 > 0) {
                string3 = string.substring(0, n4);
                string4 = string.substring(n4, string.length());
            }
            string3 = string3 + string2 + string4;
        } else {
            string3 = string + string2;
        }
        return string3;
    }

    @Override
    public boolean isCustomized() {
        return false;
    }

    @Override
    public void setCloseRTStmtsNotDrivenByFinalizer(boolean bl2) {
    }

    @Override
    public void setIsConnProfileFromT2ZosCachedDefaultCtx(boolean bl2) {
    }
}

