<?php
	// This PHP guestbook script was written by Thomas Hettenhausen in 2003.
	// http://flatphpbook.sourceforge.net
	// http://www.hettenhausen.net
	//
	// This software is free software; you can redistribute it and/or modify
	// it under the terms of the GNU General Public License as published by
	// the Free Software Foundation; either version 2 of the License, or
	// (at your option) any later version.
	// 
	// This program is distributed in the hope that it will be useful,
	// but WITHOUT ANY WARRANTY; without even the implied warranty of
	// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	// GNU General Public License for more details.
	// 
	// You should have received a copy of the GNU General Public License
	// along with this program; if not, write to the Free Software
	// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	// this needs to be done first, so the script knows how to do some of the other stuff:

	// admin settings	
	$adminusername = "admin"; // the administrator username who can delete posts - YOU REALLY SHOULD CHANGE THIS
	$adminpassword = "adminpw" ; // the corresponding passwort - YOU REALLY SHOULD CHANGE THIS
	$adminmode = 0; // set adminmode to 0 for security reasons DO NOT CHANGE THIS

	// reading the configuration from the INI file
	$INIfileName = "guestbook.ini";
	$configFromINI = parse_ini_file($INIfileName, true);
	
	// reading the language-specific content
	$languageStrings = parse_ini_file($configFromINI['Files']['languageFile']);

	if ($configFromINI['General']['useCookies'] != "1")	{
		session_start();
		header("Cache-control: private"); // IE 6 Fix, needed for using the "Back" button with sessions and forms
	}



	////////////////////////////////////////////////////////////////////////
	//                                         FUNCTIONS                                          //
	////////////////////////////////////////////////////////////////////////


	// removes HTML tags and the delimiters used in the db file from the input
	function safeHTML($input)	{
		global $configFromINI;
		$input = strip_tags($input);
		$input = htmlspecialchars(stripslashes($input), ENT_QUOTES);
		$input = preg_replace("/(\015\012)|(\015)|(\012)/", "&nbsp;<br />", $input); // exchanges CR, LF and CRLF with <br />
		$input = ereg_replace($configFromINI['General']['delimiter'], "[[delimiter]]", $input);
		return $input;
	}

	// here the BBcode for formatting, links and images is replaced with the real HTML tags
	// together with any incidentally used delimiter in the database file (because a visitor wanted to use it in his text) -
	// they were exchanged by the safeHTML() function and are now reinserted for display
	function recreateUserInput($input, $externalLinksTargetCode)	{
		global $configFromINI, $languageStrings;
		$input = str_replace("[[delimiter]]", $configFromINI['General']['delimiter'], $input);		// put the real delimiter back into the string
		$input = preg_replace("/(\[\[comment\]\])(.+?)(\[\[\/comment\]\])/i", "<br /><br /><i><b>".$languageStrings['AdminComment'].":</b><br />\\2</i>", $input);
		$input = preg_replace("/(\[b\])(.+?)(\[\/b\])/i", "<span style=\"font-weight: bold;\">\\2</span>",  $input);
		$input = preg_replace("/(\[i\])(.+?)(\[\/i\])/i", "<span style=\"font-style: italic;\">\\2</span>", $input);
		$input = preg_replace("/(\[u\])(.+?)(\[\/u\])/i", "<span style=\"text-decoration: underline;\">\\2</span>", $input);
		$input = preg_replace("/(\[pre\])(.+?)(\[\/pre\])/i", "<pre>\\2</pre>", $input);
		$input = preg_replace("/(\[img\])(.+?)(\[\/img\])/i", '<img src="\\2" alt="\\2">', $input);
		$input = preg_replace("/(\[color=(.+?)\])(.+?)(\[\/color\])/i", "<span style=\"color: \\2\">\\3</span>", $input);
		$input = preg_replace("/(\[size=(.+?)\])(.+?)(\[\/size\])/i", "<span style=\"font-size: \\2%;\">\\3</span>", $input);
		$input = preg_replace("/(\[email\])(.+?)(\[\/email\])/i", "<a href=\"mailto:\\2\">\\2 </a>", $input);
		$input = preg_replace("/(\[email=(.+?)\])(.+?)(\[\/email\])/i", "<a href=\"mailto:\\2\">\\3</a>", $input);
		$input = preg_replace("/\[url\]http\:\/\//i", "[url]", $input);
		$input = preg_replace("/\[url=http\:\/\//i", "[url=", $input);
		$input = preg_replace("/(\[url\])(.+?)(\[\/url\])/i", "<a href=\"http://\\2\"".$externalLinksTargetCode.">\\2</a>", $input);
		$input = preg_replace("/(\[url=\])(.+?)(\[\/url\])/i", "<a href=\"http://\\2\"".$externalLinksTargetCode.">\\2</a>", $input);
		$input = preg_replace("/(\[url=(.+?)\])(.+?)(\[\/url\])/i", "<a href=\"http://\\2\"".$externalLinksTargetCode.">\\3</a>", $input);
		$input = str_replace('\\&quot;', '&quot;', $input);
		return $input;
	}


	// displays the input fields for a new post: name, email, you name it
	function displayInputForm($Nickname, $Emailaddress, $Homepage, $forgotten, $customFields) {
		global $configFromINI, $languageStrings;
		// determines if an input field was forgotten and highlites its title in red
		switch($forgotten)	{
			case "nickname":
				$highliteMessageOpen = "";
				$highliteMessageClose = "";
				$highliteNickOpen = "<span class=\"forgotten\">*&nbsp;";
				$highliteNickClose = "</span>";
				break;
			case "message":
				$highliteNickOpen = "";
				$highliteNickClose = "";
				$highliteMessageOpen = "<span class=\"forgotten\">*&nbsp;";
				$highliteMessageClose = "</span>";
				break;
			case "both":
				$highliteNickOpen = "<span class=\"forgotten\">*&nbsp;";
				$highliteNickClose = "</span>";
				$highliteMessageOpen = "<span class=\"forgotten\">*&nbsp;";
				$highliteMessageClose = "</span>";
				break;
			default:
				$highliteNickOpen = "";
				$highliteNickClose = "";
				$highliteMessageOpen = "";
				$highliteMessageClose = "";
				break;
		}
		if (isset($_POST["Message"]))	{
			$messageDisplay = stripslashes($_POST["Message"]);
		}
		else	{
			$messageDisplay = "";
		}
		echo "\n\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<form name=\"inputform\" method=\"post\" action=\"".$_SERVER['PHP_SELF']."\">\n";
		echo "\t\t\t\t\t\t\t\t<table border=\"0\">\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>".$highliteNickOpen.$languageStrings['YourName'].$highliteNickClose.":<br />";
		echo "<input type=\"text\" name=\"NickName\" size=\"26\" value=\"".$Nickname."\" /></td>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourEmail'].":<br />";
		echo "<input type=\"text\" name=\"EmailAddress\" size=\"36\" value=\"".$Emailaddress."\" /></td>";
		echo "\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$languageStrings['YourHomepage'].":<br />";
		echo "<input type=\"text\" name=\"Homepage\" size=\"67\" value=\"".$Homepage."\" /></td>\n\t\t\t\t\t\t\t\t\t</tr>";
		if ($configFromINI['Behaviour']['customFields'] != "0")
		{
			$customFieldNames = split(",", $configFromINI['Behaviour']['customFieldNames']);
			for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
			{
				echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$customFieldNames[$field].":<br>\n";
				echo "\t\t\t\t\t\t\t\t\t\t<input type=\"text\" name=\"customField".$field."\" size=\"67\" value=\"".$customFields[$field]."\" /><td>\n\t\t\t\t\t\t\t\t\t</tr>";
			}
		}
		echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$highliteMessageOpen.$languageStrings['YourMessage'].$highliteMessageClose.":<br />\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<textarea rows=\"5\" cols=\"50\" id=\"messagebox\" name=\"Message\">".$messageDisplay."</textarea>\n\t\t\t\t\t\t\t\t\t\t\t<br />\n";
		// disables BBcodebuttons if so desired
		if ($configFromINI['BBcode']['displayButtons'] == "1")	{
			if ($configFromINI['BBcode']['displayWebButtons'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"h\" value=\"".$languageStrings['ButtonWWW']."\" onClick=\"addHyperlink('".$languageStrings['jsWWWurl']."', '".$languageStrings['jsWWWname']."')\" onMouseOver=\"helpHyperlink('".$languageStrings['jsHelpWWW']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"e\" value=\"".$languageStrings['ButtonEmail']."\" onClick=\"addEmail('".$languageStrings['jsEmailAddress']."', '".$languageStrings['jsEmailName']."')\" onMouseOver=\"helpEmail('".$languageStrings['jsHelpEmail']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayFormatButtons'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"b\" value=\"".$languageStrings['ButtonBold']."\" style=\"font-weight: bold;\" onClick=\"addBold('".$languageStrings['jsBold']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpBold('".$languageStrings['jsHelpBold']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"i\" value=\"".$languageStrings['ButtonItalic']."\" style=\"font-style: italic;\" onClick=\"addItalics('".$languageStrings['jsItalic']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpItalics('".$languageStrings['jsHelpItalic']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"u\" value=\"".$languageStrings['ButtonUnderline']."\" style=\"text-decoration: underline;\" onClick=\"addUnderline('".$languageStrings['jsUnderline']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpUnderline('".$languageStrings['jsHelpUnderline']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayColorButton'] == "1")	{			
				echo "\t\t\t\t\t\t\t\t\t\t\t<select name=\"colorselect\" size=\"1\" onChange=\"addColor('".$languageStrings['jsColor']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpColor('".$languageStrings['jsHelpColor']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option selected=\"selected\">".$languageStrings['ButtonColor']."</option><option value=\"#ff0000\" style=\"color: #ff0000;\">".$languageStrings['red']."</option><option value=\"#ff8800\" style=\"color: #ff8800;\">".$languageStrings['orange']."</option><option value=\"#ffff00\" style=\"color: #ffff00;\">".$languageStrings['yellow']."</option>\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"#884400\" style=\"color: #884400;\">".$languageStrings['brown']."</option><option value=\"#008800\" style=\"color: #008800;\">".$languageStrings['green']."</option><option value=\"#00ffff\" style=\"color: #00ffff;\">".$languageStrings['turquoise']."</option><option value=\"#0000ff\" style=\"color: #0000ff;\">".$languageStrings['blue']."</option>\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"#8800ff\" style=\"color: #8800ff;\">".$languageStrings['violet']."</option><option value=\"#ff00ff\" style=\"color: #ff00ff;\">".$languageStrings['pink']."</option><option value=\"#ffffff\" style=\"color: #ffffff;\">".$languageStrings['white']."</option>\n\t\t\t\t\t\t\t\t\t\t\t</select>\n";
			}
			if ($configFromINI['BBcode']['displaySizeButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<select name=\"sizeselect\" size=\"1\" onChange=\"addSize('".$languageStrings['jsSize']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpSize('".$languageStrings['jsHelpSize']."')\" onMouseOut=\"clearHelp()\">";
				echo "\n\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"size\" selected=\"selected\">".$languageStrings['ButtonSize']."</option><option value=\"60\">".$languageStrings['tiny']."</option><option value=\"80\">".$languageStrings['small']."</option><option value=\"100\">".$languageStrings['normal']."</option><option value=\"120\">".$languageStrings['large']."</option><option value=\"140\">".$languageStrings['huge']."</option>";
				echo "\n\t\t\t\t\t\t\t\t\t\t\t</select>\n";
			}
			if ($configFromINI['BBcode']['displayImageButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" value=\"".$languageStrings['ButtonImage']."\" onClick=\"addImage('".$languageStrings['jsImage']."')\" onMouseOver=\"helpImage('".$languageStrings['jsHelpImage']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayCodeButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" value=\"".$languageStrings['ButtonCode']."\" style=\"font-family: monospaced;\" onClick=\"addCode('".$languageStrings['jsCode']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpCode('".$languageStrings['jsHelpCode']."')\" onMouseOut=\"clearHelp()\">\n";
			}
		}
		echo "\t\t\t\t\t\t\t\t\t\t\t<div id=\"jsHelpLine\" class=\"jsHelpLine\">&nbsp;<br /></div>\n";
		echo "\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">\n\t\t\t\t\t\t\t\t\t\t\t<div align=\"left\">\n\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"submit\" value=\"".$languageStrings['SubmitPost']."\" />&nbsp;\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"preview\" value=\"".$languageStrings['PreviewPost']."\" />&nbsp;\n";
		if (isset($_POST['preview']) || isset($_POST['submit']))	{
			echo "\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"cancel\" value=\"".$languageStrings['Cancel']."\">\n";
		}
		echo "\t\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</form>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>";
	}


	// displays the input fields for a new post: name, email, you name it
	function displayEditForm($Nickname, $Emailaddress, $Homepage, $Message, $whichpost, $posttime, $customFields)
	{
		global $configFromINI, $languageStrings;
		
		// replaceing the stored HTML new line tag <br /> with a line feed for displaying it in a readable form
		$Message = rtrim(str_replace("&nbsp;<br />", "\015\012", $Message));
		
		// splitting the message into the real user-submitted message and a possible admin comment already made before this date
		$originalMessage = preg_replace("/(\[\[comment\]\])(.+?)(\[\[\/comment\]\])/is", "", $Message);
		preg_match("/(\[\[comment\]\])(.+?)(\[\[\/comment\]\])/is", $Message, $Comment); // FIXME
		$Comment = preg_replace("/(\[\[comment\]\])(.+?)(\[\[\/comment\]\])/is", "\\2", $Comment[0]);
		
		echo "\n\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<form name=\"inputform\" method=\"post\" action=\"".$_SERVER['PHP_SELF']."\">\n";
		echo "\t\t\t\t\t\t\t\t<table border=\"0\">\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourName'].":<br />";
		echo "<input type=\"text\" name=\"NickName\" size=\"26\" value=\"".$Nickname."\" /></td>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourEmail'].":<br />";
		echo "<input type=\"text\" name=\"EmailAddress\" size=\"36\" value=\"".$Emailaddress."\" /></td>";
		echo "\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$languageStrings['YourHomepage'].":<br />";
		echo "<input type=\"text\" name=\"Homepage\" size=\"67\" value=\"".$Homepage."\" /><br />";
		if ($configFromINI['Behaviour']['customFields'] != "0")
		{
			$customFieldNames = split(",", $configFromINI['Behaviour']['customFieldNames']);
			for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
			{
				echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$customFieldNames[$field].":<br>\n";
				echo "\t\t\t\t\t\t\t\t\t\t<input type=\"text\" name=\"customField".$field."\" size=\"67\" value=\"".$customFields[$field]."\" /><td>\n\t\t\t\t\t\t\t\t\t</tr>";
			}
		}
		echo "\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$languageStrings['YourMessage'].":<br />\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<textarea rows=\"5\" cols=\"50\" id=\"messagebox\" name=\"Message\">".$originalMessage."</textarea>\n\t\t\t\t\t\t\t\t\t\t\t<br />\n";
		// disables BBcodebuttons if so desired
		if ($configFromINI['BBcode']['displayButtons'] == "1")	{
			if ($configFromINI['BBcode']['displayWebButtons'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"h\" value=\"".$languageStrings['ButtonWWW']."\" onClick=\"addHyperlink('".$languageStrings['jsWWWurl']."', '".$languageStrings['jsWWWname']."')\" onMouseOver=\"helpHyperlink('".$languageStrings['jsHelpWWW']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"e\" value=\"".$languageStrings['ButtonEmail']."\" onClick=\"addEmail('".$languageStrings['jsEmailAddress']."', '".$languageStrings['jsEmailName']."')\" onMouseOver=\"helpEmail('".$languageStrings['jsHelpEmail']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayFormatButtons'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"b\" value=\"".$languageStrings['ButtonBold']."\" style=\"font-weight: bold;\" onClick=\"addBold('".$languageStrings['jsBold']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpBold('".$languageStrings['jsHelpBold']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"i\" value=\"".$languageStrings['ButtonItalic']."\" style=\"font-style: italic;\" onClick=\"addItalics('".$languageStrings['jsItalic']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpItalics('".$languageStrings['jsHelpItalic']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" accesskey=\"u\" value=\"".$languageStrings['ButtonUnderline']."\" style=\"text-decoration: underline;\" onClick=\"addUnderline('".$languageStrings['jsUnderline']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpUnderline('".$languageStrings['jsHelpUnderline']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayColorButton'] == "1")	{			
				echo "\t\t\t\t\t\t\t\t\t\t\t<select name=\"colorselect\" size=\"1\" onChange=\"addColor('".$languageStrings['jsColor']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpColor('".$languageStrings['jsHelpColor']."')\" onMouseOut=\"clearHelp()\">\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option selected=\"selected\">".$languageStrings['ButtonColor']."</option><option value=\"#ff0000\" style=\"color: #ff0000;\">".$languageStrings['red']."</option><option value=\"#ff8800\" style=\"color: #ff8800;\">".$languageStrings['orange']."</option><option value=\"#ffff00\" style=\"color: #ffff00;\">".$languageStrings['yellow']."</option>\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"#884400\" style=\"color: #884400;\">".$languageStrings['brown']."</option><option value=\"#008800\" style=\"color: #008800;\">".$languageStrings['green']."</option><option value=\"#00ffff\" style=\"color: #00ffff;\">".$languageStrings['turquoise']."</option><option value=\"#0000ff\" style=\"color: #0000ff;\">".$languageStrings['blue']."</option>\n";
				echo "\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"#8800ff\" style=\"color: #8800ff;\">".$languageStrings['violet']."</option><option value=\"#ff00ff\" style=\"color: #ff00ff;\">".$languageStrings['pink']."</option><option value=\"#ffffff\" style=\"color: #ffffff;\">".$languageStrings['white']."</option>\n\t\t\t\t\t\t\t\t\t\t\t</select>\n";
			}
			if ($configFromINI['BBcode']['displaySizeButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<select name=\"sizeselect\" size=\"1\" onChange=\"addSize('".$languageStrings['jsSize']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpSize('".$languageStrings['jsHelpSize']."')\" onMouseOut=\"clearHelp()\">";
				echo "\n\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"size\" selected=\"selected\">".$languageStrings['ButtonSize']."</option><option value=\"60\">".$languageStrings['tiny']."</option><option value=\"80\">".$languageStrings['small']."</option><option value=\"100\">".$languageStrings['normal']."</option><option value=\"120\">".$languageStrings['large']."</option><option value=\"140\">".$languageStrings['huge']."</option>";
				echo "\n\t\t\t\t\t\t\t\t\t\t\t</select>\n";
			}
			if ($configFromINI['BBcode']['displayImageButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" value=\"".$languageStrings['ButtonImage']."\" onClick=\"addImage('".$languageStrings['jsImage']."')\" onMouseOver=\"helpImage('".$languageStrings['jsHelpImage']."')\" onMouseOut=\"clearHelp()\">\n";
			}
			if ($configFromINI['BBcode']['displayCodeButton'] == "1")	{
				echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"button\" value=\"".$languageStrings['ButtonCode']."\" style=\"font-family: monospaced;\" onClick=\"addCode('".$languageStrings['jsCode']."', '".$languageStrings['jsYourTextGoesHere']."')\" onMouseOver=\"helpCode('".$languageStrings['jsHelpCode']."')\" onMouseOut=\"clearHelp()\">\n";
			}
		}
		echo "\t\t\t\t\t\t\t\t\t\t\t<div id=\"jsHelpLine\" class=\"jsHelpLine\">&nbsp;<br /></div>\n";
		
		echo "\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">".$languageStrings['AdminComment'].":<br />\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<textarea rows=\"2\" cols=\"50\" id=\"commentbox\" name=\"Comment\">".$Comment."</textarea>\n\t\t\t\t\t\t\t\t\t\t\t<br />\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"whichpost\" value=\"".$whichpost."\">\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<input type=\"hidden\" name=\"posttime\" value=\"".$posttime."\">";
		echo "\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<td colspan=\"2\">\n\t\t\t\t\t\t\t\t\t\t\t<div align=\"left\">\n\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"edited\" value=\"".$languageStrings['SaveChanges']."\" />&nbsp;\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t\t<input type=\"submit\" name=\"cancel\" value=\"".$languageStrings['Cancel']."\">\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t</form>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>";
	}


	// called when displaying posts on more than one page
	// adds the page navigation that looks like "< [1] 2 3 >"
	function displayPostNavigation($numberofposts, $offset)	{
		global $configFromINI;
		if (($numberofposts > 0) && ($numberofposts > $configFromINI['Behaviour']['entriesPerPage']))	{
			$numberofpages = ceil($numberofposts / $configFromINI['Behaviour']['entriesPerPage']); // one post more than entries per page -> new page
			echo "\n\t\t<!-- navigation between the pages -->";
			echo "\n\t\t<div class=\"pageNavigation\">\n\t\t\t<p>";
			echo "\n\t\t\t\t<a href=\"" . $_SERVER['PHP_SELF'] . "?offset=" . max(($offset - $configFromINI['Behaviour']['entriesPerPage']), 0) . "\">&laquo;</a>";
			for ($thispage = 1; $thispage <= $numberofpages; $thispage++)  {
				if (($offset >= ($configFromINI['Behaviour']['entriesPerPage'] * ($thispage - 1))) && ($offset < ($configFromINI['Behaviour']['entriesPerPage'] * $thispage))) {
					echo "&nbsp;[" . $thispage . "]";
				}
				else {
					echo "&nbsp;<a href=\"" . $_SERVER['PHP_SELF'] . "?offset=" . ($configFromINI['Behaviour']['entriesPerPage'] * ($thispage - 1)) . "\">" . $thispage . "</a>";
				}
			}
			echo "&nbsp;<a href=\"" . $_SERVER['PHP_SELF'] . "?offset=" . min(($offset + $configFromINI['Behaviour']['entriesPerPage']), $numberofposts - 1) . "\">&raquo;</a>\n";
			echo "\t\t\t</p>\n\t\t</div>\n\n";
		}
	}
	

	// displays the recurring html header that is the same on every page (page title, style sheet, JavaScript, meta tags...)
	function displayHTMLHeader()	{
		global  $configFromINI;
		echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n\n";
		echo "<html>\n\t<head>\n\t\n\t\t<title>" . $configFromINI['General']['gbName'] . "</title>\n\t\t<meta name=\"Author\" content=\"Thomas Hettenhausen\">\n";
		echo "\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$configFromINI['General']['CharSet']."\">\n";
		if ($configFromINI['General']['disableMSSmartTags'] == "1")	{
			echo "\t\t<meta name=\"MSSmartTagsPreventParsing\" content=\"TRUE\">\n";
		}
		echo "\t\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" . $configFromINI['Files']['stylesheetFile'] . "\">\n";
		echo "\t\t<script language=\"JavaScript\" type=\"text/javascript\" src=\"" . $configFromINI['Files']['javascriptFile'] . "\"></script>\n\t</head>\n\t<body>\n";
		if (is_file($configFromINI['Files']['customHeader']))
		{
			include_once($configFromINI['Files']['customHeader']);
		}
	}
	

	// displays the html footer (the link to my homepage, and the required closing tags that are the same on all pages
	function displayHTMLFooter()	{
		global  $configFromINI;
		echo "\t\t<div class=\"htmlFooter\">\n\t\t\t<a href=\"http://flatphpbook.sourceforge.net/\">flatPHPbook by Thomas Hettenhausen</a>\n\t\t</div>";
		if (is_File($configFromINI['Files']['customFooter']))
		{
			include_once($configFromINI['Files']['customFooter']);
		}
		echo "\n\t</body>\n</html>";
	}
	

	// displays the appropriate link to either login to or logout from admin mode
	function displayAdminLinks()	{
		global $adminmode, $languageStrings;
		if ($adminmode == 1)	{
			echo "\t\t<div class=\"adminlink\"><a href=\"" . $_SERVER['PHP_SELF'] . "?logout=1\">".$languageStrings['AdminLogout']."</a></div>\n";
		}
		else {
			echo "\t\t<div class=\"adminlink\"><a href=\"" . $_SERVER['PHP_SELF'] . "?adminlogin=1\">".$languageStrings['AdminLogin']."</a></div>\n";
		}
	}


	// displays the current guestbook entries
	function displayGuestbook()	{
		global $configFromINI, $languageStrings, $adminmode;
		
		// open external links in another window?
		if ($configFromINI['Behaviour']['externalLinksTarget'] != "")
		{
			$externalLinksTargetCode = " target=\"".$configFromINI['Behaviour']['externalLinksTarget']."\"";
		}
		else
		{
			$externalLinksTargetCode = "";
		}

		// checking if we are displaying posts starting with the first one or if we start somewhere else when using multiple pages
		if (isset($_GET["offset"]))	{
			$offset = $_GET["offset"];
		}
		else	{
			$offset = 0;
		}

		// determining the format used to display date and time
		if ($configFromINI['Behaviour']['timeNotation'] == "american")	{
			$timeFormat = "m-d-Y, g:i:s a";
		}
		elseif ($configFromINI['Behaviour']['timeNotation'] == "german")	{
			$timeFormat = "H:i:s, d.m.Y";
		}
		else	{
			// falling back to ISO norm
			$timeFormat = "H:i:s, Y-m-d";
		}
		
		// reading the content of the guestbook file ($guestbookFile) and creating an array ($content) out of it
		//
		// if the file does not exist, create it for further use
		if (!file_exists($configFromINI['Files']['guestbookFile']))	{
			touch($configFromINI['Files']['guestbookFile']);
		}
		$content = file($configFromINI['Files']['guestbookFile']);
		$numberofposts = count($content);

		// displaying the total number of posts in the guestbook if wanted
		if ($configFromINI['Behaviour']['showTotalNumber'] == 1)	{
			echo "\n\t\t<!-- displaying the total number of posts in the guestbook -->\n";
			echo "\t\t<div id=\"totalnumber\">\n\t\t\t<p>\n\t\t\t\t".$languageStrings['TotalNumberOfPosts'].$numberofposts . "\n\t\t\t</p>\n\t\t</div>\n";
		}


		// if splitting the posts onto several pages, display navigation links
		if ($configFromINI['Behaviour']['entriesPerPage'] > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}


		// creating array out of guestbook entry
		//
		// prepare the check whether whole guestbook or current entry is empty (either if it is the last or if there accidentally got an empty line into the database file)
		$gbIsEmpty = "1";

		// order of display is checked: usually you want newest first
		if ($configFromINI['Behaviour']['displayNewestFirst'] == "1")	{
			$content = array_reverse($content);
		}

		echo "\n\t\t<!-- beginning of the display of the guestbook entries -->\n";
		echo "\n\t\t<table class=\"gbdisplay\" cellpadding=\"0\" cellspacing=\"0\">\n";


		// looping over the posts and displaying the table rows for each one
		for ($postnumber = 0; $postnumber < $numberofposts; $postnumber++)	{
			$gbentryline = $content[$postnumber];

			// the current post might be empty, and then ...
			if (($gbentryline == "") && ($gbIsEmpty == "1"))	{
				// Obviously, the guestbook is currently empty -> display a message.
				echo $languageStrings['GuestbookIsEmpty'];
			}
			else	{
				if (($configFromINI['Behaviour']['entriesPerPage'] == 0) || (($configFromINI['Behaviour']['entriesPerPage'] != 0) && ($postnumber >= $offset) && ($postnumber < ($offset + $configFromINI['Behaviour']['entriesPerPage']))))	{
					// if we are here, we can display the current post
					// creating an array of each line in the guestbook file
					$gbentry = split($configFromINI['General']['delimiter'], $gbentryline);
					if ($gbentry[2] != "")	{
						$currentHomepage = $gbentry[2];
						if (!(preg_match("/^http:\/\//", $currentHomepage)))
							{	$currentHomepage = "http://" . $currentHomepage;	}
					}

					echo "\n\t\t\t<!-- post number " . ($numberofposts - $postnumber) . " -->\n";
					if ($configFromINI['Behaviour']['tableLayout'] == "classic")
					{
						// first line of post: dark background;left cell: "nickname", right cell: "date, time"
						echo "\t\t\t<tr class=\"layouttr\">\n\t\t\t\t<td class=\"posttopleft\" valign=\"top\">";
						echo "\n\t\t\t\t\t<span class=\"nickname\">" . ($numberofposts - $postnumber) . ". " . $gbentry[0] . "</span>\n\t\t\t\t</td>\n";
						echo "\t\t\t\t<td class=\"posttopright\"  valign=\"top\">\n\t\t\t\t\t<span class=\"dateandtime\">".date($timeFormat, $gbentry[3]);
						// custom fields get displayed here
						if ($configFromINI['Behaviour']['customFields'] != "0")
						{
							$customFieldNames = split(",", $configFromINI['Behaviour']['customFieldNames']);
							for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
							{
								if ($gbentry[6 + $field])
								{
									echo ",&nbsp;".$customFieldNames[$field].":&nbsp;".$gbentry[6 + $field];
								}
							}
						}
						echo "</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n";

						// second line of post: light background; left cell: "homepage, email", right cell: "message"
						echo "\t\t\t<tr>\n\t\t\t\t<td class=\"postbottomleft\" valign=\"top\">";
						if ($gbentry[1] != "")	{
							echo "\n\t\t\t\t\t<a href=\"mailto:".$gbentry[1]."\"><img src=\"".$configFromINI['Files']['emailIcon']."\" alt=\"email\"></a>&nbsp;";
							if ($gbentry[2] == "")	{
								echo "\n\t\t\t\t";
							}
						}

						if ($gbentry[2] != "")	{
							echo "\n\t\t\t\t\t<a href=\"".$currentHomepage."\"".$externalLinksTargetCode."><img src=\"" . $configFromINI['Files']['homepageIcon'] . "\" alt=\"homepage\"></a>";
						}
						
						// displaying button to delete the entry if logged in as admin
						if ($adminmode == 1)	{
							echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"".$gbentry[3]."\"><input type=\"submit\" value=\"".$languageStrings['AdminDelete']."\" name=\"delete\" class=\"deleteButton\"></form>";
							echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"".$gbentry[3]."\"><input type=\"submit\" value=\"".$languageStrings['AdminEdit']."\" name=\"edit\" class=\"deleteButton\"></form>";
						}
						echo "\n\t\t\t\t</td>\n\t\t\t\t<td class=\"postbottomright\" valign=\"top\">";
						echo "\n\t\t\t\t\t".recreateUserInput($gbentry[5], $externalLinksTargetCode)."\t\t\t\t</td>\n\t\t\t</tr>\n";
						$gbIsEmpty = "0";
					}
					elseif ($configFromINI['Behaviour']['tableLayout'] == "simple")
					{
						// first line of post: dark background, "nickname, "homepage, "email", "date, time"
						echo "\t\t\t<tr class=\"layouttr\">\n\t\t\t\t<td class=\"posttop\" valign=\"top\">";
						echo "\n\t\t\t\t\t<span class=\"nickname\">" . ($numberofposts - $postnumber) . ". " . $gbentry[0] . "</span>";
						if ($gbentry[1] != "")	{
							echo "&nbsp;&nbsp;<a href=\"mailto:".$gbentry[1]."\"><img src=\"" . $configFromINI['Files']['emailIcon'] . "\" alt=\"email\"></a>";
							if ($gbentry[2] == "")	{
								echo "&nbsp;";
							}
						}
						if ($gbentry[2] != "")	{
							if ($gbentry[1] == "")	{
								echo "&nbsp;&nbsp;";
							}
							echo "&nbsp;<a href=\"" . $currentHomepage . "\"><img src=\"" . $configFromINI['Files']['homepageIcon'] . "\" alt=\"homepage\"></a>&nbsp;";
						}
						echo "<br />\n\t\t\t\t\t<span class=\"simpleDateandtime\">".date($timeFormat, $gbentry[3]);
						// custom fields get displayed here
						if ($configFromINI['Behaviour']['customFields'] != "0")
						{
							$customFieldNames = split(",", $configFromINI['Behaviour']['customFieldNames']);
							for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
							{
								if ($gbentry[6 + $field])
								{
									echo ",&nbsp;".$customFieldNames[$field].":&nbsp;".$gbentry[6 + $field];
								}
							}
						}
						echo "</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n";
						// second line of post: light background: "message"
						echo "\t\t\t<tr>\n\t\t\t\t<td class=\"postbottom\" valign=\"top\">";
						echo "\n\t\t\t\t\t".recreateUserInput($gbentry[5], $externalLinksTargetCode);
						// displaying button to delete the entry if logged in as admin
						if ($adminmode == 1)	{
							echo "\t\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"".$gbentry[3]."\"><input type=\"submit\" value=\"".$languageStrings['AdminDelete']."\" name=\"delete\" class=\"deleteButton\"></form>";
							echo "\n\t\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\"><input type=\"hidden\" name=\"whichpost\" value=\"".$postnumber."\"><input type=\"hidden\" name=\"posttime\" value=\"".$gbentry[3]."\"><input type=\"submit\" value=\"".$languageStrings['AdminEdit']."\" name=\"edit\" class=\"deleteButton\"></form>";
						}
						echo "\n\t\t\t\t</td>\n\t\t\t</tr>\n";
					}
				}
			}
		}
		echo "\t\t</table>\n";

	
		// if splitting the posts onto several pages, display navigation links
		if ($configFromINI['Behaviour']['entriesPerPage'] > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}
	}




	///////////////////////////////////////////////////////////////////////
	//                         MAIN BODY OF THE SCRIPT                                 //
	///////////////////////////////////////////////////////////////////////


	// FIRST: Are we admin? This is needed for e.g. deleting and configuring. *****************************************************************************************************

	// checking if LOGGING INTO admin mode, setting the appropriate PHP session variables
	if (isset($_POST["Login"]) && ($_POST["adminuser"] == $adminusername) && ($_POST["adminpass"] == $adminpassword))	{
		$adminmode = 1;
		if ($configFromINI['General']['useCookies'] == "1")	{
			setcookie('adminmode', $adminmode);
		}
		else	{
			// using PHP sessions if useCookies = 0
			session_register('adminmode');
			$_SESSION['adminmode'] = $adminmode;
		}
	}

	// CHECK IF ALREADY in admin mode via cookies or PHP session
	if ($configFromINI['General']['useCookies'] == "1")	{
		if ((isset($_COOKIE['adminmode'])) && ($_COOKIE['adminmode'] == "1"))	{
			$adminmode = 1;
		}
	}

	elseif ($configFromINI['General']['useCookies'] == "0")	{
		if ((isset($_SESSION['adminmode'])) && ($_SESSION['adminmode'] == "1"))	{
			$adminmode = 1;
		}
	}



	// LOGGING OUT of admin mode and destroying the associated cookie or PHP session
	if (isset($_GET['logout']))	{
		$adminmode = 0;
		if ($configFromINI['General']['useCookies'] == "1")	{
			setcookie('adminmode');
		}
		elseif ($configFromINI['General']['useCookies'] == "0")	{
			session_unset();
			session_destroy();
		}
	}


	// SECOND all the special cases: previewing, submitting, logging in as admin **************************************************************************************************


	// previewing and submitting a post, checking if all fields required were filled in
	if ((isset($_POST['preview'])) || isset($_POST['submit']))	{
		// set the strings
		$Nickname = safeHTML($_POST["NickName"]);
		$Emailaddress = safeHTML($_POST["EmailAddress"]);
		$messageString = safeHTML($_POST["Message"]);
		if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
			$Homepage = "";
		}
		else	{
			$Homepage = safeHTML($_POST["Homepage"]);
		}
		if ($configFromINI['Behaviour']['customFields'] != 0)
		{
			for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
			{
				$customFields[$field] = safeHTML($_POST['customField'.$field]);
			}
		}
		
		// determining the format used to display date and time
		if ($configFromINI['Behaviour']['timeNotation'] == "american")	{
			$timeFormat = "m-d-Y, g:i:s a";
		}
		elseif ($configFromINI['Behaviour']['timeNotation'] == "german")	{
			$timeFormat = "H:i:s, d.m.Y";
		}
		else	{
			// falling back to ISO norm
			$timeFormat = "H:i:s, Y-m-d";
		}
		
		// omitted both required fields
		if (($Nickname == "") && ($messageString == ""))	{
			$forgotten = "both";
		}

		// omitted one of the 2 required fields
		elseif (($Nickname == "") || ($messageString == ""))	{
			if ($Nickname == "")	{
				$forgotten =  "nickname";
			}
			elseif ($messageString == "")	{
				$forgotten =   "message";
			}
		}
		elseif (($Nickname != "") && ($messageString != ""))	{
			$forgotten =  "";
		}


		if ((isset($_POST["submit"]) && ($forgotten != "")) || (isset($_POST["preview"])))	{
			// displaying the single entry with the new data
			displayHTMLHeader();
			if ($forgotten != "")	{
				echo "\t\t<h1>".$configFromINI['General']['gbName']." - ".$languageStrings['IncompletePost']."</h1>";
			}

			if ($forgotten == "")	{
				echo "\t\t<h1>".$configFromINI['General']['gbName']." - ". $languageStrings['PreviewPost']."</h1>";
				echo "\t\t<table class=\"gbdisplay\" cellpadding=\"0\" cellspacing=\"0\">\n";
				if ($configFromINI['Behaviour']['tableLayout'] == "classic")
				{
					echo "\t\t\t<tr class=\"layouttr\">\n\t\t\t\t<td class=\"posttopleft\" valign=\"top\">";
					echo "\n\t\t\t\t\t<span class=\"nickname\">0.&nbsp;".$Nickname."</span>\n\t\t\t\t</td>\n";
					echo "\t\t\t\t<td class=\"posttopright\"  valign=\"top\">\n\t\t\t\t\t<span class=\"dateandtime\">".date($timeFormat);
					if ($configFromINI['Behaviour']['customFields'] != "0")
					{
						$customFieldNames = split(",", $configFromINI['Behaviour']['customFieldNames']);
						for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
						{
							if ($customFields[$field])
							{
								echo ",&nbsp;".$customFieldNames[$field].":&nbsp;".$customFields[$field];
							}
						}
					}
					echo "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";
					echo "\t\t\t<tr>\n\t\t\t\t<td class=\"postbottomleft\" valign=\"top\">";
					if ($Emailaddress != "")	{
						echo "\n\t\t\t\t\t<a href=\"mailto:".$Emailaddress."\"><img src=\"".$configFromINI['Files']['emailIcon']."\" alt=\"email\"></a>&nbsp;";
						if ($Homepage == "")	{
							echo "\n\t\t\t\t<br />";
						}
					}
					if ($Homepage != "")	{
						if (!(preg_match("/^http:\/\//", $Homepage)))
							{$currentHomepage = "http://" . $Homepage;}
							echo "\n\t\t\t\t\t<a href=\"".$currentHomepage."\"><img src=\"".$configFromINI['Files']['homepageIcon']."\" alt=\"homepage\"></a><br />";
					}
					echo "</td>\n\t\t\t\t<td class=\"postbottomright\" valign=\"top\">";
					echo "\n\t\t\t\t\t".recreateUserInput($messageString, $externalLinksTargetCode)."\t\t\t\t</td>\n\t\t\t</tr>\n";
				}
				elseif ($configFromINI['Behaviour']['tableLayout'] == "simple")
				{
					echo "\t\t\t<tr class=\"layouttr\">\n\t\t\t\t<td class=\"posttop\" valign=\"top\">";
					echo "\n\t\t\t\t\t<span class=\"nickname\">0.&nbsp;".$Nickname."</span>";
					
					
					
					
					if ($Emailaddress != "")	{
						echo "&nbsp;&nbsp;<a href=\"mailto:".$Emailaddress."\"><img src=\"".$configFromINI['Files']['emailIcon']."\" alt=\"email\"></a>";
						if ($Homepage == "")	{
							echo "&nbsp;";
						}
					}
					if ($Homepage != "")	{
						if ($Emailaddress == "")	{
							echo "&nbsp;&nbsp;";
						}
						echo "&nbsp;<a href=\"".$currentHomepage."\"><img src=\"".$configFromINI['Files']['homepageIcon']."\" alt=\"homepage\"></a>&nbsp;";
					}
					echo "<br />\n\t\t\t\t\t<span class=\"simpleDateandtime\">".date($timeFormat);
					// custom fields get displayed here
					if ($configFromINI['Behaviour']['customFields'] != "0")
					{
						$customFieldNames = split(",", $configFromINI['Behaviour']['customFieldNames']);
						for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
						{
							if ($customFields[$field])
							{
								echo ",&nbsp;".$customFieldNames[$field].":&nbsp;".$customFields[$field];
							}
						}
					}
					echo "</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n";
					// second line of post: light background: "message"
					echo "\t\t\t<tr>\n\t\t\t\t<td class=\"postbottom\" valign=\"top\">";
					echo "\n\t\t\t\t\t".recreateUserInput($messageString, $externalLinksTargetCode);
					echo "\n\t\t\t\t</td>\n\t\t\t</tr>\n";
				}
				echo "\t\t</table>\n\t\t<p>&nbsp;</p>\n";
			}

			// displaying the form fields with the data inserted, too
			echo "\t\t<div class=\"gbinputarea\">\n\t\t\t<div class=\"gbinput\">";
			displayInputForm($Nickname, $Emailaddress, $Homepage, $forgotten, $customFields);
			echo "</div>\n\t\t</div>";
		}

		// new post is being submitted and nothing was omitted
		elseif (isset($_POST["submit"]) && ($forgotten == ""))	{
			// IP address: real unless trackUserIP is set to 0, then "0.0.0.0"
			if ($configFromINI['Behaviour']['trackUserIP'] == "1")	{
				$userIP = $_SERVER['REMOTE_ADDR'];
			}
			else	{
				$userIP = "0.0.0.0";
			}

			$newguestbookline = $Nickname.$configFromINI['General']['delimiter'].$Emailaddress.$configFromINI['General']['delimiter'].$Homepage.$configFromINI['General']['delimiter'].time().$configFromINI['General']['delimiter'].$userIP.$configFromINI['General']['delimiter'].$messageString;
			if ($configFromINI['Behaviour']['customFields'] != 0)
			{
				for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
				{
					$newguestbookline .= $configFromINI['General']['delimiter'].$customFields[$field];
				}
			}
			$newguestbookline .= "\n";

			// adding the stuff to the guestbook file (simply adding a new line at the end due to design of the data structure)
			$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "a");
			fwrite($bookInputStream, $newguestbookline);
			fclose($bookInputStream);

			// email notification
			// if run on a Windows server or else desired, override SMTP setting from php.ini
			if ($configFromINI['Email']['sendEmail'] == "1")	{
				if ((strpos(PHP_OS, "WIN") >= 0)	|| ($configFromINI['Email']['overrideLocalhost'] == "1"))	{
					ini_set("SMTP", $configFromINI['Email']['SMTP']);
					ini_set("sendmail_from", $configFromINI['Email']['fromAddress']);
				}
				mail($configFromINI['Email']['toAddress'], "flatPHPbook: ".$languageStrings['NewPost'], $Nickname.$languageStrings['EmailNewPost'], "From: ".$configFromINI['Email']['fromAddress']."\r\nX-Mailer: PHP/".phpversion());
			}
			
			header( 'refresh: ' . $configFromINI['Behaviour']['refreshWaitingTime'] . '; url= '. $_SERVER["PHP_SELF"] );
			displayHTMLHeader();

			echo "\t\t<h1>" . $configFromINI['General']['gbName'] . "</h1>\n";
			echo "\t\t<div class=\"gbinputarea\">\n";
			echo "\t\t\t<p>".$languageStrings['ThanksForPosting']."</p>\n";
			echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $configFromINI['Behaviour']['refreshWaitingTime'] . $languageStrings['YouWillBeTaken2'] . "</p>\n";
			echo "\t\t\t<a href=\"".$_SERVER["PHP_SELF"]."\">".$languageStrings['ClickInsteadOfWaiting']."</a>\n\t\t</div>";
		}
		displayHTMLFooter();
		die;
	}


	// DELETING an entry
	if (isset($_POST['delete']) && ($adminmode == 1))	{
		// obviously, a post is to be deleted

		// need to load the database file, build an array, remove the corresponding field, and write the array back to the database file
		$content = file($configFromINI['Files']['guestbookFile']);
		$posttobedeleted = count($content) - $_POST["whichpost"] - 1;
		// preparing the double-checking: need to read the posttime filed from the database later on
		$gbentry = split($configFromINI['General']['delimiter'], $content[$posttobedeleted]);

		
		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the Delete button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be deleted
		if ($_POST["posttime"] == $gbentry[3])	{
			// now, $content is our array, need to remove the appropriate one
			$index_nb_elements = count($content) - 1;
			switch($posttobedeleted)
			{
				case 0:
					$content = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$content = array_slice($content, 0, -1);
					break;
				default:
					$array_start = array_slice($content, 0, $posttobedeleted);
					$array_end = array_slice($content, $posttobedeleted + 1);
					$content = array_merge ($array_start, $array_end);
					break;
			}

			// writing the new array back
			$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "w");
			fseek($bookInputStream, 0);
			// $content = implode("\r\n", $content);
			foreach ($content as $gbline)	{
				fwrite($bookInputStream, trim($gbline) . "\n"); }
			fclose($bookInputStream);
		}
	}
	
	
	// if the Edit button is pressed, a new page is displayed that contains the input form fields again
	// filled with the appropriate entries from the post, plus a "comment" field.
	// The text in the comment field later gets appended to the message body, though formatted.
	if (isset($_POST['edit']) && ($adminmode == 1))	{
		// getting the values to fill into the fields, these are the old parts of the post
		$content = file($configFromINI['Files']['guestbookFile']);
		$postToBeEdited = count($content) - $_POST["whichpost"] - 1;
		$gbentry = split($configFromINI['General']['delimiter'], $content[$postToBeEdited]);
		
		if ($configFromINI['Behaviour']['customFields'] != 0)
		{
			for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
			{
				$customFields[$field] = $gbentry[6 + $field];
			}
		}
		else
		{
			$customFields;
		}
		
		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." - ". $languageStrings['EditPost']."</h1>";
		echo "\t\t<div class=\"gbinputarea\">\n";
		displayEditForm($gbentry[0], $gbentry[1], $gbentry[2], $gbentry[5], $_POST["whichpost"], $_POST["posttime"], $customFields);
		echo "\n\t\t\t</div>\n";
		displayHTMLFooter();
		die;
	}
	
	if (isset($_POST['edited']) && ($adminmode == 1))	{
		$content = file($configFromINI['Files']['guestbookFile']);
		$postToBeEdited = count($content) - $_POST["whichpost"] - 1;
		
		// preparing the double-checking: need to read the posttime filed from the database later on
		$gbentry = split($configFromINI['General']['delimiter'], $content[$postToBeEdited]);
		
		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the Edit button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be edited
		if ($_POST["posttime"] == $gbentry[3])	{
			// now, $content is our array, need to create new variables:
			// one holding all possible entries before the one being edited, one holding those after, and the post being edited itself
			$index_nb_elements = count($content) - 1;
			switch($postToBeEdited)
			{
				case 0:
					$array_start;
					$array_end = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$array_start = array_slice($content, 0, -1);
					$array_end;
					break;
				default:
					$array_start = array_slice($content, 0, $postToBeEdited);
					$array_end = array_slice($content, $postToBeEdited + 1);
					break;
			}
		}
		if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
			$Homepage = "";
		}
		else	{
			$Homepage = safeHTML($_POST["Homepage"]);
		}
		
		if ($_POST["Comment"] != "")
		{
			$Comment = "[[comment]]".safeHTML($_POST["Comment"])."[[/comment]]";
		}
		else
		{
			$Comment = "";
		}
		
		$editedPost = safeHTML($_POST["NickName"]).$configFromINI['General']['delimiter'].safeHTML($_POST["EmailAddress"]).$configFromINI['General']['delimiter'].$Homepage.$configFromINI['General']['delimiter'];
		$editedPost .= $gbentry[3].$configFromINI['General']['delimiter'].$gbentry[4].$configFromINI['General']['delimiter'].safeHTML($_POST["Message"]).$Comment;
		if ($configFromINI['Behaviour']['customFields'] != 0)
		{
			for ($field = 0; $field < $configFromINI['Behaviour']['customFields']; $field++)
			{
				$editedPost .= $configFromINI['General']['delimiter'].safeHTML($_POST['customField'.$field]);
			}
		}
		//echo $editedPost;
		$newGuestbook;
		if ($array_start != 0)
		{
			foreach ($array_start as $oldPost)
			{
				$newGuestbook .= $oldPost;
			}
		}
		$newGuestbook .= $editedPost."\n";
		if ($array_end != 0)
		{
			foreach ($array_end as $oldPost)
			{
				$newGuestbook .= $oldPost;
			}
		}
		
		// writing the new array back
		$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "w");
		fseek($bookInputStream, 0);
		// $content = implode("\r\n", $content);
		fwrite($bookInputStream, trim($newGuestbook));
		fclose($bookInputStream);
		
		header( 'refresh: ' . $configFromINI['Behaviour']['refreshWaitingTime'] . '; url= '. $_SERVER["PHP_SELF"] );
		displayHTMLHeader();
		echo "\t\t<h1>\n\t\t\t".$configFromINI['General']['gbName']."\n\t\t</h1>\n\t\t<div class=\"gbinputarea\">\n";
		echo "\t\t\t<p>".$languageStrings['SavedSuccessfully']."</p>\n";
		echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $configFromINI['Behaviour']['refreshWaitingTime'] . $languageStrings['YouWillBeTaken2'] . "</p>\n";
		echo "\t\t\t<a href=\"" . $_SERVER["PHP_SELF"] . "\">" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
		displayHTMLFooter();
		die;
	}
	

	// the admin mode login, displaying a form field for entering username and passwort,
	// then directing the user to the admin mode guestbook
	if (isset($_GET["adminlogin"]))
	{
		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." ".$languageStrings['AdminTitle']."</h1>\n";
		echo "\t\t<div class=\"gbinputarea\">\n";
		echo "\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\">\n";
		echo "\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminUserName'].":</td>\n\t\t\t\t\t\t<td><input type=\"text\" name=\"adminuser\"></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminPassword'].":</td>\n\t\t\t\t\t\t<td><input type=\"password\" name=\"adminpass\"></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\n\t\t\t\t\t\t\t<input type=\"submit\" name=\"Login\" value=\"".$languageStrings['AdminLogin']."\"/>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n";
		echo "\t\t\t</form>\n\t\t</div>\n";
		displayHTMLFooter();
		die();
	}

	// CONFIGURATION - displaying the page with the web interface for editing the INI values 
	if (isset($_GET['configure']) && ($adminmode == 1))	{
		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." - ".$languageStrings['ConfigurationPage']."</h1>\n\t\t\t<div class=\"gbinputarea\">\n"; 
		echo "\t\t\t\t<form method=\"POST\" action=\"".$_SERVER['PHP_SELF']."\">\n\t\t\t\t\t<table>";
		foreach ($configFromINI as $section => $sectionContents)	{
			echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td colspan=\"2\"><b>$section:</b></td>\n\t\t\t\t\t\t</tr>";
			foreach ($sectionContents as $key => $value)	{
				if (($key == "version") || ($key == "delimiter"))	{
					echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>".$key.":</td>";
					echo "\n\t\t\t\t\t\t\t<td><input style=\"background-color: #f0f0f0; color: #606060;\" type=\"text\" name=\"".$key."\" value=\"".$value."\" readonly=\"readonly\" /></td>";
				}
				else
				{
					echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>".$key.":</td>\n\t\t\t\t\t\t\t<td><input type=\"text\" name=\"".$key."\" value=\"".$value."\" /></td>";
				}
			}
		}
		echo "\n\t\t\t\t\t\t</tr>";
		echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td colspan=\"2\"><input type=\"submit\" name=\"saveChangesINI\" value=\"".$languageStrings['SaveChanges']."\" />&nbsp;";
		echo "<input type=\"submit\" name=\"cancel\" value=\"".$languageStrings['Cancel']."\" />\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</form>\n\t\t\t</div>\n";
		displayHTMLFooter();
		die;
	}
	

	// CONFIGURATION - saving the changes to the INI made via the web interface
	if ((isset($_POST['saveChangesINI'])) && ($_POST['saveChangesINI']) && ($adminmode == 1))	{
		//empty new string that will become the content of the new INI file
		$newINI = "";

		// loop over all lines in the INI file, requires double loop because it is a nested array
		foreach ($configFromINI as $section => $sectionContents)	{
			if ($newINI != "")	{
				$newINI .= "\n";
			}

			$newINI .= "[".$section."]\n";

			foreach ($sectionContents as $INIkey => $INIvalue)	{
				// loop over all submitted POST variables
				foreach ($_POST as $postKey => $postValue) {
					if (strstr($INIkey, $postKey))	{
						$newINI .= $INIkey." = ".$postValue."\n";
					}
				}
			}
		}

		$INIoutputStream = fopen($INIfileName, "w");
		fwrite($INIoutputStream, $newINI);
		fclose($INIoutputStream);

		// these next to have to be re-set since the INI was just saved with new values
		$configFromINI = parse_ini_file($INIfileName, true);
		$languageStrings = parse_ini_file($configFromINI['Files']['languageFile']);
		header( 'refresh: ' . $configFromINI['Behaviour']['refreshWaitingTime'] . '; url= '. $_SERVER["PHP_SELF"] );
		displayHTMLHeader();
		echo "\t\t<h1>\n\t\t\t".$configFromINI['General']['gbName']."\n\t\t</h1>\n\t\t<div class=\"gbinputarea\">\n";
		echo "\t\t\t<p>".$languageStrings['SavedSuccessfully']."</p>\n";
		echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $configFromINI['Behaviour']['refreshWaitingTime'] . $languageStrings['YouWillBeTaken2'] . "</p>\n";
		echo "\t\t\t<a href=\"" . $_SERVER["PHP_SELF"] . "\">" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
		displayHTMLFooter();
		die;
	}


	// now beginning the REGULAR GUESTBOK DISPLAY ************************************************************************************************************************
	displayHTMLHeader();
	echo "\t\t<h1>".$configFromINI['General']['gbName']." ".$languageStrings['MainPage']."</h1>\n\n";
	echo "\t\t<!-- html input form for guestbook -->\n\t\t<div class=\"gbinputarea\">\n\t\t\t";

	// this includes the content of welcomeMessage.html as if it was here in this file
	// this is useful for having your own welcome message
	if (is_file($configFromINI['Files']['welcomeMessage'])){
		include_once($configFromINI['Files']['welcomeMessage']);
	}

	// all the "if ((separateViewFromSign == 1) ... etc make sure the right parts are displayed according to the mode:
	// either everything on one page, but no links, or either the form fields or the old entries together with navigation links ("Click to view" or "Click to sign").
	if (($configFromINI['Behaviour']['separateViewFromSign'] == "1") && !isset($_GET['signgb']))	{
		echo "<p align=\"center\"><a href=\"".$_SERVER['PHP_SELF']."?signgb=1\">".$languageStrings['ClickHereToSign']."</a></p>";
	}

	// calling the function which displays the long form with the input text fields and buttons
	// parameters are empty here, they are used for the preview page so that the fields can be filled with already submitted values
	if ((($configFromINI['Behaviour']['separateViewFromSign'] == "1") && isset($_GET['signgb']) && ($_GET['signgb'] == 1)) || ($configFromINI['Behaviour']['separateViewFromSign'] == 0))
	{
		echo "\n\t\t\t<div class=\"gbinput\">";
		displayInputForm("", "", "", "", "");
		echo "\n\t\t\t</div>";
		if (!($configFromINI['Behaviour']['separateViewFromSign'] == "0"))	{
			echo "<p align=\"center\"><a href=\"" . $_SERVER['PHP_SELF'] . "\">".$languageStrings['ClickHereToView']."</a></p>";
		}
	}
	echo "\n\t\t</div>\n";

if ($adminmode == 1)	{
		echo "\n\t\t<!-- this is the link that opens the configuration page -->";
		echo "\n\t\t<div id=\"editConfigLink\">\n\t\t\t<p align=\"center\">\n\t\t\t\t<a class=\"adminmode\" href=\"".$_SERVER['PHP_SELF']."?configure=1\">".$languageStrings['ClickToEditConfig']."</a>\n\t\t\t</p>\n\t\t</div>";
	}
	

	if ((($configFromINI['Behaviour']['separateViewFromSign'] == 1) && !isset($_GET['signgb'])) || ($configFromINI['Behaviour']['separateViewFromSign'] == "0"))	{
		displayGuestbook();
	}

	displayAdminLinks();
	displayHTMLFooter();
?>