#ifndef MYSTGUTIL_H_
#define MYSTGUTIL_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/util/StgUtil.h"

#include "jp/ggaf/core/util/Status.h"

#ifdef UTIL
    #undef UTIL
#endif
#define UTIL VioletVreath::MyStgUtil

#define STATUS(X) (NEW GgafCore::Status(VioletVreath::MyStgUtil::reset##X##Status))
#define StatusReset(X) ((void*)(VioletVreath::MyStgUtil::reset##X##Status))

//Cxgp hashval l錾
DECLARE_HASHVAL(EVENT_GOD_WILL_DEMISE);
DECLARE_HASHVAL(EVENT_PREPARE_TRANSIT_STAGE);
DECLARE_HASHVAL(EVENT_PREPARE_NEXT_STAGE);
DECLARE_HASHVAL(EVENT_JUST_GAME_OVER);

DECLARE_HASHVAL(EVENT_MY_SHIP_WAS_DESTROYED_BEGIN);
DECLARE_HASHVAL(EVENT_MY_SHIP_WAS_DESTROYED_FINISH);
DECLARE_HASHVAL(EVENT_ALL_MY_SHIP_WAS_DESTROYED);

DECLARE_HASHVAL(EVENT_PREGAMETITLESCENE_FINISH);
DECLARE_HASHVAL(EVENT_GAMETITLESCENE_FINISH);
DECLARE_HASHVAL(EVENT_GAMEDEMOSCENE_FINISH);
DECLARE_HASHVAL(EVENT_GAMESTART);
DECLARE_HASHVAL(EVENT_GAMEMODE_DECIDE);
DECLARE_HASHVAL(EVENT_GAMEOVERSCENE_FINISH);
DECLARE_HASHVAL(EVENT_GO_TO_TITLE);
DECLARE_HASHVAL(EVENT_NAMEENTRYSCENE_FINISH);

namespace VioletVreath {


/**
 * {Aṽ[eBeB .
 * @version 1.00
 * @since 2010/01/06
 * @author Masatoshi Tsuge
 */
class MyStgUtil : public GgafLib::StgUtil {

private:
    /**
     * (G@)̗̑͌vZ .
     * ɁA̗͂0ɂȂꍇ́A肪@֘AȂ΁A
     * Q[XRAAQ[NA(G@)̏tH[[Vւ̔j󂳂܂ʒmA
     * ɍsĂ܂֗\bhɂȂI
     * @param prm_pMy  (G@)
     * @param prm_pOpp (G@ȊO)
     * @return (G@)̗̑
     */
    static int calcEnemyStamina(GgafCore::MainActor* const prm_pEnemy, const GgafCore::MainActor* prm_pOpp);

    /**
     * ΏۃAN^[ɕRێACeA擾łΗLɂAԂ .
     * Xe[^X(getStatus()) STAT_ItemKind ̒lɂăACeނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̕ێACeiς݁jB́A擾łȂꍇ nullptrB
     */
    static GgafDx::FigureActor* activateItemOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ΏۃAN^[ɕRŃGtFNgA擾łΗLɂAԂ .
     * ^C~OIɂ́AGtFNgƓł邱ƂB<BR>
     * j󎞂̕ϓXRA{[iX\Aʏ̔GtFNgȊO̓ȃGtFNgɎgpB<BR>
     * Xe[^X(getStatus()) STAT_DestroyedEffectKind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^
     * @return ΏۃAN^[̏ŃGtFNgiς݁jB́A擾łȂꍇ nullptrB
     */
    static GgafDx::FigureActor* activateDestroyedEffectOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * łԂe .
     * @param prm_pActor
     * @return
     */
    static GgafDx::FigureActor* activateRevengeShotOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ΏۃAN^[ɕR_[WGtFNgA擾łΔAԂ .
     * Xe[^X(getStatus()) STAT_DamagedEffectKind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̃_[WGtFNgiς݁jB́A擾łȂꍇ nullptrB
     * @return
     */
    static GgafDx::FigureActor* activateDamagedEffectOf(GgafDx::GeometricActor* prm_pActor);


    /**
     * ΏۃAN^[̕RAtH[[VSŃGtFNgƃXRAZ .
     * Xe[^X(getStatus()) STAT_FormationDestroyedEffectKind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̃tH[[VSŃGtFNgiς݁jB́A擾łȂꍇ nullptrB
     */
    static GgafDx::FigureActor* activateFormationDestroyedEffectOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ΏۃAN^[̂ɕRtH[[VSŃACeA擾łΗLɂAԂ .
     * Xe[^X(getStatus()) STAT_FormationDestroyedItemKind ̒lɂăACeނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̃tH[[VSŃACeiς݁jB́A擾łȂꍇ nullptrB
     */
    static GgafDx::FigureActor* activateFormationDestroyedItemOf(GgafDx::GeometricActor* prm_pActor);


public:
    enum EffectKind {
        EF_NOTHING,
        EF_ENTRY_SMALL001_F90,
        EF_ENTRY_SMALL001_F60,
        EF_ENTRY_SMALL001_F30,
        EF_ENTRY_SMALL001_STAY_F90,
        EF_ENTRY_SMALL001_STAY_F60,
        EF_ENTRY_SMALL001_STAY_F30,
        EF_ENTRY_SMALL001_LONG,
        EF_ENTRY_MIDDLE001,
        EF_ENTRY_LARGE001,
        EF_LEAVE_SMALL001_F60,
        EF_LEAVE_SMALL001_F30,
        EF_LEAVE_SMALL001_F90,
        EF_LEAVE_MIDDLE001,
        EF_LEAVE_LARGE001,
        EF_EXPLOSION001,
        EF_EXPLOSION001_STAY,
        EF_EXPLOSION002,
        EF_EXPLOSION003,
        EF_BONUS001,
        EF_EXPLO_AND_BONUS001,
        EF_TURBO,
        EF_DAMAGED001,
    };

    enum ItemKind {
        ITEM_NOTHING,
        ITEM_MP_SMALL,
        ITEM_MP_MIDDLE,
        ITEM_MP_LARGE,
    };

    enum ShotKind {
        SHOT_NOTHING,

        SHOT_SMALL001,
        SHOT_SMALL002,

        SHOT_RV_NOMAL001,
        SHOT_RV_NOMAL002,
        SHOT_RV_GOLDEN_ANG_WAY,
    };

    enum DepoKind {
        DEPO_NOTHING,
        DEPO_LASER001,
        DEPO_LASER002,
    };

    static bool _was_MyStgUtil_inited_flg;

    static void init();

    /**
     * p .
     * vf[x](0`999)  x Ԗڂ̉pB
     */
    static angle GOLDEN_ANG[1000];

    /**
     * v = 1 - cos(2t)̉e[u .
     * yz
     * t:(t[)
     * v:x
     * ʐρړ
     * t = 0.00.51.0 ΂ĂȂ߂炩 v = 0.0`2.0`0.0 ƕωA1.0ړ
     */
    static double SMOOTH_DV[3600+1];

    /**
     * U͂̈З͗ .
     * ߋVbĝقU͂Ȃ悤ɂ߂̔zB
     * vf͏ot[Al͍U͂ɏ悶␳B
     */
    static double SHOT_POWER[300+1];

    /**
     * pgUˏe𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDx::VecDriver ̈ړAړxAx<BR>
     * @param prm_x               ˌXW
     * @param prm_y               ˌYW
     * @param prm_z               ˌZW
     * @param prm_rz              ˕Rz
     * @param prm_ry              ˕Ry
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_num         PZbgː(1`999)
     * @param prm_first_expanse_angle   ˒ȅƎˊp(0 ` D180ANGBď̍Lp̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_inc_expanse_angle     1eɉZƎˊp(0 ` D180ANG)
     * @param prm_velo_first      eZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         ˏWAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDx::FigureActor* shotWayGoldenAng(coord prm_x, coord prm_y, coord prm_z,
                                                  angle prm_rz, angle prm_ry,
                                                  GgafCore::ActorDepository* prm_pDepo_shot,
                                                  coord prm_r,
                                                  int prm_way_num,
                                                  angle prm_first_expanse_angle, angle prm_inc_expanse_angle,
                                                  velo prm_velo_first, acce prm_acce,
                                                  int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                  void (*pFunc_call_back_dispatched)(GgafDx::FigureActor*, int, int, int) = nullptr);

    /**
     * ˌĂi_rz > _ryjɌĉpgUˏe𕡐ZbgɌ .
     * ˂VbgɁA̍ڂݒ肳܂B<BR>
     * EVbg _x, _y, _z W <BR>
     * EVbg GgafDx::VecDriver ̈ړAړxAx<BR>
     * @param prm_pFrom           ˌ
     * @param prm_pDepo_shot      ˂Vbg̃f|Wg
     * @param prm_r               ˌƔ˂Vbg̏\ʒu(ˌ̔a)B0傫l̕KvLB
     * @param prm_way_num         PZbgː(1`999)
     * @param prm_first_expanse_angle   ˒ȅƎˊp(0 ` D180ANGBď̍Lp̂悤ȃC[WBƒe̊Ԋu)
     * @param prm_inc_expanse_angle     1eɉZƎˊp(0 ` D180ANG)
     * @param prm_velo_first      eZbg̃VbgxBeZbgȍ~̏x prm_attenuated 悶ĂB
     * @param prm_acce            eZbg̃Vbgx
     * @param prm_set_num         ˏWAYe̍vZbg
     * @param prm_interval_frames eZbgƒeZbg̏ot[ԊuB(0傫ݒlŁAԍłԂ̂悤ȉoɂȂB0 w͑SZbgĔˁBj
     * @param prm_attenuated      eZbgȍ~̃Zbg̃Vbgx֏旦Bx(< 1.0)͑x(>1.0)B1.0͑SZbgxB
     * @param pFunc_call_back_dispatched
     * @return Ō̔˒ẽAN^[(ĂȂꍇ nullptr)
     */
    static GgafDx::FigureActor* shotWayGoldenAng(GgafDx::GeometricActor* prm_pFrom,
                                                  GgafCore::ActorDepository* prm_pDepo_shot,
                                                  coord prm_r,
                                                  int prm_way_num,
                                                  angle prm_first_expanse_angle, angle prm_inc_expanse_angle,
                                                  velo prm_velo_first, acce prm_acce,
                                                  int prm_set_num, frame prm_interval_frames, float prm_attenuated,
                                                  void (*pFunc_call_back_dispatched)(GgafDx::FigureActor*, int, int, int) = nullptr);



    /**
     * @̗Dʐ𒲂ׂ
     * @param kind_my
     * @param kind_enemy
     * @return ȉ̕\QƁB
     * <table>
     * <tr><th>0菬              </th><th>0   </th><th>0傫         </th></tr>
     * <tr><td>attribute_my̕   </td><td>i</td><td>kind_my̕D   </td></tr>
     * <tr><td>attribute_enemy̕D</td><td>i</td><td>kind_enemy̕</td></tr>
     * </table>
     */
    static int judgeMyAdvantage(kind_t attribute_my, kind_t attribute_enemy);

    static int judgeEnemyAdvantage(kind_t kattribute_enemy, kind_t attribute_my);

    /**
     * (@)̗̑͌vZ .
     * @param prm_pMy  (@)
     * @param prm_pOpp (@ȊO)
     * @return (@)̗̑
     */
    static int calcMyStamina(GgafCore::MainActor* prm_pMy, const GgafCore::MainActor* const prm_pOpp);


    /**
     * ΏۃAN^[ɕRGtFNgA擾łΔAԂ .
     * Xe[^X(getStatus()) STAT_ExplosionEffectKind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̔GtFNgiς݁jB́A擾łȂꍇ nullptrB
     */
    static GgafDx::FigureActor* activateExplosionEffectOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ʏVbg .
     * @param prm_pActor
     * @return
     */
    static GgafDx::FigureActor* activateAttackShotOf(GgafDx::GeometricActor* prm_pActor);

    /**     */
    static GgafCore::ActorDepository* getDepositoryOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ΏۃAN^[ɕRGtFNgA擾łΗLɂAԂ .
     * Xe[^X(getStatus()) STAT_EntryEffectKind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̓GtFNgiς݁Anullptr͕ԂȂ)
     */
    static EffectBlink* activateEntryEffectOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ΏۃAN^[ɕRޏGtFNgA擾łΗLɂAԂ .
     * Xe[^X(getStatus()) STAT_LeaveEffectKind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̑ޏGtFNgiς݁Anullptr͕ԂȂ)
     */
    static EffectBlink* activateLeaveEffectOf(GgafDx::GeometricActor* prm_pActor);

    /**
     * ΏۃAN^[ɕRŗLGtFNgîPjA擾łΗLɂAԂ .
     * Xe[^X(getStatus()) STAT_ProperEffect01Kind ̒lɂĎނU蕪B
     * @param prm_pActor ΏۃAN^[
     * @return ΏۃAN^[̓GtFNgiς݁jB́A擾łȂꍇ nullptrB
     */
    static GgafDx::FigureActor* activateProperEffect01Of(GgafDx::GeometricActor* prm_pActor);

    /**
     * GLqbg̕WIȏ .
     * j󂳂ꂽꍇ<br>
     * Ej󎞓_Z<br>
     * ENZ<br>
     * EACeo             activateItemOf()<br>
     * EŎGtFNgJn activateDestroyedEffectOf()<br>
     * EłԂeo           activateRevengeShotOf()<br>
     * EGtFNgo       activateExplosionEffectOf()<br>
     * EґSŔ<br>
     * EґSŎACeo(STAT_ItemKind)<br>
     * j󂳂Ȃꍇ<br>
     * E_[W^_Z<br>
     * E_[WtbV\       STAT_FlushAble<br>
     * E_[WGtFNgo activateDamagedEffectOf()<br>
     * @param prm_this qbggiGLj̃AN^[n
     * @param prm_pOther qbg̃AN^[n
     * @return true:j󂳂ꂽ/false:j󂳂ĂȂ
     */
    static bool performEnemyHit(GgafDx::FigureActor* prm_this, const GgafDx::GeometricActor* const prm_pOther);

    /**
     * ґSj󎞂̕WIȏ .
     * @param prm_pActor_last_destroyed ґ̍Ōɔj󂳂ꂽAN^[n
     * @return ґSŎGtFNg
     */
    static GgafDx::FigureActor* performFormationDestroyAll(GgafDx::FigureActor* prm_pActor_last_destroyed);

    // ȉ gen01 start ` end Excel}Nɂ莩ꂽR[hłB
    // R[hύX́uXe[^XCreater.xlsvsƁB
    // gen01 start
	//@
	static GgafCore::Status* resetMyShipStatus(GgafCore::Status* p);
	//@Vbg
	static GgafCore::Status* resetMyShot001Status(GgafCore::Status* p);
	//@XiCvVbg
	static GgafCore::Status* resetMySnipeShot001Status(GgafCore::Status* p);
	//}WbNGlM[j
	static GgafCore::Status* resetMyMagicEnergyCoreStatus(GgafCore::Status* p);
	//@[U[
	static GgafCore::Status* resetMyStraightLaserChip001Status(GgafCore::Status* p);
	//g
	static GgafCore::Status* resetMyBunshinStatus(GgafCore::Status* p);
	//gVVbg
	static GgafCore::Status* resetMyBunshinShot001Status(GgafCore::Status* p);
	//gXiCvVVbg
	static GgafCore::Status* resetMyBunshinSnipeShot001Status(GgafCore::Status* p);
	//gJ[u[U[
	static GgafCore::Status* resetMyBunshinWateringLaserChip001Status(GgafCore::Status* p);
	//gDs[h
	static GgafCore::Status* resetMyTorpedoStatus(GgafCore::Status* p);
	//gDs[h
	static GgafCore::Status* resetMyTorpedoBlastStatus(GgafCore::Status* p);
	//ėpVbg001
	static GgafCore::Status* resetShot001Status(GgafCore::Status* p);
	//ėpVbg002
	static GgafCore::Status* resetShot002Status(GgafCore::Status* p);
	//ėpVbg003~j[U[
	static GgafCore::Status* resetShot003Status(GgafCore::Status* p);
	//ėp~j[U[Vbg
	static GgafCore::Status* resetShot004Status(GgafCore::Status* p);
	//ėpGXg[g[U[001
	static GgafCore::Status* resetEnemyStraightLaserChip001Status(GgafCore::Status* p);
	//ėpGJ[u[U[001
	static GgafCore::Status* resetEnemyWateringLaserChip001Status(GgafCore::Status* p);
	//GX
	static GgafCore::Status* resetEnemyEresStatus(GgafCore::Status* p);
	//GXVbg001
	static GgafCore::Status* resetEnemyEresShot001Status(GgafCore::Status* p);
	//XgGA
	static GgafCore::Status* resetEnemyStraeaStatus(GgafCore::Status* p);
	//XgGA[U[
	static GgafCore::Status* resetEnemyStraeaLaserChip001Status(GgafCore::Status* p);
	//XgGA[U[
	static GgafCore::Status* resetEnemyStraeaLaserChip002Status(GgafCore::Status* p);
	//XgGA[U[
	static GgafCore::Status* resetEnemyStraeaLaserChip003Status(GgafCore::Status* p);
	//XgGA[U[
	static GgafCore::Status* resetEnemyStraeaLaserChip004Status(GgafCore::Status* p);
	//IXieBXBÃnb`j
	static GgafCore::Status* resetEnemyOmulusStatus(GgafCore::Status* p);
	//GXieBXBÃnb`j
	static GgafCore::Status* resetEnemyEmusStatus(GgafCore::Status* p);
	//GX̃[U[
	static GgafCore::Status* resetEnemyEmusLaserChip001Status(GgafCore::Status* p);
	//GeBX
	static GgafCore::Status* resetEnemyEtisStatus(GgafCore::Status* p);
	//X
	static GgafCore::Status* resetEnemyRisStatus(GgafCore::Status* p);
	//QA
	static GgafCore::Status* resetEnemyGeriaStatus(GgafCore::Status* p);
	//nA
	static GgafCore::Status* resetEnemyHaliaStatus(GgafCore::Status* p);
	//܂P
	static GgafCore::Status* resetEnemyTamago01Status(GgafCore::Status* p);
	//CP
	static GgafCore::Status* resetEnemyIrceStatus(GgafCore::Status* p);
	//eBXBAig[Xj
	static GgafCore::Status* resetEnemyRatislaviaStatus(GgafCore::Status* p);
	//AX
	static GgafCore::Status* resetEnemyAllasStatus(GgafCore::Status* p);
	//E[m~A
	static GgafCore::Status* resetEnemyUnomiaStatus(GgafCore::Status* p);
	//G~A
	static GgafCore::Status* resetEnemyEmiliaStatus(GgafCore::Status* p);
	//G~Af
	static GgafCore::Status* resetEnemyEmiliaFragmentStatus(GgafCore::Status* p);
	//G~AfЂ̒f
	static GgafCore::Status* resetEnemyEmiliaFragment2Status(GgafCore::Status* p);
	//G~AfЂ̒fЂ̒f
	static GgafCore::Status* resetEnemyEmiliaFragment3Status(GgafCore::Status* p);
	//MPACe
	static GgafCore::Status* resetMagicPointItem001Status(GgafCore::Status* p);
	//MPACe
	static GgafCore::Status* resetMagicPointItem002Status(GgafCore::Status* p);
	//MPACe
	static GgafCore::Status* resetMagicPointItem003Status(GgafCore::Status* p);
	//XRAACe
	static GgafCore::Status* resetScoreItem001Status(GgafCore::Status* p);
	//VreathACe
	static GgafCore::Status* resetVreathItem001Status(GgafCore::Status* p);
	//G[x
	static GgafCore::Status* resetEnemyEbeStatus(GgafCore::Status* p);
	//qYr[
	static GgafCore::Status* resetEnemyHisbeStatus(GgafCore::Status* p);
	//qYr[2
	static GgafCore::Status* resetEnemyHisbe002Status(GgafCore::Status* p);
	//qYr[[U[
	static GgafCore::Status* resetEnemyHisbeLaserChip001Status(GgafCore::Status* p);
	//qYr[[U[
	static GgafCore::Status* resetEnemyHisbeLaserChip002Status(GgafCore::Status* p);
	//qYr[[U[
	static GgafCore::Status* resetEnemyHisbeLaserChip003Status(GgafCore::Status* p);
	//hXeA
	static GgafCore::Status* resetEnemyDrasteaStatus(GgafCore::Status* p);
	//^e
	static GgafCore::Status* resetEnemyTalanteStatus(GgafCore::Status* p);
	//GXyA
	static GgafCore::Status* resetEnemyEsperiaStatus(GgafCore::Status* p);
	//GXyAA[U[
	static GgafCore::Status* resetEnemyEsperiaLaserChip001Status(GgafCore::Status* p);
	//O[eXg
	static GgafCore::Status* resetTestGuStatus(GgafCore::Status* p);
	//`L[eXg
	static GgafCore::Status* resetTestChokiStatus(GgafCore::Status* p);
	//p[eXg
	static GgafCore::Status* resetTestPaStatus(GgafCore::Status* p);
	//m[}[eXg
	static GgafCore::Status* resetTestNomalStatus(GgafCore::Status* p);
	//O[Vbg
	static GgafCore::Status* resetTestGuShotStatus(GgafCore::Status* p);
	//`L[Vbg
	static GgafCore::Status* resetTestChokiShotStatus(GgafCore::Status* p);
	//p[Vbg
	static GgafCore::Status* resetTestPaShotStatus(GgafCore::Status* p);
	//m[}[Vbg
	static GgafCore::Status* resetTestNomalShotStatus(GgafCore::Status* p);
	//eBXBAAC
	static GgafCore::Status* resetEnemyRatislaviaEyeStatus(GgafCore::Status* p);
	//eBXBAACpXg[g[U[001
	static GgafCore::Status* resetEnemyRatislaviaEyeStraightLaserChip001Status(GgafCore::Status* p);
	//G~Il
	static GgafCore::Status* resetEnemyErmioneStatus(GgafCore::Status* p);
	//G~Ilr̓
	static GgafCore::Status* resetEnemyErmioneArmHeadStatus(GgafCore::Status* p);
	//G~Ilr̓
	static GgafCore::Status* resetEnemyErmioneArmBodyStatus(GgafCore::Status* p);
	//G~Ilr̎_
	static GgafCore::Status* resetEnemyErmioneArmWeakStatus(GgafCore::Status* p);
	//Ab|[
	static GgafCore::Status* resetEnemyApphoStatus(GgafCore::Status* p);
	//AeBIy
	static GgafCore::Status* resetEnemyAntiopeStatus(GgafCore::Status* p);
	//fwCh
	static GgafCore::Status* resetEnemyDelheidStatus(GgafCore::Status* p);
	//ATi
	static GgafCore::Status* resetEnemyAlisanaStatus(GgafCore::Status* p);
	//C[_
	static GgafCore::Status* resetEnemyIdaStatus(GgafCore::Status* p);
	//^SX
	static GgafCore::Status* resetEnemyThagorasStatus(GgafCore::Status* p);
	//IgDi
	static GgafCore::Status* resetEnemyOrtunaStatus(GgafCore::Status* p);
	//O
	static GgafCore::Status* resetEnemyGlajaStatus(GgafCore::Status* p);
	//Oe
	static GgafCore::Status* resetEnemyGlajaLance001Status(GgafCore::Status* p);
	//hD[i
	static GgafCore::Status* resetEnemyDunaStatus(GgafCore::Status* p);
	//I[c@eBA
	static GgafCore::Status* resetEnemyOzartiaStatus(GgafCore::Status* p);
	//I[c@eBAVbgOP(ǃubN)
	static GgafCore::Status* resetEnemyOzartiaShot01Status(GgafCore::Status* p);
	//I[c@eBA[U[`bv
	static GgafCore::Status* resetEnemyOzartiaLaserChip01Status(GgafCore::Status* p);
	//I[c@eBAX
	static GgafCore::Status* resetEnemyOzartiaPillar01Status(GgafCore::Status* p);
	//GrEX
	static GgafCore::Status* resetEnemyOebiusStatus(GgafCore::Status* p);
	//GrEXRA
	static GgafCore::Status* resetEnemyOebiusCoreStatus(GgafCore::Status* p);
	//G}
	static GgafCore::Status* resetEnemyErelmanStatus(GgafCore::Status* p);
	//G}RA
	static GgafCore::Status* resetEnemyErelmanCoreStatus(GgafCore::Status* p);
	//EfBP
	static GgafCore::Status* resetEnemyUrydikeStatus(GgafCore::Status* p);
	//eAXpVbg
	static GgafCore::Status* resetAliceShotStatus(GgafCore::Status* p);
	//n`{bNX01
	static GgafCore::Status* resetWall01Status(GgafCore::Status* p);
    // gen01 end
};

}
#endif /*MYSTGUTIL_H_*/
