#include "MyShip.h"

#include "jp/ggaf/core/actor/ex/ActorDepository.h"
#include "jp/ggaf/dx/actor/supporter/Checker.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/GeoDriver.h"
#include "jp/ggaf/dx/actor/supporter/Scaler.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/model/Model.h"
#include "jp/ggaf/dx/util/CollisionArea.h"
#include "jp/ggaf/dx/util/CollisionPart.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/actor/effect/EffectTurbo001.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/DamageDispBar.h"
#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/MyMagicEnergyCore.h"
#include "jp/gecchi/VioletVreath/actor/my/MyShot001.h"
#include "jp/gecchi/VioletVreath/actor/my/MySnipeShot001.h"
#include "jp/gecchi/VioletVreath/actor/my/MyStraightLaserChip001.h"
#include "jp/gecchi/VioletVreath/actor/my/MyTorpedoController.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/Config.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/actor/my/Bunshin/MyBunshinBase.h"
#include "jp/ggaf/lib/util/Direction26Util.h"
#include "jp/ggaf/lib/util/ColliAAPrism.h"
#include "jp/ggaf/lib/util/ColliAAPyramid.h"

using namespace GgafLib;
using namespace VioletVreath;

coord MyShip::lim_y_top_     =  0;
coord MyShip::lim_y_bottom_  =  0;
coord MyShip::lim_x_infront_ =  0;
coord MyShip::lim_x_behaind_ =  0;
coord MyShip::lim_z_left_    =  0;
coord MyShip::lim_z_right_   =  0;

uint32_t MyShip::shot2_matrix_[4][MYSHIP_SHOT_MATRIX] = {
    {
            8,           //  0001000
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
            8            //  0001000
    },
    {
            0,           //  0000000
            2,           //  0000010
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
           32,           //  0100000
            0            //  0000000
    },
    {
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
           65,           //  1000001
            0,           //  0000000
            0,           //  0000000
            0            //  0000000
    },
    {
            0,           //  0000000
           32,           //  0100000
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
            2,           //  0000010
            0            //  0000000

    }
};

uint32_t MyShip::shot3_matrix_[2][MYSHIP_SHOT_MATRIX] = {
    {
            8,           //  0001000
            0,           //  0000000
            0,           //  0000000
           65,           //  1000001
            0,           //  0000000
            0,           //  0000000
            8            //  0001000
    },
    {
            0,           //  0000000
           34,           //  0100010
            0,           //  0000000
            0,           //  0000000
            0,           //  0000000
           34,           //  0100010
            0            //  0000000
    }
};

/** \tgAːŁAPvbVŌƂoAː */
#define SOFT_RAPIDSHOT_NUM       (3)
/** \tgAːł̃VbgƃVbg̊Ԋu */
#define SOFT_RAPIDSHOT_INTERVAL  (4)

enum {
    SE_DAMAGED     ,
    SE_EXPLOSION   ,
    SE_TURBO       ,
    SE_CANT_TURBO  ,
    SE_FIRE_LASER  ,
    SE_FIRE_SHOT   ,
    SE_FIRE_TORPEDO,
};


MyShip::MyShip(const char* prm_name) :
        VvMyActor<DefaultD3DXMeshActor>(prm_name, "VicViper", StatusReset(MyShip)) {
//DefaultMeshActor(prm_name, "jiki") {
//CubeMapMeshActor(prm_name, "wakka") {
//DefaultD3DXAniMeshActor(prm_name, "AnimatedSkelton") {
    _class_name = "MyShip";

    //effectBlendOne(); //ZTechniquew

    //ʂ̑傫ɔāAړ͈͂
    //̂FovXɈˑ̂ŔB
    static const coord game_buffer_width  = PX_C(CONFIG::GAME_BUFFER_WIDTH);
    static const coord game_buffer_height = PX_C(CONFIG::GAME_BUFFER_HEIGHT);
    MyShip::lim_y_top_     =  (game_buffer_height/2) + game_buffer_height*4;  //́A4ʕȂ̈܂ňړ\
    MyShip::lim_y_bottom_  = -(game_buffer_height/2) - game_buffer_height*4;  //́A4ʕȂ̈܂ňړ\
    MyShip::lim_x_infront_ =  (game_buffer_width/2)  + game_buffer_width*2;   //ÓA2ʕȂ̈܂ňړ\
    MyShip::lim_x_behaind_ = -(game_buffer_width/2)  - game_buffer_width*1;   //́ÂPʕȂ̈܂ňړ\
    MyShip::lim_z_left_    =  (game_buffer_height/2) + game_buffer_height*4;   //ÓA4ʕȂ̈܂ňړ\
    MyShip::lim_z_right_   = -(game_buffer_height/2) - game_buffer_height*4;   //́A4ʕȂ̈܂ňړ\
    _TRACE_("MyShip ͈ X("<<MyShip::lim_x_behaind_<<" ` "<<MyShip::lim_x_infront_<<")  Y("<<MyShip::lim_y_bottom_<<" ` "<<MyShip::lim_y_top_<<")  Z("<<MyShip::lim_z_right_<<" ` "<<MyShip::lim_z_left_<<")");


    //CommonScenenew̏ꍇݒ
    angRxVelo_BeginMZ_ = 1000;   //͎O֒ʏZʏړJnX]px̏x
    angRxAcce_MZ_ = 300;         //͎O֒ʏZړX]px̏px
    angRxTopVelo_MZ_ = 5000;     //͎O֒ʏZړX]px̏px
    angRxStop_MZ_ = 90000;       //͎O֒ʏZړX]p̖ڕW~px
    angRxVelo_BeginMZT_ = 20000; //͎OTurboړJnX]px̏x

    mv_speed_ = 0;
    veloBeginMT_ = 0;
    setMoveSpeed(2000);


//    //debug ---->
//    pDepo_TestGuShot_ = NEW GgafCore::ActorDepository("Depo_TestGuShot");
//    for (int i = 0; i < 25; i++) { //eXgO[eXgbN
//        pDepo_TestGuShot_->appendChild(NEW TestGuShot("TestGuShot"));
//    }
//    appendGroupChild(pDepo_TestGuShot_);
//    pDepo_TestChokiShot_ = NEW GgafCore::ActorDepository("Depo_TestChokiShot");
//    for (int i = 0; i < 25; i++) { //eXg`LeXgbN
//        pDepo_TestChokiShot_->appendChild(NEW TestChokiShot("TestChokiShot"));
//    }
//    appendGroupChild(pDepo_TestChokiShot_);
//    pDepo_TestPaShot_ = NEW GgafCore::ActorDepository("Depo_TestPaShot");
//    for (int i = 0; i < 25; i++) { //eXgp[eXgbN
//        pDepo_TestPaShot_->appendChild(NEW TestPaShot("TestPaShot"));
//    }
//    appendGroupChild(pDepo_TestPaShot_);
//    pDepo_TestNomalShot_ = NEW GgafCore::ActorDepository("Depo_TestNomalShot");
//    for (int i = 0; i < 25; i++) { //eXgm[}eXgbN
//        pDepo_TestNomalShot_->appendChild(NEW TestNomalShot("TestNomalShot"));
//    }
//    appendGroupChild(pDepo_TestNomalShot_);
//    //<---- debug


    pDepo_MyShots001_ = NEW GgafCore::ActorDepository("RotShot001");
    MyShot001* pShot;
    for (int i = 0; i < 50; i++) { //eXgbN
        pShot = NEW MyShot001("MY_MyShot001");
        pShot->inactivate();
        pDepo_MyShots001_->put(pShot);
    }
    appendGroupChild(pDepo_MyShots001_);

    pDepo_MySnipeShots001_ = NEW GgafCore::ActorDepository("RotShot001");
    MySnipeShot001* pSnipeShot;
    for (int i = 0; i < 5; i++) { //eXgbN
        pSnipeShot = NEW MySnipeShot001("MY_MySnipeShot001");
        pSnipeShot->inactivate();
        pDepo_MySnipeShots001_->put(pSnipeShot);
    }
    appendGroupChild(pDepo_MySnipeShots001_);

    pLaserChipDepo_ = NEW LaserChipDepository("MyRotLaser");
    MyStraightLaserChip001* pChip;
    for (int i = 0; i < 80; i++) { //[U[XgbN
        std::string name = "MyStraightLaserChip001("+XTOS(i)+")";
        pChip = NEW MyStraightLaserChip001(name.c_str());
        pChip->setPositionSource(this); //ʒu
        pLaserChipDepo_->put(pChip);
    }
    pLaserChipDepo_->config(80, 25);
    appendGroupChild(pLaserChipDepo_);

    //bNIRg[[
    pLockonCtrler_ = NEW MyLockonController("MySHipLockonController");
    appendGroupChild(pLockonCtrler_);

    //tHgRg[[
    pTorpedoCtrler_ = NEW MyTorpedoController("TorpedoController", this, pLockonCtrler_);
    appendGroupChild(pTorpedoCtrler_);

    pEffectTurbo001_ = NEW EffectTurbo001("EffectTurbo001");
    appendGroupChild(pEffectTurbo001_);
//    pEffectTurbo002_ = NEW EffectTurbo002("EffectTurbo002");
//    appendGroupChild(pEffectTurbo002_);

    pMyMagicEnergyCore_ = NEW MyMagicEnergyCore("MyMagicEnergyCore");
    appendGroupChild(pMyMagicEnergyCore_);

    //26Ɉړꍇ̎@̌X`
    pSenakai_ = &(senakai_[13]);
    pSenakai_[DIR26(-1,-1,-1)] = -D_ANG(120);
    pSenakai_[DIR26(-1,-1, 0)] =  0;
    pSenakai_[DIR26(-1,-1, 1)] =  D_ANG(120);
    pSenakai_[DIR26(-1, 0,-1)] = -D90ANG;
    pSenakai_[DIR26(-1, 0, 0)] =  0;
    pSenakai_[DIR26(-1, 0, 1)] =  D90ANG;
    pSenakai_[DIR26(-1, 1,-1)] = -D_ANG(30);
    pSenakai_[DIR26(-1, 1, 0)] =  0;
    pSenakai_[DIR26(-1, 1, 1)] =  D_ANG(30);
    pSenakai_[DIR26( 0,-1,-1)] = -D135ANG;
    pSenakai_[DIR26( 0,-1, 0)] =  0;
    pSenakai_[DIR26( 0,-1, 1)] =  D135ANG;
    pSenakai_[DIR26( 0, 0,-1)] = -D90ANG;
    pSenakai_[DIR26( 0, 0, 0)] =  0;
    pSenakai_[DIR26( 0, 0, 1)] =  D90ANG;
    pSenakai_[DIR26( 0, 1,-1)] = -D45ANG;
    pSenakai_[DIR26( 0, 1, 0)] =  0;
    pSenakai_[DIR26( 0, 1, 1)] =  D45ANG;
    pSenakai_[DIR26( 1,-1,-1)] = -D_ANG(120);
    pSenakai_[DIR26( 1,-1, 0)] =  0;
    pSenakai_[DIR26( 1,-1, 1)] =  D_ANG(120);
    pSenakai_[DIR26( 1, 0,-1)] = -D90ANG;
    pSenakai_[DIR26( 1, 0, 0)] =  0;
    pSenakai_[DIR26( 1, 0, 1)] =  D90ANG;
    pSenakai_[DIR26( 1, 1,-1)] = -D_ANG(30);
    pSenakai_[DIR26( 1, 1, 0)] =  0;
    pSenakai_[DIR26( 1, 1, 1)] =  D_ANG(30);

    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_DAMAGED     , "WAVE_MY_DAMAGED_001");
    pSeTx->set(SE_EXPLOSION   , "WAVE_MY_SE_EXPLOSION_001");
    pSeTx->set(SE_TURBO       , "WAVE_MY_TURBO_001");
    pSeTx->set(SE_CANT_TURBO  , "WAVE_MY_CANT_TURBO_001");
    pSeTx->set(SE_FIRE_LASER  , "WAVE_MY_FIRE_LASER_001");
    pSeTx->set(SE_FIRE_SHOT   , "WAVE_MY_FIRE_SHOT_001");
    pSeTx->set(SE_FIRE_TORPEDO, "WAVE_MY_FIRE_TORPEDO_001");

    veloTurboTop_ = 30000;
    veloTurboBottom_ = 10000;

    is_being_soft_rapidshot_ = false;
    soft_rapidshot_shot_count_ = 0;
    soft_rapidshot_push_cnt_ = 0;
    soft_rapidshot_shot_count_in_one_push_ = 0;
    soft_rapidshot_frames_in_one_push = 0;
    is_snipe_shot_ = false;

    is_just_shot_ = false;
    is_shooting_laser_ = false;
    can_shoot_laser_ = false;
    frame_shot_pressed_ = 0;

    can_control_ = true;
    is_diving_ = false;

    blown_veloX_ = 0;
    blown_veloY_ = 0;
    blown_veloZ_ = 0;
    mv_way_sgn_x_ = 0;
    mv_way_sgn_y_ = 0;
    mv_way_sgn_z_ = 0;
    mv_way_ = DIR26(mv_way_sgn_x_, mv_way_sgn_y_, mv_way_sgn_z_);
    prev_way_ = mv_way_;
    is_just_change_mv_way_ = false;

    //MPl
    mp_ = MY_SHIP_START_MP;
    //mp_ςƁAQƂ MpBar ̕\Aĕς

    //Vreath͎l getStatus() STAT_StaminalQƂ悤ɐݒB
//    vreath_.link( &(getStatus()->_paValue[STAT_Stamina]._int_val) );
    //STAT_Stamina΁Avreath_ ωAQƂ VreathBar ̕\Aĕς

    //@[^[ݒu
    pMagicMeter_ = NEW MagicMeter("MagicMeter", &mp_, &(getStatus()->_value[STAT_Stamina]._int_val) );
    pMagicMeter_->setPosition(PX_C(100), PX_C(CONFIG::GAME_BUFFER_HEIGHT) - (pMagicMeter_->height_) - PX_C(16+16+16));
    appendGroupChild(pMagicMeter_);

    r_blown_velo_decay_ = 0.8;

    invincible_frames_ = 0;

    trace_delay_count_ = 0;
    is_trace_waiting_ = false;

    shot_level_ = 1;

    prev_x_ = _x;
    prev_y_ = _y;
    prev_z_ = _z;
}

void MyShip::onCreateModel() {
    GgafDx::Model* pModel = getModel();
    pModel->setSpecular(5.0, 1.0);
}

void MyShip::initialize() {
    _TRACE_(FUNC_NAME<<"");

    //ʂɐU蕪
//    bringSceneMediator()->appendGroupChild(KIND_MY_SHOT_NOMAL, pDepo_MyShots001_->extract());
//    bringSceneMediator()->appendGroupChild(KIND_MY_SHOT_NOMAL, pDepo_MyWaves001_->extract());
    //bringSceneMediator()->appendGroupChild(KIND_MY_SHOT_NOMAL, pLaserChipDepo_->extract());

    setHitAble(true);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
//    pChecker->setColliSphere(0, -100000, -50000, 20000, 100000);
// pChecker->setColliAABox(0, -100000, -50000, 20000, 10000, 40000, 80000);
//    pChecker->setColliSphere(1, 0,-100000,0, 30000, true, true, true);
//    pChecker->setColliSphere(2, 0,100000,0, 30000, true, true, true);
//    pChecker->setColliSphere(3, 0,0,-100000, 30000, true, true, true);
//    pChecker->setColliSphere(4, 0,0,100000, 30000, true, true, true);

//    pChecker->setColliAACube(0, 40000);
/////////////TEST
      pChecker->setColliAACube(0, PX_C(40));

    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setMvVelo(0);

    //setMaterialColor(1.0, 0.5, 0.5);
    setAlpha(1.0);
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    pGeoDriver->forceVxyzMvVeloRange(-veloTurboTop_, veloTurboTop_);
    pGeoDriver->setZeroVxyzMvAcce();

    getVecDriver()->setRollFaceAngVelo(300);
}


void MyShip::onReset() {
    _TRACE_(FUNC_NAME<<" "<<NODE_INFO<<"");
    is_being_soft_rapidshot_ = false;
    soft_rapidshot_shot_count_ = 0;
    soft_rapidshot_push_cnt_ = 0;
    soft_rapidshot_shot_count_in_one_push_ = 0;
    soft_rapidshot_frames_in_one_push = 0;
    is_snipe_shot_ = false;
    is_being_soft_rapidshot_ = false;
    is_just_shot_ = false;
    is_shooting_laser_ = false;
    can_shoot_laser_ = false;
    frame_shot_pressed_ = 0;
    _x = _y = _z = 0;
    mv_way_sgn_x_ = 0;
    mv_way_sgn_y_ = 0;
    mv_way_sgn_z_ = 0;
    mv_way_ = DIR26(mv_way_sgn_x_, mv_way_sgn_y_, mv_way_sgn_z_);
//    mv_way_switch_.reset();

    mp_ = MY_SHIP_START_MP;
    getStatus()->reset();

    setInvincibleFrames(60 * 10); //oꎞ̖G
}

void MyShip::onActive() {
    _TRACE_(FUNC_NAME<<"");
    //[U[⃍bN^[Qbg⋛qɂ邽
    //ʂɌĂяo
    pLockonCtrler_->onActive();
    pTorpedoCtrler_->onActive();
}
void MyShip::onInactive() {
    _TRACE_(FUNC_NAME<<"");
    //[U[⃍bN^[Qbg⋛qɂ邽
    //ʂɌĂяo
    pLockonCtrler_->onInactive();
    pTorpedoCtrler_->onInactive();
//    pLaserChipDepo_->reset();
}
void MyShip::processBehavior() {
    VirtualButton* pVbPlay = VB_PLAY;
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    //싑
    if (!can_control_) {
        return;
    }
    updateMoveWay();
    if (getStatus()->get(STAT_Stamina) < 0) {
        //؂
    } else {
        if (pVbPlay->isPressed(VB_OPTION)) {
            int tmp = mv_speed_;
            mv_speed_ /= 8; //IvV쒆ړ͒x
            moveNomal();
            mv_speed_ = tmp;
        } else {
            moveNomal();
        }

        if (pVbPlay->isPushedDown(VB_TURBO)) {
            if (pGeoDriver->_velo_vx_mv == 0 && pGeoDriver->_velo_vy_mv == 0 && pGeoDriver->_velo_vz_mv == 0) {
                //^[{ړSɏIȂƎ̃^[{͎ss
                moveTurbo();
                UTIL::activateProperEffect01Of(this); //^[{JñGtFNg
                getSeTransmitter()->play3D(SE_TURBO);
            } else {
                //^[{ړ
                getSeTransmitter()->play3D(SE_CANT_TURBO);
            }
        } else {
            //Not^[{Jn
            if (pVbPlay->isPressed(VB_TURBO)) {
                //^[{{^邱ƂŁAx₩ɂȂA
                //ړL΂
                pGeoDriver->_velo_vx_mv *= 0.96;
                pGeoDriver->_velo_vy_mv *= 0.96;
                pGeoDriver->_velo_vz_mv *= 0.96;
            } else {
                //^[{𗣂ꍇAxB
                pGeoDriver->_velo_vx_mv *= 0.8;
                pGeoDriver->_velo_vy_mv *= 0.8;
                pGeoDriver->_velo_vz_mv *= 0.8;
            }
            if (ABS(pGeoDriver->_velo_vx_mv) <= 2) {
                pGeoDriver->_velo_vx_mv = 0;
            }
            if (ABS(pGeoDriver->_velo_vy_mv) <= 2) {
                pGeoDriver->_velo_vy_mv = 0;
            }
            if (ABS(pGeoDriver->_velo_vz_mv) <= 2) {
                pGeoDriver->_velo_vz_mv = 0;
            }
        }

        if (pVbPlay->isDoublePushedDown(VB_OPTION,8,8) ) {
            pGeoDriver->setZeroVxyzMvVelo(); //^[{ړł~Bi^[{LZIɂȂIj
        }
    }

    //Xs悭ĂȂΑx߂
    angvelo MZ = angRxTopVelo_MZ_-3000; //3000͒ʏ񎞂ɑx߂angRxTopVelo_MZ_𒴂Ȃ悤ɂ邽߁AOŌƌӖiTODO:vjB
    if (pVecDriver->_angvelo_face[AXIS_X] >= MZ) {
        pVecDriver->_angvelo_face[AXIS_X] *= 0.93;
        //_getVecDriver()->setFaceAngAcce(AXIS_X, -1*angRxAcce_MZ_*2);
    } else if (pVecDriver->_angvelo_face[AXIS_X] <= -MZ) {
        pVecDriver->_angvelo_face[AXIS_X] *= 0.93;
        //_getVecDriver()->setFaceAngAcce(AXIS_X, angRxAcce_MZ_*2);
    }

    //񂵂Ȃړ̏ꍇA@̂𐅕ɂiA悭ĂȂꍇɌBsetStopTargetFaceAng̑4px邢ꍇ󂯓j
    if (pSenakai_[mv_way_] == 0) {
        angle dist = pVecDriver->getFaceAngDistance(AXIS_X, 0, TURN_CLOSE_TO);
        if (0 <= dist && dist < D180ANG) {
            getVecDriver()->setFaceAngAcce(AXIS_X, angRxAcce_MZ_);
        } else if (-1*D180ANG < dist && dist < 0) {
            getVecDriver()->setFaceAngAcce(AXIS_X, -1*angRxAcce_MZ_);
        }
        pVecDriver->setMvAcce(0);
        pVecDriver->setStopTargetFaceAng(AXIS_X, 0, TURN_BOTH, angRxTopVelo_MZ_);
    }

    ////////////////////////////////////////////////////

    //Wɔf
    pVecDriver->behave();
    pGeoDriver->behave();
    getSeTransmitter()->behave();

    if (invincible_frames_ > 0) {
        setHitAble(false);
        invincible_frames_ --;
        if (getActiveFrame() % 2 == 0) {
            setAlpha(0.6);
        } else {
            setAlpha(0);
        }
        if (invincible_frames_ == 0) {
            setHitAble(true);
            setAlpha(1.0);
        }
    } else {

    }
    //
    if (ABS(blown_veloX_) < PX_C(1)) {
        blown_veloX_ = 0;
    } else {
        _x += blown_veloX_;
        blown_veloX_ *= r_blown_velo_decay_;
    }
    if (ABS(blown_veloY_) < PX_C(1)) {
        blown_veloY_ = 0;
    } else {
        _y += blown_veloY_;
        blown_veloY_ *= r_blown_velo_decay_;
    }
    if (ABS(blown_veloZ_) < PX_C(1)) {
        blown_veloZ_ = 0;
    } else {
        _z += blown_veloZ_;
        blown_veloZ_ *= r_blown_velo_decay_;
    }


    if (is_diving_) {
        //˓[V́Aړ͈͐䖳
    } else {
        //ʏړ͈͐
        if (_y > MyShip::lim_y_top_) {
            _y = MyShip::lim_y_top_;
        } else if (_y < MyShip::lim_y_bottom_ ) {
            _y = MyShip::lim_y_bottom_;
        }

        if (_x > MyShip::lim_x_infront_) {
            _x = MyShip::lim_x_infront_;
        } else if (_x < MyShip::lim_x_behaind_) {
            _x = MyShip::lim_x_behaind_;
        }

        if (_z > MyShip::lim_z_left_) {
            _z = MyShip::lim_z_left_;
        } else if (_z < MyShip::lim_z_right_) {
            _z = MyShip::lim_z_right_;
        }
    }

    //t[̌ċz̏
    getStatus()->minus(STAT_Stamina, MY_SHIP_VREATH_COST);

    //Vbg֘A
    is_shooting_laser_ = false;
    if (pVbPlay->isPressed(VB_SHOT1)) {
        frame_shot_pressed_ ++;
        if (can_shoot_laser_) {
            if (frame_shot_pressed_ > 30) { //30t[ςȂŃ[U[
                is_shooting_laser_ = true;
            }
        }
    } else {
        frame_shot_pressed_ = 0;
        pLockonCtrler_->releaseAllLockon(); //bNI
    }

    //[U[
    if (is_shooting_laser_) {
        if (pVbPlay->isPressed(VB_SHOT1)) {
            LaserChip* pLaserChip = pLaserChipDepo_->dispatch();
            if (pLaserChip) {
                if (pLaserChip->getInfrontChip() == nullptr) {
                    getSeTransmitter()->play3D(SE_FIRE_LASER);
                }
            }
        } else {

        }
    }

    //\tgA
    //PvbVڂ̏ê݂P̂ݔ˂̃XiCvVbgB
    //QvbVڈȍ~\tgAˁAPvbV4Fɍő3
    if (pVbPlay->isPushedDown(VB_SHOT1) && !pVbPlay->isPressed(VB_POWERUP)) {
        if (is_being_soft_rapidshot_) {
            if (soft_rapidshot_frames_in_one_push >= SOFT_RAPIDSHOT_INTERVAL) {
                //vbṼ\tgA˂ɂQڂ SOFT_RAPIDSHOT_INTERVAL t[莟̃vbVxꍇ
                //A˂ƘA˂̂Ȃڂ悤ɉo߂ɁA
                //soft_rapidshot_frames_in_one_push  SOFT_RAPIDSHOT_INTERVAL {̒l_nŏlɂ
                soft_rapidshot_frames_in_one_push = soft_rapidshot_frames_in_one_push % SOFT_RAPIDSHOT_INTERVAL;
                if (soft_rapidshot_frames_in_one_push > 0) {
                    //soft_rapidshot_frames_in_one_push ^ǂ0Ȃ΁ASOFT_RAPIDSHOT_NUM ̒e\tgA˂ɂ蔭˂邱ƂɂȂ邪A
                    //soft_rapidshot_frames_in_one_push > 0 Ȃ΁ASOFT_RAPIDSHOT_NUM-1 ɂȂPĂ܂B
                    //ׁASOFT_RAPIDSHOT_NUM ̒eƂۏ؂邽߂ɁAsoft_rapidshot_frames_in_one_push␳
                    soft_rapidshot_frames_in_one_push -= SOFT_RAPIDSHOT_INTERVAL;
                }
                soft_rapidshot_shot_count_in_one_push_ = 0;
                soft_rapidshot_push_cnt_++;
            } else {
                //vbVA\tgA˂ɂQڂ SOFT_RAPIDSHOT_INTERVAL t[莟̃vbVꍇ
                //󂯓ċIɔ˂ł(SOFT_RAPIDSHOT_INTERVAL葬蓮A˂́AA˗D)
                soft_rapidshot_frames_in_one_push = 0;
                soft_rapidshot_shot_count_in_one_push_ = 0;
                soft_rapidshot_push_cnt_++;
            }
        } else {
            //\tgAˊJnI
            is_being_soft_rapidshot_ = true;
            soft_rapidshot_frames_in_one_push = 0;
            soft_rapidshot_shot_count_in_one_push_ = 0;
            soft_rapidshot_push_cnt_ = 1;
        }
    }

    if (is_being_soft_rapidshot_) {
        //\tgA˒AۂɃVbg^C~O̔
        if (soft_rapidshot_frames_in_one_push % SOFT_RAPIDSHOT_INTERVAL == 0) {
            //Vbg^C~Oł͂邪AʂăVbgĂ悢H
            soft_rapidshot_shot_count_++;
            soft_rapidshot_shot_count_in_one_push_++;
            //\tgAˈێԊO
            if(soft_rapidshot_frames_in_one_push > SOFT_RAPIDSHOT_INTERVAL*(SOFT_RAPIDSHOT_NUM-1)) {
                //\tgAˉ
                is_being_soft_rapidshot_ = false;
                soft_rapidshot_shot_count_ = 0;
                soft_rapidshot_shot_count_in_one_push_ = 0;
                soft_rapidshot_push_cnt_ = 0;
                is_just_shot_ = false; //Vbg
            } else {
                //\tgAˈێԓȂ̂
                is_just_shot_ = true;  //Vbg܂傤
                soft_rapidshot_frames_in_one_push++;
            }
        } else {
            //\tgA˒A^C~O
            is_just_shot_ = false;
            soft_rapidshot_frames_in_one_push++;
        }
    } else {
         //\tgA˒łȂ
        is_just_shot_ = false;
    }

    //XiCvVbg̔
    is_snipe_shot_ = false;
    if (is_just_shot_) {
        if (soft_rapidshot_push_cnt_ == 1) { //ŏ̃vbVłB
            if (soft_rapidshot_shot_count_in_one_push_ == 1) {  //ŏ̃vbV̂Pڂł
                is_snipe_shot_ = true; //XiCvVbgI
            }
            if (2 <= soft_rapidshot_shot_count_in_one_push_ && soft_rapidshot_shot_count_in_one_push_ <= SOFT_RAPIDSHOT_NUM) {
                is_just_shot_ = false; //XiCvVbg̃vbV́AeȊO𖳗VbgB
            } else {
                is_just_shot_ = true;
            }
        }
    } else {
    }

    if (is_just_shot_) {
        if (is_snipe_shot_) {
            //XiCvVbg
            MySnipeShot001* const pSnipeShot = (MySnipeShot001*)pDepo_MySnipeShots001_->dispatch();
            if (pSnipeShot) {
                getSeTransmitter()->play3D(SE_FIRE_SHOT);
                pSnipeShot->setPositionAt(this);
                pSnipeShot->getVecDriver()->setRzRyMvAng(_rz, _ry);
                pSnipeShot->getVecDriver()->setMvVelo(PX_C(100));
                pSnipeShot->getVecDriver()->setMvAcce(100);
            }
        } else {
            //XiCvVbgȊO
            if (shot_level_ >= 1) {
                MyShot001* const pShot = (MyShot001*)pDepo_MyShots001_->dispatch();
                if (pShot) {
                    getSeTransmitter()->play3D(SE_FIRE_SHOT);
                    pShot->setPositionAt(this);
                    pShot->getVecDriver()->setRzRyMvAng(_rz, _ry);
                    pShot->getVecDriver()->setMvVelo(PX_C(70));
                    pShot->getVecDriver()->setMvAcce(80);
                }
            }

            if (shot_level_ == 2) {
                uint32_t i = soft_rapidshot_shot_count_ % 4;
                UTIL::shotWay003(this,
                                 pDepo_MyShots001_ , MyShip::shot2_matrix_[i],
                                 nullptr, nullptr,
                                 nullptr, nullptr,
                                 PX_C(1),
                                 MYSHIP_SHOT_MATRIX, MYSHIP_SHOT_MATRIX,
                                 D_ANG(5), D_ANG(5),
                                 PX_C(70), 100,
                                 1, 0, 1.0);
            } else if (shot_level_ >= 3) {
                uint32_t i = soft_rapidshot_shot_count_ % 2;
                UTIL::shotWay003(this,
                                 pDepo_MyShots001_ , MyShip::shot3_matrix_[i],
                                 nullptr, nullptr,
                                 nullptr, nullptr,
                                 PX_C(1),
                                 MYSHIP_SHOT_MATRIX, MYSHIP_SHOT_MATRIX,
                                 D_ANG(5), D_ANG(5),
                                 PX_C(70), 100,
                                 1, 0, 1.0);
            }
        }
    }


    //q
    if (pVbPlay->isPushedDown(VB_SHOT2)) {
        if (this->pTorpedoCtrler_->fire()) {
            getSeTransmitter()->play3D(SE_FIRE_TORPEDO);
        }
    }


    if (prev_x_ == _x && prev_y_ == _y && prev_z_ == _z) {
        is_move_ = false;
    } else {
        is_move_ = true;
    }
    mv_offset_x_ = _x - prev_x_;
    mv_offset_y_ = _y - prev_y_;
    mv_offset_z_ = _z - prev_z_;
    prev_x_ = _x;
    prev_y_ = _y;
    prev_z_ = _z;
}

void MyShip::processJudgement() {
    //TODO: TEST
    if (GgafDx::Input::isPushedDownKey(DIK_0)) {
        //@J
        setHitAble(false);
        getSeTransmitter()->play3D(SE_EXPLOSION);
        throwEventUpperTree(EVENT_MY_SHIP_WAS_DESTROYED_BEGIN);
    }
    //TODO:_[WeXg TEST
    if (GgafDx::Input::isPushedDownKey(DIK_9)) {
        int vreath = getStatus()->get(STAT_Stamina);
        getStatus()->minus(STAT_Stamina, 10000);
        int damage = vreath - getStatus()->get(STAT_Stamina);
        if (damage > 0) {
            pMagicMeter_->pDamageDispBar_->dispDamage(vreath, vreath-damage);
        }
    }
}

void MyShip::onHit(const GgafCore::Actor* prm_pOtherActor) {
    GgafDx::GeometricActor* pOther = (GgafDx::GeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg
    int vreath = getStatus()->get(STAT_Stamina);
    if (UTIL::calcMyStamina(this, pOther) <= 0) {
        //@J
        setHitAble(false);
        getSeTransmitter()->play3D(SE_EXPLOSION);
        throwEventUpperTree(EVENT_MY_SHIP_WAS_DESTROYED_BEGIN);
    }
    int damage = vreath - getStatus()->get(STAT_Stamina);
    if (damage > 0) {
        pMagicMeter_->pDamageDispBar_->dispDamage(vreath, vreath-damage);
    }

    //ǂ̏ꍇʂȏ
    if (pOther->lookUpKind() & KIND_CHIKEI) {
        //ѕlB
        //݂̈ړ̋tiшЗ͂͂Q{Ɂj
        float vx1,vy1,vz1;
        coord dX1 = -mv_offset_x_;
        coord dY1 = -mv_offset_y_;
        coord dZ1 = -mv_offset_z_;
        if (dX1 == 0 && dY1 == 0 && dZ1 == 0) {
            vx1 = vy1 = vz1 = 0;
        } else {
            UTIL::getNormalizedVector(dX1, dY1, dZ1,
                                     vx1, vy1, vz1 );
        }
        float vx2, vy2, vz2;
        coord dX2,dY2,dZ2;
        if ( pOther->instanceOf(Obj_MassWallActor)) {
            GgafDx::CollisionPart** papColli = pOther->_pChecker->_pCollisionArea->_papColliPart;

            ColliAABox* pBox = (ColliAABox*)(papColli[0]); //[0]BOX,[1]vY,[2]s~bh
            ColliAAPrism* pPrism = (ColliAAPrism*)(papColli[1]); //[0]BOX,[1]vY,[2]s~bh
            ColliAAPyramid* pPyramid = (ColliAAPyramid*)(papColli[2]); //[0]BOX,[1]vY,[2]s~bh
            if (pBox->_is_valid_flg) {
                //vYȊO̕
                dX2 = (_x - pOther->_x);
                dY2 = (_y - pOther->_y);
                dZ2 = (_z - pOther->_z);
            } else if (pPrism->_is_valid_flg) {
                //vY
                //ԏdSW␳
                pos_t pos_info = pPrism->_pos_info;
                if (pos_info & POS_PRISM_XY_xx) {
                    if (pos_info & POS_PRISM_xx_PP) {
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //        _
                        // x-     _焠   x+
                        //            _
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    } else if (pos_info & POS_PRISM_xx_NP) {
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //        ^
                        // x-   ^     x+
                        //        ^    
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    } else if (pos_info & POS_PRISM_xx_PN) {
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //            ^
                        // x-     ^   x+
                        //        ^焠
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    } else { // ̂ POS_PRISM_xx_NN
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //        _    
                        // x-   _     x+
                        //        _
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    }

                } else if (pos_info & POS_PRISM_YZ_xx) {

                    if (pos_info & POS_PRISM_xx_PP) {
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //        _
                        // y-     _焠   y+
                        //            _
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else if (pos_info & POS_PRISM_xx_NP) {
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //        ^
                        // y-   ^     y+
                        //        ^    
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else if (pos_info & POS_PRISM_xx_PN) {
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //            ^
                        // y-     ^   y+
                        //        ^焠
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    } else { // ̂ POS_PRISM_xx_NN
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //        _    
                        // y-   _     y+
                        //        _
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    }

                } else if (pos_info & POS_PRISM_ZX_xx) {
                    if (pos_info & POS_PRISM_xx_PP) {
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //        _
                        // z-     _焠   z+
                        //            _
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y               ));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else if (pos_info & POS_PRISM_xx_NP) {
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //        ^
                        // z-   ^     z+
                        //        ^    
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y               ));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    } else if (pos_info & POS_PRISM_xx_PN) {
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //            ^
                        // z-     ^   z+
                        //        ^焠
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y               ));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else { // ̂ POS_PRISM_xx_NN
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //        _    
                        // z-   _     z+
                        //        _
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y                ));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    }
                } else if (pPyramid->_is_valid_flg) {
                    //TODO:s~bhӂƂԏdS
                    dX2 = (_x - pOther->_x);
                    dY2 = (_y - pOther->_y);
                    dZ2 = (_z - pOther->_z);
                }
            } else {

            }
        } else {
            //ǂȂꍇ͒SWŐԕ
            GgafDx::CollisionArea* pCollisionArea = pOther->_pChecker->_pCollisionArea;
            if (pCollisionArea->_hit_colli_part_index >= 0) {
                GgafDx::CollisionPart* pPart = pCollisionArea->_papColliPart[pCollisionArea->_hit_colli_part_index];
                dX2 = (_x - (pOther->_x + pPart->_cx));
                dY2 = (_y - (pOther->_y + pPart->_cy));
                dZ2 = (_z - (pOther->_z + pPart->_cz));
            } else {
                dX2 = (_x - pOther->_x);
                dY2 = (_y - pOther->_y);
                dZ2 = (_z - pOther->_z);
            }
        }

        if (dX2 == 0 && dY2 == 0 && dZ2 == 0) {
            vx2 = vy2 = vz2 = 0;
        } else {
            UTIL::getNormalizedVector(dX2, dY2, dZ2,
                                     vx2, vy2, vz2 );
        }

        float vx3, vy3, vz3;
        UTIL::getNormalizedVector(
                    vx1+vx2, vy1+vy2, vz1+vz2,
                    vx3, vy3, vz3);
        setBlownVelo(vx3*PX_C(40), vy3*PX_C(40), vz3*PX_C(40), 0.8);
        setInvincibleFrames(120);
    }
    if (pOther->lookUpKind() & KIND_ITEM)  {
    } else {
        UTIL::activateExplosionEffectOf(this);
        getSeTransmitter()->play3D(SE_DAMAGED);
    }
}


void MyShip::setMoveSpeed(velo prm_speed_velo) {
    //lv_MoveSpeed_ = lv;
    //mv_speed_ = PX_C(lv);
    mv_speed_ = prm_speed_velo;
    veloBeginMT_ = mv_speed_ * 20;
}

void MyShip::onCatchEvent(hashval prm_no, void* prm_pSource) {
}

void MyShip::setBlownVelo(velo prm_blown_veloX, velo prm_blown_veloY, velo prm_blown_veloZ, double prm_r_blown_velo_attenuate) {
    blown_veloX_ += prm_blown_veloX;
    blown_veloY_ += prm_blown_veloY;
    blown_veloZ_ += prm_blown_veloZ;
    r_blown_velo_decay_ = prm_r_blown_velo_attenuate;
}

void MyShip::setInvincibleFrames(int prm_frames) {
    setHitAble(false);
    invincible_frames_ = prm_frames;
}
void MyShip::updateMoveWay() {
    VirtualButton* pVbPlay = VB_PLAY;
    dir26 pos_camera = pVAM->getPosCam();
    dir26 pos_up = pVAM->getPosUp();
    dir26* pa_dir8 = VamSysCamWorker::cam_to_8dir_[pos_camera]; //WQbg
    //UPTB
    int up_idx = 0;
    for (int i = 0; i < 8; i++) {
        if (pos_up == pa_dir8[i]) {
            up_idx = i; //UPCfbNXۑ
        }
    }
    //pa_dir8[up_idx] ł
    bool isPressed_VB_UP    = pVbPlay->isPressed(VB_UP);
    bool isPressed_VB_DOWN  = pVbPlay->isPressed(VB_DOWN);
    bool isPressed_VB_LEFT  = pVbPlay->isPressed(VB_LEFT);
    bool isPressed_VB_RIGHT = pVbPlay->isPressed(VB_RIGHT);
    int mv_dir = -1; //͕ԍ0~7(ォÊW)
    if (isPressed_VB_UP) {
        if (isPressed_VB_RIGHT) {
            mv_dir = 1; //E
        } else if (isPressed_VB_LEFT) {
            mv_dir = 7; //
        } else {
            mv_dir = 0; //
        }
    } else if (isPressed_VB_DOWN) {
        if (isPressed_VB_RIGHT) {
            mv_dir = 3; //E
        } else if (isPressed_VB_LEFT) {
            mv_dir = 5; //
        } else {
            mv_dir = 4; //
        }
    } else if (isPressed_VB_RIGHT) {
        mv_dir = 2;
    } else if (isPressed_VB_LEFT) {
        mv_dir = 6;
    }
    dir26 new_mv_way = DIR26(0, 0, 0);
    if (mv_dir > -1) {
        int dir_8_idx = (up_idx + mv_dir) % 8;
        new_mv_way = pa_dir8[dir_8_idx];
    }
    prev_way_ = mv_way_;
    mv_way_ = new_mv_way;
    Direction26Util::cnvDirNo2Sgn(mv_way_,
                                  mv_way_sgn_x_, mv_way_sgn_y_, mv_way_sgn_z_);
    is_just_change_mv_way_ = (prev_way_ != mv_way_ ? true : false);
}

void MyShip::moveNomal() {
    const dir26 mv_way = mv_way_;
    float vx,vy,vz;
    Direction26Util::cnvDirNo2Vec(mv_way, vx, vy, vz);
    _x += mv_speed_ * vx;
    _y += mv_speed_ * vy;
    _z += mv_speed_ * vz;
    if (is_just_change_mv_way_) {
        angle rz, ry;
        Direction26Util::cnvDirNo2RzRy(mv_way, rz, ry);
        getVecDriver()->setRzRyMvAng(rz, ry);
        //
        int sgn_turn = pSenakai_[mv_way] > pSenakai_[prev_way_] ? 1 : -1;
        if (sgn_turn != 0) {
            getVecDriver()->setFaceAngAcce(AXIS_X, sgn_turn*angRxAcce_MZ_);
            getVecDriver()->setStopTargetFaceAng(AXIS_X, pSenakai_[mv_way],
                                              TURN_CLOSE_TO,
                                              angRxTopVelo_MZ_);
        }
    }
}

void MyShip::moveTurbo() {
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    float vx,vy,vz;
    Direction26Util::cnvDirNo2Vec(mv_way_, vx, vy, vz);
    pGeoDriver->addVxMvVelo(veloBeginMT_ * vx);
    pGeoDriver->addVyMvVelo(veloBeginMT_ * vy);
    pGeoDriver->addVzMvVelo(veloBeginMT_ * vz);
    angle rz, ry;
    Direction26Util::cnvDirNo2RzRy(mv_way_, rz, ry);
    getVecDriver()->setRzRyMvAng(rz, ry);

    //
    angle senkai = pSenakai_[mv_way_];
    if (senkai != 0) {
        double senkai_spin_speed_rate = (1.0 * D90ANG / senkai); //񎞁A90x-90xɌXꍇ 1.0A1.0 ƂȂB
        getVecDriver()->setRollFaceAngVelo(angRxVelo_BeginMZT_ * senkai_spin_speed_rate);
    }
}

MyShip::~MyShip() {
}


