#include "MyLockonController.h"

#include "LockonCursor001_Main.h"
#include "LockonCursor001_Sub.h"
#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"

using namespace GgafLib;
using namespace VioletVreath;

/** PIvV̍ő\bNI */
const int MyLockonController::max_lockon_num_ = 8;
int MyLockonController::lockon_num_ = 0;

MyLockonController::MyLockonController(const char* prm_name) :
        GgafCore::DestructActor(prm_name) {
    _class_name = "MyLockonController";
    pMainLockonEffect_ = NEW LockonCursor001_Main("MAIN");
    pMainLockonEffect_->inactivate();
    appendChild(pMainLockonEffect_);
    for (int i = 1; i < MyLockonController::max_lockon_num_; i++) {
        std::string name = "ChildLockon("+XTOS(i)+")";
        LockonCursor001_Sub* pLockonCursor_Sub = NEW LockonCursor001_Sub(name.c_str());
        pLockonCursor_Sub->inactivate();
        appendChild(pLockonCursor_Sub);
    }
}

void MyLockonController::initialize() {
}
void MyLockonController::onReset() {
    //bNI^[Qbg̃Xgɂ
    listTarget_.removeAll();
    //bNIAN^[̃Zbg
    LockonCursor001* pLockonCursor001;
    for (int i = 0; i < MyLockonController::max_lockon_num_; i++) {
        pLockonCursor001 = (LockonCursor001*)(getChild(i));
        pLockonCursor001->releaseLockon();
        pLockonCursor001->inactivate();
    }
}

void MyLockonController::onActive() {
    onReset();
}


void MyLockonController::processBehavior() {
    //bNI^[QbgmF
    GgafDx::GeometricActor* pMainLockonTarget = listTarget_.getCurrent(); //CbNĨ^[Qbg
    GgafDx::GeometricActor* pTarget = listTarget_.getCurrent();  //^[QbgJ[\
    GgafCore::MainActor* pLockonEffect_Active = (GgafCore::MainActor*)getChildFirst();         //bNIGtFNgJ[\
    int n = listTarget_.length();
    for (int i = 0; i < n; i++) {
        if (pTarget->isActiveInTheTree() && pTarget->getStatus()->get(STAT_Stamina) > 0) {
            //^[QbgȂ
            //GtFNgAN^[̃^[QbgXVAGtFNgYƂ܂
            ((LockonCursor001*)pLockonEffect_Active)->lockon(pTarget);
            if (!pLockonEffect_Active->isActiveInTheTree()) {
                pLockonEffect_Active->activate();
            }
            pLockonEffect_Active = pLockonEffect_Active->getNext(); //񏈗bNIGtFNgAN^[
            pTarget = listTarget_.next();                         //񏈗^[Qbg
        } else {
            //^[QbgS
            if (pTarget == pMainLockonTarget) {
                //S^[QbgCbNĨ^[Qbgłꍇ
                if (listTarget_.length() == 1) {
                    //S^[QbgCbNĨ^[QbgŃO̍Ō̈̏ꍇ
                    listTarget_.remove();                                    //^[Qbgo
                    ((LockonCursor001*)pLockonEffect_Active)->releaseLockon(); //bNIGtFNg[Xs
                    pTarget = nullptr;
                    break;
                } else {
                    //S^[QbgCbNĨ^[QbgŃO̍Ō̈ł͖ꍇ
                    listTarget_.remove();               //^[Qbgo
                    pTarget = listTarget_.getCurrent(); //񏈗^[Qbgցiremove()ɂ莟̃^[QbggetCurrent()ƂȂj
                    pMainLockonTarget = pTarget;          //CbNĨ^[QbgXV
                    //CbNIGtFNg𒼋߃bNI֖߂
                    //CbNIGtFNg̎̃GtFNgƂ
                    ((LockonCursor001*)pLockonEffect_Active->getNext())->releaseLockon(); //uṽbNIGtFNg[Xs
                    pLockonEffect_Active->getNext()->moveLast();               //̃bNIGtFNg𖖔
                    //u񏈗bNIGtFNgAN^[ցv̏Ώۈړ͕svBɏbNIGtFNgAN^[̂܂܂ł邽߁B
                }
            } else {
                //S^[QbgTubNĨ^[Qbgłꍇ
                listTarget_.remove();               //^[Qbgo
                pTarget = listTarget_.getCurrent(); //񏈗^[Qbgցiremove()ɂ莟̃^[QbggetCurrent()ƂȂj
                ((LockonCursor001*)pLockonEffect_Active)->releaseLockon(); //bNIGtFNg[Xs
                pLockonEffect_Active = pLockonEffect_Active->getNext();    //񏈗bNIGtFNgAN^[
                pLockonEffect_Active->getPrev()->moveLast();    //񏈗bNIGtFNgAN^[𖖔
            }
        }
    }
}

void MyLockonController::processJudgement() {
}

void MyLockonController::onInactive() {
    onReset();
}

void MyLockonController::lockon(GgafDx::GeometricActor* prm_pTarget) {
    if (MyLockonController::lockon_num_ == 0) {
        return; //݂̃bNI\0
    }

    if (listTarget_.indexOf(prm_pTarget) == -1) {
        //bNIς݂ɖ̂ŁAbNI
        if (listTarget_.length() >= MyLockonController::lockon_num_) { //^[QbgXgɖ̏ꍇ
            //bNI^[Qbg[e[g
            listTarget_.prev();           //JgŏIvf
            listTarget_.set(prm_pTarget, false); //ŏIvfƂɃC^[Qbg㏑
            //bNIGtFNgAN^[͂̂܂
            //ɂAprocessBehavior() ̃^[Qbĝɂ
            //YbƂB
        } else {   //܂^[QbgXgɉȂA͗]Tiǉ\ȏꍇj
            //^[Qbg[e[g
            listTarget_.addPrev(prm_pTarget, false);
            listTarget_.prev();
            //bNIGtFNg
            if (listTarget_.length() == 1) {
                //ŏ̃bNI^[QbgǉiCbNI^[Qbgj
                GgafCore::MainActor* pLockonEffect = (GgafCore::MainActor*)getChildFirst(); //CbNIGtFNg
                pLockonEffect->activate();
                ((LockonCursor001*)pLockonEffect)->lockon(prm_pTarget);

                //ŏ̃bNI^[QbgȊO̒ǉiTubNI^[Qbgǉj
            } else if (listTarget_.length() > 1) {
                //ChildbNIǉ
                if (listTarget_.length() >= 3) {
                    //Rڂ̈ȍ~^[QbgǉiQڈȍ~̃TubNI^[Qbgǉj
                    //bNIGtFNg̓ȃ[e[gsBiŌ̃Rgǉ̏ꍇQƁj
                    //Last؂o
                    GgafCore::MainActor* pLockonEffect = (GgafCore::MainActor*)getChildFirst()->getPrev(); //Last
                    GgafCore::MainActor* pLockonEffect_Next = pLockonEffect->getNext(); //MainbNIƂȂ
                    GgafCore::MainActor* pLockonEffect_Prev = pLockonEffect->getPrev();
                    pLockonEffect_Prev->_pNext = pLockonEffect_Next;
                    pLockonEffect_Next->_pPrev = pLockonEffect_Prev;
                    pLockonEffect_Prev->_is_last_flg = true;
                    pLockonEffect->_is_last_flg = false;
                    //First->Next ̊Ԃɓ
                    GgafCore::MainActor* pMainLockonEffect = (GgafCore::MainActor*)getChildFirst();
                    GgafCore::MainActor* pMainLockonEffect_Next = (GgafCore::MainActor*)getChildFirst()->getNext();
                    pMainLockonEffect->_pNext = pLockonEffect;
                    pLockonEffect->_pPrev = pMainLockonEffect;
                    pLockonEffect->_pNext = pMainLockonEffect_Next;
                    pMainLockonEffect_Next->_pPrev = pLockonEffect;
                    pLockonEffect->activate(); //TubNIL
                    //TubNIGtFNgbNII
                    ((LockonCursor001*)pLockonEffect)->lockon(listTarget_.getNext());
                } else {
                    //Qڂ̃^[Qbgǉiŏ̃TubNI^[Qbgǉj
                    GgafCore::MainActor* pLockonEffect = (GgafCore::MainActor*)getChildFirst()->getPrev(); //QȂ̂ŌNexẗʒu
                    pLockonEffect->activate(); //TubNIL
                    ((LockonCursor001*)pLockonEffect)->lockon(listTarget_.getNext());
                }
            }
        }
    } else {
        //prm_pTarget ͊ɃbNIς
    }
}

void MyLockonController::releaseAllLockon() {
    if (listTarget_.length() == 0) {
        return;
    }
    listTarget_.removeAll();
    //bNIGtFNgCANeBuɂ
    GgafCore::MainActor* pLockonEffect = (GgafCore::MainActor*)getChildFirst();
    while (pLockonEffect) {
        ((LockonCursor001*)pLockonEffect)->releaseLockon();
        if (pLockonEffect->isLast()) {
            break;
        } else {
            pLockonEffect = pLockonEffect->getNext();
        }
    }
}

MyLockonController::~MyLockonController() {
}

void MyLockonController::dumpTarget(GgafDx::GeometricActor* pMain) {
    if (listTarget_.getFromFirst(0) == nullptr) {
        _TRACE_N_("nullptr\n");
        return;
    } else {
        _TRACE_N_("");
    }
    for (int i = 0; i < listTarget_.length(); i++) {
        if (listTarget_.getFromFirst(i) == pMain) {
            _TRACE_N_("I");
        }
        _TRACE_N_(listTarget_.getFromFirst(i)->getName()<<"["<<i<<"]");
    }
    _TRACE_N_(" ... avtive="<<listTarget_.getCurrent()->getName()<<"\n");
}

//yY^z
//ubNI^[Qbg(G)ƃbNIGtFNg(Ə)̊֌Wv(2010/09/14)
//
//bNIAbNI[X
//bNI^[QbgƃbNIGtFNg̊֌WƂĎcB
//
//l      c CbNIGtFNg
//S0`S3  c TubNIGtFNg
//t1`t5  c bNI^[Qbg
//
//CbNIGtFNg(l)̏ꏊɈʒu郍bNI^[Qbg
//uCbNI^[Qbgv
//TubNIGtFNg(S0`S3)̏ꏊɈʒu郍bNI^[Qbg
//uTubNI^[Qbgv
//ƌĂԂƂɂB

//ǉ̏ꍇ
// ̂lS0S1S2S3    EEEGtFNgAN^[
//                      t1bNI
// t1
// GtFNgAN^[ω
//                      t2ǉbNI
// t2t1
// ̂lS3S0S1S2
//                      t3ǉbNI
// t3t2t1
// ̂lS2S3S0S1
//                      t4ǉbNI
// t4t3t2t1
// ̂lS1S2S3S0
//                      t5ǉbNI
// t5t4t3t2t1
// ̂lS0S1S2S3

// Œǉ̏ꍇ
// ̂lS0S1S2S3    EEEGtFNgAN^[͑sv
//
// t5t4t3t2t1
// t6t5t4t3t2   Y
// t7t6t5t4t3   Y
// t8t7t6t5t4   Y
// t9t8t7t6t5   YƂ܂

//S̏ꍇ
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t1)
// t5t4t3t2
// ̂lS0S1S2S3    EEEωiS3ցjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t2)
// t5t4t3t1
// ̂lS0S1S3S2    EEES2ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t3)
// t5t4t2t1
// ̂lS0S2S3S1    EEES1ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t4)
// t5t3t2t1
// ̂lS2S3S1S0    EEES0ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t5)
// t4t3t2t1
// ̂lS1S2S3S0    EEE S0ցiӁjړlockonRelase()



//؂ꍇ2
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t1)
// t4t3t1
// ̂lS0S1S3S2    EEES2ցiȗHjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t2)
// t4t3t1
// ̂lS0S2S3S1    EEES1ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t3)
// t4t2t1
// ̂lS1S2S3S0    EEES0ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t4)
// t3t2t1
// ̂lS1S2S3S0    EEES0ցiӁjړlockonRelase()



//؂ꍇ3
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t3t2t1
//              remove(t1)
// t3t2
// ̂lS0S2S3S1    EEES1ցiȗHjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t3t2t1
//              remove(t2)
// t3t1
// ̂lS1S2S3S0    EEES0ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t3t2t1
//              remove(t3)
// t2t1
// ̂lS1S2S3S0    EEES0ֈړlockonRelase()



//؂ꍇ4
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t2t1
//              remove(t1)
// t2
// ̂lS1S2S3S0    EEES0ցiȗHjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t2t1
//              remove(t2)
// t2t1
// ̂lS1S2S3S0    EEES0wړlockonRelase()


//؂ꍇ5
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t1
//              remove(t1)
//
// ̂lS1S2S3S0    EEEωMlockonRelase()
