#include "CostDispBar.h"

#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include "jp/ggaf/lib/util/Quantity.hpp"



using namespace GgafLib;
using namespace VioletVreath;

CostDispBar::CostDispBar(const char* prm_name, FramedHorizontalBarActor* prm_pTargetSourceBar)
      : FramedHorizontalBarActor(prm_name, "CostDispBar") {
    _class_name = "CostDispBar";
    pSourceBar_ = prm_pTargetSourceBar;
}

void CostDispBar::initialize() {
    setAlpha(0.7); //̒lg
}

void CostDispBar::onReset() {
    setPositionAt(pSourceBar_);
    _sy = pSourceBar_->_sy;
    setVal(0);
}

void CostDispBar::onActive() {
    setPositionAt(pSourceBar_);
    _sy = pSourceBar_->_sy;
    setVal(0);
}

void CostDispBar::processBehavior() {
}


void CostDispBar::processJudgement() {
}

void CostDispBar::processPreDraw() {
    _x = pSourceBar_->_x + pSourceBar_->getCoordWidth(); //pSourceBar_[̍W
    coord bar_width = getCoordWidth();
    if (bar_width >= 0) {
        getUvFlipper()->setActivePtn(4);//
        setAlign(ALIGN_LEFT);
        setValByCoordWidth(bar_width);
    } else {
        getUvFlipper()->setActivePtn(0);//
        setAlign(ALIGN_RIGHT);
        setValByCoordWidth(-bar_width);
    }
    FramedHorizontalBarActor::processPreDraw();
}
void CostDispBar::onInactive() {
}

CostDispBar::~CostDispBar() {
}
