#include "MagicMeter.h"

#include "jp/ggaf/core/util/LinkedListRing.hpp"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include "jp/ggaf/dx/effect/MassBoardEffect.h"
#include "jp/ggaf/dx/model/MassBoardModel.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/CostDispBar.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/DamageDispBar.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/MpBar.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/LaserMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/ShotMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/LockonMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/Magic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/SmileMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/SpeedMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TorpedoMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TractorMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/VreathMagic.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/MagicLvCursor001.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/MagicLvCursor002.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/MagicLvCursor003.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/MagicMeterCursor001.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/MagicMeterStatus.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/VreathBar.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/ggaf/dx/sound/Se.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/BunshinMagic.h"



using namespace GgafLib;
using namespace VioletVreath;

enum {
    SE_CURSOR_MOVE_METER       ,
    SE_CURSOR_MOVE_LEVEL       ,
    SE_CURSOR_MOVE_LEVEL_CANCEL,
    SE_CURSOR_BAD_MOVE         ,
    SE_EXECUTE_LEVELUP_MAGIC   ,
    SE_EXECUTE_LEVELDOWN_MAGIC ,
    SE_EXECUTE_CANCEL_LEVELUP_MAGIC   ,
    SE_EXECUTE_CANCEL_LEVELDOWN_MAGIC ,
    SE_NG_MP_IS_SHORT       ,
    SE_EFFECT_MAGIC    ,
    SE_NOTICE_LEVELDOWN_MAGIC,
    SE_BAD_OPERATION   ,
};

MagicMeter::MagicMeter(const char* prm_name, int* prm_pMP_MyShip, int* prm_pVreath_MyShip)
      : DefaultMassBoardActor(prm_name, "128,MagicMeter"),
width_px_(_pMassBoardModel->_model_width_px),
height_px_(_pMassBoardModel->_model_height_px),
width_(PX_C(width_px_)),
height_(PX_C(height_px_)) {

    _class_name = "MagicMeter";
    pTractorMagic_ = NEW TractorMagic("TRACTOR", prm_pMP_MyShip); //ێRXgL
    pSpeedMagic_   = NEW SpeedMagic("SPEED", prm_pMP_MyShip);
    pLockonMagic_  = NEW LockonMagic("LOCKON", prm_pMP_MyShip);
    pTorpedoMagic_ = NEW TorpedoMagic("TORPEDO", prm_pMP_MyShip);
    pShotMagic_    = NEW ShotMagic("SHOT", prm_pMP_MyShip);
    pLaserMagic_   = NEW LaserMagic("LASER", prm_pMP_MyShip);
    pBunshinMagic_ = NEW BunshinMagic("BUNSHIN", prm_pMP_MyShip);
    pVreathMagic_  = NEW VreathMagic("VREATH", prm_pMP_MyShip);
    pSmileMagic_   = NEW SmileMagic("SMILE", prm_pMP_MyShip); //@
    lstMagic_.addLast(pTractorMagic_);
    lstMagic_.addLast(pSpeedMagic_  );
    lstMagic_.addLast(pLockonMagic_ );
    lstMagic_.addLast(pTorpedoMagic_);
    lstMagic_.addLast(pShotMagic_   );
    lstMagic_.addLast(pLaserMagic_  );
    lstMagic_.addLast(pBunshinMagic_);
    lstMagic_.addLast(pVreathMagic_ );
    lstMagic_.addLast(pSmileMagic_  );
    lstMagic_.createIndex();

    int magic_num = lstMagic_.length();
    for (int i = 0; i < magic_num; i++) {
        appendGroupChild(lstMagic_.getNext(i));
    }

    papLvTgtMvCur_   = NEW MagicLvCursor001*[magic_num];
    papLvNowCur_     = NEW MagicLvCursor002*[magic_num];
    papLvCastingCur_ = NEW MagicLvCursor003*[magic_num];
    r_roll_      = NEW float[magic_num];
    r_roll_velo_ = NEW float[magic_num];
    Magic* pMagic;
    MagicList::Elem* pMagicElem = lstMagic_.getElemFirst();
    for (int i = 0; i < magic_num; i++) {
        pMagic = pMagicElem->getValue();
        papLvNowCur_[i] = NEW MagicLvCursor002("LvHilightCursor", this, pMagic); //xJ[\
        papLvCastingCur_[i] = NEW MagicLvCursor003("LvCastMarkCursor", this, pMagic); //rxJ[\
        papLvCastingCur_[i]->markOff();
        papLvTgtMvCur_[i] = NEW MagicLvCursor001("LvTargetCursor", this, pMagic); //[^⏕J[\
        pMagicElem = pMagicElem->_pNext;
    }
    for (int i = 0; i < magic_num; i++) {
        r_roll_[i] = 0.0f;
        r_roll_velo_[i] = 0.0f;
    }

    //\vIeBlāAappendGroupChildsI
    for (int i = 0; i < magic_num; i++) {
        appendGroupChild(papLvNowCur_[i]); //xJ[\
    }
    for (int i = 0; i < magic_num; i++) {
        appendGroupChild(papLvCastingCur_[i]); //rxJ[\
    }
    for (int i = 0; i < magic_num; i++) {
        appendGroupChild(papLvTgtMvCur_[i]); //[^⏕J[\
    }

    const int mp_max_val = MY_SHIP_MAX_MP;
    const coord mp_disp_width = PX_C(800); //ʕ\̉800sNZB
    const int vreath_max_val = *prm_pVreath_MyShip; //ŏ^炱gp
    const coord vreath_disp_width = PX_C(800);  //ʕ\̉sNZB
    //MPo[ݒu
    pMpBar_ = NEW MpBar("MpBar");
    pMpBar_->linkVariable(prm_pMP_MyShip);
    pMpBar_->scale(0, mp_max_val, mp_disp_width);
    appendGroupChild(pMpBar_);
    //Vreatho[ݒu
    pVreathBar_ = NEW VreathBar("VreathBar");
    pVreathBar_->linkVariable(prm_pVreath_MyShip);
    pVreathBar_->scale(0, vreath_max_val, vreath_disp_width);
    appendGroupChild(pVreathBar_);

    //GlM[o[̃RXg\o[
    pMpCostDispBar_ = NEW CostDispBar("CostDispBar", pMpBar_);
    pMpCostDispBar_->scale(-mp_max_val, +mp_max_val, mp_disp_width*2);
    appendGroupChild(pMpCostDispBar_);
    //Vreatho[ARXg\o[
    pVreathCostDispBar_ = NEW CostDispBar("CostDispBar2", pVreathBar_);
    pVreathCostDispBar_->scale(-vreath_max_val, +vreath_max_val, vreath_disp_width*2);
    appendGroupChild(pVreathCostDispBar_);
    //Vreatho[A_[W\o[
    pDamageDispBar_ = NEW DamageDispBar("DamageDispBar", pVreathBar_);
    pDamageDispBar_->scale(-vreath_max_val, +vreath_max_val, vreath_disp_width*2);
    appendGroupChild(pDamageDispBar_);

    //c@ʎԕ\
    pMagicMeterStatus_ = NEW MagicMeterStatus("MagicMeterStatus", this);
    appendGroupChild(pMagicMeterStatus_);

    //[^J[\
    pMainCur_ = NEW MagicMeterCursor001("MagicCursor", this);
    appendGroupChild(pMainCur_);

    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_CURSOR_MOVE_METER             , "WAVE_MM_CURSOR_MOVE_METER");  //僁[^[J[\ړ
    pSeTx->set(SE_CURSOR_MOVE_LEVEL             , "WAVE_MM_CURSOR_MOVE_LEVEL");  //㉺xړ
    pSeTx->set(SE_CURSOR_MOVE_LEVEL_CANCEL      , "WAVE_MM_CURSOR_MOVE_LEVEL_CANCEL");  //㉺xړLZij
    pSeTx->set(SE_CURSOR_BAD_MOVE               , "WAVE_MM_CURSOR_BAD_MOVE");  //_ȃJ[\ړiƂ邳̂Ōݖgpj
    pSeTx->set(SE_EXECUTE_LEVELUP_MAGIC         , "WAVE_MM_EXECUTE_LEVELUP_MAGIC");  //xAbvs
    pSeTx->set(SE_EXECUTE_LEVELDOWN_MAGIC       , "WAVE_MM_EXECUTE_LEVELDOWN_MAGIC");  //x_Es
    pSeTx->set(SE_EXECUTE_CANCEL_LEVELUP_MAGIC  , "WAVE_MM_EXECUTE_CANCEL_LEVELUP_MAGIC");  //irLZājxAbvs
    pSeTx->set(SE_EXECUTE_CANCEL_LEVELDOWN_MAGIC, "WAVE_MM_EXECUTE_CANCEL_LEVELDOWN_MAGIC");  //irLZājx_Es
    pSeTx->set(SE_NG_MP_IS_SHORT                , "WAVE_MM_NG_MP_IS_SHORT");  //MPȂߔ邢͌ʊJnłȂꍇ
    pSeTx->set(SE_EFFECT_MAGIC                  , "WAVE_MM_EFFECT_MAGIC");  //Aʔ
    pSeTx->set(SE_NOTICE_LEVELDOWN_MAGIC        , "WAVE_MM_NOTICE_LEVELDOWN_MAGIC");  //x_E\
    pSeTx->set(SE_BAD_OPERATION                 , "WAVE_MM_BAD_OPERATION");  //~XBoȂ́Auu[

    pSeTx4Cast_ = NEW GgafDx::SeTransmitterForActor(this);
    pSeTx4Invoke_ = NEW GgafDx::SeTransmitterForActor(this);
    for (int i = 0; i < magic_num; i++) {
        pSeTx4Cast_->set(i, "WAVE_MM_CASTING", i); //rSEB`lw
        pSeTx4Invoke_->set(i, "WAVE_MM_INVOKING", i); //SEB`lw
    }
    fraeme_of_notice_remaind_ = 60*5;//c͂x̎c莞
    alpha_velo_ = -0.01f;

    //CX^Xf[^
    max_draw_num_ = 0;
    int len_magics = lstMagic_.length();
    MagicList::Elem* pElem = lstMagic_.getElemFirst();
    for (int i = 0; i < len_magics; i++) {
        max_draw_num_++; //}WbN[^[wi
        max_draw_num_++; //}WbN[^[݂̌̃}WbNx\
        pMagic = pElem->getValue();//̂ŃANeBuł͂
        int lv_slecter_num = pMagic->max_level_+1;
        for (int j = 0; j < lv_slecter_num; j++) {
            max_draw_num_++;  //e}WbNvf
        }
        pElem = pElem->_pNext;
    }
    static const size_t size_of_D3DCOLORVALUE = sizeof(D3DCOLORVALUE);
    paInstancedata_MM_ = NEW VERTEX_instancedata[max_draw_num_];
    paInstancedata_MM_[0].px_x = C_PX(_x);
    paInstancedata_MM_[0].px_y = C_PX(_y);
    paInstancedata_MM_[0].depth_z = C_PX(_z);
    paInstancedata_MM_[0].local_px_x = 0.0f;
    paInstancedata_MM_[0].local_px_y = 0.0f;
    paInstancedata_MM_[0].r_sx = SC_R(_sx);
    paInstancedata_MM_[0].r_sy = SC_R(_sy);
    paInstancedata_MM_[0].rad_rz = ANG_RAD(_rz);
    paInstancedata_MM_[0].offset_u = 0;
    paInstancedata_MM_[0].offset_v = 0;
    memcpy(&(paInstancedata_MM_[0].r), &(_paMaterial[0].Diffuse), size_of_D3DCOLORVALUE);
    for (int i = 1; i < max_draw_num_; i++) {
        paInstancedata_MM_[i] = paInstancedata_MM_[0]; //Rs[ď
    }
}

void MagicMeter::loadStatus(int prm_saveno) {
    st_[prm_saveno].seekg(std::stringstream::beg); //o
    loadProperties(st_[prm_saveno]);
}

void MagicMeter::saveStatus(int prm_saveno) {
    save(st_[prm_saveno]);
}

void MagicMeter::save(std::stringstream& sts) {
    sts << pMpBar_->getVal() << " ";
    Magic* pOrgMagic = lstMagic_.getCurrent();
    int len_magics = lstMagic_.length();
    for (int i = 0; i < len_magics; i++) {
        pOrgMagic->save(sts);
        pOrgMagic = lstMagic_.next();
    }
}

void MagicMeter::loadProperties(std::stringstream& sts) {
    int mp;
    sts >> mp;
    pMpBar_->setVal(mp);

    Magic* pOrgMagic = lstMagic_.getCurrent();
    int len_magics = lstMagic_.length();
    for (int i = 0; i < len_magics; i++) {
        pOrgMagic->loadProperties(sts);
        pOrgMagic = lstMagic_.next();
    }
}

void MagicMeter::initialize() {
    pMpBar_->setPosition(_x, _y + height_ + PX_C(16));
    pVreathBar_->setPosition(pMpBar_->_x, pMpBar_->_y + PX_C(16));
    pMagicMeterStatus_->setPositionAt(this);

    getUvFlipper()->exec(FLIP_ORDER_LOOP, 10); //Aj
    Magic* pMagic;
    for (int i = 0; i < lstMagic_.length(); i++) {
        pMagic = lstMagic_.getFromFirst(i);
        papLvTgtMvCur_[i]->moveTo(pMagic->level_);
        papLvNowCur_[i]->moveTo(pMagic->level_);
        papLvCastingCur_[i]->moveTo(0);
        papLvCastingCur_[i]->markOff();
    }
}
void MagicMeter::onReset() {
    Magic* pMagic;
    for (int i = 0; i < lstMagic_.length(); i++) {
        pMagic = lstMagic_.getFromFirst(i);
        pMagic->resetTree(); //MagicZbgB
        papLvTgtMvCur_[i]->moveTo(pMagic->level_);
        papLvNowCur_[i]->moveTo(pMagic->level_);
        papLvCastingCur_[i]->moveTo(0);
        papLvCastingCur_[i]->markOff();

        r_roll_[i] = 0.0f;
        r_roll_velo_[i] = 0.0f;

        pSeTx4Cast_->stop(i);
        pSeTx4Invoke_->stop(i);
    }
    pMpCostDispBar_->setVal(0);
    pVreathCostDispBar_->setVal(0);
    pDamageDispBar_->setVal(0);
}

void MagicMeter::onActive() {
}

void MagicMeter::processBehavior() {
    ////////////////////////e@ɂĂ̏//////////////////////////
    GgafCore::Progress* pMagicProg;
    Magic* pMagic = nullptr;
    int pMagic_level, pMagic_new_level;
    MagicLvCursor001* pLvTgtMvCur;
    MagicLvCursor002* pLvNowCur;
    MagicLvCursor003* pLvCastingCur;

    for (int m = 0; m < lstMagic_.length(); m++) {
        pMagic = lstMagic_.getFromFirst(m);    //@IuWFNg
        pMagicProg = pMagic->_pProg;           //@̐i
        pMagic_level = pMagic->level_;         //@̌x
        pMagic_new_level = pMagic->new_level_; //@̐VxirȄꍇj
        pLvTgtMvCur = papLvTgtMvCur_[m];       //J[\IuWFNg(ړ)
        pLvNowCur = papLvNowCur_[m];           //x\pJ[\IuWFNg
        pLvCastingCur = papLvCastingCur_[m];   //rx\pJ[\IuWFNgiCASTINGȂǂ̕j

        //[Abv
        r_roll_[m] += r_roll_velo_[m];
        if (r_roll_[m] < 0.0f) {
            r_roll_[m] = 0.0f;
            r_roll_velo_[m] = 0.0f;
        }
        if (r_roll_[m] > 1.0f) {
            r_roll_[m] = 1.0f;
            r_roll_velo_[m] = 0.0f;
        }

        //rJn
        if (pMagicProg->hasJustChangedTo(Magic::STATE_CASTING)) {
            switch (pMagic->last_cast_) {
                case MAGIC_CAST_OK_LEVELUP: {
                    getSeTransmitter()->play(SE_EXECUTE_LEVELUP_MAGIC);
                    pSeTx4Cast_->play(m, true);
                    pLvTgtMvCur->blink(); //sJsJI
                    pLvCastingCur->markOnLevelUpCast(pMagic_new_level);
                    break;
                }
                case MAGIC_CAST_LEVELDOWN: {
                    getSeTransmitter()->play(SE_EXECUTE_LEVELDOWN_MAGIC);
                    pLvTgtMvCur->blink(); //sJsJI
                    pLvNowCur->moveSmoothTo(pMagic_new_level);
                    pLvNowCur->blink();
                    if (pMagic_new_level > 0) {
                        //x0ȊOւ̃x_EȂ EFFECT GtFNg
                        pLvCastingCur->markOnLevelDownCast(pMagic_new_level);
                    }
                    break;
                }
                case MAGIC_CAST_OK_CANCEL_AND_LEVELUP: {
                    if ( pLvCastingCur->point_lv_ ==  pLvTgtMvCur->point_lv_) {
                        //݉r̃xōēx
                        //ȂɂȂ
                    } else {
                        getSeTransmitter()->play(SE_EXECUTE_CANCEL_LEVELUP_MAGIC);
                        pSeTx4Cast_->play(m);
                        pLvTgtMvCur->blink(); //sJsJI
                        pLvCastingCur->markOnLevelUpCast(pMagic_new_level);
                    }
                    break;
                }
                case MAGIC_CAST_CANCEL_AND_LEVELDOWN: {
                    getSeTransmitter()->play(SE_EXECUTE_CANCEL_LEVELDOWN_MAGIC);
                    pLvTgtMvCur->blink(); //sJsJI
                    pLvNowCur->moveSmoothTo(pMagic_new_level);
                    pLvNowCur->blink();
                    if (pMagic_new_level > 0) {
                        //x0ȊOւ̃x_EȂ EFFECT GtFNg
                        pLvCastingCur->markOnLevelDownCast(pMagic_new_level);
                    } else {
                        //x0ȊOւ̃x_EȂ΁A܂B
                        pLvCastingCur->markOff();
                    }
                    break;
                }
                default: {
                    throwCriticalException("["<<pMagic->getName()<<"] B͂ȂBpMagic->last_cast_="<<(pMagic->last_cast_));
                    break;
                }
            }
        }
        //r
        if (pMagicProg->get() == Magic::STATE_CASTING) {
            if (pMagic->new_level_ > pMagic_level) {
                //xAbvȂ特Abv
                float r = ((float)(pMagicProg->getFrame())) / ((float)(pMagic->time_of_next_state_));
                pSeTx4Cast_->getSe(m)->setFrequencyRate(1.0f + (r*3.0f));
            }
        }
        //rł͂ȂȂ
        if (pMagicProg->hasJustChangedFrom(Magic::STATE_CASTING)) {
            pSeTx4Cast_->stop(m); //
        }

        //Jn
        if (pMagicProg->hasJustChangedTo(Magic::STATE_INVOKING)) {
            switch (pMagic->last_invoke_) {
                case MAGIC_INVOKE_OK_LEVELUP: {
                    pSeTx4Invoke_->play(m, true);
                    pLvTgtMvCur->dispDisable(); //s\
                    pLvNowCur->dispDisable();
                    if (pLvTgtMvCur->point_lv_ == pMagic_level) {
                        //J[\xwĂꍇɌ
                        //Vxɂ蓮ĂB
                        pLvTgtMvCur->moveSmoothTo(pMagic_new_level);
                    }
                    frame invoking_frames = (frame)(pMagic->level_up_invoking_frames_[pMagic_level][pMagic_new_level]);
                    pLvNowCur->moveSmoothTo(pMagic_new_level, invoking_frames); //INVOKINGɍ킹ē
                    pLvCastingCur->markOnInvoke(pMagic_new_level);
                    break;
                }
                case MAGIC_INVOKE_OK_LEVELDOWN: {
                    //x_ÉArJnɌ݃x\̃J[\ړɂȂĂB
                    //̂ŁAł͉ȂB
                    break;
                }
                default: {
                    throwCriticalException("["<<pMagic->getName()<<"] B͂ȂBpMagic->last_invoke_="<<(pMagic->last_invoke_));
                    break;
                }
            }
        }
        //
        if (pMagicProg->get() == Magic::STATE_INVOKING) {
            if (pMagic->new_level_ > pMagic_level) {
                //xAbv
                float r = ((float)(pMagicProg->getFrame())) / ((float)(pMagic->time_of_next_state_));
                pSeTx4Invoke_->getSe(m)->setFrequencyRate(1.0f + (r*3.0f));//グ
            }
        }
        //ł͂ȂȂ
        if (pMagicProg->hasJustChangedFrom(Magic::STATE_INVOKING)) {
            pSeTx4Invoke_->stop(m); //
            pLvTgtMvCur->dispEnable(); //s\
            pLvNowCur->dispEnable();
        }
        //ʊJn
        if (pMagicProg->hasJustChangedTo(Magic::STATE_EFFECT_START)) {
            switch (pMagic->last_effect_) {
                case MAGIC_EFFECT_OK_LEVELUP: {
                    if (pMagic->effecting_frames_base_ == 0) {
                        //@̏ꍇ
                        getSeTransmitter()->play(SE_EFFECT_MAGIC);
                        pLvCastingCur->markOnEffect(pMagic_level);
                    } else {
                        //ʏ햂@̏ꍇ
                        getSeTransmitter()->play(SE_EFFECT_MAGIC);
                        pLvCastingCur->markOnEffect(pMagic_level);
                    }
                    break;
                }
                case MAGIC_EFFECT_OK_LEVELDOWN: {
                    if (pMagic->effecting_frames_base_ == 0) {
                        //U@̏Ĩx_Eꍇ
                        _TRACE_(FUNC_NAME<<" ["<<pMagic->getName()<<"] U@̃x_Ẽx_E");
                        pLvNowCur->moveSmoothTo(pMagic_level);
                    } else {
                        //ʂ̃x_E
                        getSeTransmitter()->play(SE_EXECUTE_LEVELDOWN_MAGIC);
                        if (pLvTgtMvCur->point_lv_ == pMagic->last_level_) {
                            //ԖA邢MP͊A
                            //J[\x_EǑsxwĂ΁A
                            //AJ[\ꏏɈړ
                            pLvTgtMvCur->moveSmoothTo(pMagic_level);
                        }
                        pLvNowCur->moveSmoothTo(pMagic_level);
                        pLvNowCur->blink();
                        if (pMagic_level > 0) {
                            pLvCastingCur->markOnEffect(pMagic_level);
                        }
                    }
                    break;
                }
                default: {
                    throwCriticalException("["<<pMagic->getName()<<"] B͂ȂBpMagic->last_effect_="<<(pMagic->last_effect_));
                    break;
                }
            }
        }

        //STATE_NOTHINGֈڍs
        if (pMagicProg->hasJustChangedTo(Magic::STATE_NOTHING)) {
            if (pMagicProg->hasJustChangedFrom(Magic::STATE_CASTING)) { //rSTATE_NOTHING
                //rirLZ or rrMPȂj
                _TRACE_(FUNC_NAME<<" ["<<pMagic->getName()<<"] rSTATE_NOTHING rB");
                pLvCastingCur->markOff(); //}[NItI
                pLvNowCur->moveSmoothTo(pMagic_level);
                pLvTgtMvCur->moveSmoothTo(pMagic_level); //xJ[\ANeBuxɖ߂
                if (pMagic->last_invoke_ == MAGIC_INVOKE_NG_MP_IS_SHORT) {
                    _TRACE_(FUNC_NAME<<" ["<<pMagic->getName()<<"] ř MAGIC_INVOKE_NG_MP_IS_SHORT  ");
                    getSeTransmitter()->play(SE_NG_MP_IS_SHORT);
                } else {
                    getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL_CANCEL);
                }
            }
            if (pMagicProg->hasJustChangedFrom(Magic::STATE_INVOKING)) {  //STATE_NOTHING
                //󔭓iAAMPȂ̂ŁAʊJnoȂj
                _TRACE_(FUNC_NAME<<" ["<<pMagic->getName()<<"] STATE_NOTHING 󔭓 ");
                pLvCastingCur->markOff(); //}[NItI
                pLvNowCur->moveSmoothTo(pMagic_level);
                pLvTgtMvCur->moveSmoothTo(pMagic_level); //xJ[\ANeBuxɖ߂
                if (pMagic->last_effect_ == MAGIC_EFFECT_NG_MP_IS_SHORT) {
                    _TRACE_(FUNC_NAME<<" ["<<pMagic->getName()<<"] 󔭓̌ MAGIC_EFFECT_NG_MP_IS_SHORT  ");
                    getSeTransmitter()->play(SE_NG_MP_IS_SHORT);
                } else {
                    getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL_CANCEL);
                }
            }
        }

        //x_Ex
        if (pMagic->lvinfo_[pMagic_level].remained_frame_of_effecting == fraeme_of_notice_remaind_) {
            getSeTransmitter()->play(SE_NOTICE_LEVELDOWN_MAGIC);
        }
    }

//    //debug -------------->
//    if (GgafDx::Input::isPushedDownKey(DIK_K)) {
//        _TRACE_("MagicMeter saveStatus(0)!!!!");
//        saveStatus(0);
//    }
//    if (GgafDx::Input::isPushedDownKey(DIK_L)) {
//        _TRACE_("MagicMeter loadStatus(0)!!!!");
//        loadStatus(0);
//    }
//    //<-----------------debug

    ////////////////////////@[^[ɂĂ̏//////////////////////////
    VirtualButton* pVbPlay = VB_PLAY;
    MyShip* pMyShip = pMYSHIP;
    if (pMyShip->canControl() && pVbPlay->isPressed(VB_POWERUP)) {
        alpha_velo_ = 0.05f;
        Magic* pActiveMagic = lstMagic_.getCurrent();     //ANeBuȖ@
        int active_idx = lstMagic_.getCurrentIndex();     //ANeBuȖ@̃CfbNX
        progress active_prg = pActiveMagic->getProgress()->get();  //ANeBuȖ@̐i
        if (pMyShip->canControl() && pVbPlay->isPushedDown(VB_POWERUP)) {
            rollOpen(active_idx);
        }

        if (pVbPlay->isAutoRepeat(VB_RIGHT)) {    //uv
            //x\
            if (active_prg == Magic::STATE_CASTING) {
                if (papLvTgtMvCur_[active_idx]->point_lv_ != papLvCastingCur_[active_idx]->point_lv_) {
                    getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL_CANCEL);
                    papLvTgtMvCur_[active_idx]->moveSmoothTo(papLvCastingCur_[active_idx]->point_lv_); //xJ[\r惌xɖ߂
                }
            } else {
                if (papLvTgtMvCur_[active_idx]->point_lv_ != papLvNowCur_[active_idx]->point_lv_) {
                    getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL_CANCEL);
                    papLvTgtMvCur_[active_idx]->moveSmoothTo(papLvNowCur_[active_idx]->point_lv_); //xJ[\ANeBuxɖ߂
                }
            }
            rollClose(active_idx); //݃[N[Y

            lstMagic_.next(); //[^[Pi߂
            pActiveMagic= lstMagic_.getCurrent();     //XV
            active_idx = lstMagic_.getCurrentIndex(); //XV
            active_prg = pActiveMagic->getProgress()->get(); //XV

            rollOpen(active_idx);  //i߂[I[v
            pMainCur_->moveTo(active_idx); //[^[J[\Pi߂
            getSeTransmitter()->play(SE_CURSOR_MOVE_METER);

        } else if (pVbPlay->isAutoRepeat(VB_LEFT)) { //uv
            //x\
            if (active_prg == Magic::STATE_CASTING) {
                if (papLvTgtMvCur_[active_idx]->point_lv_ != papLvCastingCur_[active_idx]->point_lv_) {
                    getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL_CANCEL);
                    papLvTgtMvCur_[active_idx]->moveSmoothTo(papLvCastingCur_[active_idx]->point_lv_); //xJ[\r惌xɖ߂
                }
            } else {
                if (papLvTgtMvCur_[active_idx]->point_lv_ != papLvNowCur_[active_idx]->point_lv_) {
                    getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL_CANCEL);
                    papLvTgtMvCur_[active_idx]->moveSmoothTo(papLvNowCur_[active_idx]->point_lv_); //xJ[\ANeBuxɖ߂
                }
            }
            rollClose(active_idx); //݃[N[Y

            lstMagic_.prev(); //[^[P߂
            pActiveMagic= lstMagic_.getCurrent();     //XV
            active_idx = lstMagic_.getCurrentIndex(); //XV
            active_prg = pActiveMagic->getProgress()->get(); //XV

            rollOpen(active_idx); //߂[I[v
            pMainCur_->moveTo(active_idx); //[^[J[\P߂
            getSeTransmitter()->play(SE_CURSOR_MOVE_METER);

        } else if (pVbPlay->isAutoRepeat(VB_UP) ) {  // uv
            if (pActiveMagic->max_level_ > papLvTgtMvCur_[active_idx]->point_lv_) {
                getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL);
                papLvTgtMvCur_[active_idx]->moveSmoothTo(papLvTgtMvCur_[active_idx]->point_lv_ + 1);
            }

        } else if (pVbPlay->isAutoRepeat(VB_DOWN)) {  //uv
            if (0 < papLvTgtMvCur_[active_idx]->point_lv_) {
                getSeTransmitter()->play(SE_CURSOR_MOVE_LEVEL);
                papLvTgtMvCur_[active_idx]->moveSmoothTo(papLvTgtMvCur_[active_idx]->point_lv_ - 1);
            }
        } else {

        }
        //MPRXgo[
        if (r_roll_[active_idx] > 0.01f) {
            if (papLvTgtMvCur_[active_idx]->point_lv_ == pActiveMagic->level_) {
                //J[\茻݂ƓxwĂꍇ
                pMpCostDispBar_->setVal(0);
            } else if (papLvTgtMvCur_[active_idx]->point_lv_ > pActiveMagic->level_) {
                //J[\݂荂xwĂꍇ
                //MPRXg𕉂̐Ԃ̕\
                pMpCostDispBar_->setVal(
                  -1*pActiveMagic->level_up_cost_[pActiveMagic->level_][papLvTgtMvCur_[active_idx]->point_lv_]
                );
            } else {
                //J[\݂ႢxwĂꍇ
                //̐̕\
                if (pActiveMagic->keep_cost_base_ <= 0) {
                    //ێRXg̏ꍇ̂MPҌo[\
                    pMpCostDispBar_->setVal(
                      pActiveMagic->calcReduceMp(pActiveMagic->level_,  papLvTgtMvCur_[active_idx]->point_lv_)
                    );
                } else {
                    //ێRXgL̏ꍇAMPҌ͖
                }
            }
        } else {
            pMpCostDispBar_->setVal(0);
        }

        //Vreatho[ANeBuꍇAVreath\
        if (pActiveMagic == pVreathMagic_) {
            VreathMagic* pVM = (VreathMagic*)pActiveMagic;
            if (r_roll_[active_idx] > 0.01f) {
                if (papLvTgtMvCur_[active_idx]->point_lv_ == pVM->level_) {
                    //J[\茻݂ƓxwĂꍇ
                    pVreathCostDispBar_->setVal(0);
                } else if (papLvTgtMvCur_[active_idx]->point_lv_ > pVM->level_) {
                    //J[\݂荂xwĂꍇ
                    //̐̕\
                    pVreathCostDispBar_->setVal(
                            (int)(pVM->calcTotalVreath(pActiveMagic->level_,  papLvTgtMvCur_[active_idx]->point_lv_))
                    );
                } else {
                    //J[\݂ႢxwĂꍇ
                    pVreathCostDispBar_->setVal(0);
                }
            } else {
                pVreathCostDispBar_->setVal(0);
            }
        } else {
            pVreathCostDispBar_->setVal(0);
        }

        //uv
        if (pVbPlay->isPushedDown(VB_SHOT1) || pVbPlay->isPushedDown(VB_SHOT2) || pVbPlay->isPushedDown(VB_TURBO)) {
            int r = pActiveMagic->cast(papLvTgtMvCur_[active_idx]->point_lv_);
            switch (r) {
                case MAGIC_CAST_NG_INVOKING_NOW: {
                    getSeTransmitter()->play(SE_BAD_OPERATION);
                    break;
                }
                case MAGIC_CAST_NG_MP_IS_SHORT: {
                    getSeTransmitter()->play(SE_NG_MP_IS_SHORT);
                    break;
                }
            }
        }
    } else  {
        alpha_velo_ = -0.02f;
        if (!pMyShip->canControl() || pVbPlay->isReleasedUp(VB_POWERUP)) {
            rollClose(lstMagic_.getCurrentIndex());
        }
        pMpCostDispBar_->setVal(0);
        pVreathCostDispBar_->setVal(0);
    }

    addAlpha(alpha_velo_);
    if (getAlpha() < 0.3f) {
        setAlpha(0.3f); //ANeBû\
    } else if (getAlpha() > 1.0f) {
        setAlpha(1.0f); //ANeBũnbL\
    }
}

void MagicMeter::onInactive() {
}

void MagicMeter::processDraw() {
    GgafDx::MassBoardEffect* const pMassBoardEffect = _pMassBoardEffect;
    ID3DXEffect* pID3DXEffect = pMassBoardEffect->_pID3DXEffect;
    GgafDx::UvFlipper* pUvFlipper = getUvFlipper();

    HRESULT hr;
    //p[[^[
    //[====]P̑傫 [====][====][====]
    MagicList::Elem* pElem = lstMagic_.getElemFirst();
    Magic* pMagic;
    int pMagic_level;
    int len_magics = lstMagic_.length();
    int n = 0;
    float u,v;
    float x = float(C_PX(_x));
    float y = float(C_PX(_y));
    float z = float(C_PX(_z));
    float alpha = getAlpha();
    VERTEX_instancedata* p = paInstancedata_MM_;

    for (int i = 0; i < len_magics; i++) {
        pMagic = pElem->getValue();//̂ŃANeBuł͂
        pMagic_level = pMagic->level_;
        float wx = width_px_*i;

        //}WbN[^[wi
        p->px_x = x + wx;
        p->px_y = y;
        p->depth_z = z;

        if (pMagic_level > 0 && pMagic->lvinfo_[pMagic_level].remained_frame_of_effecting <= fraeme_of_notice_remaind_) {
            p->r = 2.0;   p->g = 0.5;   p->b = 0.5;
//            pUvFlipper->getUV(1, u, v); //p^[1͐ԔwiAc莞Ԃ΂
        } else {
            p->r = 1.0;   p->g = 1.0;   p->b = 1.0;
//            pUvFlipper->getUV(0, u, v); //p^[0͒ʏwi
        }
        p->a = alpha;
        pUvFlipper->getUV(0, u, v);
        p->offset_u = u;
        p->offset_v = v;
        ++p; n++;

        //}WbN[^[݂̌̃}WbNx\
        p->px_x = x + wx;
        p->px_y = y;
        p->depth_z = z;
        p->r = 1.0;   p->g = 1.0;   p->b = 1.0;
        p->a = alpha*3; //\
        pUvFlipper->getUV(pMagic->lvinfo_[pMagic_level].pno_, u, v);
        p->offset_u = u;
        p->offset_v = v;
        ++p; n++;

        float rr = r_roll_[i];
        if (rr > 0.1f) {
            //e}WbNvf
            int lv_slecter_num = pMagic->max_level_+1;
            for (int j = 0; j < lv_slecter_num; j++) {

                //@
                p->px_x = x + wx;
                p->px_y = y - (height_px_*(j+1)*rr);
                p->depth_z = z;
                p->a = alpha*rr; //ANeBuȗ͕\
                if (pMagic->chkCastAble(j) <= MAGIC_CAST_NG_MP_IS_SHORT) {
                    //rs\ (MAGIC_CAST_NG_MP_IS_SHORT  MAGIC_CAST_NG_INVOKING_NOW)
//                    pUvFlipper->getUV(pMagic->lvinfo_[j].pno_ + 1, u, v); //ẼׂeNX`p^[ DISABLE ȃp^[O
                    p->r = 0.3;  p->g = 0.3;  p->b = 0.3;
                } else {
                    //r\\
//                    pUvFlipper->getUV(pMagic->lvinfo_[j].pno_, u, v);
                    p->r = 1.0;  p->g = 1.0;  p->b = 1.0;
                }
                pUvFlipper->getUV(pMagic->lvinfo_[j].pno_, u, v);
                p->offset_u = u;
                p->offset_v = v;
                p++; n++;
            }
        }
        pElem = pElem->_pNext;
    }
    _pMassBoardModel->GgafDx::MassBoardModel::draw(this, n, paInstancedata_MM_);
}

void MagicMeter::rollOpen(int prm_meter_index) {
    r_roll_velo_[prm_meter_index] = 0.1f;
}

void MagicMeter::rollClose(int prm_meter_index) {
    r_roll_velo_[prm_meter_index] = -0.1f;
}

MagicMeter::~MagicMeter() {
    GGAF_DELETEARR(papLvTgtMvCur_);
    GGAF_DELETEARR(papLvNowCur_);
    GGAF_DELETEARR(papLvCastingCur_);
    GGAF_DELETEARR(r_roll_);
    GGAF_DELETEARR(r_roll_velo_);
    GGAF_DELETE(pSeTx4Cast_);
    GGAF_DELETE(pSeTx4Invoke_);

    GGAF_DELETEARR(paInstancedata_MM_);
}
