#include "MagicPointItem.h"

#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/GeoDriver.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/actor/item/Item.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TractorMagic.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/actor/my/MyMagicEnergyCore.h"



using namespace GgafLib;
using namespace VioletVreath;

enum {
    PROG_DRIFT      , //ʏړ
    PROG_ATTACH     , //z(z)
    PROG_ABSORB     , //z(z)
    PROG_BANPEI,
};
enum {
    SE_GET_ITEM ,
};

MagicPointItem::MagicPointItem(const char* prm_name, const char* prm_model, void* prm_pFuncStatusReset)
               : Item(prm_name, prm_model, prm_pFuncStatusReset) {
    _class_name = "MagicPointItem";
    effectBlendOne(); //ZTechniquew
    setZEnableDraw(true);        //`掞AZobt@l͍l
    setZWriteEnable(false);  //gZobt@݂Ȃ
    setCullingDraw(false);
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setRollPitchYawFaceAngVelo(D_ANG(3), D_ANG(5), D_ANG(7));
    pVecDriver->linkFaceAngByMvAng(true);
    kDX_ = kDY_ = kDZ_ = 0;
    setHitAble(true, false); //ʊO蔻͖
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, 400000);
    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_GET_ITEM, "WAVE_GET_ITEM_001");
}

void MagicPointItem::initialize() {
}

void MagicPointItem::onActive() {
    // _x, _y, _z ͔Wɐݒς
    setHitAble(true, false);
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    pGeoDriver->forceVxyzMvVeloRange(-30000, 30000);
    pGeoDriver->setZeroVxyzMvVelo();
    pGeoDriver->setZeroVxyzMvAcce();
    pGeoDriver->stopGravitationMvSequence();

    //ݒ
    MyShip* pMyShip = pMYSHIP;
//    //U΂͈͐`Pӂ̒
//    int scattered_renge    = pChecker->_pCollisionArea->_papColliPart[0]->_dx; //蔻Ɠ
//    //n_A@ւ̕ւ̎U΂͈͐`̈悪ʒu鋗iscattered_distance > (scattered_renge/2) ł邱)
////    int scattered_distance = scattered_renge/2 + 400000;
//    //]āAscattered_distance ĂĂA@͓ȂĂ肬SĉłB
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->forceMvVeloRange(0, 20000);
    float vX, vY, vZ;
    UTIL::getNormalizedVector(
            pMyShip->_x - _x,
            pMyShip->_y - _y,
            pMyShip->_z - _z,
            vX, vY, vZ);
    int d = PX_C(200);
    int r = PX_C(75);
    pVecDriver->setMvAngTwd( (coord)(_x + (vX * d) + RND(-r, +r)),
                          (coord)(_y + (vY * d) + RND(-r, +r)),
                          (coord)(_z + (vZ * d) + RND(-r, +r)) );
    pVecDriver->setMvVelo(2000);
    pVecDriver->setMvAcce(100);

    getProgress()->reset(PROG_DRIFT);
    _sx = _sy = _sz = 1000;
}

void MagicPointItem::processBehavior() {
    MyShip* pMyShip = pMYSHIP;
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    GgafCore::Progress* const pProg = getProgress();
    //ʏړ
    if (pProg->get() == PROG_DRIFT) {
        //TractorMagicPROG_ATTACHֈڍs
        if (getTractorMagic()->is_tracting_) {
            effectFlush(6); //tbV
            setHitAble(false);
            pProg->change(PROG_ATTACH);
        }
        //邢 onHit()  PROG_ATTACH ԕω̂҂
    }

    //@Ɠ蔻肪qbgA@Ɍ
    if (pProg->get() == PROG_ATTACH) {
        MyMagicEnergyCore* pE = pMyShip->pMyMagicEnergyCore_;
        if (pProg->hasJustChanged()) {
            //@Ɉ͂ň񂹂悤ȓݒ
            pGeoDriver->setVxyzMvVelo(pVecDriver->_vX * pVecDriver->_velo_mv,
                                     pVecDriver->_vY * pVecDriver->_velo_mv,
                                     pVecDriver->_vZ * pVecDriver->_velo_mv);
            pGeoDriver->execGravitationMvSequenceTwd(pE,
                                                    PX_C(50), 300, PX_C(300));
            pVecDriver->stopMv();
        }

        //@ߕӂɓBH
        if (ABS(pE->_x - _x) < PX_C(20) &&
            ABS(pE->_y - _y) < PX_C(20) &&
            ABS(pE->_z - _z) < PX_C(20) )
        {
            kDX_ = pE->_x - _x;
            kDY_ = pE->_y - _y;
            kDZ_ = pE->_z - _z;
            pProg->change(PROG_ABSORB); //zz
        }
    }

    //@ߕӂɓBAzAz̓
    if (pProg->get() == PROG_ABSORB) {
        MyMagicEnergyCore* pE = pMyShip->pMyMagicEnergyCore_;
        if (pProg->hasJustChanged()) {
            pGeoDriver->setZeroVxyzMvVelo();
            pGeoDriver->setZeroVxyzMvAcce();
            pGeoDriver->stopGravitationMvSequence();
        }
        _x = pE->_x + kDX_;
        _y = pE->_y + kDY_;
        _z = pE->_z + kDZ_;
        addScale(-100);
        pMyShip->mp_ += 12; //I

        if (_sx < 100) {
            getSeTransmitter()->play(SE_GET_ITEM);
            pProg->changeNothing();
            sayonara(); //I
        }
    }
    pVecDriver->behave();
    pGeoDriver->behave();
}

void MagicPointItem::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
//    //ʏړ
//    if (pProg->get() == PROG_DRIFT) {
//        //onHit() ŏԕω̂҂
//    }
//
//    //@Ɠ蔻肪qbg
//    if (pProg->get() == PROG_ATTACH) {
//
//    }
//
//    //@ɋzAz̓
//    if (pProg->get() == PROG_ABSORB) {
//    }
}

void MagicPointItem::onInactive() {
}

void MagicPointItem::onHit(const GgafCore::Actor* prm_pOtherActor) {
    GgafDx::GeometricActor* pOther = (GgafDx::GeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg

    GgafCore::Progress* const pProg = getProgress();
    if (pProg->get() == PROG_DRIFT && (pOther->lookUpKind() & KIND_MY_BODY))  {
        setHitAble(false);
        pProg->change(PROG_ATTACH);
    }
}

MagicPointItem::~MagicPointItem() {
}

