#include "EnemyOmulus.h"

#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/Scaler.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/model/Model.h"
#include "jp/ggaf/dx/model/supporter/TextureBlinker.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafLib;
using namespace VioletVreath;

#define MORPHTARGET_HATCH_OPEN 1

enum {
    PROG_INIT       ,
    PROG_HATCH_CLOSE,
    PROG_HATCH_OPEN ,
    PROG_BANPEI,
};
enum {
    SE_DAMAGED  ,
    SE_EXPLOSION,
};

EnemyOmulus::EnemyOmulus(const char* prm_name) :
        VvEnemyActor<DefaultMassMorphMeshActor>(prm_name, "Omulus_1", StatusReset(EnemyOmulus)) {
    _class_name = "EnemyOmulus";
    is_open_hatch_ = false;
    frame_of_open_interval_  = 3*60;
    frame_of_close_interval_ = 20*60;
    frame_of_morph_interval_ = 120;

    pDepo_Fired_ = nullptr;
    pConn_depo_ = connectToDepositoryManager("Talante");
    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");
}

void EnemyOmulus::onCreateModel() {
    GgafDx::Model* pModel = getModel();
    pModel->setBlinkPower(0.1, 0.9);
    pModel->getTexBlinker()->setRange(0.1, 1.0);
    pModel->getTexBlinker()->beat(120, 60, 0, 60, -1);
    pModel->setSpecular(5.0, 1.0);
}

void EnemyOmulus::initialize() {
    setHitAble(true);
    getVecDriver()->linkFaceAngByMvAng(true);
    getMorpher()->setRange(MORPHTARGET_HATCH_OPEN, 0.0f, 1.0f);
    setMorphWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, 200000);
    setScale(1000);
    getScaler()->setRange(1000, 1200);
    getScaler()->beat(30, 5, 0, 20, -1);
    pDepo_Fired_ = pConn_depo_->peek();
}

void EnemyOmulus::onActive() {
    getStatus()->reset();
    setMorphWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    is_open_hatch_ = false;
//    frame_of_moment_nextopen_ = frame_of_close_interval_;
    getProgress()->reset(PROG_HATCH_CLOSE);
}

void EnemyOmulus::processBehavior() {
    //[JŌvZs
    changeGeoLocal();

    //{[ɂAN^[̃
    //_x, _y, _z, _rx, _ry, _rz ɂĂQ̍WnZbg؂ւKvȎdlłB
    //ꂼꃍ[JWAŏIi΁jWƌĂԂƂɂ܂B
    //EŏIi΁jW EEE ʂ̃[hWn̎łB
    //E[JW     EEE eAN^[̊_(0,0,0)̑ΓIȍWnӖ܂B
    //                          WvZ͂ōsĉB
    //j
    //  @WvZ͎Ƀ[JWňvZłBGgafDx::VecDriver Ń[JWn̑sƂƂB
    //    Aؓo^A蔻A^[QbgWȂǁÃIuWFNg烏[hWQƂ铙A
    //    {Ԃ͍ŏIi΁jWnB
    //    processBehavior()Jn ŏIi΁jWn(changeGeoFinal())̏ԂƂȂĂB
    //  AprocessBehavior()ŕKvɉ changeGeoLocal() Ńo[ _x, _y, _z, _rx, _ry, _rz [JWn
    //    ؂ւ邱Ƃ\Bړ̍WvZsB
    //  BA processBehavior() 𔲂ۂɂ͕KŏIW(changeGeoFinal())̏Ԃɖ߂ĂB
    //  CŏIi΁jWƁA[JW݂͌ɓƗA͂ȂA
    //    \̃[hϊs쐬AsςōAŏIIȕ\ʒu肷B

    //changeGeoLocal(); s
    //[JWnɐؑւ܂B
    //E_x, _y, _z     EEE ́A[JWӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_x, _y, _z 
    //                        [JWlɐ؂ւ܂B
    //E_rx, _ry, _rz  EEE ́A[JWł̎]lӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_rx, _ry, _rz
    //                        [JW]lɐ؂ւ܂B

    //changeGeoFinal(); s
    //ŏIi΁jWnɐ؂ւ܂B
    //E_x, _y, _z    EEE t[ GgafDx::GeometricActor::processSettlementBehavior() ŌvZꎩXVĂ܂B
    //                       processBehavior()  changeGeoFinal() sƁAPt[O_x, _y, _zɐ؂ւ鎖ɂȂ܂B
    //                       _x, _y, _z ͎QƐpBlĂӖL܂
    //E_rx, _ry, _rz EEE t[ GgafDx::GeometricActor::processSettlementBehavior() ܂I
    //                       changeGeoFinal(); sĂA_rx, _ry, _rz ͈ȑO̍ŏIi΁jWn̒l
    //                       ςȂŕω܂B
    //                       ̃IuWFNgA{[ɂAN^[QƂƂA_rx, _ry, _rz͑SMpł܂B

    //Ӂ
    //EGgafDx::VecDriver(getVecDriver()) behave() ȊO\bh́AɃ[JW̑ƂB
    //  behave()ȊO\bh͎ۂɍWvZĂ킯ł͂Ȃ̂ŁA
    //  changeGeoFinal()AchangeGeoLocal()Ɋ֌WȂAĂяo\B
    //EGgafDx::VecDriver(getVecDriver()) behave() \bh͍WPt[̏ԂɂvZsB
    //  āÂ悤 [JW(changeGeoLocal())ŌĂяoƂB
    //    changeGeoLocal();
    //    pVecDriver->behave();
    //    changeGeoFinal();
    //TODO:݊ƂȂB
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafCore::Progress* const pProg = getProgress();
    switch (pProg->get()) {
        case PROG_INIT: {
            pProg->change(PROG_HATCH_CLOSE);
            break;
        }
        case PROG_HATCH_CLOSE: {
            if (pProg->hasJustChanged()) {
                getMorpher()->transitionLinearUntil(MORPHTARGET_HATCH_OPEN,
                                                0.0f, frame_of_morph_interval_);
                pVecDriver->setRollFaceAngVelo(-3000);
            }

            //
            if (pProg->getFrame() >= frame_of_close_interval_ + frame_of_morph_interval_) {
                pProg->change(PROG_HATCH_OPEN);
            }
            break;
        }
        case PROG_HATCH_OPEN: {
            if (pProg->hasJustChanged()) {
                getMorpher()->transitionLinearUntil(MORPHTARGET_HATCH_OPEN,
                                           1.0f, frame_of_morph_interval_);
                pVecDriver->setRollFaceAngVelo(0);
            }
            //processJudgement()ŃVbg
            if (pProg->getFrame() >= frame_of_open_interval_+ frame_of_morph_interval_) {
                pProg->change(PROG_HATCH_CLOSE);
            }
            break;
        }
        default :
            break;
    }

    getScaler()->behave();
    getMorpher()->behave();

    pVecDriver->behave();
    changeGeoFinal();
}

void EnemyOmulus::processChangeGeoFinal() {
    //΍WXVĂ`
    GgafCore::Progress* const pProg = getProgress();
    switch (pProg->get()) {
        case PROG_HATCH_OPEN: {
            //I[vGo
            if (getMorphWeight(MORPHTARGET_HATCH_OPEN) > 0.5) { //[Vȏ܂œBȂ
                if (pProg->getFrame() % (frame)(RF_EnemyOmulus_ShotInterval(G_RANK)) == 0) { //oԊu
                    if (pDepo_Fired_) {
                        GgafDx::FigureActor* pActor = (GgafDx::FigureActor*)pDepo_Fired_->dispatch();
                        if (pActor) {
                            pActor->getVecDriver()->setRzRyMvAng(_rz, _ry); //΍Wnł̌
                            pActor->setPosition(_x, _y, _z);
                            pActor->reset();
                        }
                    }
                }
            }
            break;
        }
        default :
            break;
    }
}

void EnemyOmulus::processJudgement() {
    if (getBaseActor() && getBaseActor()->isActiveInTheTree()) {
//        (*(_pActor_base->_pFunc_calc_rot_mv_world_matrix))(_pActor_base, _matWorld);
    } else {
        //y䂪ȂΎ
        sayonara();
    }


//    if (isOutOfSpacetime()) {
//        sayonara();
//    }
}

void EnemyOmulus::onHit(const GgafCore::Actor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDx::GeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        getSeTransmitter()->play3D(SE_EXPLOSION);
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
        getSeTransmitter()->play3D(SE_DAMAGED);
    }
}

void EnemyOmulus::onInactive() {
    sayonara();
}

EnemyOmulus::~EnemyOmulus() {
    pConn_depo_->close();
}
