#include "EnemyErmione.h"

#include "jp/ggaf/dx/actor/supporter/AlphaFader.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Ermione/EnemyErmioneArmWeak.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Ermione/EnemyErmioneArmHead.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Ermione/EnemyErmioneArmBody.h"
#include "jp/ggaf/dx/actor/supporter/VecDriverFaceAngAssistant.h"
#include "jp/gecchi/VioletVreath/actor/effect/Blink/EffectBlink.h"



using namespace GgafLib;
using namespace VioletVreath;

enum {
    PROG_INIT ,
    PROG_ENTRY,
    PROG_MOVE ,
    PROG_BANPEI,
};
enum {
    SE_DAMAGED  ,
    SE_EXPLOSION,
};

EnemyErmione::EnemyErmione(const char* prm_name) :
        VvEnemyActor<DefaultMorphMeshActor>(prm_name, "Ermione_1", StatusReset(EnemyErmione)) {
    _class_name = "EnemyErmione";
//    num_arm_ = 6; //r̍v{
//    num_arm_part_ = 11;  //er̐ߐi3ȏj
//    angle pos_rz[] = {D_ANG(0),   D_ANG(90),   D_ANG(180),  D_ANG(270), D_ANG(0) , D_ANG(0)   }; //₷ꏊ
//    angle pos_ry[] = {D_ANG(0),   D_ANG(0),    D_ANG(0)  ,  D_ANG(0)  , D_ANG(90), D_ANG(270) };


    num_arm_ = 4; //r̍v{
    num_arm_part_ = 11;  //er̐ߐi3ȏj
    //lʑ̂̒_ɘr𐶂₻I
    //1ӂa Ƃƍ  (6)a / 3
    //dS͍1/4
    //  (6)a / 3) * (3/4) = (6)a / 4
    //  (6)a / 3) * (1/4) = (6)a / 12
    //dS(0,0,0)ƂAE̒_
    //(   (6)a / 4 ,            0,     0 ) Ƃ
    //c
    //( -((6)a / 12),  (3)a / 2,     0 )
    //( -((6)a / 12), -(3)a / 6,   a/2 )
    //( -((6)a / 12), -(3)a / 6,  -a/2 )
    //http://sansuu.noblog.net/blog/e/10762566.writeback
    double a = 1.0;
    angle pos_rz[4];
    angle pos_ry[4];
    const double sqrt6 = sqrt(6.0);
    const double sqrt3 = sqrt(3.0);
    pos_rz[0] = D_ANG(0);   pos_ry[0] = D_ANG(0);
    UTIL::convVectorToRzRy( -(sqrt6*a)/12.0,  (sqrt3*a)/2.0,    0.0,   pos_rz[1], pos_ry[1]);
    UTIL::convVectorToRzRy( -(sqrt6*a)/12.0, -(sqrt3*a)/6.0,  a/2.0,   pos_rz[2], pos_ry[2]);
    UTIL::convVectorToRzRy( -(sqrt6*a)/12.0, -(sqrt3*a)/6.0, -a/2.0,   pos_rz[3], pos_ry[3]);

//////////////TEST
//    num_arm_ = 1; //r̍v{
//    num_arm_part_ = 11;  //er̐ߐi3ȏj
//    angle pos_rz[] = {D_ANG(0)}; //₷ꏊ
//    angle pos_ry[] = {D_ANG(0)};
///////////////


    static coord R = PX_C(130);     //{Ermione̔a
    static coord arm_R = PX_C(45);  //̘r̊֐߂P̔a

    //̂悤ȃc[\(rR{̏ꍇ)
    //Ermione
    // 
    //GroupHead()
    // 
    //ArmPart({)     ArmPart({)     ArmPart({)
    //                                      
    //ArmPart              ArmPart             ArmPart
    //                                      
    //ArmPart(_)        ArmPart(_)       ArmPart(_)
    //                                      
    //ArmPart              ArmPart             ArmPart
    //                                      
    //ArmPart              ArmPart             ArmPart
    //                                      
    //ArmPart()          ArmPart()         ArmPart()

    paArm_ = NEW EnemyErmione::Arm[num_arm_];
    float vx, vy, vz;
    for (int arm = 0; arm < num_arm_; arm++) { //r̖{Ń[v
        paArm_[arm].pos_Rz_ = pos_rz[arm];
        paArm_[arm].pos_Ry_ = pos_ry[arm];
        UTIL::convRzRyToVector(paArm_[arm].pos_Rz_, paArm_[arm].pos_Ry_,
                               vx, vy, vz); //r̃xNg
        paArm_[arm].papArmPart_ = NEW EnemyErmioneArm*[num_arm_part_];

        for (int i = 0; i < num_arm_part_; i++) { //r̓(֐)
            if (i == (num_arm_part_-1)/2) {
                //r̐߂̎_(r̐ߐ̔Ɏ_߂쐬)
                paArm_[arm].papArmPart_[i] = NEW EnemyErmioneArmWeak("ArmWeak");
            } else if (i == num_arm_part_-1) {
                //r̐߂̐擪
                paArm_[arm].papArmPart_[i] = NEW EnemyErmioneArmHead("ArmHead");
            } else {
                //ʂ̘r̐
                paArm_[arm].papArmPart_[i] = NEW EnemyErmioneArmBody("ArmBody");
            }
            if (i == 0) {
                //߂{̏ꍇ
                //֐ߌŒ肳
                paArm_[arm].papArmPart_[i]->config(arm, i, 0, 0);
                //gyƂFKݒ
                this->appendGroupChildAsFk(
                        paArm_[arm].papArmPart_[i],
                        vx*R, vy*R, vz*R,
                        D0ANG, paArm_[arm].pos_Ry_, paArm_[arm].pos_Rz_);
            } else {
                //߂{ȊOꍇ
                //ɍsقǉ͈͂Ɖ]Xs[h傫iŁAFKȂ̂IKۂIj
                paArm_[arm].papArmPart_[i]->config(arm, i, D_ANG(10+(i*2.5)), 10+(i*10));
                //O̘r̐߂yƂFKݒ
                paArm_[arm].papArmPart_[i-1]->appendGroupChildAsFk(
                                               paArm_[arm].papArmPart_[i],
                                               arm_R, 0, 0,
                                               D0ANG, D0ANG, D0ANG); //yڍs͐^̂ Face rz,ry=0,0 ŗǂ
            }
        }
    }
    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");
}

void EnemyErmione::onCreateModel() {
}

void EnemyErmione::initialize() {
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliSphere(0, 90000);
}

void EnemyErmione::onActive() {
    getStatus()->reset();
    setMorphWeight(1, 0.0);

    getProgress()->reset(PROG_INIT);
    setHitAble(false);
}

void EnemyErmione::processBehavior() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafCore::Progress* const pProg = getProgress();
    switch (pProg->get()) {
        case PROG_INIT: {
            setHitAble(false);
            setAlpha(0);
            pVecDriver->setMvVelo(10);
            pProg->changeNext();
            break;
        }

        case PROG_ENTRY: {
            EffectBlink* pEffectEntry = nullptr;
            if (pProg->hasJustChanged()) {
                pEffectEntry = UTIL::activateEntryEffectOf(this);
            }
            static const frame frame_of_summons_begin = pEffectEntry->getFrameOfSummonsBegin();
            static const frame frame_of_entering = pEffectEntry->getSummoningFrames() + frame_of_summons_begin;
            if (pProg->hasArrivedAt(frame_of_summons_begin)) {
                getAlphaFader()->transitionLinearUntil(1.0, frame_of_entering);
            }
            if (pProg->hasArrivedAt(frame_of_entering)) {
                setHitAble(true);
                throwEventLowerTree(EVENT_ERMIONE_ENTRY_DONE);
                pVecDriver->setMvAngTwd(pMYSHIP);
                pVecDriver->setMvVelo(PX_C(2));
                pVecDriver->asstFaceAng()->turnByDtTwd(
                        pMYSHIP, TURN_CLOSE_TO, true, 60*30,
                        0.4, 0.6, 0, true);

                pProg->changeNext();
            }
            break;
        }

        case PROG_MOVE: {
            if (pProg->hasJustChanged()) {
                pVecDriver->setFaceAngVelo(AXIS_X, 55);
                pVecDriver->setFaceAngVelo(AXIS_Y, 53);
                pVecDriver->setFaceAngVelo(AXIS_Z, 51);
            }
            break;
        }

        default: {
            break;
        }
    }
    getAlphaFader()->behave();
    pVecDriver->behave();
    getMorpher()->behave();
    getSeTransmitter()->behave();
}

void EnemyErmione::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void EnemyErmione::onHit(const GgafCore::Actor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDx::GeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        getSeTransmitter()->play3D(SE_EXPLOSION);
        sayonara();
        throwEventLowerTree(EVENT_ERMIONE_SAYONARA);
    } else {
        //j󂳂Ȃ(X^~i > 0)
        getSeTransmitter()->play3D(SE_DAMAGED);
    }
}

void EnemyErmione::onInactive() {
    //sayonara();
}

void EnemyErmione::addArm(angle prm_rz, angle prm_ry) {

}

EnemyErmione::~EnemyErmione() {
    GGAF_DELETEARR(paArm_);
}
