#include "EnemyEresShot001.h"

#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"

using namespace GgafLib;
using namespace VioletVreath;

enum {
    ERESSHOT001_SE_EXPLOSION,
};

EnemyEresShot001::EnemyEresShot001(const char* prm_name) :
        VvEnemyActor<DefaultMeshSetActor>(prm_name, "myvic", StatusReset(EnemyEresShot001)) {
    _class_name = "EnemyEresShot001";
    inactivateTree();

    /** ȍ */
    velo1st_ = 13000;
    /** ỏxiŒxȂj */
    iMoveAcce_1st_ = -150;
    /** goĂA@̕ɕ]Jnt[ */
    frame_TurnBegin_ = 60;
    /** ړx */
    veloTop_ = 30000;
    /** Œۏ؈ړx */
    veloBottom_ = 0;
    /** ]ɔ₷Ƃłt[ */
    frame_TurnInterval_ = 400;
    /** ]̊pxAOl(̒l) */
    angVelo_Turn_ = 7000;
    /** ]Jniframe_TurnBegin_jĐݒ肳x */
    iMoveAcce_2nd_ = 100;

    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(ERESSHOT001_SE_EXPLOSION, "WAVE_EXPLOSION_002");
}

void EnemyEresShot001::initialize() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->forceMvVeloRange(veloTop_, veloBottom_);
    pVecDriver->linkFaceAngByMvAng(true);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, PX_C(60));
    setHitAble(true);
}

void EnemyEresShot001::onActive() {
    getStatus()->reset();

    //o
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setMvVelo(velo1st_);
    pVecDriver->setMvAcce(iMoveAcce_1st_);

    setHitAble(true);
}

void EnemyEresShot001::processBehavior() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    //]Jn
    if (getActiveFrame() == frame_TurnBegin_) {
        pVecDriver->turnMvAngTwd(pMYSHIP,
                              angVelo_Turn_, 0,
                              TURN_CLOSE_TO, true);
        pVecDriver->setMvAcce(iMoveAcce_2nd_);
    }

    //]I
    if (getActiveFrame() == frame_TurnBegin_ + frame_TurnInterval_) {
        pVecDriver->setRzRyMvAngVelo(0,0);
        pVecDriver->_is_targeting_ry_mv = false;
        pVecDriver->_is_targeting_rz_mv = false;
    }

    //behaveUvFlip();
    //Wɔf
    pVecDriver->behave();
    //getSeTransmitter()->behave();
}

void EnemyEresShot001::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void EnemyEresShot001::onHit(const GgafCore::Actor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDx::GeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        getSeTransmitter()->play3D(ERESSHOT001_SE_EXPLOSION);
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
    }
}

void EnemyEresShot001::onInactive() {
    sayonara();
}

EnemyEresShot001::~EnemyEresShot001() {
}
