#ifndef ENEMYAPPHO_H_
#define ENEMYAPPHO_H_
#include "VioletVreath.h"
#include "jp/gecchi/VioletVreath/actor/VvEnemyActor.hpp"
#include "jp/ggaf/lib/actor/DefaultMeshSetActor.h"

#include "jp/ggaf/dx/util/GeoElem.h"

namespace VioletVreath {

/**
 * G@Ab|[ .
 * A˂UWK̎Ĝ悤ɁA
 * āAڂ̑OɃX[ƗāA
 * ƃEEāAX[ƓB
 * @version 1.00
 * @since 2013/03/18
 * @author Masatoshi Tsuge
 */
class EnemyAppho : public VvEnemyActor<GgafLib::DefaultMeshSetActor> {

public:
    /** [r]oW(tH[[VIuWFNgݒ) */
    GgafDx::GeoElem entry_pos_;
    /** [r]EEW(tH[[VIuWFNgݒ) */
    GgafDx::GeoElem stagnating_pos_;
    /** [r]ޏoW(tH[[VIuWFNgݒ) */
    GgafDx::GeoElem leave_pos_;

public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    EnemyAppho(const char* prm_name);

    void onCreateModel() override;

    /**
     * Ab|[̏iCX^Xۏ؁j
     */
    void initialize() override;

    /**
     * Ab|[ANeBuɂȂuԂ̏ .
     */
    void onActive() override;

    /**
     * Ab|[̐U镑 .
     */
    void processBehavior() override;

    /**
     * Ab|[̐U镑̔菈 .
     */
    void processJudgement() override;

    /**
     * Ab|[̏Փˎ .
     * @param prm_pOtherActor ՓˑΏ
     */
    void onHit(const GgafCore::Actor* prm_pOtherActor) override;


    void onInactive() override;


    virtual ~EnemyAppho();
};

}
#endif /*ENEMYAPPHO_H_*/

