#include "EnemyWateringLaserChip001.h"
#include "jp/ggaf/lib/actor/laserchip/WateringLaserChip.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"

using namespace GgafLib;
using namespace VioletVreath;

EnemyWateringLaserChip001::EnemyWateringLaserChip001(const char* prm_name) :
        VvEnemyActor<WateringLaserChip>(prm_name, "EnemyWateringLaserChip001", StatusReset(EnemyWateringLaserChip001)) {
    _class_name = "EnemyWateringLaserChip001";
    tmp_x_ = _x;
    tmp_y_ = _y;
    tmp_z_ = _z;
}

void EnemyWateringLaserChip001::initialize() {
    getVecDriver()->linkFaceAngByMvAng(true);
    registerHitAreaCube_AutoGenMidColli(50000);
    setHitAble(true);
    setScaleR(6.0);
    setCullingDraw(false);
}

void EnemyWateringLaserChip001::onCreateModel() {

}

void EnemyWateringLaserChip001::onActive() {
    WateringLaserChip::onActive();
    getVecDriver()->setMvVelo(PX_C(100));
    getVecDriver()->setMvAcce(PX_C(5));
    getStatus()->reset();
}

void EnemyWateringLaserChip001::processBehavior() {
    if (hasJustChangedToActive()) {
        //ANeBuɂȂuԂ́A
        //pAN^[w肵ŏ̍Wŕ\B
        //͎Ԃ̊sƁÂŁAŏ͂̂܂܂̍Wŕ\B
        //Ƃ͂̂́Aˌ͂Pt[ړĂ̂ŁAsb^ɂ͌ȂȂB
    } else {
        GgafDx::VecDriver* const pVecDriver = getVecDriver();
        pVecDriver->behave();
    }
    WateringLaserChip::processBehavior();//WړĂĂяo

    tmp_x_ = _x;
    tmp_y_ = _y;
    tmp_z_ = _z;
}

void EnemyWateringLaserChip001::processSettlementBehavior() {
    //ϋȐWݒB([U[炩ɂm[}CYj
    //processSettlementBehavior() ̃\bḧӋ`Ƃ͗čWړĂB
    //{ processBehaviorAfter() IȈӖ̏ł邪AS[U[`bvړłȂƈӖȂ̂
    //dȂ̂processSettlementBehavior()ɐHł܂B
    if (getActiveFrame() > 3) {
        EnemyWateringLaserChip001* pF = (EnemyWateringLaserChip001*)getInfrontChip();
        EnemyWateringLaserChip001* pB = (EnemyWateringLaserChip001*)getBehindChip();
        if (pF && pB && pF->isActive() && pB->isActive()) {
            //_pChip_behind == nullptr ̔肾ł͂߁B_pChip_behind->_is_active_flg Ɣ肷邱
            //ȂȂ dispatch ̏uԂ_pChip_behind != nullptr ƂȂ邪Aactive()ɂLɂȂ͎̂t[
            //_x,_y,_z ɂ͂܂ςȒlĂB
            //ԍWɍĐݒ
            _x = ((pF->tmp_x_ + pB->tmp_x_)/2 + tmp_x_)/2;
            _y = ((pF->tmp_y_ + pB->tmp_y_)/2 + tmp_y_)/2;
            _z = ((pF->tmp_z_ + pB->tmp_z_)/2 + tmp_z_)/2;
        }
    }
    WateringLaserChip::processSettlementBehavior();
}

void EnemyWateringLaserChip001::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void EnemyWateringLaserChip001::onHit(const GgafCore::Actor* prm_pOtherActor) {
    GgafDx::GeometricActor* pOther = (GgafDx::GeometricActor*)prm_pOtherActor;
    if (getActiveFrame() <= 2 && (pOther->lookUpKind() & KIND_CHIKEI)) {
        //o2t[ȓŃqbg肪n`ȂΖion`ɂj󂳂j
        return;
    }

    bool was_destroyed = UTIL::performEnemyHit(this, pOther);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
    }
}

void EnemyWateringLaserChip001::onInactive() {
    WateringLaserChip::onInactive();
}


EnemyWateringLaserChip001::~EnemyWateringLaserChip001() {
}

