#ifndef HOSHIBOSHI_H_
#define HOSHIBOSHI_H_
#include "VioletVreath.h"
#include "jp/ggaf/dx/actor/PointSpriteActor.h"
#include "jp/ggaf/lib/actor/WorldBoundActor.h"

namespace VioletVreath {

#define RENDER_DEPTH_INDEX_HOSHIBOSHI (RENDER_DEPTH_INDEX_WORLDBOUND-1)

/**
 * X|CgXvCg .
 * X̒_(XvCg)WQ́AXYZW -1.0`1.0 ͈͓ɏW񂵂č쐬Ă邱ƂOB<BR>
 * XAYAZړĂAX̒_(XvCg)W̓[e[gAXN[Ă悤Ɍʂo<br>
 * ܂AAN^[(@)̎Ő炩ɔ\ʂoB<br>
 * @version 1.00
 * @since 2010/02/28
 * @author Masatoshi Tsuge
 */
class HoshiBoshi : public GgafDx::PointSpriteActor {

public:
    float far_rate_;

    coord space_distance_;

    GgafDx::GeometricActor* pCriteria_;

    static coord CAM_ZF_;

public:
    HoshiBoshi(const char* prm_name, const char* prm_model_id);

    static bool initStatic(HoshiBoshi* prm_pHoshiBoshi);

    /**
     * X̍L̊g{ݒ .
     * 1.0ݒ肷ƁÃ݂J猩͈(XYZW -zf ` zf)A
     * f̐X̒_(XvCg)WQ̍W͈(XYZW -1.0`1.0jƈvB
     * @param prm_far_rate L̊g{
     */
    void setFarRate(float prm_far_rate);

    inline float getFarRate() {
        return far_rate_;
    }
    /**
     * AN^[ݒ .
     * ݒ肳ꂽAN^[̎́AX͊炩ɔ\iAt@œjƂȂB
     * @param prm_pCriteria AN^[
     */
    void setCriteriaActor(GgafDx::GeometricActor* prm_pCriteria);

    virtual void onCreateModel() override {
    }

    virtual void initialize() override;

    virtual void processSettlementBehavior() override;

    virtual void processJudgement() override;

    virtual void processDraw() override;

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual void onHit(const GgafCore::Actor* prm_pOtherActor) override {
    }

    virtual void drawHitArea() override;

    virtual int isOutOfView() override;

    virtual bool isOutOfSpacetime() const override;



    virtual ~HoshiBoshi();



    static void setWorldMatrix_HoshiBoshi(const GgafDx::GeometricActor* prm_pActor, D3DXMATRIX& out_matWorld);
};

}
#endif /*HOSHIBOSHI_H_*/

