#include "HoshiBoshi.h"

#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/gecchi/VioletVreath/effect/HoshiboshiEffect.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"



using namespace GgafLib;
using namespace VioletVreath;

coord HoshiBoshi::CAM_ZF_;

HoshiBoshi::HoshiBoshi(const char* prm_name, const char* prm_model_id) :

                                        GgafDx::PointSpriteActor(prm_name,
                                                               prm_model_id,
                                                               TYPE_POINTSPRITE_MODEL,
                                                               "HoshiBoshiEffect",
                                                               TYPE_HOSHIBOSHI_EFFECT,
                                                               "HoshiBoshiTechnique",
                                                               nullptr) {
    _class_name = "HoshiBoshi";
    effectBlendOne(); //Z
    setHitAble(false);

    //Ǝ[hϊ
    defineRotMvWorldMatrix(HoshiBoshi::setWorldMatrix_HoshiBoshi);
    setSpecialRenderDepthIndex(RENDER_DEPTH_INDEX_HOSHIBOSHI);
    pCriteria_ = pGOD->getSpacetime()->getCamera();
    setFarRate(1.0);
    static volatile bool is_init = HoshiBoshi::initStatic(this); //ÓIo
}

bool HoshiBoshi::initStatic(HoshiBoshi* prm_pHoshiBoshi) {
    HoshiBoshi::CAM_ZF_ = ABS(DX_C(pGOD->getSpacetime()->getCamera()->getZFar()));
    return true;
}

void HoshiBoshi::setFarRate(float prm_far_rate) {
    //XDIRECTX-1.0`1.0i-10px`10px)Ɏ܂ĂOŁA
    //Ԃ̑傫ɎU΂点
    far_rate_ = prm_far_rate;
    space_distance_ = HoshiBoshi::CAM_ZF_*far_rate_;
    _sx = _sy = _sz =  (pGOD->getSpacetime()->getCamera()->getZFar()*LEN_UNIT)*far_rate_;
}
int HoshiBoshi::isOutOfView() {
    //ʊO薳
    return 0;
}

void HoshiBoshi::setCriteriaActor(GgafDx::GeometricActor* prm_pCriteria) {
    pCriteria_ = prm_pCriteria;
}

bool HoshiBoshi::isOutOfSpacetime() const {
    //Q[W͈͊O薳
    return false;
}

void HoshiBoshi::initialize() {

}

void HoshiBoshi::processSettlementBehavior() {
    if (_x > space_distance_) {
        _x -= (space_distance_*2);
    } else if (_x < -space_distance_) {
        _x += (space_distance_*2);
    }

    if (_y > space_distance_) {
        _y -= (space_distance_*2);
    } else if (_y < -space_distance_) {
        _y += (space_distance_*2);
    }

    if (_z > space_distance_) {
        _z -= (space_distance_*2);
    } else if (_z < -space_distance_) {
        _z += (space_distance_*2);
    }

    //ʊO薳ɔȂȗ
    //GeometricActor::processSettlementBehavior() Ɠ鎖I
    _fX = C_DX(_x);
    _fY = C_DX(_y);
    _fZ = C_DX(_z);
    (*_pFunc_calc_rot_mv_world_matrix)(this, _matWorld); //[hϊ
}

void HoshiBoshi::processJudgement() {
}

void HoshiBoshi::processDraw() {
    HoshiboshiEffect* pHoshiboshiEffect = (HoshiboshiEffect*)_pPointSpriteEffect;
    ID3DXEffect* const pID3DXEffect = pHoshiboshiEffect->_pID3DXEffect;
    HRESULT hr;
    hr = pID3DXEffect->SetFloat(pHoshiboshiEffect->h_fX_MyShip_, pCriteria_->_fX);
    checkDxException(hr, D3D_OK, "SetFloat(h_fX_MyShip_) Ɏs܂B");
    hr = pID3DXEffect->SetFloat(pHoshiboshiEffect->h_fY_MyShip_, pCriteria_->_fY);
    checkDxException(hr, D3D_OK, "SetFloat(h_fY_MyShip_) Ɏs܂B");
    hr = pID3DXEffect->SetFloat(pHoshiboshiEffect->h_fZ_MyShip_, pCriteria_->_fZ);
    checkDxException(hr, D3D_OK, "SetFloat(h_fZ_MyShip_) Ɏs܂B");
    hr = pID3DXEffect->SetFloat(pHoshiboshiEffect->h_far_rate_, far_rate_);
    checkDxException(hr, D3D_OK, "SetFloat(h_far_rate_) Ɏs܂B");
    GgafDx::PointSpriteActor::processDraw();
}


void HoshiBoshi::drawHitArea() {
}

HoshiBoshi::~HoshiBoshi() {
}

void HoshiBoshi::setWorldMatrix_HoshiBoshi(const GgafDx::GeometricActor* prm_pActor, D3DXMATRIX& out_matWorld) {
    //Worldϊ
    //gk ~ X] ~ Z] ~ Y] ~ sړ ̕ϊsݒ<BR>
    //XYZ̏łȂƂɒ
    float sinRx = ANG_SIN(prm_pActor->_rx);
    float cosRx = ANG_COS(prm_pActor->_rx);
    float sinRy = ANG_SIN(prm_pActor->_ry);
    float cosRy = ANG_COS(prm_pActor->_ry);
    float sinRz = ANG_SIN(prm_pActor->_rz);
    float cosRz = ANG_COS(prm_pActor->_rz);
    float sx = SC_R(prm_pActor->_sx);
    float sy = SC_R(prm_pActor->_sy);
    float sz = SC_R(prm_pActor->_sz);

    out_matWorld._11 = sx * cosRz *cosRy;
    out_matWorld._12 = sx * sinRz;
    out_matWorld._13 = sx * cosRz * -sinRy;
    out_matWorld._14 = 0.0f;

    out_matWorld._21 = (sy * cosRx * -sinRz *  cosRy) + (sy * sinRx * sinRy);
    out_matWorld._22 = sy * cosRx *  cosRz;
    out_matWorld._23 = (sy * cosRx * -sinRz * -sinRy) + (sy * sinRx * cosRy);
    out_matWorld._24 = 0.0f;

    out_matWorld._31 = (sz * -sinRx * -sinRz *  cosRy) + (sz * cosRx * sinRy);
    out_matWorld._32 = sz * -sinRx *  cosRz;
    out_matWorld._33 = (sz * -sinRx * -sinRz * -sinRy) + (sz * cosRx * cosRy);
    out_matWorld._34 = 0.0f;

    out_matWorld._41 = prm_pActor->_fX;
    out_matWorld._42 = prm_pActor->_fY;
    out_matWorld._43 = prm_pActor->_fZ;
    out_matWorld._44 = 1.0f;
}
