#include "GgafEffectConst.fxh"
/**
 * GgafLib::DefaultSpriteActor pVF[_[ .
 * |SɃeNX`\t[XvCgP`悷WIȃVF[_[B
 * _obt@tH[}bǵAȉ̂悤 GgafLib::SpriteModel ɒ`Ă̂OƂĂ܂B
 * {
 *     float x, y, z;             // W([JWn)
 *     float nx, ny, nz;          // @xNg([JWn)
 *     DWORD color;               // _J[iݖgpj
 *     float tu, tv;              // eNX`W
 * };
 *
 * DWORD SpriteModel::FVF = (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1);
 *
 * @author Masatoshi Tsuge
 * @since 2009/03/06
 */

/** fWorldϊs */
float4x4 g_matWorld;
/** fViewϊs */
float4x4 g_matView;
/** f̎ˉeϊs */
float4x4 g_matProj;
/** f̃}eAF(CgɂgUˎ̃f̐F) */
float4 g_colMaterialDiffuse;
/** eNX`UWip^[Noɂ葝j */
float g_offset_u;
/** eNX`VWip^[Noɂ葝j */
float g_offset_v;
/** f̃eNX`F_ŋ@\(GgafDx::TextureBlinkerQ)̓_ŋx */
float g_tex_blink_power;
/** f̃eNX`F_ŋ@\(GgafDx::TextureBlinkerQ)̑ΏۂƂȂRGB̂l(0.0`1.0) */
float g_tex_blink_threshold;
/** tF[hCEAEg@\(GgafDx::AlphaCurtainQ)̂߂̃}X^[At@l(0.0`1.0) */
float g_alpha_master;
/** ݂̎ˉeϊsvfzfBJ牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn */
float g_zf;
/** -1.0 or 0.999 Bł\ꍇ0.999 B*/
float g_far_rate;

/** eNX`̃Tv[(s0 WX^ɃZbgꂽeNX`g) */
sampler MyTextureSampler : register(s0);

/** _VF[_[Ao͍\ */
struct OUT_VS
{
    float4 posModel_Proj : POSITION;  //ŏIIȒ_W([hEr[Eˉeϊ)
    float4 color         : COLOR0;    //_J[
    float2 uv            : TEXCOORD0; //_eNX`UV
};


/**
 * GgafLib::DefaultMeshActor p̋^XvCgW_VF[_[ .
 * _ World > View > ˉe ϊB
 * f̃}eAFt𒸓_J[̐ݒōsB
 * eNX`̃p^[ԍɔݒ肳ꂽUVWݒB
 * @param prm_posModel_Local  _̃[JWBAEAAȄ4_nĂ
 * @param prm_uv              _UVW
 */
OUT_VS VS_DefaultSprite(
      float4 prm_posModel_Local : POSITION, // f̒_
      float2 prm_uv             : TEXCOORD0 // f̒_UV
) {
    OUT_VS out_vs = (OUT_VS)0;

    //World*View*ˉeϊ
    out_vs.posModel_Proj = mul(mul(mul( prm_posModel_Local, g_matWorld ), g_matView ), g_matProj);  // o͂ɐݒ
    //̕\@B
    if (g_far_rate > 0.0) {
        if (out_vs.posModel_Proj.z > g_zf*g_far_rate) {
            //{OZłA`邽߁AˉeZW㏑A
            out_vs.posModel_Proj.z = g_zf*g_far_rate;
        }
    }
    //dot by dotl
    out_vs.posModel_Proj = adjustDotByDot(out_vs.posModel_Proj);

    //UṼItZbgip^[ԍɂ鑝jZ
    out_vs.uv.x = prm_uv.x + g_offset_u;
    out_vs.uv.y = prm_uv.y + g_offset_v;

    //}eAFƂĒ_J[ɐݒ
    out_vs.color = g_colMaterialDiffuse;

    return out_vs;
}

/**
 * GgafLib::DefaultSpriteActor p̋^XvCgWsNZVF[_[ .
 * @param prm_uv    UVW
 * @param prm_color Fi}eAAtHOlς݁j
 */
float4 PS_DefaultSprite(
    float2 prm_uv    : TEXCOORD0,
    float4 prm_color : COLOR0
) : COLOR  {
    //߂F
    float4 colTex = tex2D( MyTextureSampler, prm_uv); //eNX`F擾
    //eNX`FɃ}eAJ[ƃXyL[l
    float4 colOut = colTex * prm_color;
    //Blinkerl
    if (colTex.r >= g_tex_blink_threshold || colOut.g >= g_tex_blink_threshold || colOut.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }

    //}X^[
    colOut.a *= g_alpha_master;
    return colOut;
}

float4 PS_Flush(
    float2 prm_uv : TEXCOORD0
) : COLOR  {
    float4 colOut = tex2D( MyTextureSampler, prm_uv)  * FLUSH_COLOR;
//    colOut *= g_colMaterialDiffuse;
//    colOut.a *= g_alpha_master;
    return colOut;
}

//eNjbNFDefaultSpriteTechnique
//y@\z
//SpriteModelpWVF[_[
//yTvz
//|i[XvCgj`悷BCgȂǂ̉Ae͖B
technique DefaultSpriteTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultSprite();
        PixelShader  = compile PS_VERSION PS_DefaultSprite();
    }
}

technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultSprite();
        PixelShader  = compile PS_VERSION PS_DefaultSprite();
    }
}

technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultSprite();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}
