#include "GgafEffectConst.fxh"
////////////////////////////////////////////////////////////////////////////////
// ggaf CuAGgafDx::SpriteModelpVF[_[
//
// author : Masatoshi Tsuge
// date:2009/03/06
////////////////////////////////////////////////////////////////////////////////
float4x4 g_matWorld;  //Worldϊs
float4x4 g_matView;   //Viewϊs
float4x4 g_matProj;   //ˉeϊs
float4 g_colMaterialDiffuse;
float g_offset_u; //eNX`UW
float g_offset_v; //eNX`VW
float g_tex_blink_power;
float g_tex_blink_threshold;
float g_alpha_master;
float g_zf;
float g_far_rate;
float g_sin_rz;
float g_cos_rz;
float g_u_center;
float g_v_center;
//soWX^̃Tvg(ŒpCvCɃZbgꂽeNX`VF[_[Ŏg)
sampler MyTextureSampler : register(s0);

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj    : POSITION;
    float2 uv     : TEXCOORD0;
};


///////////////////////////////////////////////////////////////////////////

//XvCgW_VF[_[
OUT_VS VS_DefaultRegularPolygonSprite(
      float4 prm_posModel_Local    : POSITION,     // f̒_
      float2 prm_uv     : TEXCOORD0     // f̒_UV
) {
    OUT_VS out_vs = (OUT_VS)0;
    float x = prm_posModel_Local.x;
    float y = prm_posModel_Local.y;
    prm_posModel_Local.x = (x*g_cos_rz + y*-g_sin_rz);
    prm_posModel_Local.y = (x*g_sin_rz + y*g_cos_rz);
    //_vZ
    const float4 posModel_World = mul(prm_posModel_Local, g_matWorld ); // Worldϊ
    const float4 posModel_View = mul(posModel_World, g_matView );       // Viewϊ
    const float4 posModel_Proj = mul(posModel_View, g_matProj);         // ˉeϊ
    out_vs.posModel_Proj = posModel_Proj;                         // o͂ɐݒ
    if (g_far_rate > 0.0) {
        if (out_vs.posModel_Proj.z > g_zf*g_far_rate) {
            out_vs.posModel_Proj.z = g_zf*g_far_rate; //{OZłA`邽0.9ȓɏ㏑A
        }
    }
    //dot by dotl
    out_vs.posModel_Proj = adjustDotByDot(out_vs.posModel_Proj);
    //UṼItZbg(p^[ԍɂ鑝)Z
    x = prm_uv.x - g_u_center;
    y = prm_uv.y - g_v_center;
    out_vs.uv.x = (x*g_cos_rz + y*g_sin_rz);
    out_vs.uv.y = (x*-g_sin_rz + y*g_cos_rz);
    out_vs.uv.x += (g_u_center + g_offset_u);
    out_vs.uv.y += (g_v_center + g_offset_v);
    return out_vs;
}

//XvCgWsNZVF[_[
float4 PS_DefaultRegularPolygonSprite(
    float2 prm_uv	  : TEXCOORD0
) : COLOR  {
    //߂F
    float4 colOut = tex2D( MyTextureSampler, prm_uv) ;
    if (colOut.r >= g_tex_blink_threshold || colOut.g >= g_tex_blink_threshold || colOut.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }
    colOut *= g_colMaterialDiffuse;
    colOut.a *= g_alpha_master;
    return colOut;
}

float4 PS_Flush(
    float2 prm_uv	  : TEXCOORD0
) : COLOR  {
    float4 colOut = tex2D( MyTextureSampler, prm_uv)  * FLUSH_COLOR;
    colOut *= g_colMaterialDiffuse;
    colOut.a *= g_alpha_master;
    return colOut;
}

//eNjbNFDefaultRegularPolygonSpriteTechnique
//y@\z
//SpriteModelpWVF[_[
//yTvz
//|i[XvCgj`悷BCgȂǂ̉Ae͖B
technique DefaultRegularPolygonSpriteTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultRegularPolygonSprite();
        PixelShader  = compile PS_VERSION PS_DefaultRegularPolygonSprite();
    }
}

technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultRegularPolygonSprite();
        PixelShader  = compile PS_VERSION PS_DefaultRegularPolygonSprite();
    }
}

technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultRegularPolygonSprite();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}
