#include "Jiki.h"

#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/ggaf/lib/util/StgUtil.h"
#include "jp/gecchi/VioletVrain/scene/VvSpacetime.h"
#include "jp/gecchi/VioletVrain/scene/VvSpacetime/World.h"
#include "jp/gecchi/VioletVrain/VvGod.h"



using namespace GgafLib;
using namespace VioletVrain;

enum {
    LOCKON001_PROG_FIRST_LOCK ,
    LOCKON001_PROG_LOCK       ,
    LOCKON001_PROG_RELEASE    ,
    PROG_BANPEI,
};

Jiki::Jiki(const char* prm_name) :
        VvMyActor<DefaultSpriteActor>(prm_name, "Lockon001", (void*)Jiki::resetJikiStatus) {
    _class_name = "Jiki";
//    defineRotMvWorldMatrix_Billboard(); //[hϊ̓r{[hRz]ɋ
    effectBlendOne(); //GtFNgeNjbN͉Zɋ
    setZEnableDraw(false);      //Zobt@͍lɋ
    setZWriteEnable(false); //gZobt@݂Ȃɋ
    setCullingDraw(false);
    setHitAble(true);
}

void Jiki::initialize() {
    GgafDx::UvFlipper* pUvFlipper = getUvFlipper();
    pUvFlipper->setFlipPtnRange(0, 3);   //Aj͈͂O`PT
    pUvFlipper->exec(FLIP_ORDER_LOOP, 5); //Aj
    CollisionChecker* pChecker = getCollisionChecker();
//    pChecker->createCollisionArea(1);
////    pChecker->set2DColliSquare(0, PX_C(128));
////    pChecker->set2DColliCircle(0, PX_C(32));
//    pChecker->set2DColliRightTriangle_WH(0, PX_C(60), PX_C(70), PX_C(250), PX_C(150), POS_R_TRIANGLE_NN);

    pChecker->createCollisionArea(4);
    coord ox = PX_C(30);
    coord oy = PX_C(40);
    coord w = PX_C(50);
    coord h = PX_C(70);
    pChecker->set2DColliRightTriangle_WH(0, ox - (w*2), oy - (h*2), w, h, POS_R_TRIANGLE_PP);
    pChecker->set2DColliRightTriangle_WH(1, ox - (w*2), oy + (h*2), w, h, POS_R_TRIANGLE_PN);
    pChecker->set2DColliRightTriangle_WH(2, ox + (w*2), oy - (h*2), w, h, POS_R_TRIANGLE_NP);
    pChecker->set2DColliRightTriangle_WH(3, ox + (w*2), oy + (h*2), w, h, POS_R_TRIANGLE_NN);
}

void Jiki::onReset() {
    getProgress()->reset(LOCKON001_PROG_RELEASE);
}

void Jiki::onActive() {
    getUvFlipper()->setActivePtnToTop();
    getVecDriver()->setFaceAngVelo(AXIS_Z, 1000);        //]
}

void Jiki::processBehavior() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafCore::Progress* const pProg = getProgress();
    VirtualButton* pVb = &(P_GOD->getSpacetime()->getWorld()->vb_);
    if (pVb->isPressed(VB_BUTTON1)) {
        //{^PiXy[XL[jȂ̏ꍇ
        if (pVb->isPressed(VB_UP)) {
            _z += PX_C(2); //
        }
        if (pVb->isPressed(VB_DOWN)) {
            _z -= PX_C(2); //O
        }
    } else {
        //{^PiXy[XL[j𗣂Ăꍇ
        if (pVb->isPressed(VB_RIGHT)) {
            _x += PX_C(2); //E
        }
        if (pVb->isPressed(VB_LEFT)) {
            _x -= PX_C(2); //
        }
        if (pVb->isPressed(VB_UP)) {
            _y += PX_C(2); //
        }
        if (pVb->isPressed(VB_DOWN)) {
            _y -= PX_C(2); //
        }
    }
    getUvFlipper()->behave();
    pVecDriver->behave();
}

void Jiki::processJudgement() {
}

void Jiki::onInactive() {
}

Jiki::~Jiki() {
}


