#include "MgrWorld.h"

#include "jp/ggaf/lib/util/VirtualButton.h"
#include "scene/MgrSpacetime/MgrWorld/TrialAndErrScene.h"
#include "scene/MgrSpacetime/MgrWorld/ParallelCurveTestScene.h"
#include "scene/MgrSpacetime.h"
#include "MgrGod.h"

using namespace GgafLib;
using namespace Mogera;

MgrWorld::MgrWorld(const char* prm_name) : GgafLib::DefaultScene(prm_name) {
    pTestScene_ = nullptr;
    pHitCheckRounder_ = P_GOD->getSpacetime()->getLinearOctreeHitCheckRounder();
}

void MgrWorld::initialize() {
    pTestScene_ = desireScene(TrialAndErrScene);
//    pTestScene_ = desireScene(ParallelCurveTestScene);
    appendChild(pTestScene_);

}

void MgrWorld::processBehavior() {
    VirtualButton* pVb = P_GOD->getSpacetime()->pVb_;
    //Ct[\ؑ
    if (pVb->isPushedDown(VB_UI_DEBUG)) {
        if (GgafDx::God::_d3dfillmode == D3DFILL_WIREFRAME) {
            GgafDx::God::_d3dfillmode = D3DFILL_SOLID;
        } else {
            GgafDx::God::_d3dfillmode = D3DFILL_WIREFRAME;
        }
    }

    //ꎞ~
    if (pVb->isPushedDown(VB_PAUSE)) {
        if (pTestScene_->wasPaused()) {
            pTestScene_->unpause();
        } else {
            pTestScene_->pause();
        }
    }

}

void MgrWorld::processJudgement() {
    //蔻`FbN
    pHitCheckRounder_->executeAll(MGR_MIKATA, MGR_TEKI);
}

MgrWorld::~MgrWorld() {
//    GGAF_DELETE(pBarVal_);
}

