#include "Zako.h"

#include "jp/ggaf/dx/actor/supporter/AlphaFader.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/ggaf/dx/util/curve/DriverLeader.h"
#include "jp/ggaf/lib/actor/DefaultGeometricActor.h"
#include "actor/Zakoko.h"



using namespace GgafLib;
using namespace Mogera;

enum {
    PROG_INIT   ,
    PROG_CURVE ,
    PROG_LEAVE ,
    PROG_BANPEI,
};

Zako::Zako(const char* prm_name) :
        DefaultMeshSetActor(prm_name, "Zako") {
    _class_name = "Zako";
    pDriverLeader_ = nullptr; //tH[[VIuWFNgݒ肷
    pOs_ = nullptr;

    int n = 6;
    for (int t = 0; t < n; t++) {
        double rad_pos = ((PI*2.0)*t) / n;
        double z = cos(rad_pos);
        double y = sin(rad_pos);
        static coord r = PX_C(50);
        std::string name = "Zakoko("+XTOS(t)+")";
        Zakoko* pZakoko = NEW Zakoko(name.c_str());
        appendGroupChildAsFk(pZakoko, 0,  z*r,  y*r, 0, 0, 0);
        pZakoko->setMaterialColor(RCNV(0, n-1, t, 5, 1.0),
                                  RCNV(0, n-1, t, 1.0, 5),
                                  0.5);
    }
}

void Zako::onCreateModel() {
//    pModel->setSpecular(5.0, 1.0);
}

void Zako::initialize() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->linkFaceAngByMvAng(true);
    pVecDriver->setRollFaceAngVelo(D_ANG(2));
    pVecDriver->setMvVelo(PX_C(1));

    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, PX_C(128));
}

void Zako::onActive() {
    getProgress()->reset(PROG_INIT);
    if (isFirst()) {
        std::string filename = XTOS(getName()) + ".dat";
        pOs_ = NEW std::ofstream(filename.c_str());
    }
}

void Zako::processBehavior() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
//    GgafCore::Progress* const pProg = getProgress();
//    switch (pProg->get()) {
//        case PROG_INIT: {
//            pProg->changeNext();
//            break;
//        }
//
//        case PROG_CURVE: {
//            if (pProg->hasJustChanged()) {
//                getVecDriver()->setMvAcce(0); //xꍇ͐؂Ă
//                pDriverLeader_->start(RELATIVE_COORD_DIRECTION, 1);
//            }
//            pDriverLeader_->behave(); //J[uړ悤Driver𑀍
//
//            if (pDriverLeader_->isFinished()) {
//                pProg->changeNext();
//            }
//            break;
//        }
//
//        case PROG_LEAVE: {
//            if (pProg->hasJustChanged()) {
//                sayonara();
//            }
//            break;
//        }
//        default :
//            break;
//    }
//
    pVecDriver->behave();
}

void Zako::processJudgement() {
//    if (pOs_) {
//        (*pOs_) << _x << "  " << _y << "  " << _z << std::endl;
//    }
}

void Zako::onHit(const GgafCore::Actor* prm_pOtherActor) {
}

void Zako::onInactive() {
}

Zako::~Zako() {
    if (pOs_) {
        (*pOs_).close();
    }
    GGAF_DELETE_NULLABLE(pDriverLeader_);
}
