#include "jp/ggaf/lib/util/ColliAAPrism.h"

#include "jp/ggaf/lib/util/StgUtil.h"



using namespace GgafLib;

ColliAAPrism::ColliAAPrism() : ColliAABox() {
    _shape_kind = COLLI_AAPRISM;
    _a = 0;
    _b = 0;
    _vIH_x = 0;
    _vIH_y = 0;
}

void ColliAAPrism::set(int x1, int y1, int z1, int x2, int y2, int z2, pos_t pos_info, bool rot_x, bool rot_y, bool rot_z) {
#ifdef MY_DEBUG
    if (rot_x || rot_y || rot_z) {
        //TODO:Ђ܂ȂvYvf͉]sړ
        throwCriticalException("蔻̃vYvf͉]sړ͖ΉłB");
    }
#endif

    ColliAABox::set(x1, y1, z1, x2, y2, z2, rot_x, rot_y, rot_z);

    //   y  = ax + b
    //   a  = (y2-y1)/(x2-x1)
    //   b  = (x1y2-x2y1) / (x1-x2)

    //   y  = {(y2-y1)/(x2-x1)} (x-x1) + y1
    //+90xŖ@ōs
    int x1_s=0, y1_s=0, x2_e=0, y2_e=0;
    _pos_info = pos_info;
    if (_pos_info & POS_PRISM_XY_xx) {
        if (_pos_info & POS_PRISM_xx_PP) {
            //             y+
            // (_x1,_y2)      (_x2,_y2)
            //        
            //        _
            // x-     _焠   x+
            //            _
            //        
            // (_x1,_y1)      (_x2,_y1)
            //             y-
            x1_s = _x2;
            y1_s = _y1;
            x2_e = _x1;
            y2_e = _y2;
        } else if (_pos_info & POS_PRISM_xx_NP) {
            //             y+
            // (_x1,_y2)      (_x2,_y2)
            //        
            //        ^
            // x-   ^     x+
            //        ^    
            //        
            // (_x1,_y1)      (_x2,_y1)
            //             y-
            x1_s = _x2;
            y1_s = _y2;
            x2_e = _x1;
            y2_e = _y1;
        } else if (_pos_info & POS_PRISM_xx_PN) {
            //             y+
            // (_x1,_y2)      (_x2,_y2)
            //        
            //            ^
            // x-     ^   x+
            //        ^焠
            //        
            // (_x1,_y1)      (_x2,_y1)
            //             y-
            x1_s = _x1;
            y1_s = _y1;
            x2_e = _x2;
            y2_e = _y2;
        } else { // ̂ POS_PRISM_xx_NN
            //             y+
            // (_x1,_y2)      (_x2,_y2)
            //        
            //        _    
            // x-   _     x+
            //        _
            //        
            // (_x1,_y1)      (_x2,_y1)
            //             y-
            x1_s = _x1;
            y1_s = _y2;
            x2_e = _x2;
            y2_e = _y1;
        }


    } else if (_pos_info & POS_PRISM_YZ_xx) {

        if (_pos_info & POS_PRISM_xx_PP) {
            //             z+
            // (_y1,_z2)      (_y2,_z2)
            //        
            //        _
            // y-     _焠   y+
            //            _
            //        
            // (_y1,_z1)      (_y2,_z1)
            //             z-
            x1_s = _y2;
            y1_s = _z1;
            x2_e = _y1;
            y2_e = _z2;
        } else if (_pos_info & POS_PRISM_xx_NP) {
            //             z+
            // (_y1,_z2)      (_y2,_z2)
            //        
            //        ^
            // y-   ^     y+
            //        ^    
            //        
            // (_y1,_z1)      (_y2,_z1)
            //             z-
            x1_s = _y2;
            y1_s = _z2;
            x2_e = _y1;
            y2_e = _z1;
        } else if (_pos_info & POS_PRISM_xx_PN) {
            //             z+
            // (_y1,_z2)      (_y2,_z2)
            //        
            //            ^
            // y-     ^   y+
            //        ^焠
            //        
            // (_y1,_z1)      (_y2,_z1)
            //             z-
            x1_s = _y1;
            y1_s = _z1;
            x2_e = _y2;
            y2_e = _z2;
        } else { // ̂ POS_PRISM_xx_NN
            //             z+
            // (_y1,_z2)      (_y2,_z2)
            //        
            //        _    
            // y-   _     y+
            //        _
            //        
            // (_y1,_z1)      (_y2,_z1)
            //             z-
            x1_s = _y1;
            y1_s = _z2;
            x2_e = _y2;
            y2_e = _z1;
        }

    } else if (_pos_info & POS_PRISM_ZX_xx) {
        if (_pos_info & POS_PRISM_xx_PP) {
            //             x+
            // (_z1,_x2)      (_z2,_x2)
            //        
            //        _
            // z-     _焠   z+
            //            _
            //        
            // (_z1,_x1)      (_z2,_x1)
            //             x-
            x1_s = _z2;
            y1_s = _x1;
            x2_e = _z1;
            y2_e = _x2;
        } else if (_pos_info & POS_PRISM_xx_NP) {
            //             x+
            // (_z1,_x2)      (_z2,_x2)
            //        
            //        ^
            // z-   ^     z+
            //        ^    
            //        
            // (_z1,_x1)      (_z2,_x1)
            //             x-
            x1_s = _z2;
            y1_s = _x2;
            x2_e = _z1;
            y2_e = _x1;
        } else if (_pos_info & POS_PRISM_xx_PN) {
            //             x+
            // (_z1,_x2)      (_z2,_x2)
            //        
            //            ^
            // z-     ^   z+
            //        ^焠
            //        
            // (_z1,_x1)      (_z2,_x1)
            //             x-
            x1_s = _z1;
            y1_s = _x1;
            x2_e = _z2;
            y2_e = _x2;
        } else { // ̂ POS_PRISM_xx_NN
            //             x+
            // (_z1,_x2)      (_z2,_x2)
            //        
            //        _    
            // z-   _     z+
            //        _
            //        
            // (_z1,_x1)      (_z2,_x1)
            //             x-
            x1_s = _z1;
            y1_s = _x2;
            x2_e = _z2;
            y2_e = _x1;
        }
    } else {
        //memo WallAAPrismActor  new̓vYʒu 0 ɂ邱ƂƂ̂ŁA
        //ȉ̃G[̓X[悤ɕύXB

        //throwCriticalException("ȃvYʒu _pos_info="<<_pos_info)
    }

    //蔻莞ɎgpvZp̒l\ߋ߂ĂB
    if (x2_e == x1_s) {
        _a = 0;
        _b = 0;
    } else {
        //vYΕӂ̋EX
        _a = 1.0*(y2_e - y1_s) / (x2_e - x1_s);
        //vYΕӂ̋E̐ؕ
        _b = (x1_s*y2_e - x2_e*y1_s) / (x1_s - x2_e);
    }
    //ƂŌvZyɂȂ邽߁A
    //vYΕӖʂ̖@xNg̋t̃xNg _vIH_x, _vIH_y߂Ă
    //ΕӃxNg(x2_e-x1_s, y2_e-y1_s)90x
    //ΕӖʂ̖@xNgƂȂ悤ɂĂB
    //ŕێĂ̂-90x(+270x)̃xNgł
    angle angIH = UTIL::simplifyAng(
        UTIL::getAngle2D(x2_e-x1_s, y2_e-y1_s)
        + D270ANG
        );
    _vIH_x = UTIL::COS[angIH/SANG_RATE];
    _vIH_y = UTIL::SIN[angIH/SANG_RATE];

}


ColliAAPrism::~ColliAAPrism() {
}
