#include "jp/ggaf/lib/actor/WorldBoundActor.h"

#include "jp/ggaf/lib/DefaultGod.h"
#include "jp/ggaf/lib/scene/DefaultSpacetime.h"
#include "jp/ggaf/lib/actor/camera/DefaultCamera.h"




using namespace GgafLib;

WorldBoundActor::WorldBoundActor(const char* prm_name, const char* prm_model) :
        GgafDx::WorldBoundActor(prm_name,
                              prm_model,
                              "WorldBoundEffect",
                              "WorldBoundTechnique",
                              nullptr) {

    _class_name = "WorldBoundActor";
    _offset_frames = 0;
    setSpecialRenderDepthIndex(RENDER_DEPTH_INDEX_WORLDBOUND);
    setHitAble(false);
    setZEnableDraw(false);   //Zobt@͍l
    setZWriteEnable(false);  //gZobt@݂Ȃ
    setFaceAngZero();
}

void WorldBoundActor::initialize() {
    DefaultCamera* pCam = pGOD->getSpacetime()->getCamera();
    setPositionAt(pCam);
    dxcoord world_r = pCam->getZFar(); //EEa
    dxcoord world_bound_model_r = 1.0f; //WorldBound001̃f͔aDIRECTX1̋ł
    setScaleR((world_r*0.989)/world_bound_model_r);
}


void WorldBoundActor::processSettlementBehavior() {
    DefaultCamera* pCam = pGOD->getSpacetime()->getCamera();
    //ʊO薳ɔȂȗB
    //̏𖳎Ă܂
    //Eg{[̍l
    //Eؓo^
    //E䂩̋vZ
    //GeometricActor::processSettlementBehavior() Ɠ鎖I
    setPositionAt(pCam);
    _fX = C_DX(_x);
    _fY = C_DX(_y);
    _fZ = C_DX(_z);
    UTIL::setWorldMatrix_ScRxRzRyMv(this, _matWorld); //[hϊ
}
//void WorldBoundActor::processPreDraw() {
//    //ʊO薳ɔȂȗ
//    //̏𖳎Ă܂
//    //EiK_O̐[xvZ
//    //EꎞeNjbNl
//    //FigureActor::processPreDraw() Ɠ鎖I
//    if (_pModel->_is_init_model == false) {
//        onCreateModel(); //f쐬̏
//        _pModel->_is_init_model = true;
//    }
//    GgafDx::Spacetime::registerFigureActor(REGULAR_RENDER_DEPTH_INDEXS_NUM,this); //Ő[
//}

WorldBoundActor::~WorldBoundActor() {
}
