#include "jp/ggaf/lib/actor/CappedGraphBarActor.h"

#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include "jp/ggaf/dx/effect/BoardEffect.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/model/BoardModel.h"
#include "jp/ggaf/dx/util/Util.h"



using namespace GgafLib;

CappedGraphBarActor::CappedGraphBarActor(const char* prm_name, const char* prm_model, Quantity<int, pixcoord>* prm_pQty)
      : GraphBarActor(prm_name, prm_model, prm_pQty) {
    _class_name = "CappedGraphBarActor";
}

CappedGraphBarActor::CappedGraphBarActor(const char* prm_name, const char* prm_model)
      : GraphBarActor(prm_name, prm_model) {
    _class_name = "CappedGraphBarActor";
}

void CappedGraphBarActor::processDraw() {
    float bar_width = (float)(_pQty->getQty());
    if (bar_width == 0.0f) { //I know float ==
        return;
    }
    ID3DXEffect* const pID3DXEffect = _pBoardEffect->_pID3DXEffect;
    float left_x = (float)(C_PX(_x));
    float top_y = (float)(C_PX(_y));
    HRESULT hr;
#ifdef MY_DEBUG
    if (_align != ALIGN_LEFT) {
        throwCriticalException("XWACg ALIGN_LEFT ȊOo܂Bthis="<<NODE_INFO);
    }
#endif
    if (_valign == VALIGN_BOTTOM) {
        hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_y, (float)(-_pBoardModel->_model_height_px));
    } else if (_valign == VALIGN_MIDDLE) {
        hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_y, (float)(-_pBoardModel->_model_height_px*0.5));
    } else { //VALIGN_TOP
        hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_y, 0.0f);
    }
    checkDxException(hr, D3D_OK, "SetFloat(_h_local_left_top_y) Ɏs܂B");

    hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_rz, ANG_RAD(_rz));
    checkDxException(hr, D3D_OK, "SetFloat(_h_rz) Ɏs܂B");
    hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_depth_z, (float)(C_PX(_z)));
    checkDxException(hr, D3D_OK, "SetFloat(_h_depth_z) Ɏs܂B");
    hr = pID3DXEffect->SetValue(_pBoardEffect->_h_colMaterialDiffuse, &(_paMaterial[0].Diffuse), sizeof(D3DCOLORVALUE) );
    checkDxException(hr, D3D_OK, "SetValue(_h_colMaterialDiffuse) Ɏs܂B");

    if (bar_width > 0.0f) {
        //_pUvFlipper->_pattno_uvflip_now  <=>  "<" ̔ԍɍ킹邱ƁI
        if (bar_width > _chip_width*2) {
            // <=> ̐^ = \
            _pUvFlipper->_pattno_uvflip_now++;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x + (_chip_width * SC_R(_sx)) );
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_y, top_y);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_y) Ɏs܂B3");

            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_x, 0.0f);
            checkDxException(hr, D3D_OK, "SetFloat(_h_local_left_top_x) Ɏs܂B");

            float sx = (bar_width * _rate_org_chip_width) -  2.0f;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sx, sx * SC_R(_sx));
            checkDxException(hr, D3D_OK, "SetFloat(_sx) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sy, SC_R(_sy));
            checkDxException(hr, D3D_OK, "SetFloat(_sy) Ɏs܂B");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            // <=> ̍i < \
            _pUvFlipper->_pattno_uvflip_now--;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sx, 1.0f * SC_R(_sx));
            checkDxException(hr, D3D_OK, "SetFloat(_sx) Ɏs܂B");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            // <=> ̉Ei > \
            _pUvFlipper->_pattno_uvflip_now += 2;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x + ((bar_width - _chip_width)*SC_R(_sx)) );
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            _pUvFlipper->_pattno_uvflip_now -=2 ; //Ƃɖ߂
        } else {

            // <=> ̍i < \
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_y, top_y);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_y) Ɏs܂B3");

            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_x, 0.0f);
            checkDxException(hr, D3D_OK, "SetFloat(_h_local_left_top_x) Ɏs܂B");

            float sx = (bar_width * _rate_org_chip_width) * 0.5f;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sx, sx * SC_R(_sx));
            checkDxException(hr, D3D_OK, "SetFloat(_sx) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sy, SC_R(_sy));
            checkDxException(hr, D3D_OK, "SetFloat(_sy) Ɏs܂B");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            // <=> ̉Ei > \
            _pUvFlipper->_pattno_uvflip_now += 2;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x + ((_chip_width*sx)*SC_R(_sx)) );
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            _pUvFlipper->_pattno_uvflip_now -= 2; //Ƃɖ߂
        }
    } else {
        //̒̏ꍇ
        if (bar_width < -_chip_width*2) {
            // <=> ̐^ = 𔽓]\
            _pUvFlipper->_pattno_uvflip_now++;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x - (_chip_width * SC_R(_sx)) );
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_y, top_y);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_y) Ɏs܂B3");

            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_x, 0.0f);
            checkDxException(hr, D3D_OK, "SetFloat(_h_local_left_top_x) Ɏs܂B");

            float sx = (-bar_width * _rate_org_chip_width) - 2.0f;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sx, -sx * SC_R(_sx));
            checkDxException(hr, D3D_OK, "SetFloat(_sx) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sy, SC_R(_sy));
            checkDxException(hr, D3D_OK, "SetFloat(_sy) Ɏs܂B");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            // <=> ̍i < 𔽓]\ĉEi > \
            _pUvFlipper->_pattno_uvflip_now--;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sx, -1.0f * SC_R(_sx));
            checkDxException(hr, D3D_OK, "SetFloat(_sx) Ɏs܂B");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            // <=> ̉Ei > 𔽓]\či < \
            _pUvFlipper->_pattno_uvflip_now += 2;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x - (((-bar_width) - _chip_width)*SC_R(_sx)) );
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            _pUvFlipper->_pattno_uvflip_now -=2; //Ƃɖ߂

        } else {
            float sx = (-bar_width * _rate_org_chip_width) * 0.5f;

            // <=> ̍i < 𔽓]\ĉEi > \
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_y, top_y);
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_y) Ɏs܂B3");

            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_local_left_top_x, 0.0f);
            checkDxException(hr, D3D_OK, "SetFloat(_h_local_left_top_x) Ɏs܂B");

            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sx, -sx * SC_R(_sx));
            checkDxException(hr, D3D_OK, "SetFloat(_sx) Ɏs܂B");
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_sy, SC_R(_sy));
            checkDxException(hr, D3D_OK, "SetFloat(_sy) Ɏs܂B");
            _pBoardModel->GgafDx::BoardModel::draw(this);

            // <=> ̉Ei > 𔽓]\či < \
            _pUvFlipper->_pattno_uvflip_now += 2;
            hr = pID3DXEffect->SetFloat(_pBoardEffect->_h_transformed_x, left_x - ((_chip_width*sx)*SC_R(_sx)) );
            checkDxException(hr, D3D_OK, "SetFloat(_h_transformed_x) Ɏs܂B3");
            _pBoardModel->GgafDx::BoardModel::draw(this);
            _pUvFlipper->_pattno_uvflip_now -= 2; //Ƃɖ߂
        }
    }
}

CappedGraphBarActor::~CappedGraphBarActor() {
}
